/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectedSelfElementInfo
extends SmartPointerElementInfo {
    private final SmartPsiFileRange myInjectedFileRangeInHostFile;
    @Nullable
    private final AffixOffsets myAffixOffsets;
    private final Identikit myType;
    @NotNull
    private final SmartPsiElementPointer<PsiLanguageInjectionHost> myHostContext;

    InjectedSelfElementInfo(@NotNull Project project, @NotNull PsiElement injectedElement, @NotNull TextRange injectedRange, @NotNull PsiFile containingFile, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> hostContext) {
        if (project == null) {
            InjectedSelfElementInfo.$$$reportNull$$$0(0);
        }
        if (injectedElement == null) {
            InjectedSelfElementInfo.$$$reportNull$$$0(1);
        }
        if (injectedRange == null) {
            InjectedSelfElementInfo.$$$reportNull$$$0(2);
        }
        if (containingFile == null) {
            InjectedSelfElementInfo.$$$reportNull$$$0(3);
        }
        if (hostContext == null) {
            InjectedSelfElementInfo.$$$reportNull$$$0(4);
        }
        this.myHostContext = hostContext;
        assert (containingFile.getViewProvider() instanceof FreeThreadedFileViewProvider) : "element parameter must be an injected element: " + injectedElement + "; " + containingFile;
        assert (containingFile.getTextRange().contains(injectedRange)) : "Injected range outside the file: " + injectedRange + "; file: " + containingFile.getTextRange();
        TextRange hostRange = InjectedLanguageManager.getInstance(project).injectedToHost(injectedElement, injectedRange);
        PsiFile hostFile = hostContext.getContainingFile();
        assert (!(hostFile.getViewProvider() instanceof FreeThreadedFileViewProvider)) : "hostContext parameter must not be and injected element: " + hostContext;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project);
        this.myInjectedFileRangeInHostFile = smartPointerManager.createSmartPsiFileRangePointer(hostFile, hostRange);
        this.myType = Identikit.fromPsi(injectedElement, LanguageUtil.getRootLanguage(containingFile));
        int startAffixIndex = -1;
        int startAffixOffset = -1;
        int endAffixIndex = -1;
        int endAffixOffset = -1;
        List<TextRange> fragments = InjectedLanguageManager.getInstance(project).getNonEditableFragments((DocumentWindow)containingFile.getViewProvider().getDocument());
        for (int i = 0; i < fragments.size(); ++i) {
            TextRange range = fragments.get(i);
            if (range.containsOffset(injectedRange.getStartOffset())) {
                startAffixIndex = i;
                startAffixOffset = injectedRange.getStartOffset() - range.getStartOffset();
            }
            if (!range.containsOffset(injectedRange.getEndOffset())) continue;
            endAffixIndex = i;
            endAffixOffset = injectedRange.getEndOffset() - range.getStartOffset();
        }
        this.myAffixOffsets = startAffixIndex >= 0 || endAffixIndex >= 0 ? new AffixOffsets(startAffixIndex, startAffixOffset, endAffixIndex, endAffixOffset) : null;
    }

    @Override
    VirtualFile getVirtualFile() {
        PsiElement element = this.restoreElement();
        if (element == null) {
            return null;
        }
        return element.getContainingFile().getVirtualFile();
    }

    @Override
    Segment getRange() {
        return this.getInjectedRange(false);
    }

    @Override
    @Nullable
    Segment getPsiRange() {
        return this.getInjectedRange(true);
    }

    @Override
    PsiElement restoreElement() {
        PsiFile hostFile = this.myHostContext.getContainingFile();
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiLanguageInjectionHost hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = this.myInjectedFileRangeInHostFile.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile injectedPsi = this.getInjectedFileIn(hostContext, hostFile, TextRange.create(segment));
        ProperTextRange rangeInInjected = InjectedSelfElementInfo.hostToInjected(true, segment, injectedPsi, this.myAffixOffsets);
        if (rangeInInjected == null) {
            return null;
        }
        return this.myType.findPsiElement(injectedPsi, rangeInInjected.getStartOffset(), rangeInInjected.getEndOffset());
    }

    private PsiFile getInjectedFileIn(@NotNull PsiElement hostContext, @NotNull PsiFile hostFile, @NotNull TextRange rangeInHostFile) {
        PsiFile[] result2;
        block6: {
            PsiLanguageInjectionHost.InjectedPsiVisitor visitor;
            block5: {
                if (hostContext == null) {
                    InjectedSelfElementInfo.$$$reportNull$$$0(5);
                }
                if (hostFile == null) {
                    InjectedSelfElementInfo.$$$reportNull$$$0(6);
                }
                if (rangeInHostFile == null) {
                    InjectedSelfElementInfo.$$$reportNull$$$0(7);
                }
                PsiDocumentManagerBase docManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.getProject());
                result2 = new PsiFile[]{null};
                visitor = (injectedPsi, places) -> {
                    DocumentWindow window;
                    TextRange hostRange;
                    Document document;
                    if (rangeInHostFile == null) {
                        InjectedSelfElementInfo.$$$reportNull$$$0(10);
                    }
                    if ((document = docManager.getDocument(injectedPsi)) instanceof DocumentWindow && (hostRange = (window = (DocumentWindow)((Object)docManager.getLastCommittedDocument(document))).injectedToHost(new TextRange(0, injectedPsi.getTextLength()))).contains(rangeInHostFile)) {
                        result2[0] = injectedPsi;
                    }
                };
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.getProject());
                Document document = documentManager.getDocument(hostFile);
                if (document == null || !documentManager.isUncommited(document)) break block5;
                for (DocumentWindow documentWindow : InjectedLanguageManager.getInstance(this.getProject()).getCachedInjectedDocumentsInRange(hostFile, rangeInHostFile)) {
                    PsiFile injected = documentManager.getPsiFile(documentWindow);
                    if (injected == null) continue;
                    visitor.visit(injected, Collections.emptyList());
                }
                break block6;
            }
            List<Pair<PsiElement, TextRange>> injected = InjectedLanguageManager.getInstance(this.getProject()).getInjectedPsiFiles(hostContext);
            if (injected == null) break block6;
            for (Pair<PsiElement, TextRange> pair : injected) {
                PsiFile injectedFile = ((PsiElement)pair.first).getContainingFile();
                visitor.visit(injectedFile, ContainerUtil.emptyList());
            }
        }
        return result2[0];
    }

    @Override
    boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            InjectedSelfElementInfo.$$$reportNull$$$0(8);
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!((InjectedSelfElementInfo)other).myHostContext.equals(this.myHostContext)) {
            return false;
        }
        SmartPointerElementInfo myElementInfo = ((SmartPsiElementPointerImpl)((Object)this.myInjectedFileRangeInHostFile)).getElementInfo();
        SmartPointerElementInfo oElementInfo = ((SmartPsiElementPointerImpl)((Object)((InjectedSelfElementInfo)other).myInjectedFileRangeInHostFile)).getElementInfo();
        return myElementInfo.pointsToTheSameElementAs(oElementInfo);
    }

    @Override
    PsiFile restoreFile() {
        PsiFile hostFile = this.myHostContext.getContainingFile();
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiLanguageInjectionHost hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = this.myInjectedFileRangeInHostFile.getPsiRange();
        if (segment == null) {
            return null;
        }
        TextRange rangeInHostFile = TextRange.create(segment);
        return this.getInjectedFileIn(hostContext, hostFile, rangeInHostFile);
    }

    @Nullable
    private ProperTextRange getInjectedRange(boolean psi) {
        Segment hostElementRange;
        PsiLanguageInjectionHost hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = hostElementRange = psi ? this.myInjectedFileRangeInHostFile.getPsiRange() : this.myInjectedFileRangeInHostFile.getRange();
        if (hostElementRange == null) {
            return null;
        }
        return InjectedSelfElementInfo.hostToInjected(psi, hostElementRange, this.restoreFile(), this.myAffixOffsets);
    }

    @Nullable
    private static ProperTextRange hostToInjected(boolean psi, Segment hostRange, @Nullable PsiFile injectedFile, @Nullable AffixOffsets affixOffsets) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = virtualFile = injectedFile == null ? null : injectedFile.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            Project project = injectedFile.getProject();
            DocumentWindow documentWindow = ((VirtualFileWindow)((Object)virtualFile)).getDocumentWindow();
            if (psi) {
                documentWindow = (DocumentWindow)((Object)((PsiDocumentManagerBase)PsiDocumentManager.getInstance(project)).getLastCommittedDocument(documentWindow));
            }
            int start = documentWindow.hostToInjected(hostRange.getStartOffset());
            int end = documentWindow.hostToInjected(hostRange.getEndOffset());
            if (affixOffsets != null) {
                return affixOffsets.expandRangeToAffixes(start, end, InjectedLanguageManager.getInstance(project).getNonEditableFragments(documentWindow));
            }
            return ProperTextRange.create(start, end);
        }
        return null;
    }

    @Override
    void cleanup() {
        SmartPointerManager.getInstance(this.getProject()).removePointer(this.myInjectedFileRangeInHostFile);
    }

    @Override
    @Nullable
    Document getDocumentToSynchronize() {
        return ((SmartPsiElementPointerImpl)this.myHostContext).getElementInfo().getDocumentToSynchronize();
    }

    @Override
    int elementHashCode() {
        return ((SmartPsiElementPointerImpl)this.myHostContext).getElementInfo().elementHashCode();
    }

    @Override
    @NotNull
    Project getProject() {
        Project project = this.myHostContext.getProject();
        if (project == null) {
            InjectedSelfElementInfo.$$$reportNull$$$0(9);
        }
        return project;
    }

    public String toString() {
        return "injected{type=" + this.myType + ", range=" + this.myInjectedFileRangeInHostFile + ", host=" + this.myHostContext + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInHostFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedFileIn";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pointsToTheSameElementAs";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInjectedFileIn$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AffixOffsets {
        final int startAffixIndex;
        final int startAffixOffset;
        final int endAffixIndex;
        final int endAffixOffset;

        AffixOffsets(int startAffixIndex, int startAffixOffset, int endAffixIndex, int endAffixOffset) {
            this.startAffixIndex = startAffixIndex;
            this.startAffixOffset = startAffixOffset;
            this.endAffixIndex = endAffixIndex;
            this.endAffixOffset = endAffixOffset;
        }

        @Nullable
        ProperTextRange expandRangeToAffixes(int start, int end, List<TextRange> fragments) {
            TextRange fragment;
            if (this.startAffixIndex >= 0) {
                TextRange textRange = fragment = this.startAffixIndex < fragments.size() ? fragments.get(this.startAffixIndex) : null;
                if (fragment == null || this.startAffixOffset > fragment.getLength()) {
                    return null;
                }
                start = fragment.getStartOffset() + this.startAffixOffset;
            }
            if (this.endAffixIndex >= 0) {
                TextRange textRange = fragment = this.endAffixIndex < fragments.size() ? fragments.get(this.endAffixIndex) : null;
                if (fragment == null || this.endAffixOffset > fragment.getLength()) {
                    return null;
                }
                end = fragment.getStartOffset() + this.endAffixOffset;
            }
            return ProperTextRange.create(start, end);
        }
    }
}

