/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodsConflictResolver
implements PsiConflictResolver {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver");
    private final PsiElement myArgumentsList;
    private final PsiType[] myActualParameterTypes;
    protected LanguageLevel myLanguageLevel;

    public JavaMethodsConflictResolver(@NotNull PsiExpressionList list, @NotNull LanguageLevel languageLevel) {
        if (list == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(0);
        }
        if (languageLevel == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(1);
        }
        this(list, null, languageLevel);
    }

    public JavaMethodsConflictResolver(@NotNull PsiElement argumentsList, PsiType[] actualParameterTypes, @NotNull LanguageLevel languageLevel) {
        if (argumentsList == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(2);
        }
        if (languageLevel == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(3);
        }
        this.myArgumentsList = argumentsList;
        this.myActualParameterTypes = actualParameterTypes;
        this.myLanguageLevel = languageLevel;
    }

    @Override
    public final CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        MethodCandidateInfo.CurrentCandidateProperties properties;
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(4);
        }
        if ((properties = MethodCandidateInfo.getCurrentMethod(this.myArgumentsList)) != null && properties.isApplicabilityCheck()) {
            PsiMethod method = properties.getMethod();
            LOG.error("Recursive conflict resolution for:" + method + "; " + this.myArgumentsList.getText() + "; file=" + (method == null ? "<unknown>" : method.getContainingFile()));
        }
        return MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(this.myArgumentsList, false, () -> {
            if (conflicts == null) {
                JavaMethodsConflictResolver.$$$reportNull$$$0(43);
            }
            return this.guardedOverloadResolution(conflicts);
        });
    }

    @Nullable
    protected CandidateInfo guardedOverloadResolution(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(5);
        }
        if (conflicts.isEmpty()) {
            return null;
        }
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        Map<MethodCandidateInfo, PsiSubstitutor> map = FactoryMap.create(key -> key.getSubstitutor(false));
        boolean atLeastOneMatch = this.checkParametersNumber(conflicts, this.getActualParametersLength(), map, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkSameSignatures(conflicts, map);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkParametersNumber(conflicts, this.getActualParametersLength(), map, false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkStaticMethodsOfInterfaces(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (atLeastOneMatch) {
            JavaMethodsConflictResolver.checkPotentiallyCompatibleMethods(conflicts);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
        }
        int applicabilityLevel = this.checkApplicability(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (!atLeastOneMatch) {
            return null;
        }
        this.checkSpecifics(conflicts, applicabilityLevel, map, this.myLanguageLevel);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkPrimitiveVarargs(conflicts, this.getActualParametersLength());
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        THashSet uniques = new THashSet(conflicts);
        if (uniques.size() == 1) {
            return (CandidateInfo)uniques.iterator().next();
        }
        return null;
    }

    private static void checkPotentiallyCompatibleMethods(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(6);
        }
        ArrayList<CandidateInfo> partiallyApplicable = new ArrayList<CandidateInfo>();
        Iterator<CandidateInfo> iterator = conflicts.iterator();
        while (iterator.hasNext()) {
            CandidateInfo conflict = iterator.next();
            if (!(conflict instanceof MethodCandidateInfo)) continue;
            ThreeState compatible = ((MethodCandidateInfo)conflict).isPotentiallyCompatible();
            if (compatible == ThreeState.NO) {
                iterator.remove();
                continue;
            }
            if (compatible != ThreeState.UNSURE) continue;
            partiallyApplicable.add(conflict);
        }
        if (conflicts.size() > partiallyApplicable.size()) {
            conflicts.removeAll(partiallyApplicable);
        }
    }

    public void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, @NotNull LanguageLevel languageLevel) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(7);
        }
        if (languageLevel == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(8);
        }
        this.checkSpecifics(conflicts, applicabilityLevel, null, languageLevel);
    }

    public void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, Map<MethodCandidateInfo, PsiSubstitutor> map, @NotNull LanguageLevel languageLevel) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(9);
        }
        if (languageLevel == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(10);
        }
        boolean applicable = applicabilityLevel > 1;
        int conflictsCount = conflicts.size();
        if (applicable) {
            CandidateInfo[] newConflictsArray = conflicts.toArray(CandidateInfo.EMPTY_ARRAY);
            for (int i = 1; i < conflictsCount; ++i) {
                CandidateInfo method = newConflictsArray[i];
                block5: for (int j = 0; j < i; ++j) {
                    ProgressManager.checkCanceled();
                    CandidateInfo conflict = newConflictsArray[j];
                    if (this.nonComparable(method, conflict, applicabilityLevel == 3)) continue;
                    switch (this.isMoreSpecific((MethodCandidateInfo)method, (MethodCandidateInfo)conflict, applicabilityLevel, map, languageLevel)) {
                        case FIRST: {
                            conflicts.remove(conflict);
                            continue block5;
                        }
                        case SECOND: {
                            conflicts.remove(method);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    protected boolean nonComparable(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, boolean fixedArity) {
        if (method == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(11);
        }
        if (conflict == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(12);
        }
        assert (method != conflict);
        return false;
    }

    protected static void checkAccessStaticLevels(@NotNull List<CandidateInfo> conflicts, boolean checkAccessible) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(13);
        }
        int conflictsCount = conflicts.size();
        int maxCheckLevel = -1;
        int[] checkLevels = new int[conflictsCount];
        int index = 0;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            MethodCandidateInfo method = (MethodCandidateInfo)conflict;
            int level = checkAccessible ? JavaMethodsConflictResolver.getCheckAccessLevel(method) : JavaMethodsConflictResolver.getCheckStaticLevel(method);
            checkLevels[index++] = level;
            maxCheckLevel = Math.max(maxCheckLevel, level);
        }
        for (int i = conflictsCount - 1; i >= 0; --i) {
            if (checkLevels[i] >= maxCheckLevel) continue;
            conflicts.remove(i);
        }
    }

    protected void checkSameSignatures(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(14);
        }
        this.checkSameSignatures(conflicts, null);
    }

    protected void checkSameSignatures(@NotNull List<CandidateInfo> conflicts, Map<MethodCandidateInfo, PsiSubstitutor> map) {
        PsiMethod method;
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(15);
        }
        THashMap signatures = new THashMap(conflicts.size());
        HashSet<PsiMethod> superMethods = new HashSet<PsiMethod>();
        for (CandidateInfo conflict : conflicts) {
            method = ((MethodCandidateInfo)conflict).getElement();
            PsiClass containingClass = method.getContainingClass();
            boolean isInterface = containingClass != null && containingClass.isInterface();
            for (HierarchicalMethodSignature methodSignature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
                PsiMethod superMethod = PsiSuperMethodUtil.correctMethodByScope(methodSignature.getMethod(), this.myArgumentsList.getResolveScope());
                if (!isInterface) {
                    superMethods.add(superMethod);
                    continue;
                }
                PsiClass aClass = superMethod.getContainingClass();
                if (aClass == null || "java.lang.Object".equals(aClass.getQualifiedName())) continue;
                superMethods.add(superMethod);
            }
        }
        for (int i = 0; i < conflicts.size(); ++i) {
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            method = (PsiMethod)info.getElement();
            if (!method.hasModifierProperty("static") && superMethods.contains(method)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            PsiClass class1 = method.getContainingClass();
            PsiSubstitutor infoSubstitutor = JavaMethodsConflictResolver.getSubstitutor((MethodCandidateInfo)info, map);
            MethodSignature signature = method.getSignature(infoSubstitutor);
            CandidateInfo existing = (CandidateInfo)signatures.get(signature);
            if (existing == null) {
                signatures.put(signature, info);
                continue;
            }
            PsiMethod existingMethod = (PsiMethod)existing.getElement();
            PsiClass existingClass = existingMethod.getContainingClass();
            if (class1 != null && existingClass != null) {
                if (class1.isInterface() && "java.lang.Object".equals(existingClass.getQualifiedName())) {
                    signatures.put(signature, info);
                    continue;
                }
                if (existingClass.isInterface() && "java.lang.Object".equals(class1.getQualifiedName())) {
                    conflicts.remove(info);
                    --i;
                    continue;
                }
            }
            if (method != existingMethod) continue;
            PsiElement scope1 = info.getCurrentFileResolveScope();
            PsiElement scope2 = existing.getCurrentFileResolveScope();
            if (!(scope1 instanceof PsiClass) || !(scope2 instanceof PsiClass) || !PsiTreeUtil.isAncestor(scope1, scope2, true) || existing.isAccessible()) continue;
            signatures.put(signature, info);
        }
    }

    @NotNull
    private static PsiSubstitutor getSubstitutor(MethodCandidateInfo existing, Map<MethodCandidateInfo, PsiSubstitutor> map) {
        PsiSubstitutor psiSubstitutor = map != null ? map.get(existing) : existing.getSubstitutor(false);
        if (psiSubstitutor == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(16);
        }
        return psiSubstitutor;
    }

    private static boolean areTypeParametersAgree(@NotNull CandidateInfo info) {
        if (info == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(17);
        }
        return ((MethodCandidateInfo)info).getPertinentApplicabilityLevel() != 1;
    }

    private void checkStaticMethodsOfInterfaces(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(18);
        }
        if (!(this.myArgumentsList instanceof PsiExpressionList)) {
            return;
        }
        PsiClass qualifierClass = null;
        Iterator<CandidateInfo> iterator = conflicts.iterator();
        while (iterator.hasNext()) {
            PsiClass containingClass;
            PsiMethod method;
            CandidateInfo conflict = iterator.next();
            if (!(conflict instanceof MethodCandidateInfo) || !(method = ((MethodCandidateInfo)conflict).getElement()).hasModifierProperty("static") || conflict.getCurrentFileResolveScope() instanceof PsiImportStaticStatement || (containingClass = method.getContainingClass()) == null || !containingClass.isInterface()) continue;
            if (qualifierClass == null && (qualifierClass = this.getQualifiedClass(method)) == null) {
                return;
            }
            if (containingClass.getManager().areElementsEquivalent(containingClass, qualifierClass)) continue;
            iterator.remove();
        }
    }

    private PsiClass getQualifiedClass(PsiMethod method) {
        PsiElement parent = this.myArgumentsList.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            PsiClass qualifierClass;
            PsiExpression expression = ((PsiMethodCallExpression)parent).getMethodExpression().getQualifierExpression();
            if (expression instanceof PsiReferenceExpression) {
                PsiElement resolve = ((PsiReferenceExpression)expression).resolve();
                if (resolve instanceof PsiClass) {
                    return (PsiClass)resolve;
                }
            } else if (expression == null && !ImportsUtil.hasStaticImportOn(parent, method, true) && (qualifierClass = PsiTreeUtil.getParentOfType(parent, PsiClass.class)) != null && !PsiTreeUtil.isAncestor(method.getContainingClass(), qualifierClass, false)) {
                return qualifierClass;
            }
            if (expression != null) {
                return PsiUtil.resolveClassInType(expression.getType());
            }
        }
        return null;
    }

    public boolean checkParametersNumber(@NotNull List<CandidateInfo> conflicts, int argumentsCount, Map<MethodCandidateInfo, PsiSubstitutor> map, boolean ignoreIfStaticsProblem) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(19);
        }
        boolean atLeastOneMatch = false;
        TIntArrayList unmatchedIndices = null;
        for (int i = 0; i < conflicts.size(); ++i) {
            boolean isVarargs;
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            if (ignoreIfStaticsProblem && !info.isStaticsScopeCorrect()) {
                return true;
            }
            if (!(info instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)info).getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            boolean bl = (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? ((MethodCandidateInfo)info).isVarargs() : method.isVarArgs()) && parametersCount - 1 <= argumentsCount ? true : (isVarargs = false);
            if (isVarargs || parametersCount == argumentsCount) {
                if (unmatchedIndices != null) {
                    for (int u = unmatchedIndices.size() - 1; u >= 0; --u) {
                        MethodCandidateInfo candidateInfo;
                        PsiMethod candidateToRemove;
                        int index = unmatchedIndices.get(u);
                        if (ignoreIfStaticsProblem && isVarargs && (candidateToRemove = (candidateInfo = (MethodCandidateInfo)conflicts.get(index)).getElement()) != method) {
                            PsiSubstitutor candidateToRemoveSubst = map.get(candidateInfo);
                            PsiSubstitutor substitutor = map.get(info);
                            if (MethodSignatureUtil.isSubsignature(candidateToRemove.getSignature(candidateToRemoveSubst), method.getSignature(substitutor))) continue;
                        }
                        conflicts.remove(index);
                        --i;
                    }
                    unmatchedIndices = null;
                }
                atLeastOneMatch = true;
                continue;
            }
            if (atLeastOneMatch) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (unmatchedIndices == null) {
                unmatchedIndices = new TIntArrayList(conflicts.size() - i);
            }
            unmatchedIndices.add(i);
        }
        return atLeastOneMatch;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public int checkApplicability(@NotNull List<CandidateInfo> conflicts) {
        int level;
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(20);
        }
        int maxApplicabilityLevel = 0;
        boolean toFilter = false;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)conflict);
            if (maxApplicabilityLevel > 0 && maxApplicabilityLevel != level) {
                toFilter = true;
            }
            if (level <= maxApplicabilityLevel) continue;
            maxApplicabilityLevel = level;
        }
        if (toFilter) {
            Iterator<CandidateInfo> iterator = conflicts.iterator();
            while (iterator.hasNext()) {
                ProgressManager.checkCanceled();
                CandidateInfo info = iterator.next();
                level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)info);
                if (level >= maxApplicabilityLevel) continue;
                iterator.remove();
            }
        }
        return maxApplicabilityLevel;
    }

    protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict) {
        if (conflict == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(21);
        }
        return conflict.getPertinentApplicabilityLevel();
    }

    private static int getCheckAccessLevel(@NotNull MethodCandidateInfo method) {
        boolean visible;
        if (method == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(22);
        }
        return (visible = method.isAccessible()) ? 1 : 0;
    }

    private static int getCheckStaticLevel(@NotNull MethodCandidateInfo method) {
        boolean available;
        if (method == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(23);
        }
        return ((available = method.isStaticsScopeCorrect()) ? 1 : 0) << 1 | (method.getCurrentFileResolveScope() instanceof PsiImportStaticStatement ? 0 : 1);
    }

    private int getActualParametersLength() {
        if (this.myActualParameterTypes == null) {
            LOG.assertTrue(this.myArgumentsList instanceof PsiExpressionList, this.myArgumentsList);
            return ((PsiExpressionList)this.myArgumentsList).getExpressions().length;
        }
        return this.myActualParameterTypes.length;
    }

    private Specifics isMoreSpecific(@NotNull MethodCandidateInfo info1, @NotNull MethodCandidateInfo info2, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, Map<MethodCandidateInfo, PsiSubstitutor> map, @NotNull LanguageLevel languageLevel) {
        boolean varargs2;
        boolean varargs1;
        if (info1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(24);
        }
        if (info2 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(25);
        }
        if (languageLevel == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(26);
        }
        PsiMethod method1 = info1.getElement();
        PsiMethod method2 = info2.getElement();
        PsiClass class1 = method1.getContainingClass();
        PsiClass class2 = method2.getContainingClass();
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        PsiTypeParameter[] typeParameters1 = method1.getTypeParameters();
        PsiTypeParameter[] typeParameters2 = method2.getTypeParameters();
        PsiSubstitutor classSubstitutor1 = JavaMethodsConflictResolver.getSubstitutor(info1, map);
        PsiSubstitutor classSubstitutor2 = JavaMethodsConflictResolver.getSubstitutor(info2, map);
        int argsLength = languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (method1.isVarArgs() || method2.isVarArgs()) ? this.getActualParametersLength() : 0;
        int max = Math.max(Math.max(params1.length, params2.length), argsLength);
        PsiType[] types1 = PsiType.createArray(max);
        PsiType[] types2 = PsiType.createArray(max);
        boolean[] varargs = new boolean[max];
        boolean varargsPosition = applicabilityLevel == 2;
        for (int i = 0; i < max; ++i) {
            PsiType type2;
            ProgressManager.checkCanceled();
            PsiType type1 = params1.length > 0 ? params1[Math.min(i, params1.length - 1)].getType() : null;
            PsiType psiType = type2 = params2.length > 0 ? params2[Math.min(i, params2.length - 1)].getType() : null;
            if (varargsPosition) {
                if (type1 instanceof PsiEllipsisType && type2 instanceof PsiEllipsisType && params1.length == params2.length && (class1 != null && !JavaVersionService.getInstance().isAtLeast(class1, JavaSdkVersion.JDK_1_7) || ((PsiArrayType)type1).getComponentType().equalsToText("java.lang.Object") || ((PsiArrayType)type2).getComponentType().equalsToText("java.lang.Object"))) {
                    type1 = ((PsiEllipsisType)type1).toArrayType();
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                } else {
                    type1 = type1 instanceof PsiEllipsisType ? ((PsiArrayType)type1).getComponentType() : type1;
                    type2 = type2 instanceof PsiEllipsisType ? ((PsiArrayType)type2).getComponentType() : type2;
                    varargs[i] = true;
                }
            }
            types1[i] = type1;
            types2[i] = type2;
        }
        boolean sameBoxing = true;
        boolean[] boxingHappened = new boolean[2];
        PsiExpression[] args = this.myArgumentsList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentsList).getExpressions() : null;
        for (int i = 0; i < types1.length; ++i) {
            PsiType argType;
            ProgressManager.checkCanceled();
            if (varargs[i]) continue;
            PsiExpression arg = args != null && i < args.length ? args[i] : null;
            PsiType psiType = argType = this.myActualParameterTypes != null && i < this.getActualParametersLength() ? this.myActualParameterTypes[i] : null;
            if (arg == null && argType == null) continue;
            boolean boxingInFirst = false;
            if (JavaMethodsConflictResolver.isBoxingUsed(classSubstitutor1.substitute(types1[i]), argType, arg)) {
                boxingHappened[0] = boxingHappened[0] | true;
                boxingInFirst = true;
            }
            boolean boxingInSecond = false;
            if (JavaMethodsConflictResolver.isBoxingUsed(classSubstitutor2.substitute(types2[i]), argType, arg)) {
                boxingHappened[1] = boxingHappened[1] | true;
                boxingInSecond = true;
            }
            sameBoxing &= boxingInFirst == boxingInSecond;
        }
        if (!boxingHappened[0] && boxingHappened[1]) {
            return Specifics.FIRST;
        }
        if (boxingHappened[0] && !boxingHappened[1]) {
            return Specifics.SECOND;
        }
        if (sameBoxing) {
            PsiSubstitutor siteSubstitutor1 = info1.getSiteSubstitutor();
            PsiSubstitutor siteSubstitutor2 = info2.getSiteSubstitutor();
            PsiType[] types2AtSite = JavaMethodsConflictResolver.typesAtSite(types2, siteSubstitutor2);
            PsiType[] types1AtSite = JavaMethodsConflictResolver.typesAtSite(types1, siteSubstitutor1);
            PsiSubstitutor methodSubstitutor1 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters1, method1, siteSubstitutor1, types1, types2AtSite, languageLevel);
            boolean applicable12 = this.isApplicableTo(types2AtSite, method1, languageLevel, varargsPosition, methodSubstitutor1, method2, siteSubstitutor2);
            PsiSubstitutor methodSubstitutor2 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters2, method2, siteSubstitutor2, types2, types1AtSite, languageLevel);
            boolean applicable21 = this.isApplicableTo(types1AtSite, method2, languageLevel, varargsPosition, methodSubstitutor2, method1, siteSubstitutor1);
            if (!this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                boolean typeArgsApplicable12 = GenericsUtil.isTypeArgumentsApplicable(typeParameters1, methodSubstitutor1, this.myArgumentsList, !applicable21);
                boolean typeArgsApplicable21 = GenericsUtil.isTypeArgumentsApplicable(typeParameters2, methodSubstitutor2, this.myArgumentsList, !applicable12);
                if (!typeArgsApplicable12) {
                    applicable12 = false;
                }
                if (!typeArgsApplicable21) {
                    applicable21 = false;
                }
            }
            if (applicable12 || applicable21) {
                boolean abstract2;
                if (applicable12 && !applicable21) {
                    return Specifics.SECOND;
                }
                if (applicable21 && !applicable12) {
                    return Specifics.FIRST;
                }
                boolean abstract1 = method1.hasModifierProperty("abstract") || method1.hasModifierProperty("default");
                boolean bl = abstract2 = method2.hasModifierProperty("abstract") || method2.hasModifierProperty("default");
                if (abstract1 && !abstract2) {
                    return Specifics.SECOND;
                }
                if (abstract2 && !abstract1) {
                    return Specifics.FIRST;
                }
                if (abstract1 && MethodSignatureUtil.areOverrideEquivalent(method1, method2)) {
                    PsiType returnType1 = siteSubstitutor1.substitute(method1.getReturnType());
                    PsiType returnType2 = siteSubstitutor2.substitute(method2.getReturnType());
                    if (returnType1 != null && returnType2 != null && returnType1.isAssignableFrom(returnType2)) {
                        return Specifics.SECOND;
                    }
                    return Specifics.FIRST;
                }
            }
        } else if (varargsPosition) {
            PsiType lastParamType1 = classSubstitutor1.substitute(types1[types1.length - 1]);
            PsiType lastParamType2 = classSubstitutor2.substitute(types2[types1.length - 1]);
            boolean assignable1 = TypeConversionUtil.isAssignable(lastParamType2, lastParamType1);
            boolean assignable2 = TypeConversionUtil.isAssignable(lastParamType1, lastParamType2);
            if (assignable1 && !assignable2) {
                return Specifics.FIRST;
            }
            if (assignable2 && !assignable1) {
                return Specifics.SECOND;
            }
        }
        if (class1 != class2 && (method1.hasModifierProperty("static") || method2.hasModifierProperty("static"))) {
            if (class2.isInheritor(class1, true)) {
                if (MethodSignatureUtil.isSubsignature(method1.getSignature(classSubstitutor1), method2.getSignature(classSubstitutor2))) {
                    return Specifics.SECOND;
                }
            } else if (class1.isInheritor(class2, true) && MethodSignatureUtil.isSubsignature(method2.getSignature(classSubstitutor2), method1.getSignature(classSubstitutor1))) {
                return Specifics.FIRST;
            }
        }
        if ((varargs1 = info1.isVarargs()) ^ (varargs2 = info2.isVarargs())) {
            return varargs1 ? Specifics.SECOND : Specifics.FIRST;
        }
        return Specifics.NEITHER;
    }

    private static boolean isBoxingUsed(PsiType parameterType, @Nullable PsiType argType, PsiExpression arg) {
        ProgressManager.checkCanceled();
        boolean isExpressionTypePrimitive = argType != null ? argType instanceof PsiPrimitiveType : PsiPolyExpressionUtil.isExpressionOfPrimitiveType(arg);
        return parameterType instanceof PsiPrimitiveType ^ isExpressionTypePrimitive;
    }

    private boolean isApplicableTo(@NotNull PsiType[] types2AtSite, @NotNull PsiMethod method1, final @NotNull LanguageLevel languageLevel, boolean varargsPosition, @NotNull PsiSubstitutor methodSubstitutor1, @NotNull PsiMethod method2, final PsiSubstitutor siteSubstitutor1) {
        PsiElement parent;
        if (types2AtSite == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(27);
        }
        if (method1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(28);
        }
        if (languageLevel == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(29);
        }
        if (methodSubstitutor1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(30);
        }
        if (method2 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(31);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && method1.getTypeParameters().length > 0 && this.myArgumentsList instanceof PsiExpressionList && (parent = this.myArgumentsList.getParent()) instanceof PsiCallExpression) {
            return InferenceSession.isMoreSpecific(method2, method1, siteSubstitutor1, ((PsiExpressionList)this.myArgumentsList).getExpressions(), this.myArgumentsList, varargsPosition);
        }
        PsiUtil.ApplicabilityChecker applicabilityChecker = new PsiUtil.ApplicabilityChecker(){

            @Override
            public boolean isApplicable(PsiType left, PsiType right, boolean allowUncheckedConversion, int argId) {
                PsiClass rightClass;
                if (right instanceof PsiClassType && (rightClass = ((PsiClassType)right).resolve()) instanceof PsiTypeParameter) {
                    right = new PsiImmediateClassType(rightClass, siteSubstitutor1);
                }
                return languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? JavaMethodsConflictResolver.this.isTypeMoreSpecific(left, right, argId) : TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion);
            }
        };
        int applicabilityLevel = PsiUtil.getApplicabilityLevel(method1, methodSubstitutor1, types2AtSite, languageLevel, false, varargsPosition, applicabilityChecker);
        return applicabilityLevel > 1;
    }

    private boolean isTypeMoreSpecific(PsiType left, PsiType right, int argId) {
        PsiExpression[] expressions;
        if (TypeConversionUtil.isAssignable(left, right, false)) {
            return true;
        }
        if (this.myArgumentsList instanceof PsiExpressionList && argId < (expressions = ((PsiExpressionList)this.myArgumentsList).getExpressions()).length) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(expressions[argId], right, left);
        }
        return false;
    }

    @NotNull
    private static PsiType[] typesAtSite(@NotNull PsiType[] types1, @NotNull PsiSubstitutor siteSubstitutor1) {
        if (types1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(32);
        }
        if (siteSubstitutor1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(33);
        }
        PsiType[] types = PsiType.createArray(types1.length);
        for (int i = 0; i < types1.length; ++i) {
            types[i] = siteSubstitutor1.substitute(types1[i]);
        }
        if (types == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(34);
        }
        return types;
    }

    @NotNull
    private static PsiSubstitutor calculateMethodSubstitutor(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiMethod method, @NotNull PsiSubstitutor siteSubstitutor, @NotNull PsiType[] types1, @NotNull PsiType[] types2, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(35);
        }
        if (method == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(36);
        }
        if (siteSubstitutor == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(37);
        }
        if (types1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(38);
        }
        if (types2 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(39);
        }
        if (languageLevel == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(40);
        }
        PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance(method.getProject()).inferTypeArguments(typeParameters, types1, types2, languageLevel);
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(method)) {
            PsiClass aClass;
            PsiType type;
            ProgressManager.checkCanceled();
            LOG.assertTrue(typeParameter != null);
            if (!substitutor.getSubstitutionMap().containsKey(typeParameter)) {
                type = siteSubstitutor.substitute(typeParameter);
                if (type instanceof PsiClassType && typeParameter.getOwner() == method && (aClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method) {
                    type = TypeConversionUtil.erasure(type, siteSubstitutor);
                }
                substitutor = substitutor.put(typeParameter, type);
                continue;
            }
            type = substitutor.substitute(typeParameter);
            if (!(type instanceof PsiClassType) || !((aClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter)) continue;
            substitutor = substitutor.put(typeParameter, JavaPsiFacade.getElementFactory(aClass.getProject()).createType(aClass, siteSubstitutor));
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(41);
        }
        return psiSubstitutor;
    }

    public void checkPrimitiveVarargs(@NotNull List<CandidateInfo> conflicts, int argumentsCount) {
        PsiType type;
        PsiType componentType;
        PsiMethod method;
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(42);
        }
        if (JavaVersionService.getInstance().isAtLeast(this.myArgumentsList, JavaSdkVersion.JDK_1_7)) {
            return;
        }
        CandidateInfo objectVararg = null;
        for (CandidateInfo conflict : conflicts) {
            PsiClassType classType;
            ProgressManager.checkCanceled();
            method = (PsiMethod)conflict.getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            if (!method.isVarArgs() || parametersCount - 1 != argumentsCount || !Comparing.equal(componentType = ((PsiArrayType)(type = method.getParameterList().getParameters()[parametersCount - 1].getType())).getComponentType(), classType = PsiType.getJavaLangObject(method.getManager(), GlobalSearchScope.allScope(method.getProject())))) continue;
            objectVararg = conflict;
        }
        if (objectVararg != null) {
            for (CandidateInfo conflict : conflicts) {
                ProgressManager.checkCanceled();
                method = (PsiMethod)conflict.getElement();
                if (method == objectVararg || !method.isVarArgs()) continue;
                int paramsCount = method.getParameterList().getParametersCount();
                type = method.getParameterList().getParameters()[paramsCount - 1].getType();
                componentType = ((PsiArrayType)type).getComponentType();
                if (argumentsCount != paramsCount - 1 || !(componentType instanceof PsiPrimitiveType)) continue;
                conflicts.remove(objectVararg);
                break;
            }
        }
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiExpression expr, PsiType sType, PsiType tType) {
        if (expr instanceof PsiParenthesizedExpression) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiParenthesizedExpression)expr).getExpression(), sType, tType);
        }
        if (expr instanceof PsiConditionalExpression) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiConditionalExpression)expr).getThenExpression(), sType, tType) && JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiConditionalExpression)expr).getElseExpression(), sType, tType);
        }
        if (expr instanceof PsiFunctionalExpression) {
            if (expr instanceof PsiLambdaExpression && !((PsiLambdaExpression)expr).hasFormalParameterTypes()) {
                return false;
            }
            if (expr instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)expr).isExact()) {
                return false;
            }
            if (LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !TypeConversionUtil.erasure(tType).isAssignableFrom(sType) && !TypeConversionUtil.erasure(sType).isAssignableFrom(tType)) {
                return InferenceSession.isFunctionalTypeMoreSpecificOnExpression(sType, tType, expr);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 34: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 34: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 26: 
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsList";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 11: 
            case 22: 
            case 23: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflict";
                break;
            }
            case 16: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info1";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info2";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types2AtSite";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSubstitutor1";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method2";
                break;
            }
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types1";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siteSubstitutor1";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siteSubstitutor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "typesAtSite";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMethodSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveConflict";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "guardedOverloadResolution";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkPotentiallyCompatibleMethods";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkSpecifics";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nonComparable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkAccessStaticLevels";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkSameSignatures";
                break;
            }
            case 16: 
            case 34: 
            case 41: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "areTypeParametersAgree";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticMethodsOfInterfaces";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkParametersNumber";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkApplicability";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPertinentApplicabilityLevel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCheckAccessLevel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCheckStaticLevel";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isMoreSpecific";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "typesAtSite";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "calculateMethodSubstitutor";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkPrimitiveVarargs";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveConflict$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 34: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Specifics {
        FIRST,
        SECOND,
        NEITHER;

    }
}

