/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Debugger;
import org.jetbrains.annotations.NotNull;

class SchedulingWrapper
implements ScheduledExecutorService {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.concurrency.SchedulingWrapper");
    private final AtomicBoolean shutdown;
    @NotNull
    final ExecutorService backendExecutorService;
    final AppDelayQueue delayQueue;
    private static final AtomicLong sequencer = new AtomicLong();

    SchedulingWrapper(@NotNull ExecutorService backendExecutorService, @NotNull AppDelayQueue delayQueue) {
        if (backendExecutorService == null) {
            SchedulingWrapper.$$$reportNull$$$0(0);
        }
        if (delayQueue == null) {
            SchedulingWrapper.$$$reportNull$$$0(1);
        }
        this.shutdown = new AtomicBoolean();
        this.delayQueue = delayQueue;
        if (backendExecutorService instanceof ScheduledExecutorService) {
            throw new IllegalArgumentException("backendExecutorService: " + backendExecutorService + " is already ScheduledExecutorService");
        }
        this.backendExecutorService = backendExecutorService;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = this.doShutdownNow();
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void shutdown() {
        this.doShutdown();
    }

    void doShutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            throw new IllegalStateException("Already shutdown");
        }
    }

    @NotNull
    List<Runnable> doShutdownNow() {
        this.doShutdown();
        List<Runnable> list = this.cancelAndRemoveTasksFromQueue();
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    List<Runnable> cancelAndRemoveTasksFromQueue() {
        List<Runnable> result2 = ContainerUtil.filter(this.delayQueue, new Condition<MyScheduledFutureTask>(){

            @Override
            public boolean value(MyScheduledFutureTask task) {
                if (task.getBackendExecutorService() == SchedulingWrapper.this.backendExecutorService) {
                    task.cancel(false);
                    return true;
                }
                return false;
            }
        });
        this.delayQueue.removeAll(new HashSet<MyScheduledFutureTask>(result2));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Shutdown. Drained tasks: " + result2);
        }
        List<Runnable> list = result2;
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(5);
        }
        if (!this.isShutdown()) {
            throw new IllegalStateException("must await termination after shutdown() or shutdownNow() only");
        }
        ArrayList<MyScheduledFutureTask> tasks = new ArrayList<MyScheduledFutureTask>(this.delayQueue);
        for (MyScheduledFutureTask task : tasks) {
            if (task.getBackendExecutorService() != this.backendExecutorService) continue;
            try {
                task.get(timeout, (TimeUnit)unit);
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        return this.backendExecutorService.awaitTermination(timeout, (TimeUnit)unit);
    }

    /*
     * WARNING - void declaration
     */
    private static long triggerTime(@NotNull AppDelayQueue queue, long delay, TimeUnit timeUnit) {
        void unit;
        if (queue == null) {
            SchedulingWrapper.$$$reportNull$$$0(6);
        }
        return SchedulingWrapper.triggerTime(queue, unit.toNanos(delay < 0L ? 0L : delay));
    }

    private static long now() {
        return System.nanoTime();
    }

    private static long triggerTime(@NotNull AppDelayQueue queue, long delay) {
        if (queue == null) {
            SchedulingWrapper.$$$reportNull$$$0(7);
        }
        return SchedulingWrapper.now() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : SchedulingWrapper.overflowFree(queue, delay));
    }

    private static long overflowFree(@NotNull AppDelayQueue queue, long delay) {
        long headDelay;
        Object head;
        if (queue == null) {
            SchedulingWrapper.$$$reportNull$$$0(8);
        }
        if ((head = queue.peek()) != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@Debugger.Capture @NotNull Runnable command, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (command == null) {
            SchedulingWrapper.$$$reportNull$$$0(9);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(10);
        }
        MyScheduledFutureTask t = new MyScheduledFutureTask(command, null, SchedulingWrapper.triggerTime(this.delayQueue, delay, (TimeUnit)unit));
        MyScheduledFutureTask myScheduledFutureTask = this.delayedExecute(t);
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(11);
        }
        return myScheduledFutureTask;
    }

    @NotNull
    private <T> MyScheduledFutureTask<T> delayedExecute(@NotNull MyScheduledFutureTask<T> t) {
        if (t == null) {
            SchedulingWrapper.$$$reportNull$$$0(12);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Submit at delay " + t.getDelay(TimeUnit.MILLISECONDS) + "ms " + BoundedTaskExecutor.info(t));
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Already shutdown");
        }
        this.delayQueue.add(t);
        if (t.getDelay(TimeUnit.DAYS) > 31L && !t.isPeriodic()) {
            throw new IllegalArgumentException("Unsupported crazy delay " + t.getDelay(TimeUnit.DAYS) + " days: " + BoundedTaskExecutor.info(t));
        }
        MyScheduledFutureTask<T> myScheduledFutureTask = t;
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(13);
        }
        return myScheduledFutureTask;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <V> ScheduledFuture<V> schedule(@Debugger.Capture @NotNull Callable<V> callable, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (callable == null) {
            SchedulingWrapper.$$$reportNull$$$0(14);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(15);
        }
        MyScheduledFutureTask t = new MyScheduledFutureTask(callable, SchedulingWrapper.triggerTime(this.delayQueue, delay, (TimeUnit)unit));
        MyScheduledFutureTask myScheduledFutureTask = this.delayedExecute(t);
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(16);
        }
        return myScheduledFutureTask;
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit timeUnit) {
        if (command == null) {
            SchedulingWrapper.$$$reportNull$$$0(17);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(18);
        }
        throw new IncorrectOperationException("Not supported because it's bad for hibernation; use scheduleWithFixedDelay() with the same parameters instead.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (command == null) {
            SchedulingWrapper.$$$reportNull$$$0(19);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(20);
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay must be positive but got: " + delay);
        }
        MyScheduledFutureTask sft = new MyScheduledFutureTask(command, null, SchedulingWrapper.triggerTime(this.delayQueue, initialDelay, (TimeUnit)unit), unit.toNanos(-delay));
        MyScheduledFutureTask myScheduledFutureTask = this.delayedExecute(sft);
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(21);
        }
        return myScheduledFutureTask;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(22);
        }
        Future<T> future = this.backendExecutorService.submit(task);
        if (future == null) {
            SchedulingWrapper.$$$reportNull$$$0(23);
        }
        return future;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result2) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(24);
        }
        Future<T> future = this.backendExecutorService.submit(task, result2);
        if (future == null) {
            SchedulingWrapper.$$$reportNull$$$0(25);
        }
        return future;
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(26);
        }
        Future<?> future = this.backendExecutorService.submit(task);
        if (future == null) {
            SchedulingWrapper.$$$reportNull$$$0(27);
        }
        return future;
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(28);
        }
        List list = this.backendExecutorService.invokeAll(tasks);
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(29);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(30);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(31);
        }
        List list = this.backendExecutorService.invokeAll(tasks, timeout, (TimeUnit)unit);
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(32);
        }
        return list;
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(33);
        }
        Object t = this.backendExecutorService.invokeAny(tasks);
        if (t == null) {
            SchedulingWrapper.$$$reportNull$$$0(34);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        void unit;
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(35);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(36);
        }
        return this.backendExecutorService.invokeAny(tasks, timeout, (TimeUnit)unit);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (command == null) {
            SchedulingWrapper.$$$reportNull$$$0(37);
        }
        this.backendExecutorService.execute(command);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutorService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delayQueue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/SchedulingWrapper";
                break;
            }
            case 5: 
            case 10: 
            case 15: 
            case 18: 
            case 20: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 28: 
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/SchedulingWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doShutdownNow";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelAndRemoveTasksFromQueue";
                break;
            }
            case 11: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "schedule";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "delayedExecute";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleWithFixedDelay";
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 29: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeAll";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "triggerTime";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "overflowFree";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "delayedExecute";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAtFixedRate";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "scheduleWithFixedDelay";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "invokeAll";
                break;
            }
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "invokeAny";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class MyScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;

        private MyScheduledFutureTask(Runnable r, V result2, long ns) {
            if (r == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(0);
            }
            super(r, result2);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        /*
         * WARNING - void declaration
         */
        private MyScheduledFutureTask(Runnable r, V result2, long ns, long l) {
            void period;
            if (r == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(1);
            }
            super(r, result2);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        private MyScheduledFutureTask(Callable<V> callable, long ns) {
            if (callable == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(2);
            }
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean canceled = super.cancel(mayInterruptIfRunning);
            SchedulingWrapper.this.delayQueue.remove(this);
            return canceled;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            if (unit == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(3);
            }
            return unit.convert(this.time - SchedulingWrapper.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            if (other == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(4);
            }
            if (other == this) {
                return 0;
            }
            if (other instanceof MyScheduledFutureTask) {
                MyScheduledFutureTask x = (MyScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : SchedulingWrapper.triggerTime(SchedulingWrapper.this.delayQueue, -p);
        }

        @Override
        public void run() {
            boolean periodic;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Executing " + BoundedTaskExecutor.info(this));
            }
            if (!(periodic = this.isPeriodic())) {
                super.run();
            } else if (this.runAndReset()) {
                this.setNextRunTime();
                SchedulingWrapper.this.delayQueue.offer(this);
            }
        }

        @Override
        public String toString() {
            Object info = BoundedTaskExecutor.info(this);
            return "Delay: " + this.getDelay(TimeUnit.MILLISECONDS) + "ms; " + (info == this ? super.toString() : info);
        }

        @NotNull
        ExecutorService getBackendExecutorService() {
            ExecutorService executorService = SchedulingWrapper.this.backendExecutorService;
            if (executorService == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(5);
            }
            return executorService;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBackendExecutorService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDelay";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

