/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdTagNameBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class XmlTagNamesIndex
extends XmlIndex<Void> {
    static final ID<String, Void> NAME = ID.create("XmlTagNames");

    public static Collection<VirtualFile> getFilesByTagName(String tagName, Project project) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, tagName, XmlTagNamesIndex.createFilter(project));
    }

    public static Collection<String> getAllTagNames(Project project) {
        return FileBasedIndex.getInstance().getAllKeys(NAME, project);
    }

    @Override
    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            XmlTagNamesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = new DataIndexer<String, Void, FileContent>(){

            @Override
            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                CharSequence text2;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StringUtil.indexOf(text2 = inputData.getContentAsText(), "http://www.w3.org/2001/XMLSchema") == -1) {
                    Map<String, Void> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                Collection<String> tags = XsdTagNameBuilder.computeTagNames(CharArrayUtil.readerFromCharSequence(text2));
                HashMap<String, Void> map = new HashMap<String, Void>(tags.size());
                for (String tag : tags) {
                    map.put(tag, null);
                }
                HashMap<String, Void> hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/xml/index/XmlTagNamesIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/xml/index/XmlTagNamesIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            XmlTagNamesIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @Override
    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
        if (voidDataExternalizer == null) {
            XmlTagNamesIndex.$$$reportNull$$$0(2);
        }
        return voidDataExternalizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xml/index/XmlTagNamesIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

