/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleNegationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.negation.display.name", new Object[0]);
        if (string == null) {
            DoubleNegationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("double.negation.problem.descriptor", new Object[0]);
        if (string == null) {
            DoubleNegationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DoubleNegationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleNegationVisitor();
    }

    public static boolean isNegation(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiPrefixExpression) {
            return DoubleNegationInspection.isUnaryNegation((PsiPrefixExpression)expression);
        }
        if (expression instanceof PsiPolyadicExpression) {
            return DoubleNegationInspection.isBinaryNegation((PsiPolyadicExpression)expression);
        }
        return false;
    }

    static boolean isUnaryNegation(PsiPrefixExpression expression) {
        return JavaTokenType.EXCL.equals(expression.getOperationTokenType());
    }

    static boolean isBinaryNegation(PsiPolyadicExpression expression) {
        for (PsiExpression operand : expression.getOperands()) {
            if (!TypeUtils.hasFloatingPointType(operand)) continue;
            return false;
        }
        return JavaTokenType.NE.equals(expression.getOperationTokenType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/DoubleNegationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        @Override
        public void visitPrefixExpression(PsiPrefixExpression expression) {
            PsiExpression nestedPrefixOperand;
            super.visitPrefixExpression(expression);
            if (!DoubleNegationInspection.isUnaryNegation(expression)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (!DoubleNegationInspection.isNegation(operand)) {
                return;
            }
            PsiExpression nestedOperand = ParenthesesUtils.stripParentheses(operand);
            if (nestedOperand instanceof PsiPrefixExpression && ((nestedPrefixOperand = ((PsiPrefixExpression)nestedOperand).getOperand()) == null || !LambdaUtil.isSafeLambdaReturnValueReplacement(expression, nestedPrefixOperand))) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            if (!DoubleNegationInspection.isBinaryNegation(expression)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            if (operands.length == 2) {
                int notNegatedCount = 0;
                for (PsiExpression operand : operands) {
                    if (DoubleNegationInspection.isNegation(operand)) continue;
                    ++notNegatedCount;
                }
                if (notNegatedCount > 1) {
                    return;
                }
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class DoubleNegationFix
    extends InspectionGadgetsFix {
        private DoubleNegationFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("double.negation.quickfix", new Object[0]);
            if (string == null) {
                DoubleNegationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement expression = descriptor.getPsiElement();
            CommentTracker tracker = new CommentTracker();
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                PsiExpression operand = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
                PsiReplacementUtil.replaceExpression(prefixExpression, BoolUtils.getNegatedExpressionText(operand, tracker), tracker);
            } else if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                PsiExpression[] operands = polyadicExpression.getOperands();
                int length = operands.length;
                if (length == 2) {
                    PsiExpression firstOperand = operands[0];
                    PsiExpression secondOperand = operands[1];
                    if (DoubleNegationInspection.isNegation(firstOperand)) {
                        PsiReplacementUtil.replaceExpression(polyadicExpression, BoolUtils.getNegatedExpressionText(firstOperand, tracker) + "==" + tracker.text(secondOperand), tracker);
                    } else {
                        PsiReplacementUtil.replaceExpression(polyadicExpression, tracker.text(firstOperand) + "==" + BoolUtils.getNegatedExpressionText(secondOperand, tracker), tracker);
                    }
                } else {
                    StringBuilder newExpressionText = new StringBuilder();
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            if (length % 2 != 1 && i == length - 1) {
                                newExpressionText.append("!=");
                            } else {
                                newExpressionText.append("==");
                            }
                        }
                        newExpressionText.append(tracker.text(operands[i]));
                    }
                    PsiReplacementUtil.replaceExpression(polyadicExpression, newExpressionText.toString(), tracker);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DoubleNegationInspection$DoubleNegationFix", "getFamilyName"));
        }
    }
}

