/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TryFinallyCanBeTryWithResourcesInspection
extends BaseInspection {
    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.display.name", new Object[0]);
        if (string == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.problem.descriptor", new Object[0]);
        if (string == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new TryFinallyCanBeTryWithResourcesFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel7OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TryFinallyCanBeTryWithResourcesVisitor();
    }

    private static boolean isVariableUsedOutsideContext(PsiVariable variable, PsiElement context) {
        VariableUsedOutsideContextVisitor visitor = new VariableUsedOutsideContextVisitor(variable, context);
        PsiCodeBlock declarationScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        if (declarationScope == null) {
            return true;
        }
        declarationScope.accept(visitor);
        return visitor.variableIsUsed();
    }

    private static List<PsiLocalVariable> collectVariables(PsiTryStatement tryStatement) {
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock == null) {
            return Collections.emptyList();
        }
        PsiStatement[] statements = finallyBlock.getStatements();
        if (statements.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<PsiLocalVariable> variables = new ArrayList<PsiLocalVariable>();
        for (PsiStatement statement : statements) {
            PsiLocalVariable variable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(statement);
            if (variable == null) continue;
            variables.add(variable);
        }
        Collections.sort(variables, PsiElementOrderComparator.getInstance());
        return variables;
    }

    @Nullable
    private static PsiLocalVariable findAutoCloseableVariable(PsiStatement statement) {
        if (statement instanceof PsiIfStatement) {
            PsiLocalVariable resourceVariable;
            PsiLocalVariable variable;
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (!(condition instanceof PsiBinaryExpression)) {
                return null;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.NE.equals(tokenType)) {
                return null;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return null;
            }
            if (PsiType.NULL.equals(rhs.getType())) {
                variable = TryFinallyCanBeTryWithResourcesInspection.resolveLocalVariable(lhs);
            } else if (PsiType.NULL.equals(lhs.getType())) {
                variable = TryFinallyCanBeTryWithResourcesInspection.resolveLocalVariable(rhs);
            } else {
                return null;
            }
            if (variable == null) {
                return null;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch instanceof PsiExpressionStatement) {
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(thenBranch);
            } else if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(ControlFlowUtils.getOnlyStatementInBlock(codeBlock));
            } else {
                return null;
            }
            if (variable.equals(resourceVariable)) {
                return resourceVariable;
            }
        } else if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"close".equals(methodName)) {
                return null;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiLocalVariable) || target instanceof PsiResourceVariable) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)target;
            if (!TryFinallyCanBeTryWithResourcesInspection.isAutoCloseable(variable)) {
                return null;
            }
            return variable;
        }
        return null;
    }

    private static boolean isAutoCloseable(PsiVariable variable) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(variable.getType());
        return InheritanceUtil.isInheritor(aClass, "java.lang.AutoCloseable");
    }

    private static int findInitialization(PsiElement[] elements, PsiVariable variable, boolean hasInitializer) {
        int result2 = -1;
        int statementsLength = elements.length;
        for (int i = 0; i < statementsLength; ++i) {
            PsiElement element = elements[i];
            if (TryFinallyCanBeTryWithResourcesInspection.isNormalAssignment(element, variable)) {
                if (result2 >= 0 && !hasInitializer) {
                    return -1;
                }
                if (hasInitializer) {
                    return i;
                }
                result2 = i;
                continue;
            }
            if (!VariableAccessUtils.variableIsAssigned(variable, element)) continue;
            return hasInitializer ? i : -1;
        }
        return result2;
    }

    private static boolean isNormalAssignment(PsiElement element, PsiVariable variable) {
        if (!(element instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)element;
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
        PsiExpression lhs = assignmentExpression.getLExpression();
        if (!(lhs instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
        PsiElement target = referenceExpression.resolve();
        return variable.equals(target);
    }

    private static PsiLocalVariable resolveLocalVariable(PsiExpression expression) {
        if (!(expression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement target = referenceExpression.resolve();
        return !(target instanceof PsiLocalVariable) ? null : (PsiLocalVariable)target;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class VariableUsedOutsideContextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean used;
        @NotNull
        private final PsiVariable variable;
        private final PsiElement skipContext;

        public VariableUsedOutsideContextVisitor(@NotNull PsiVariable variable, PsiElement skipContext) {
            if (variable == null) {
                VariableUsedOutsideContextVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
            this.skipContext = skipContext;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                VariableUsedOutsideContextVisitor.$$$reportNull$$$0(1);
            }
            if (element.equals(this.skipContext)) {
                return;
            }
            if (this.used) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                VariableUsedOutsideContextVisitor.$$$reportNull$$$0(2);
            }
            if (this.used) {
                return;
            }
            super.visitReferenceExpression(referenceExpression);
            PsiElement target = referenceExpression.resolve();
            if (target == null) {
                return;
            }
            if (target.equals(this.variable) && !VariableUsedOutsideContextVisitor.isCloseMethodCalled(referenceExpression)) {
                this.used = true;
            }
        }

        private static boolean isCloseMethodCalled(PsiReferenceExpression referenceExpression) {
            PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            return "close".equals(name);
        }

        public boolean variableIsUsed() {
            return this.used;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$VariableUsedOutsideContextVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TryFinallyCanBeTryWithResourcesVisitor
    extends BaseInspectionVisitor {
        private TryFinallyCanBeTryWithResourcesVisitor() {
        }

        @Override
        public void visitTryStatement(PsiTryStatement tryStatement) {
            super.visitTryStatement(tryStatement);
            PsiResourceList resourceList = tryStatement.getResourceList();
            if (resourceList != null) {
                return;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            List variables = TryFinallyCanBeTryWithResourcesInspection.collectVariables(tryStatement);
            if (variables.isEmpty()) {
                return;
            }
            PsiElement[] tryBlockStatements = tryBlock.getStatements();
            Iterator iterator = variables.iterator();
            while (iterator.hasNext()) {
                PsiType type;
                PsiVariable variable;
                PsiExpression initializer = (variable = (PsiVariable)iterator.next()).getInitializer();
                boolean hasInitializer = initializer == null ? false : !PsiType.NULL.equals(type = initializer.getType());
                int index = TryFinallyCanBeTryWithResourcesInspection.findInitialization(tryBlockStatements, variable, hasInitializer);
                if (index >= 0 != hasInitializer && !TryFinallyCanBeTryWithResourcesInspection.isVariableUsedOutsideContext(variable, tryBlock)) continue;
                return;
            }
            this.registerStatementError(tryStatement, new Object[0]);
        }
    }

    private static class TryFinallyCanBeTryWithResourcesFix
    extends InspectionGadgetsFix {
        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.quickfix", new Object[0]);
            if (string == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiCatchSection[] catchSections;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiTryStatement)) {
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            PsiElement[] tryBlockChildren = tryBlock.getChildren();
            LinkedHashSet<PsiLocalVariable> variables = new LinkedHashSet<PsiLocalVariable>();
            for (PsiLocalVariable variable : TryFinallyCanBeTryWithResourcesInspection.collectVariables(tryStatement)) {
                if (TryFinallyCanBeTryWithResourcesInspection.isVariableUsedOutsideContext(variable, tryBlock)) continue;
                variables.add(variable);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            StringBuilder newTryStatementText = new StringBuilder("try (");
            HashSet<Integer> unwantedChildren = new HashSet<Integer>(2);
            boolean separator = false;
            for (PsiLocalVariable variable : variables) {
                boolean hasInitializer;
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    hasInitializer = false;
                } else {
                    PsiType type = initializer.getType();
                    boolean bl = hasInitializer = !PsiType.NULL.equals(type);
                }
                if (separator) {
                    newTryStatementText.append(';');
                }
                newTryStatementText.append(variable.getTypeElement().getText()).append(' ').append(variable.getName()).append('=');
                if (hasInitializer) {
                    newTryStatementText.append(initializer.getText());
                } else {
                    PsiAssignmentExpression assignmentExpression;
                    PsiExpression rhs;
                    int index = TryFinallyCanBeTryWithResourcesInspection.findInitialization(tryBlockChildren, variable, false);
                    if (index < 0) {
                        return;
                    }
                    unwantedChildren.add(index);
                    PsiExpressionStatement expressionStatement = (PsiExpressionStatement)tryBlockChildren[index];
                    if (expressionStatement.getNextSibling() instanceof PsiWhiteSpace) {
                        unwantedChildren.add(index + 1);
                    }
                    if ((rhs = (assignmentExpression = (PsiAssignmentExpression)expressionStatement.getExpression()).getRExpression()) == null) {
                        return;
                    }
                    newTryStatementText.append(rhs.getText());
                }
                separator = true;
            }
            if (!unwantedChildren.isEmpty()) {
                for (int j = 1; !unwantedChildren.contains(j) && j < tryBlockChildren.length - 1; ++j) {
                    tryStatement.getParent().addBefore(tryBlockChildren[j], tryStatement);
                    unwantedChildren.add(j);
                }
            }
            newTryStatementText.append(") {");
            int tryBlockStatementsLength = tryBlockChildren.length - 1;
            for (int i = 1; i < tryBlockStatementsLength; ++i) {
                PsiElement child = tryBlockChildren[i];
                if (unwantedChildren.contains(i)) continue;
                newTryStatementText.append(child.getText());
            }
            newTryStatementText.append('}');
            for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
                newTryStatementText.append(catchSection.getText());
            }
            PsiElement[] finallyChildren = finallyBlock.getChildren();
            boolean appended = false;
            int finallyChildrenLength = finallyChildren.length - 1;
            ArrayList<Object> savedComments = new ArrayList<Object>();
            for (int i = 1; i < finallyChildrenLength; ++i) {
                PsiElement child = finallyChildren[i];
                if (TryFinallyCanBeTryWithResourcesFix.isCloseStatement(child, variables)) continue;
                if (!appended) {
                    if (child instanceof PsiComment) {
                        PsiComment comment = (PsiComment)child;
                        PsiElement psiElement = child.getPrevSibling();
                        if (psiElement instanceof PsiWhiteSpace && savedComments.isEmpty()) {
                            savedComments.add(psiElement);
                        }
                        savedComments.add(comment);
                        PsiElement nextSibling = child.getNextSibling();
                        if (!(nextSibling instanceof PsiWhiteSpace)) continue;
                        savedComments.add(nextSibling);
                        continue;
                    }
                    if (child instanceof PsiWhiteSpace) continue;
                    newTryStatementText.append(" finally {");
                    for (PsiElement psiElement : savedComments) {
                        newTryStatementText.append(psiElement.getText());
                    }
                    newTryStatementText.append(child.getText());
                    appended = true;
                    continue;
                }
                newTryStatementText.append(child.getText());
            }
            if (appended) {
                newTryStatementText.append('}');
            }
            for (PsiLocalVariable variable : variables) {
                variable.delete();
            }
            if (!appended) {
                int savedCommentsSize = savedComments.size();
                PsiElement parent1 = tryStatement.getParent();
                for (int i = savedCommentsSize - 1; i >= 0; --i) {
                    PsiElement psiElement = (PsiElement)savedComments.get(i);
                    parent1.addAfter(psiElement, tryStatement);
                }
            }
            PsiStatement newTryStatement = factory.createStatementFromText(newTryStatementText.toString(), element);
            tryStatement.replace(newTryStatement);
        }

        private static boolean isCloseStatement(PsiElement element, Set<PsiLocalVariable> variables) {
            if (element instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)element;
                PsiExpression expression = expressionStatement.getExpression();
                if (!(expression instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"close".equals(methodName)) {
                    return false;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable)) {
                    return false;
                }
                PsiLocalVariable variable = (PsiLocalVariable)target;
                return variables.contains(variable);
            }
            if (element instanceof PsiIfStatement) {
                PsiStatement thenBranch;
                PsiIfStatement ifStatement = (PsiIfStatement)element;
                if (ifStatement.getElseBranch() != null) {
                    return false;
                }
                PsiExpression condition = ifStatement.getCondition();
                if (!(condition instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (!JavaTokenType.NE.equals(tokenType)) {
                    return false;
                }
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    return false;
                }
                if (PsiType.NULL.equals(rhs.getType())) {
                    if (TryFinallyCanBeTryWithResourcesInspection.resolveLocalVariable(lhs) == null) {
                        return false;
                    }
                } else if (PsiType.NULL.equals(lhs.getType())) {
                    if (TryFinallyCanBeTryWithResourcesInspection.resolveLocalVariable(rhs) == null) {
                        return false;
                    }
                } else {
                    return false;
                }
                if ((thenBranch = ifStatement.getThenBranch()) instanceof PsiExpressionStatement) {
                    return TryFinallyCanBeTryWithResourcesFix.isCloseStatement(thenBranch, variables);
                }
                if (thenBranch instanceof PsiBlockStatement) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                    PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                    return TryFinallyCanBeTryWithResourcesFix.isCloseStatement(ControlFlowUtils.getOnlyStatementInBlock(codeBlock), variables);
                }
                return false;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$TryFinallyCanBeTryWithResourcesFix", "getFamilyName"));
        }
    }
}

