/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.hash.HashSet;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestUtils {
    public static final String RUN_WITH = "org.junit.runner.RunWith";
    private static final CallMatcher ASSERT_THROWS = CallMatcher.staticCall("org.junit.jupiter.api.Assertions", "assertThrows");

    private TestUtils() {
    }

    public static boolean isInTestSourceContent(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        VirtualFile virtualFile = file == null ? null : file.getVirtualFile();
        return virtualFile != null && ProjectRootManager.getInstance(file.getProject()).getFileIndex().isInTestSourceContent(virtualFile);
    }

    public static boolean isPartOfJUnitTestMethod(@NotNull PsiElement element) {
        PsiMethod method;
        if (element == null) {
            TestUtils.$$$reportNull$$$0(0);
        }
        return (method = PsiTreeUtil.getParentOfType(element, PsiMethod.class, false)) != null && TestUtils.isJUnitTestMethod(method);
    }

    public static boolean isJUnit4BeforeOrAfterMethod(@NotNull PsiMethod method) {
        if (method == null) {
            TestUtils.$$$reportNull$$$0(1);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "org.junit.Before", 1) || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "org.junit.After", 1);
    }

    public static boolean isJUnitTestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        Set<TestFramework> frameworks = TestFrameworks.detectApplicableFrameworks(containingClass);
        return frameworks.stream().anyMatch(framework -> framework.getName().startsWith("JUnit") && framework.isTestMethod(method, false));
    }

    public static boolean isRunnable(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.hasModifierProperty("abstract") || method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (!PsiType.VOID.equals(returnType)) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        return parameterList.getParametersCount() == 0;
    }

    public static boolean isJUnit3TestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        String test = "test";
        if (!methodName.startsWith("test") || !method.hasModifierProperty("public") && method.getParameterList().getParametersCount() > 0) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return TestUtils.isJUnitTestClass(containingClass);
    }

    public static boolean isJUnit4TestMethod(@Nullable PsiMethod method) {
        return method != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "org.junit.Test", 1);
    }

    public static boolean isAnnotatedTestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        TestFramework testFramework = TestFrameworks.detectFramework(containingClass);
        if (testFramework == null) {
            return false;
        }
        if (testFramework.isTestMethod(method, false)) {
            String testFrameworkName = testFramework.getName();
            return testFrameworkName.equals("JUnit4") || testFrameworkName.equals("JUnit5");
        }
        return false;
    }

    public static boolean isJUnitTestClass(@Nullable PsiClass targetClass) {
        return targetClass != null && InheritanceUtil.isInheritor(targetClass, "junit.framework.TestCase");
    }

    public static boolean isJUnit4TestClass(@Nullable PsiClass aClass, boolean runWithIsTestClass) {
        if (aClass == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, RUN_WITH, 1)) {
            return runWithIsTestClass;
        }
        for (PsiMethod method : aClass.getAllMethods()) {
            if (!TestUtils.isJUnit4TestMethod(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInTestCode(PsiElement element) {
        if (TestUtils.isPartOfJUnitTestMethod(element)) {
            return true;
        }
        PsiClass containingClass = PsiTreeUtil.getParentOfType(element, PsiClass.class);
        if (containingClass != null && TestFrameworks.getInstance().isTestOrConfig(containingClass)) {
            return true;
        }
        return TestUtils.isInTestSourceContent(element);
    }

    public static boolean testInstancePerClass(@NotNull PsiClass containingClass) {
        if (containingClass == null) {
            TestUtils.$$$reportNull$$$0(2);
        }
        return TestUtils.testInstancePerClass(containingClass, new HashSet<PsiClass>());
    }

    private static boolean testInstancePerClass(@NotNull PsiClass containingClass, HashSet<PsiClass> classes) {
        PsiAnnotation annotation;
        if (containingClass == null) {
            TestUtils.$$$reportNull$$$0(3);
        }
        if ((annotation = (PsiAnnotation)MetaAnnotationUtil.findMetaAnnotations((PsiModifierListOwner)containingClass, Collections.singletonList("org.junit.jupiter.api.TestInstance")).findFirst().orElse(null)) != null) {
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("value");
            if (value != null && value.getText().contains("PER_CLASS")) {
                return true;
            }
        } else {
            for (PsiClass superClass : containingClass.getSupers()) {
                if (!classes.add(superClass) || !TestUtils.testInstancePerClass(superClass, classes)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExceptionExpected(PsiElement element) {
        if (!TestUtils.isInTestSourceContent(element)) {
            return false;
        }
        while (element != null && !(element instanceof PsiFile)) {
            PsiElement parent;
            PsiExpressionList expressionList;
            if (element instanceof PsiMethod) {
                return TestUtils.hasExpectedExceptionAnnotation((PsiMethod)element);
            }
            if (element instanceof PsiLambdaExpression && (expressionList = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprUp(element.getParent()), PsiExpressionList.class)) != null && (parent = expressionList.getParent()) instanceof PsiMethodCallExpression && ASSERT_THROWS.test((PsiMethodCallExpression)parent)) {
                return true;
            }
            if (element instanceof PsiTryStatement && ((PsiTryStatement)element).getCatchBlocks().length > 0) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    public static boolean hasExpectedExceptionAnnotation(PsiMethod method) {
        PsiModifierList modifierList = method.getModifierList();
        return TestUtils.hasAnnotationWithParameter(modifierList, "org.junit.Test", "expected") || TestUtils.hasAnnotationWithParameter(modifierList, "org.testng.annotations.Test", "expectedExceptions");
    }

    private static boolean hasAnnotationWithParameter(PsiModifierList modifierList, String annotationName, String expectedParameterName) {
        PsiNameValuePair[] nameValuePairs;
        PsiAnnotation testAnnotation = modifierList.findAnnotation(annotationName);
        if (testAnnotation == null) {
            return false;
        }
        PsiAnnotationParameterList parameterList = testAnnotation.getParameterList();
        for (PsiNameValuePair nameValuePair : nameValuePairs = parameterList.getAttributes()) {
            String parameterName = nameValuePair.getName();
            if (!expectedParameterName.equals(parameterName)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/TestUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPartOfJUnitTestMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isJUnit4BeforeOrAfterMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "testInstancePerClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

