/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizeReplaceableByIsEmptyInspectionBase
extends BaseInspection {
    public boolean ignoreNegations = false;
    public OrderedSet<String> ignoredTypes = new OrderedSet();

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("size.replaceable.by.isempty.display.name", new Object[0]);
        if (string == null) {
            SizeReplaceableByIsEmptyInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", infos[0]);
        if (string == null) {
            SizeReplaceableByIsEmptyInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SizeReplaceableByIsEmptyVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SizeReplaceableByIsEmptyFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/SizeReplaceableByIsEmptyInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SizeReplaceableByIsEmptyVisitor
    extends BaseInspectionVisitor {
        private SizeReplaceableByIsEmptyVisitor() {
        }

        @Override
        public void visitBinaryExpression(PsiBinaryExpression expression) {
            String replacementIsEmptyCall;
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (lhs instanceof PsiMethodCallExpression) {
                String replacementIsEmptyCall2 = this.getReplacementIsEmptyCall(lhs, rhs, false, expression.getOperationTokenType());
                if (replacementIsEmptyCall2 != null) {
                    this.registerError((PsiElement)expression, replacementIsEmptyCall2);
                }
            } else if (rhs instanceof PsiMethodCallExpression && (replacementIsEmptyCall = this.getReplacementIsEmptyCall(rhs, lhs, true, expression.getOperationTokenType())) != null) {
                this.registerError((PsiElement)expression, replacementIsEmptyCall);
            }
        }

        @Nullable
        private String getReplacementIsEmptyCall(PsiExpression lhs, PsiExpression rhs, boolean flipped, IElementType tokenType) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            String isEmptyCall = this.getIsEmptyCall(callExpression);
            if (isEmptyCall == null) {
                return null;
            }
            Object object = ExpressionUtils.computeConstantExpression(rhs);
            if (!(object instanceof Integer)) {
                return null;
            }
            Integer integer = (Integer)object;
            int constant = integer;
            if (constant != 0) {
                return null;
            }
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                return isEmptyCall;
            }
            if (SizeReplaceableByIsEmptyInspectionBase.this.ignoreNegations) {
                return null;
            }
            if (JavaTokenType.NE.equals(tokenType)) {
                return '!' + isEmptyCall;
            }
            if (flipped ? JavaTokenType.LT.equals(tokenType) : JavaTokenType.GT.equals(tokenType)) {
                return '!' + isEmptyCall;
            }
            return null;
        }

        @Nullable
        private String getIsEmptyCall(PsiMethodCallExpression callExpression) {
            PsiMethod[] methods;
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"size".equals(referenceName) && !"length".equals(referenceName)) {
                return null;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 0) {
                return null;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return null;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(qualifierExpression.getType());
            if (aClass == null || PsiTreeUtil.isAncestor(aClass, callExpression, true)) {
                return null;
            }
            for (String ignoredType : SizeReplaceableByIsEmptyInspectionBase.this.ignoredTypes) {
                if (!InheritanceUtil.isInheritor(aClass, ignoredType)) continue;
                return null;
            }
            for (PsiMethod method : methods = aClass.findMethodsByName("isEmpty", true)) {
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 0) continue;
                return qualifierExpression.getText() + ".isEmpty()";
            }
            return null;
        }
    }

    protected static class SizeReplaceableByIsEmptyFix
    extends InspectionGadgetsFix {
        protected SizeReplaceableByIsEmptyFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("size.replaceable.by.isempty.quickfix", new Object[0]);
            if (string == null) {
                SizeReplaceableByIsEmptyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)descriptor.getPsiElement();
            PsiExpression operand = binaryExpression.getLOperand();
            if (!(operand instanceof PsiMethodCallExpression)) {
                operand = binaryExpression.getROperand();
            }
            if (!(operand instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String newExpression = commentTracker.text(qualifierExpression);
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.EQEQ.equals(tokenType)) {
                newExpression = '!' + newExpression;
            }
            newExpression = newExpression + ".isEmpty()";
            PsiReplacementUtil.replaceExpression(binaryExpression, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SizeReplaceableByIsEmptyInspectionBase$SizeReplaceableByIsEmptyFix", "getFamilyName"));
        }
    }
}

