/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementParser {
    private static final TokenSet TRY_CLOSERS_SET = TokenSet.create(JavaTokenType.CATCH_KEYWORD, JavaTokenType.FINALLY_KEYWORD);
    private final JavaParser myParser;

    public StatementParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            StatementParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(PsiBuilder builder) {
        return this.parseCodeBlock(builder, false);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(PsiBuilder builder, boolean isStatement) {
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        if (isStatement && JavaParserUtil.isParseStatementCodeBlocksDeep(builder)) {
            return this.parseCodeBlockDeep(builder, false);
        }
        return PsiBuilderUtil.parseBlockLazy(builder, JavaTokenType.LBRACE, JavaTokenType.RBRACE, JavaElementType.CODE_BLOCK);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlockDeep(PsiBuilder builder, boolean parseUntilEof) {
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker codeBlock = builder.mark();
        builder.advanceLexer();
        this.parseStatements(builder, parseUntilEof ? BraceMode.TILL_LAST : BraceMode.TILL_FIRST);
        boolean greedyBlock = !JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
        builder.getTokenType();
        JavaParserUtil.done(codeBlock, JavaElementType.CODE_BLOCK);
        if (greedyBlock) {
            codeBlock.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return codeBlock;
    }

    public void parseStatements(PsiBuilder builder) {
        this.parseStatements(builder, null);
    }

    private void parseStatements(PsiBuilder builder, @Nullable BraceMode braceMode) {
        while (builder.getTokenType() != null) {
            PsiBuilder.Marker statement = this.parseStatement(builder);
            if (statement != null) continue;
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.RBRACE) {
                if (braceMode == BraceMode.TILL_FIRST) {
                    return;
                }
                if (braceMode == BraceMode.TILL_LAST && builder.lookAhead(1) == null) {
                    return;
                }
            }
            PsiBuilder.Marker error = builder.mark();
            builder.advanceLexer();
            if (tokenType == JavaTokenType.ELSE_KEYWORD) {
                error.error(JavaErrorMessages.message("else.without.if", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.CATCH_KEYWORD) {
                error.error(JavaErrorMessages.message("catch.without.try", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.FINALLY_KEYWORD) {
                error.error(JavaErrorMessages.message("finally.without.try", new Object[0]));
                continue;
            }
            error.error(JavaErrorMessages.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement;
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.IF_KEYWORD) {
            return this.parseIfStatement(builder);
        }
        if (tokenType == JavaTokenType.WHILE_KEYWORD) {
            return this.parseWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.FOR_KEYWORD) {
            return this.parseForStatement(builder);
        }
        if (tokenType == JavaTokenType.DO_KEYWORD) {
            return this.parseDoWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.parseSwitchStatement(builder);
        }
        if (tokenType == JavaTokenType.CASE_KEYWORD || tokenType == JavaTokenType.DEFAULT_KEYWORD) {
            return this.parseSwitchLabelStatement(builder);
        }
        if (tokenType == JavaTokenType.BREAK_KEYWORD) {
            return StatementParser.parseBreakStatement(builder);
        }
        if (tokenType == JavaTokenType.CONTINUE_KEYWORD) {
            return StatementParser.parseContinueStatement(builder);
        }
        if (tokenType == JavaTokenType.RETURN_KEYWORD) {
            return this.parseReturnStatement(builder);
        }
        if (tokenType == JavaTokenType.THROW_KEYWORD) {
            return this.parseThrowStatement(builder);
        }
        if (tokenType == JavaTokenType.SYNCHRONIZED_KEYWORD) {
            return this.parseSynchronizedStatement(builder);
        }
        if (tokenType == JavaTokenType.TRY_KEYWORD) {
            return this.parseTryStatement(builder);
        }
        if (tokenType == JavaTokenType.ASSERT_KEYWORD) {
            return this.parseAssertStatement(builder);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseBlockStatement(builder);
        }
        if (tokenType instanceof ILazyParseableElementType) {
            builder.advanceLexer();
            return null;
        }
        if (tokenType == JavaTokenType.SEMICOLON) {
            PsiBuilder.Marker empty = builder.mark();
            builder.advanceLexer();
            JavaParserUtil.done(empty, JavaElementType.EMPTY_STATEMENT);
            return empty;
        }
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.AT) {
            PsiBuilder.Marker refPos = builder.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            StatementParser.skipQualifiedName(builder);
            IElementType suspectedLT = builder.getTokenType();
            IElementType next = builder.lookAhead(1);
            refPos.rollbackTo();
            if (suspectedLT == JavaTokenType.LT || suspectedLT == JavaTokenType.DOT && next == JavaTokenType.AT) {
                PsiBuilder.Marker declStatement = builder.mark();
                PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK);
                if (decl == null) {
                    PsiBuilder.Marker marker = this.myParser.getReferenceParser().parseType(builder, 0);
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    if (marker == null) {
                        builder.advanceLexer();
                    }
                }
                JavaParserUtil.done(declStatement, JavaElementType.DECLARATION_STATEMENT);
                return declStatement;
            }
        }
        PsiBuilder.Marker pos = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr != null) {
            int count = 1;
            PsiBuilder.Marker list = expr.precede();
            PsiBuilder.Marker statement2 = list.precede();
            while (builder.getTokenType() == JavaTokenType.COMMA) {
                PsiBuilder.Marker commaPos = builder.mark();
                builder.advanceLexer();
                PsiBuilder.Marker expr1 = this.myParser.getExpressionParser().parse(builder);
                if (expr1 == null) {
                    commaPos.rollbackTo();
                    break;
                }
                commaPos.drop();
                ++count;
            }
            if (count > 1) {
                pos.drop();
                JavaParserUtil.done(list, JavaElementType.EXPRESSION_LIST);
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_LIST_STATEMENT);
                return statement2;
            }
            if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                PsiBuilderUtil.drop(list, pos);
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_STATEMENT);
                return statement2;
            }
            pos.rollbackTo();
        } else {
            pos.drop();
        }
        PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK);
        if (decl != null) {
            statement = decl.precede();
            JavaParserUtil.done(statement, JavaElementType.DECLARATION_STATEMENT);
            return statement;
        }
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.COLON) {
            statement = builder.mark();
            PsiBuilderUtil.advance(builder, 2);
            this.parseStatement(builder);
            JavaParserUtil.done(statement, JavaElementType.LABELED_STATEMENT);
            return statement;
        }
        if (expr != null) {
            statement = builder.mark();
            this.myParser.getExpressionParser().parse(builder);
            JavaParserUtil.semicolon(builder);
            JavaParserUtil.done(statement, JavaElementType.EXPRESSION_STATEMENT);
            return statement;
        }
        return null;
    }

    private static void skipQualifiedName(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            return;
        }
        while (builder.getTokenType() == JavaTokenType.DOT && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            PsiBuilderUtil.advance(builder, 2);
        }
    }

    @NotNull
    private PsiBuilder.Marker parseIfStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!this.parseExpressionInParenth(builder)) {
            JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(1);
            }
            return marker;
        }
        PsiBuilder.Marker thenStatement = this.parseStatement(builder);
        if (thenStatement == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(2);
            }
            return marker;
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.ELSE_KEYWORD)) {
            JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(3);
            }
            return marker;
        }
        PsiBuilder.Marker elseStatement = this.parseStatement(builder);
        if (elseStatement == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(4);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!this.parseExpressionInParenth(builder)) {
            JavaParserUtil.done(statement, JavaElementType.WHILE_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(5);
            }
            return marker;
        }
        PsiBuilder.Marker bodyStatement = this.parseStatement(builder);
        if (bodyStatement == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.WHILE_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(6);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseForStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(7);
            }
            return marker;
        }
        PsiBuilder.Marker afterParenth = builder.mark();
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, false, true);
        if (param == null || JavaParserUtil.exprType(param) != JavaElementType.PARAMETER || builder.getTokenType() != JavaTokenType.COLON) {
            afterParenth.rollbackTo();
            PsiBuilder.Marker marker = this.parseForLoopFromInitializer(builder, statement);
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(8);
            }
            return marker;
        }
        afterParenth.drop();
        PsiBuilder.Marker marker = this.parseForEachFromColon(builder, statement);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(9);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseForLoopFromInitializer(PsiBuilder builder, PsiBuilder.Marker statement) {
        PsiBuilder.Marker bodyStatement;
        PsiBuilder.Marker init = this.parseStatement(builder);
        if (init == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                PsiBuilder.Marker marker = statement;
                if (marker == null) {
                    StatementParser.$$$reportNull$$$0(10);
                }
                return marker;
            }
        } else {
            PsiBuilder.Marker expr;
            boolean missingSemicolon = false;
            if (StatementParser.getLastToken(builder) != JavaTokenType.SEMICOLON) {
                missingSemicolon = !JavaParserUtil.expectOrError(builder, JavaTokenType.SEMICOLON, "expected.semicolon");
            }
            missingSemicolon &= (expr = this.myParser.getExpressionParser().parse(builder)) == null;
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON)) {
                if (!missingSemicolon) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.semicolon", new Object[0]));
                }
                if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                    JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(11);
                    }
                    return marker;
                }
            } else {
                this.parseForUpdateExpressions(builder);
                if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
                    JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(12);
                    }
                    return marker;
                }
            }
        }
        if ((bodyStatement = this.parseStatement(builder)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(13);
        }
        return marker;
    }

    private static IElementType getLastToken(PsiBuilder builder) {
        IElementType token;
        int offset = -1;
        while (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(token = builder.rawLookup(offset))) {
            --offset;
        }
        return token;
    }

    private void parseForUpdateExpressions(PsiBuilder builder) {
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            return;
        }
        if (builder.getTokenType() != JavaTokenType.COMMA) {
            PsiBuilder.Marker expressionStatement = expr.precede();
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_STATEMENT);
            expressionStatement.setCustomEdgeTokenBinders(null, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        } else {
            PsiBuilder.Marker expressionList = expr.precede();
            PsiBuilder.Marker expressionStatement = expressionList.precede();
            do {
                builder.advanceLexer();
                PsiBuilder.Marker nextExpression = this.myParser.getExpressionParser().parse(builder);
                if (nextExpression != null) continue;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            } while (builder.getTokenType() == JavaTokenType.COMMA);
            JavaParserUtil.done(expressionList, JavaElementType.EXPRESSION_LIST);
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_LIST_STATEMENT);
            expressionStatement.setCustomEdgeTokenBinders(null, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
    }

    @NotNull
    private PsiBuilder.Marker parseForEachFromColon(PsiBuilder builder, PsiBuilder.Marker statement) {
        builder.advanceLexer();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            PsiBuilder.Marker bodyStatement = this.parseStatement(builder);
            if (bodyStatement == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            }
        } else {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.FOREACH_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(14);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseDoWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker body = this.parseStatement(builder);
        if (body == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.DO_WHILE_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(15);
            }
            return marker;
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.WHILE_KEYWORD)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.while", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.DO_WHILE_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(16);
            }
            return marker;
        }
        if (this.parseExpressionInParenth(builder)) {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.DO_WHILE_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(17);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSwitchStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!this.parseExpressionInParenth(builder)) {
            JavaParserUtil.done(statement, JavaElementType.SWITCH_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(18);
            }
            return marker;
        }
        PsiBuilder.Marker body = this.parseCodeBlock(builder, true);
        if (body == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.SWITCH_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(19);
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker parseSwitchLabelStatement(PsiBuilder builder) {
        PsiBuilder.Marker expr;
        PsiBuilder.Marker statement = builder.mark();
        boolean isCase = builder.getTokenType() == JavaTokenType.CASE_KEYWORD;
        builder.advanceLexer();
        if (isCase && (expr = this.myParser.getExpressionParser().parse(builder)) == null) {
            statement.rollbackTo();
            return null;
        }
        JavaParserUtil.expectOrError(builder, JavaTokenType.COLON, "expected.colon");
        JavaParserUtil.done(statement, JavaElementType.SWITCH_LABEL_STATEMENT);
        return statement;
    }

    @NotNull
    private static PsiBuilder.Marker parseBreakStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.BREAK_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(20);
        }
        return marker;
    }

    @NotNull
    private static PsiBuilder.Marker parseContinueStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.CONTINUE_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(21);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseReturnStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        this.myParser.getExpressionParser().parse(builder);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.RETURN_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(22);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseThrowStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.THROW_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(23);
            }
            return marker;
        }
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.THROW_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(24);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSynchronizedStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!this.parseExpressionInParenth(builder)) {
            JavaParserUtil.done(statement, JavaElementType.SYNCHRONIZED_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(25);
            }
            return marker;
        }
        PsiBuilder.Marker body = this.parseCodeBlock(builder, true);
        if (body == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.SYNCHRONIZED_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(26);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseTryStatement(PsiBuilder builder) {
        PsiBuilder.Marker finallyBlock;
        PsiBuilder.Marker tryBlock;
        boolean hasResourceList;
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        boolean bl = hasResourceList = builder.getTokenType() == JavaTokenType.LPARENTH;
        if (hasResourceList) {
            this.myParser.getDeclarationParser().parseResourceList(builder);
        }
        if ((tryBlock = this.parseCodeBlock(builder, true)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.TRY_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(27);
            }
            return marker;
        }
        if (!hasResourceList && !TRY_CLOSERS_SET.contains(builder.getTokenType())) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.catch.or.finally", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.TRY_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(28);
            }
            return marker;
        }
        while (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD && this.parseCatchBlock(builder)) {
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.FINALLY_KEYWORD) && (finallyBlock = this.parseCodeBlock(builder, true)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.TRY_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(29);
        }
        return marker;
    }

    public boolean parseCatchBlock(PsiBuilder builder) {
        assert (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD) : builder.getTokenType();
        PsiBuilder.Marker section = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, true, false);
        if (param == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.parameter", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker body = this.parseCodeBlock(builder, true);
        if (body == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
        return true;
    }

    @NotNull
    private PsiBuilder.Marker parseAssertStatement(PsiBuilder builder) {
        PsiBuilder.Marker expr2;
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.boolean.expression", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.ASSERT_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(30);
            }
            return marker;
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.COLON) && (expr2 = this.myParser.getExpressionParser().parse(builder)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.ASSERT_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(31);
            }
            return marker;
        }
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.ASSERT_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(32);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseBlockStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        this.parseCodeBlock(builder, true);
        JavaParserUtil.done(statement, JavaElementType.BLOCK_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(33);
        }
        return marker;
    }

    private boolean parseExpressionInParenth(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            return false;
        }
        PsiBuilder.Marker beforeExpr = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null || builder.getTokenType() == JavaTokenType.SEMICOLON) {
            beforeExpr.rollbackTo();
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                return false;
            }
        } else {
            beforeExpr.drop();
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
                return false;
            }
        }
        builder.advanceLexer();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/StatementParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/StatementParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIfStatement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWhileStatement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForStatement";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForLoopFromInitializer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForEachFromColon";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDoWhileStatement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSwitchStatement";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBreakStatement";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContinueStatement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReturnStatement";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseThrowStatement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSynchronizedStatement";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTryStatement";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAssertStatement";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBlockStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BraceMode {
        TILL_FIRST,
        TILL_LAST;

    }
}

