/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.BundleBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SideBorder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.Function;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.AppleBoldDottedPainter;
import com.intellij.util.ui.CenteredIcon;
import com.intellij.util.ui.ClientPropertyHolder;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.WavePainter;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.im.InputContext;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import org.intellij.lang.annotations.JdkConstants;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.java2d.SunGraphicsEnvironment;

public class UIUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
    public static final String BORDER_LINE = "<hr size=1 noshade>";
    private static final StyleSheet DEFAULT_HTML_KIT_CSS;
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE;
    private static final String[] STANDARD_FONT_SIZES;
    private static final GrayFilter DEFAULT_GRAY_FILTER;
    private static final GrayFilter DARCULA_GRAY_FILTER;
    public static final char MNEMONIC = '\u001b';
    @NonNls
    public static final String HTML_MIME = "text/html";
    @NonNls
    public static final String JSLIDER_ISFILLED = "JSlider.isFilled";
    @NonNls
    public static final String ARIAL_FONT_NAME = "Arial";
    @NonNls
    public static final String TABLE_FOCUS_CELL_BACKGROUND_PROPERTY = "Table.focusCellBackground";
    @NonNls
    public static final String CENTER_TOOLTIP_DEFAULT = "ToCenterTooltip";
    @NonNls
    public static final String CENTER_TOOLTIP_STRICT = "ToCenterTooltip.default";
    private static final Pattern CLOSE_TAG_PATTERN;
    @NonNls
    private static final String FOCUS_PROXY_KEY = "isFocusProxy";
    public static final Key<Integer> KEEP_BORDER_SIDES;
    private static final Key<UndoManager> UNDO_MANAGER;
    private static final AbstractAction REDO_ACTION;
    private static final AbstractAction UNDO_ACTION;
    private static final Color UNFOCUSED_SELECTION_COLOR;
    private static final Color ACTIVE_HEADER_COLOR;
    private static final Color INACTIVE_HEADER_COLOR;
    private static final Color BORDER_COLOR;
    public static final Color CONTRAST_BORDER_COLOR;
    public static final Color SIDE_PANEL_BACKGROUND;
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final int DEFAULT_HGAP = 10;
    public static final int DEFAULT_VGAP = 4;
    public static final int LARGE_VGAP = 12;
    public static final Insets PANEL_REGULAR_INSETS;
    public static final Insets PANEL_SMALL_INSETS;
    public static final Border DEBUG_MARKER_BORDER;
    private static volatile Pair<String, Integer> ourSystemFontData;
    public static float DEF_SYSTEM_FONT_SIZE;
    @NonNls
    private static final String ROOT_PANE = "JRootPane.future";
    private static final Ref<Boolean> ourRetina;
    private static Boolean jreHiDPI;
    private static boolean jreHiDPI_earlierVersion;
    private static final Map<Class, Ref<Method>> ourDefaultIconMethodsCache;
    public static final Color GTK_AMBIANCE_TEXT_COLOR;
    public static final Color GTK_AMBIANCE_BACKGROUND_COLOR;
    private static String systemLaFClassName;
    public static final int LIST_FIXED_CELL_HEIGHT = 20;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS;
    private static final JBTreeTraverser<Component> UI_TRAVERSER;
    private static final Function.Mono<Component> COMPONENT_PARENT;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static final DocumentAdapter SET_TEXT_CHECKER;
    private static Map<String, String> ourRealFontFamilies;
    public static final String CHECKBOX_ROLLOVER_PROPERTY = "JCheckBox.rollOver.rectangle";
    public static final String CHECKBOX_PRESSED_PROPERTY = "JCheckBox.pressed.rectangle";

    public static void decorateFrame(@NotNull JRootPane pane) {
        if (pane == null) {
            UIUtil.$$$reportNull$$$0(0);
        }
        if (Registry.is("ide.mac.allowDarkWindowDecorations")) {
            pane.putClientProperty("jetbrains.awt.windowDarkAppearance", UIUtil.isUnderDarcula());
        }
    }

    private static void blockATKWrapper() {
        if (!SystemInfo.isLinux || !Registry.is("linux.jdk.accessibility.atkwrapper.block")) {
            return;
        }
        if (ScreenReader.isEnabled("org.GNOME.Accessibility.AtkWrapper")) {
            System.setProperty("javax.accessibility.assistive_technologies", "java.lang.Object");
            LOG.info("org.GNOME.Accessibility.AtkWrapper is blocked, see IDEA-149219");
        }
    }

    public static int getMultiClickInterval() {
        Object property = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (property instanceof Integer) {
            return (Integer)property;
        }
        return 500;
    }

    public static void applyStyle(@NotNull ComponentStyle componentStyle, @NotNull Component comp) {
        if (componentStyle == null) {
            UIUtil.$$$reportNull$$$0(1);
        }
        if (comp == null) {
            UIUtil.$$$reportNull$$$0(2);
        }
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)comp;
        if (UIUtil.isUnderAquaBasedLookAndFeel()) {
            c.putClientProperty("JComponent.sizeVariant", StringUtil.toLowerCase(componentStyle.name()));
        }
        FontSize fontSize = componentStyle == ComponentStyle.MINI ? FontSize.MINI : (componentStyle == ComponentStyle.SMALL ? FontSize.SMALL : FontSize.NORMAL);
        c.setFont(UIUtil.getFont(fontSize, c.getFont()));
        Container p = c.getParent();
        if (p != null) {
            SwingUtilities.updateComponentTreeUI(p);
        }
    }

    public static Cursor getTextCursor(Color backgroundColor) {
        return SystemInfo.isMac && ColorUtil.isDark(backgroundColor) ? MacUIUtil.getInvertedTextCursor() : Cursor.getPredefinedCursor(2);
    }

    public static void drawFramingLines(@NotNull Graphics2D g, int startX, int endX, int topY, int bottomY, @NotNull Color color) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(3);
        }
        if (color == null) {
            UIUtil.$$$reportNull$$$0(4);
        }
        UIUtil.drawLine(g, startX, topY, endX, topY, null, color);
        UIUtil.drawLine(g, startX, bottomY, endX, bottomY, null, color);
    }

    public static GrayFilter getGrayFilter() {
        return UIUtil.isUnderDarcula() ? DARCULA_GRAY_FILTER : DEFAULT_GRAY_FILTER;
    }

    public static boolean isAppleRetina() {
        return false;
    }

    public static Couple<Color> getCellColors(JTable table, boolean isSel, int row, int column) {
        return Couple.of(isSel ? table.getSelectionForeground() : table.getForeground(), isSel ? table.getSelectionBackground() : table.getBackground());
    }

    public static void fixOSXEditorBackground(@NotNull JTable table) {
        if (table == null) {
            UIUtil.$$$reportNull$$$0(5);
        }
        if (!SystemInfo.isMac) {
            return;
        }
        if (table.isEditing()) {
            int column = table.getEditingColumn();
            int row = table.getEditingRow();
            Component renderer = column >= 0 && row >= 0 ? table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), true, table.hasFocus(), row, column) : null;
            Component component = table.getEditorComponent();
            if (component != null && renderer != null) {
                UIUtil.changeBackGround(component, renderer.getBackground());
            }
        }
    }

    public static boolean isDialogFont(Font font) {
        return "Dialog".equals(font.getFamily(Locale.US));
    }

    public static boolean isScrolledToTheBottom(JComponent c) {
        JScrollPane scrollPane;
        JScrollPane jScrollPane = scrollPane = c != null ? UIUtil.getParentOfType(JScrollPane.class, c) : null;
        if (scrollPane == null) {
            return true;
        }
        Rectangle viewRect = scrollPane.getViewport().getViewRect();
        return c.getHeight() == viewRect.y + viewRect.height;
    }

    private UIUtil() {
    }

    public static boolean isJreHiDPI() {
        return UIUtil.isJreHiDPI((GraphicsConfiguration)null);
    }

    public static boolean isJreHiDPI(@Nullable GraphicsConfiguration gc) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(gc));
    }

    public static boolean isJreHiDPI(@Nullable Graphics2D g) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(g));
    }

    public static boolean isJreHiDPI(@Nullable Component comp) {
        return UIUtil.isJreHiDPI(comp != null ? comp.getGraphicsConfiguration() : null);
    }

    public static boolean isJreHiDPI(@Nullable JBUI.ScaleContext ctx) {
        return UIUtil.isJreHiDPIEnabled() && JBUI.isHiDPI(JBUI.sysScale(ctx));
    }

    public static boolean isJreHiDPIEnabled() {
        if (jreHiDPI != null) {
            return jreHiDPI;
        }
        jreHiDPI = false;
        jreHiDPI_earlierVersion = true;
        if (SystemInfo.isLinux) {
            return false;
        }
        if (SystemInfo.isJetBrainsJvm) {
            try {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                if (ge instanceof SunGraphicsEnvironment) {
                    Method m = ReflectionUtil.getDeclaredMethod(SunGraphicsEnvironment.class, "isUIScaleOn", new Class[0]);
                    jreHiDPI = (Boolean)m.invoke((Object)ge, new Object[0]);
                    jreHiDPI_earlierVersion = false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (SystemInfo.isMac) {
            jreHiDPI = true;
        }
        return jreHiDPI;
    }

    static boolean isJreHiDPI_earlierVersion() {
        UIUtil.isJreHiDPIEnabled();
        return jreHiDPI_earlierVersion;
    }

    public static boolean isRetina(Graphics2D graphics) {
        return SystemInfo.isMac ? DetectRetinaKit.isMacRetina(graphics) : UIUtil.isRetina();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        if ("true".equalsIgnoreCase(System.getProperty("is.hidpi"))) {
            return true;
        }
        if (Registry.is("new.retina.detection")) {
            return DetectRetinaKit.isRetina();
        }
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set(false);
                try {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    Integer scale = ReflectionUtil.getField(device.getClass(), device, Integer.TYPE, "scale");
                    if (scale != null && scale == 2) {
                        ourRetina.set(true);
                        return true;
                    }
                }
                catch (AWTError aWTError) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ourRetina.set(false);
            }
            return ourRetina.get();
        }
    }

    public static boolean hasLeakingAppleListeners() {
        return SystemInfo.isMac && System.getProperty("java.runtime.version").startsWith("1.6.0_29");
    }

    public static void removeLeakingAppleListeners() {
        if (!UIUtil.hasLeakingAppleListeners()) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String name = "apple.awt.contentScaleFactor";
        for (PropertyChangeListener each : toolkit.getPropertyChangeListeners(name)) {
            toolkit.removePropertyChangeListener(name, each);
        }
    }

    public static boolean isClientPropertyTrue(Object component, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(6);
        }
        return Boolean.TRUE.equals(UIUtil.getClientProperty(component, key));
    }

    public static Object getClientProperty(Object component, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(7);
        }
        return component instanceof JComponent ? ((JComponent)component).getClientProperty(key) : null;
    }

    public static <T> T getClientProperty(Object component, @NotNull Class<T> type) {
        if (type == null) {
            UIUtil.$$$reportNull$$$0(8);
        }
        return ObjectUtils.tryCast(UIUtil.getClientProperty(component, type), type);
    }

    public static <T> T getClientProperty(Object component, @NotNull Key<T> key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(9);
        }
        return (T)UIUtil.getClientProperty(component, key);
    }

    public static <T> void putClientProperty(@NotNull JComponent component, @NotNull Key<T> key, T value) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(10);
        }
        if (key == null) {
            UIUtil.$$$reportNull$$$0(11);
        }
        component.putClientProperty(key, value);
    }

    public static String getHtmlBody(@NotNull String text) {
        int bodyIndex;
        int htmlIndex;
        if (text == null) {
            UIUtil.$$$reportNull$$$0(12);
        }
        if ((htmlIndex = 6 + text.indexOf("<html>")) < 6) {
            return text.replaceAll("\n", "<br>");
        }
        int htmlCloseIndex = text.indexOf("</html>", htmlIndex);
        if (htmlCloseIndex < 0) {
            htmlCloseIndex = text.length();
        }
        if ((bodyIndex = 6 + text.indexOf("<body>", htmlIndex)) < 6) {
            return text.substring(htmlIndex, htmlCloseIndex);
        }
        int bodyCloseIndex = text.indexOf("</body>", bodyIndex);
        if (bodyCloseIndex < 0) {
            bodyCloseIndex = text.length();
        }
        return text.substring(bodyIndex, Math.min(bodyCloseIndex, htmlCloseIndex));
    }

    public static String getHtmlBody(Html html) {
        String result = UIUtil.getHtmlBody(html.getText());
        return html.isKeepFont() ? result : result.replaceAll("<font(.*?)>", "").replaceAll("</font>", "");
    }

    public static void drawLinePickedOut(Graphics graphics, int x, int y, int x1, int y1) {
        if (x == x1) {
            int minY = Math.min(y, y1);
            int maxY = Math.max(y, y1);
            UIUtil.drawLine(graphics, x, minY + 1, x1, maxY - 1);
        } else if (y == y1) {
            int minX = Math.min(x, x1);
            int maxX = Math.max(x, x1);
            UIUtil.drawLine(graphics, minX + 1, y, maxX - 1, y1);
        } else {
            UIUtil.drawLine(graphics, x, y, x1, y1);
        }
    }

    public static boolean isReallyTypedEvent(KeyEvent e) {
        char c = e.getKeyChar();
        if (c < ' ' || c == '\u007f') {
            return false;
        }
        if (SystemInfo.isWindows && c >= '\u200c' && c <= '\u200f') {
            return true;
        }
        if (SystemInfo.isMac) {
            return !e.isMetaDown() && !e.isControlDown();
        }
        return !e.isAltDown() && !e.isControlDown();
    }

    public static int getStringY(@NotNull String string, @NotNull Rectangle bounds, @NotNull Graphics2D g) {
        if (string == null) {
            UIUtil.$$$reportNull$$$0(13);
        }
        if (bounds == null) {
            UIUtil.$$$reportNull$$$0(14);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(15);
        }
        int centerY = bounds.height / 2;
        Font font = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle stringBounds = font.getStringBounds(string, frc).getBounds();
        return (int)((double)centerY - (double)stringBounds.height / 2.0 - (double)stringBounds.y);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label, @NotNull Graphics g) {
        if (label == null) {
            UIUtil.$$$reportNull$$$0(16);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(17);
        }
        UIUtil.drawLabelDottedRectangle(label, g, null);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label, @NotNull Graphics g, @Nullable Rectangle bounds) {
        if (label == null) {
            UIUtil.$$$reportNull$$$0(18);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(19);
        }
        if (bounds == null) {
            bounds = UIUtil.getLabelTextBounds(label);
        }
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int baseLine = label.getUI().getBaseline(label, label.getWidth(), label.getHeight());
        int textY = baseLine - fm.getLeading() - fm.getAscent();
        int textHeight = fm.getHeight();
        UIUtil.drawDottedRectangle(g, bounds.x, textY, bounds.x + bounds.width - 1, textY + textHeight - 1);
    }

    public static Rectangle getLabelTextBounds(@NotNull JLabel label) {
        if (label == null) {
            UIUtil.$$$reportNull$$$0(20);
        }
        Dimension size = label.getPreferredSize();
        Icon icon = label.getIcon();
        Point point = new Point(0, 0);
        Insets insets = label.getInsets();
        if (icon != null) {
            point.x += label.getIconTextGap();
            point.x += icon.getIconWidth();
        }
        point.x += insets.left;
        point.y += insets.top;
        size.width -= point.x;
        size.width -= insets.right;
        size.height -= insets.bottom;
        return new Rectangle(point, size);
    }

    public static int getHighestGlyphHeight(@NotNull String string, @NotNull Font font, @NotNull Graphics graphics) {
        if (string == null) {
            UIUtil.$$$reportNull$$$0(21);
        }
        if (font == null) {
            UIUtil.$$$reportNull$$$0(22);
        }
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(23);
        }
        FontRenderContext frc = ((Graphics2D)graphics).getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, string);
        int maxHeight = 0;
        for (int i = 0; i < string.length(); ++i) {
            maxHeight = Math.max(maxHeight, (int)gv.getGlyphMetrics(i).getBounds2D().getHeight());
        }
        return maxHeight;
    }

    public static void setEnabled(Component component, boolean enabled, boolean recursively) {
        UIUtil.setEnabled(component, enabled, recursively, false);
    }

    public static void setEnabled(Component component, boolean enabled, boolean recursively, boolean visibleOnly) {
        JBIterable<Component> all = recursively ? ((JBTreeTraverser)UIUtil.uiTraverser(component).expandAndFilter(visibleOnly ? new Condition<Component>(){

            @Override
            public boolean value(Component c) {
                return c.isVisible();
            }
        } : Conditions.alwaysTrue())).traverse() : JBIterable.of(component);
        Color fg = enabled ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground();
        for (Component c : all) {
            c.setEnabled(enabled);
            if (fg == null || !(c instanceof JLabel)) continue;
            c.setForeground(fg);
        }
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        Stroke stroke = ((Graphics2D)g).getStroke();
        if (stroke instanceof BasicStroke) {
            if (x1 == x2) {
                float lineWidth = ((BasicStroke)stroke).getLineWidth();
                ((Graphics2D)g).fill(new Rectangle2D.Float(x1, Math.min(y1, y2), lineWidth, (float)Math.abs(y1 - y2) + lineWidth));
                return;
            }
            if (y1 == y2) {
                float lineWidth = ((BasicStroke)stroke).getLineWidth();
                ((Graphics2D)g).fill(new Rectangle2D.Float(Math.min(x1, x2), y1, (float)Math.abs(x1 - x2) + lineWidth, lineWidth));
                return;
            }
        }
        g.drawLine(x1, y1, x2, y2);
    }

    public static void drawLine(Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, @Nullable Color fgColor) {
        Color oldFg = g.getColor();
        Color oldBg = g.getBackground();
        if (fgColor != null) {
            g.setColor(fgColor);
        }
        if (bgColor != null) {
            g.setBackground(bgColor);
        }
        UIUtil.drawLine(g, x1, y1, x2, y2);
        if (fgColor != null) {
            g.setColor(oldFg);
        }
        if (bgColor != null) {
            g.setBackground(oldBg);
        }
    }

    public static void drawWave(Graphics2D g, Rectangle rectangle) {
        WavePainter.forColor(g.getColor()).paint(g, (int)rectangle.getMinX(), (int)rectangle.getMaxX(), (int)rectangle.getMaxY());
    }

    @NotNull
    public static String[] splitText(String text, FontMetrics fontMetrics, int widthLimit, char separator) {
        ArrayList<String> lines = new ArrayList<String>();
        String currentLine = "";
        StringBuilder currentAtom = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String s;
            int width;
            char ch = text.charAt(i);
            currentAtom.append(ch);
            if (ch == separator) {
                currentLine = currentLine + currentAtom.toString();
                currentAtom.setLength(0);
            }
            if ((width = fontMetrics.stringWidth(s = currentLine + currentAtom)) < widthLimit - fontMetrics.charWidth('w')) continue;
            if (!currentLine.isEmpty()) {
                lines.add(currentLine);
                currentLine = "";
                continue;
            }
            lines.add(currentAtom.toString());
            currentAtom.setLength(0);
        }
        String s = currentLine + currentAtom;
        if (!s.isEmpty()) {
            lines.add(s);
        }
        String[] stringArray = ArrayUtil.toStringArray(lines);
        if (stringArray == null) {
            UIUtil.$$$reportNull$$$0(24);
        }
        return stringArray;
    }

    public static void setActionNameAndMnemonic(@NotNull String text, @NotNull Action action) {
        if (text == null) {
            UIUtil.$$$reportNull$$$0(25);
        }
        if (action == null) {
            UIUtil.$$$reportNull$$$0(26);
        }
        UIUtil.assignMnemonic(text, action);
        text = text.replaceAll("&", "");
        action.putValue("Name", text);
    }

    public static void assignMnemonic(@NotNull String text, @NotNull Action action) {
        String mnemoChar;
        int mnemoPos;
        if (text == null) {
            UIUtil.$$$reportNull$$$0(27);
        }
        if (action == null) {
            UIUtil.$$$reportNull$$$0(28);
        }
        if ((mnemoPos = text.indexOf(38)) >= 0 && mnemoPos < text.length() - 2 && (mnemoChar = text.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
            action.putValue("MnemonicKey", mnemoChar.charAt(0));
        }
    }

    public static Font getLabelFont(@NotNull FontSize size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(29);
        }
        return UIUtil.getFont(size, null);
    }

    @NotNull
    public static Font getFont(@NotNull FontSize size, @Nullable Font base) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(30);
        }
        if (base == null) {
            base = UIUtil.getLabelFont();
        }
        Font font = base.deriveFont(UIUtil.getFontSize(size));
        if (font == null) {
            UIUtil.$$$reportNull$$$0(31);
        }
        return font;
    }

    public static float getFontSize(FontSize size) {
        int defSize = UIUtil.getLabelFont().getSize();
        switch (size) {
            case SMALL: {
                return Math.max((float)defSize - JBUI.scale(2.0f), JBUI.scale(11.0f));
            }
            case MINI: {
                return Math.max((float)defSize - JBUI.scale(4.0f), JBUI.scale(9.0f));
            }
        }
        return defSize;
    }

    public static Color getLabelFontColor(FontColor fontColor) {
        Color defColor = UIUtil.getLabelForeground();
        if (fontColor == FontColor.BRIGHTER) {
            return new JBColor(new Color(Math.min(defColor.getRed() + 50, 255), Math.min(defColor.getGreen() + 50, 255), Math.min(defColor.getBlue() + 50, 255)), defColor.darker());
        }
        return defColor;
    }

    public static int getCheckBoxTextHorizontalOffset(@NotNull JCheckBox cb) {
        if (cb == null) {
            UIUtil.$$$reportNull$$$0(32);
        }
        ButtonUI ui = cb.getUI();
        String text = cb.getText();
        Icon buttonIcon = cb.getIcon();
        if (buttonIcon == null && ui != null) {
            if (ui instanceof BasicRadioButtonUI) {
                buttonIcon = ((BasicRadioButtonUI)ui).getDefaultIcon();
            } else if (UIUtil.isUnderAquaLookAndFeel()) {
                Method method;
                Ref<Method> cached = ourDefaultIconMethodsCache.get(ui.getClass());
                if (cached == null) {
                    cached = Ref.create(ReflectionUtil.findMethod(Arrays.asList(ui.getClass().getMethods()), "getDefaultIcon", JComponent.class));
                    ourDefaultIconMethodsCache.put(ui.getClass(), cached);
                    if (!cached.isNull()) {
                        cached.get().setAccessible(true);
                    }
                }
                if ((method = cached.get()) != null) {
                    try {
                        buttonIcon = (Icon)method.invoke((Object)ui, cb);
                    }
                    catch (Exception e) {
                        cached.set(null);
                    }
                }
            }
        }
        Dimension size = new Dimension();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = cb.getInsets();
        size = cb.getSize(size);
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = size.width - (i.right + viewRect.x);
        viewRect.height = size.height - (i.bottom + viewRect.y);
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        SwingUtilities.layoutCompoundLabel(cb, cb.getFontMetrics(cb.getFont()), text, buttonIcon, cb.getVerticalAlignment(), cb.getHorizontalAlignment(), cb.getVerticalTextPosition(), cb.getHorizontalTextPosition(), viewRect, iconRect, textRect, text == null ? 0 : cb.getIconTextGap());
        return textRect.x;
    }

    public static int getScrollBarWidth() {
        return UIManager.getInt("ScrollBar.width");
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static Color getLabelBackground() {
        return UIManager.getColor("Label.background");
    }

    public static Color getLabelForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public static Color getLabelDisabledForeground() {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color != null) {
            return color;
        }
        return UIManager.getColor("Label.disabledText");
    }

    @NotNull
    public static String removeMnemonic(@NotNull String s) {
        if (s == null) {
            UIUtil.$$$reportNull$$$0(33);
        }
        if (s.indexOf(38) != -1) {
            s = StringUtil.replace(s, "&", "");
        }
        if (s.indexOf(95) != -1) {
            s = StringUtil.replace(s, "_", "");
        }
        if (s.indexOf(27) != -1) {
            s = StringUtil.replace(s, String.valueOf('\u001b'), "");
        }
        String string = s;
        if (string == null) {
            UIUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    public static int getDisplayMnemonicIndex(@NotNull String s) {
        int idx;
        if (s == null) {
            UIUtil.$$$reportNull$$$0(35);
        }
        if ((idx = s.indexOf(38)) >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(38)) {
            return idx;
        }
        idx = s.indexOf(27);
        if (idx >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(27)) {
            return idx;
        }
        return -1;
    }

    public static String replaceMnemonicAmpersand(String value) {
        return BundleBase.replaceMnemonicAmpersand(value);
    }

    public static Color getTableHeaderBackground() {
        return UIManager.getColor("TableHeader.background");
    }

    public static Color getTreeTextForeground() {
        return UIManager.getColor("Tree.textForeground");
    }

    public static Color getTreeSelectionBackground() {
        return UIManager.getColor("Tree.selectionBackground");
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Color getListSelectionForeground() {
        Color color = UIManager.getColor("List.selectionForeground");
        if (color == null) {
            return UIManager.getColor("List[Selected].textForeground");
        }
        return color;
    }

    public static Color getFieldForegroundColor() {
        return UIManager.getColor("field.foreground");
    }

    public static Color getTableSelectionBackground() {
        return UIManager.getColor("Table.selectionBackground");
    }

    public static Color getActiveTextColor() {
        return UIManager.getColor("textActiveText");
    }

    public static Color getInactiveTextColor() {
        return UIManager.getColor("textInactiveText");
    }

    public static Color getSlightlyDarkerColor(Color c) {
        float[] hsl = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
        return new Color(Color.HSBtoRGB(hsl[0], hsl[1], hsl[2] - 0.08f > 0.0f ? hsl[2] - 0.08f : hsl[2]));
    }

    public static Color getActiveTextFieldBackgroundColor() {
        return UIUtil.getTextFieldBackground();
    }

    public static Color getInactiveTextFieldBackgroundColor() {
        return UIManager.getColor("TextField.inactiveBackground");
    }

    public static Font getTreeFont() {
        return UIManager.getFont("Tree.font");
    }

    public static Font getListFont() {
        return UIManager.getFont("List.font");
    }

    public static Color getTreeSelectionForeground() {
        return UIManager.getColor("Tree.selectionForeground");
    }

    public static Color getTreeForeground(boolean selected, boolean hasFocus) {
        if (!selected) {
            return UIUtil.getTreeForeground();
        }
        Color fg = UIManager.getColor("Tree.selectionInactiveForeground");
        if (!hasFocus && fg != null) {
            return fg;
        }
        return UIUtil.getTreeSelectionForeground();
    }

    public static Color getTextInactiveTextColor() {
        return UIUtil.getInactiveTextColor();
    }

    public static void installPopupMenuColorAndFonts(JComponent contentPane) {
        LookAndFeel.installColorsAndFont(contentPane, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    public static void installPopupMenuBorder(JComponent contentPane) {
        LookAndFeel.installBorder(contentPane, "PopupMenu.border");
    }

    public static Color getTreeSelectionBorderColor() {
        return UIManager.getColor("Tree.selectionBorderColor");
    }

    public static int getTreeRightChildIndent() {
        return UIManager.getInt("Tree.rightChildIndent");
    }

    public static int getTreeLeftChildIndent() {
        return UIManager.getInt("Tree.leftChildIndent");
    }

    public static Color getToolTipBackground() {
        return UIManager.getColor("ToolTip.background");
    }

    public static Color getToolTipForeground() {
        return UIManager.getColor("ToolTip.foreground");
    }

    public static Color getComboBoxDisabledForeground() {
        return UIManager.getColor("ComboBox.disabledForeground");
    }

    public static Color getComboBoxDisabledBackground() {
        return UIManager.getColor("ComboBox.disabledBackground");
    }

    public static Color getButtonSelectColor() {
        return UIManager.getColor("Button.select");
    }

    public static Integer getPropertyMaxGutterIconWidth(String propertyPrefix) {
        return (Integer)UIManager.get(propertyPrefix + ".maxGutterIconWidth");
    }

    public static Color getMenuItemDisabledForeground() {
        return UIManager.getColor("MenuItem.disabledForeground");
    }

    public static Object getMenuItemDisabledForegroundObject() {
        return UIManager.get("MenuItem.disabledForeground");
    }

    public static Object getTabbedPanePaintContentBorder(JComponent c) {
        return c.getClientProperty("TabbedPane.paintContentBorder");
    }

    public static boolean isMenuCrossMenuMnemonics() {
        return UIManager.getBoolean("Menu.crossMenuMnemonic");
    }

    public static Color getTableBackground() {
        return UIUtil.isUnderGTKLookAndFeel() ? UIUtil.getTreeTextBackground() : UIManager.getColor("Table.background");
    }

    public static Color getTableBackground(boolean isSelected) {
        return isSelected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground();
    }

    public static Color getTableSelectionForeground() {
        return UIManager.getColor("Table.selectionForeground");
    }

    public static Color getTableForeground() {
        return UIManager.getColor("Table.foreground");
    }

    public static Color getTableForeground(boolean isSelected) {
        return isSelected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
    }

    public static Color getTableGridColor() {
        return UIManager.getColor("Table.gridColor");
    }

    public static Color getListBackground() {
        return UIUtil.isUnderGTKLookAndFeel() ? UIUtil.getTreeTextBackground() : UIManager.getColor("List.background");
    }

    public static Color getListBackground(boolean isSelected) {
        return isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
    }

    public static Color getListForeground() {
        return UIManager.getColor("List.foreground");
    }

    public static Color getListForeground(boolean isSelected) {
        return isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getListForeground();
    }

    public static Color getPanelBackground() {
        return UIManager.getColor("Panel.background");
    }

    public static Color getEditorPaneBackground() {
        return UIManager.getColor("EditorPane.background");
    }

    public static Color getTreeBackground() {
        return UIManager.getColor("Tree.background");
    }

    public static Color getTreeForeground() {
        return UIManager.getColor("Tree.foreground");
    }

    public static Color getTableFocusCellBackground() {
        return UIManager.getColor(TABLE_FOCUS_CELL_BACKGROUND_PROPERTY);
    }

    public static Color getListSelectionBackground() {
        return UIManager.getColor("List.selectionBackground");
    }

    public static Color getListUnfocusedSelectionBackground() {
        return new JBColor(UNFOCUSED_SELECTION_COLOR, new Color(13, 41, 62));
    }

    public static Color getTreeSelectionBackground(boolean focused) {
        return focused ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeUnfocusedSelectionBackground();
    }

    public static Color getTreeUnfocusedSelectionBackground() {
        Color background = UIUtil.getTreeTextBackground();
        return ColorUtil.isDark(background) ? new JBColor(Gray._30, new Color(13, 41, 62)) : UNFOCUSED_SELECTION_COLOR;
    }

    public static Color getTextFieldForeground() {
        return UIManager.getColor("TextField.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIManager.getColor(UIUtil.isUnderGTKLookAndFeel() ? "EditorPane.background" : "TextField.background");
    }

    public static Font getButtonFont() {
        return UIManager.getFont("Button.font");
    }

    public static Font getToolTipFont() {
        return UIManager.getFont("ToolTip.font");
    }

    public static Color getTabbedPaneBackground() {
        return UIManager.getColor("TabbedPane.background");
    }

    public static void setSliderIsFilled(JSlider slider, boolean value) {
        slider.putClientProperty(JSLIDER_ISFILLED, value);
    }

    public static Color getLabelTextForeground() {
        return UIManager.getColor("Label.textForeground");
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Font getOptionPaneMessageFont() {
        return UIManager.getFont("OptionPane.messageFont");
    }

    public static Font getMenuFont() {
        return UIManager.getFont("Menu.font");
    }

    public static Color getSeparatorForeground() {
        return UIManager.getColor("Separator.foreground");
    }

    public static Color getSeparatorBackground() {
        return UIManager.getColor("Separator.background");
    }

    public static Color getSeparatorShadow() {
        return UIManager.getColor("Separator.shadow");
    }

    public static Color getSeparatorHighlight() {
        return UIManager.getColor("Separator.highlight");
    }

    public static Color getSeparatorColorUnderNimbus() {
        return UIManager.getColor("nimbusBlueGrey");
    }

    public static Color getSeparatorColor() {
        Color separatorColor = UIUtil.getSeparatorForeground();
        if (UIUtil.isUnderGTKLookAndFeel()) {
            separatorColor = Gray._215;
        }
        return separatorColor;
    }

    public static Border getTableFocusCellHighlightBorder() {
        return UIManager.getBorder("Table.focusCellHighlightBorder");
    }

    public static void setLineStyleAngled(ClientPropertyHolder component) {
        component.putClientProperty("JTree.lineStyle", "Angled");
    }

    public static void setLineStyleAngled(JTree component) {
        component.putClientProperty("JTree.lineStyle", "Angled");
    }

    public static Color getTableFocusCellForeground() {
        return UIManager.getColor("Table.focusCellForeground");
    }

    public static Color getPanelBackgound() {
        return UIUtil.getPanelBackground();
    }

    public static Border getTextFieldBorder() {
        return UIManager.getBorder("TextField.border");
    }

    public static Border getButtonBorder() {
        return UIManager.getBorder("Button.border");
    }

    @NotNull
    public static Icon getErrorIcon() {
        Icon icon = ObjectUtils.notNull(UIManager.getIcon("OptionPane.errorIcon"), AllIcons.General.ErrorDialog);
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(36);
        }
        return icon;
    }

    @NotNull
    public static Icon getInformationIcon() {
        Icon icon = ObjectUtils.notNull(UIManager.getIcon("OptionPane.informationIcon"), AllIcons.General.InformationDialog);
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(37);
        }
        return icon;
    }

    @NotNull
    public static Icon getQuestionIcon() {
        Icon icon = ObjectUtils.notNull(UIManager.getIcon("OptionPane.questionIcon"), AllIcons.General.QuestionDialog);
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(38);
        }
        return icon;
    }

    @NotNull
    public static Icon getWarningIcon() {
        Icon icon = ObjectUtils.notNull(UIManager.getIcon("OptionPane.warningIcon"), AllIcons.General.WarningDialog);
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(39);
        }
        return icon;
    }

    public static Icon getBalloonInformationIcon() {
        return AllIcons.General.BalloonInformation;
    }

    public static Icon getBalloonWarningIcon() {
        return AllIcons.General.BalloonWarning;
    }

    public static Icon getBalloonErrorIcon() {
        return AllIcons.General.BalloonError;
    }

    public static Icon getRadioButtonIcon() {
        return UIManager.getIcon("RadioButton.icon");
    }

    public static Icon getTreeNodeIcon(boolean expanded, boolean selected, boolean focused) {
        boolean white = selected && focused || UIUtil.isUnderDarcula();
        Icon selectedIcon = UIUtil.getTreeSelectedExpandedIcon();
        Icon notSelectedIcon = UIUtil.getTreeExpandedIcon();
        int width = Math.max(selectedIcon.getIconWidth(), notSelectedIcon.getIconWidth());
        int height = Math.max(selectedIcon.getIconWidth(), notSelectedIcon.getIconWidth());
        return new CenteredIcon(expanded ? (white ? UIUtil.getTreeSelectedExpandedIcon() : UIUtil.getTreeExpandedIcon()) : (white ? UIUtil.getTreeSelectedCollapsedIcon() : UIUtil.getTreeCollapsedIcon()), width, height, false);
    }

    public static Icon getTreeCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    public static Icon getTreeExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    public static Icon getTreeIcon(boolean expanded) {
        return expanded ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon();
    }

    public static Icon getTreeSelectedCollapsedIcon() {
        if (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() && !UIUtil.isUnderWin10LookAndFeel()) {
            return AllIcons.Mac.Tree_white_right_arrow;
        }
        return UIUtil.getTreeCollapsedIcon();
    }

    public static Icon getTreeSelectedExpandedIcon() {
        if (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() && !UIUtil.isUnderWin10LookAndFeel()) {
            return AllIcons.Mac.Tree_white_down_arrow;
        }
        return UIUtil.getTreeExpandedIcon();
    }

    public static Border getTableHeaderCellBorder() {
        return UIManager.getBorder("TableHeader.cellBorder");
    }

    public static Color getWindowColor() {
        return UIManager.getColor("window");
    }

    public static Color getTextAreaForeground() {
        return UIManager.getColor("TextArea.foreground");
    }

    public static Color getOptionPaneBackground() {
        return UIManager.getColor("OptionPane.background");
    }

    public static boolean isUnderAlloyLookAndFeel() {
        return false;
    }

    public static boolean isUnderAlloyIDEALookAndFeel() {
        return false;
    }

    public static boolean isUnderWindowsLookAndFeel() {
        return SystemInfo.isWindows && UIManager.getLookAndFeel().getName().equals("Windows");
    }

    public static boolean isUnderWindowsClassicLookAndFeel() {
        return UIManager.getLookAndFeel().getName().equals("Windows Classic");
    }

    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    public static boolean isUnderNimbusLookAndFeel() {
        return false;
    }

    public static boolean isUnderJGoodiesLookAndFeel() {
        return false;
    }

    public static boolean isUnderAquaBasedLookAndFeel() {
        return SystemInfo.isMac && (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    public static boolean isUnderDefaultMacTheme() {
        return SystemInfo.isMac && UIUtil.isUnderIntelliJLaF();
    }

    public static boolean isUnderWin10LookAndFeel() {
        return SystemInfo.isWindows && UIUtil.isUnderIntelliJLaF() && Registry.is("ide.intellij.laf.win10.ui");
    }

    public static boolean isUnderIntelliJLaF() {
        return UIManager.getLookAndFeel().getName().contains("IntelliJ");
    }

    public static boolean isUnderGTKLookAndFeel() {
        return SystemInfo.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK");
    }

    @Nullable
    public static String getGtkThemeName() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf != null && "GTKLookAndFeel".equals(laf.getClass().getSimpleName())) {
            try {
                Method method = laf.getClass().getDeclaredMethod("getGtkThemeName", new Class[0]);
                method.setAccessible(true);
                Object theme = method.invoke((Object)laf, new Object[0]);
                if (theme != null) {
                    return theme.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isMurrineBasedTheme() {
        String gtkTheme = UIUtil.getGtkThemeName();
        return "Ambiance".equalsIgnoreCase(gtkTheme) || "Radiance".equalsIgnoreCase(gtkTheme) || "Dust".equalsIgnoreCase(gtkTheme) || "Dust Sand".equalsIgnoreCase(gtkTheme);
    }

    public static Color shade(Color c, double factor, double alphaFactor) {
        assert (factor >= 0.0) : factor;
        return new Color(Math.min((int)Math.round((double)c.getRed() * factor), 255), Math.min((int)Math.round((double)c.getGreen() * factor), 255), Math.min((int)Math.round((double)c.getBlue() * factor), 255), Math.min((int)Math.round((double)c.getAlpha() * alphaFactor), 255));
    }

    public static Color mix(Color c1, Color c2, double factor) {
        assert (0.0 <= factor && factor <= 1.0) : factor;
        double backFactor = 1.0 - factor;
        return new Color(Math.min((int)Math.round((double)c1.getRed() * backFactor + (double)c2.getRed() * factor), 255), Math.min((int)Math.round((double)c1.getGreen() * backFactor + (double)c2.getGreen() * factor), 255), Math.min((int)Math.round((double)c1.getBlue() * backFactor + (double)c2.getBlue() * factor), 255));
    }

    public static boolean isFullRowSelectionLAF() {
        return UIUtil.isUnderGTKLookAndFeel();
    }

    public static boolean isUnderNativeMacLookAndFeel() {
        return UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDarcula();
    }

    public static int getListCellHPadding() {
        return UIUtil.isUnderDefaultMacTheme() ? 8 : (UIUtil.isUnderWin10LookAndFeel() ? 2 : 7);
    }

    public static int getListCellVPadding() {
        return 1;
    }

    public static Insets getListCellPadding() {
        return JBUI.insets(UIUtil.getListCellVPadding(), UIUtil.getListCellHPadding());
    }

    public static Insets getListViewportPadding() {
        return UIUtil.isUnderNativeMacLookAndFeel() ? JBUI.insets(1, 0) : (UIUtil.isUnderWin10LookAndFeel() ? JBUI.emptyInsets() : JBUI.insets(5));
    }

    public static boolean isToUseDottedCellBorder() {
        return !UIUtil.isUnderNativeMacLookAndFeel();
    }

    public static boolean isControlKeyDown(MouseEvent mouseEvent) {
        return SystemInfo.isMac ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
    }

    public static String[] getValidFontNames(boolean familyName) {
        TreeSet<String> result = new TreeSet<String>();
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            try {
                if (!UIUtil.isValidFont(font)) continue;
                result.add(familyName ? font.getFamily() : font.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Font labelFont = UIUtil.getLabelFont();
        if (labelFont != null && UIUtil.isValidFont(labelFont)) {
            result.add(familyName ? labelFont.getFamily() : labelFont.getName());
        }
        return ArrayUtil.toStringArray(result);
    }

    public static String[] getStandardFontSizes() {
        return STANDARD_FONT_SIZES;
    }

    public static boolean isValidFont(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(40);
        }
        try {
            return font.canDisplay('a') && font.canDisplay('z') && font.canDisplay('A') && font.canDisplay('Z') && font.canDisplay('0') && font.canDisplay('1');
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setupEnclosingDialogBounds(JComponent component) {
        component.revalidate();
        component.repaint();
        Window window = SwingUtilities.windowForComponent(component);
        if (window != null && (window.getSize().height < window.getMinimumSize().height || window.getSize().width < window.getMinimumSize().width)) {
            window.pack();
        }
    }

    public static String displayPropertiesToCSS(Font font, Color fg) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            UIUtil.appendColor(fg, rule);
            rule.append(" ; ");
        }
        rule.append(" }");
        return rule.toString();
    }

    public static void appendColor(Color color, StringBuilder sb) {
        if (color.getRed() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getRed()));
        if (color.getGreen() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getGreen()));
        if (color.getBlue() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getBlue()));
    }

    public static void drawDottedRectangle(Graphics g, Rectangle r) {
        UIUtil.drawDottedRectangle(g, r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            UIUtil.drawLine(g, x, i1, x, i1);
        }
    }

    public static void drawBoldDottedLine(Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (SystemInfo.isMac && !UIUtil.isRetina() || SystemInfo.isLinux) {
            UIUtil.drawAppleDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        } else {
            UIUtil.drawBoringDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        }
    }

    public static void drawSearchMatch(Graphics2D g, float startX, float endX, int height) {
        Color c1 = new Color(255, 234, 162);
        Color c2 = new Color(255, 208, 66);
        UIUtil.drawSearchMatch(g, startX, endX, height, c1, c2);
    }

    public static void drawSearchMatch(Graphics2D g, float startXf, float endXf, int height, Color c1, Color c2) {
        boolean drawRound = endXf - startXf > 4.0f;
        GraphicsConfig config = new GraphicsConfig(g);
        g.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g.setPaint(UIUtil.getGradientPaint(startXf, 2.0f, c1, startXf, height - 5, c2));
        if (UIUtil.isJreHiDPI(g)) {
            GraphicsConfig c = GraphicsUtil.setupRoundedBorderAntialiasing(g);
            g.fill(new RoundRectangle2D.Float(startXf, 2.0f, endXf - startXf, height - 4, 5.0f, 5.0f));
            c.restore();
            config.restore();
            return;
        }
        int startX = (int)startXf;
        int endX = (int)endXf;
        g.fillRect(startX, 3, endX - startX, height - 5);
        if (drawRound) {
            UIUtil.drawLine(g, startX - 1, 4, startX - 1, height - 4);
            UIUtil.drawLine(g, endX, 4, endX, height - 4);
            g.setColor(new Color(100, 100, 100, 50));
            UIUtil.drawLine(g, startX - 1, 4, startX - 1, height - 4);
            UIUtil.drawLine(g, endX, 4, endX, height - 4);
            UIUtil.drawLine(g, startX, 3, endX - 1, 3);
            UIUtil.drawLine(g, startX, height - 3, endX - 1, height - 3);
        }
        config.restore();
    }

    public static void drawRectPickedOut(Graphics2D g, int x, int y, int w, int h) {
        UIUtil.drawLine(g, x + 1, y, x + w - 1, y);
        UIUtil.drawLine(g, x + w, y + 1, x + w, y + h - 1);
        UIUtil.drawLine(g, x + w - 1, y + h, x + 1, y + h);
        UIUtil.drawLine(g, x, y + 1, x, y + h - 1);
    }

    private static void drawBoringDottedLine(Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, startX, lineY, endX, lineY);
            UIUtil.drawLine(g, startX, lineY + 1, endX, lineY + 1);
        }
        int step = 4;
        int startPosCorrection = startX % 4 < 3 ? 0 : 1;
        g.setColor(fgColor != null ? fgColor : oldColor);
        for (int dotXi = (startX / 4 + startPosCorrection) * 4; dotXi < endX; dotXi += 4) {
            UIUtil.drawLine(g, dotXi, lineY, dotXi + 1, lineY);
            UIUtil.drawLine(g, dotXi, lineY + 1, dotXi + 1, lineY + 1);
        }
        g.setColor(oldColor);
    }

    public static void drawGradientHToolbarBackground(Graphics g, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray._215, 0.0f, height, Gray._200));
        g2d.fillRect(0, 0, width, height);
    }

    public static void drawHeader(Graphics g, int x, int width, int height, boolean active, boolean drawTopLine) {
        UIUtil.drawHeader(g, x, width, height, active, false, drawTopLine, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHeader(Graphics g, int x, int width, int height, boolean active, boolean toolWindow, boolean drawTopLine, boolean drawBottomLine) {
        GraphicsConfig config = GraphicsUtil.disableAAPainting(g);
        try {
            g.setColor(UIUtil.getPanelBackground());
            g.fillRect(x, 0, width, height);
            ((Graphics2D)g).setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray.x00.withAlpha(5), 0.0f, height, Gray.x00.withAlpha(20)));
            g.fillRect(x, 0, width, height);
            if (active) {
                g.setColor(new Color(100, 150, 230, toolWindow ? 50 : 30));
                g.fillRect(x, 0, width, height);
            }
            g.setColor(SystemInfo.isMac && UIUtil.isUnderIntelliJLaF() ? Gray.xC9 : Gray.x00.withAlpha(toolWindow ? 90 : 50));
            if (drawTopLine) {
                UIUtil.drawLine(g, x, 0, width, 0);
            }
            if (drawBottomLine) {
                UIUtil.drawLine(g, x, height - 1, width, height - 1);
            }
            if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
                g.setColor(Gray.xC9);
            } else {
                g.setColor(UIUtil.isUnderDarcula() ? CONTRAST_BORDER_COLOR : Gray.xFF.withAlpha(100));
            }
            UIUtil.drawLine(g, x, 0, width, 0);
        }
        finally {
            config.restore();
        }
    }

    public static void drawDoubleSpaceDottedLine(Graphics2D g, int start, int end, int xOrY, Color fgColor, boolean horizontal) {
        g.setColor(fgColor);
        for (int dot = start; dot < end; dot += 3) {
            if (horizontal) {
                UIUtil.drawLine(g, dot, xOrY, dot, xOrY);
                continue;
            }
            UIUtil.drawLine(g, xOrY, dot, xOrY, dot);
        }
    }

    private static void drawAppleDottedLine(Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, startX, lineY, endX, lineY);
            UIUtil.drawLine(g, startX, lineY + 1, endX, lineY + 1);
            UIUtil.drawLine(g, startX, lineY + 2, endX, lineY + 2);
        }
        AppleBoldDottedPainter painter = AppleBoldDottedPainter.forColor(ObjectUtils.notNull(fgColor, oldColor));
        painter.paint(g, startX, endX, lineY);
    }

    public static void applyRenderingHints(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            g2d.addRenderingHints(map);
        }
    }

    @NotNull
    public static BufferedImage createImage(int width, int height, int type) {
        if (UIUtil.isJreHiDPI()) {
            BufferedImage bufferedImage = RetinaImage.create(width, height, type);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(41);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(42);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage createImage(GraphicsConfiguration gc, int width, int height, int type) {
        if (UIUtil.isJreHiDPI(gc)) {
            BufferedImage bufferedImage = RetinaImage.create(gc, width, height, type);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(43);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(44);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage createImage(Graphics g, int width, int height, int type) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            if (UIUtil.isJreHiDPI(g2d)) {
                BufferedImage bufferedImage = RetinaImage.create(g2d, width, height, type);
                if (bufferedImage == null) {
                    UIUtil.$$$reportNull$$$0(45);
                }
                return bufferedImage;
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, type);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(46);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = UIUtil.createImage(width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(47);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage createImage(Component comp, int width, int height, int type) {
        BufferedImage bufferedImage = comp != null ? UIUtil.createImage(comp.getGraphicsConfiguration(), width, height, type) : UIUtil.createImage(width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(48);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage createImageForGraphics(Graphics2D g, int width, int height, int type) {
        BufferedImage bufferedImage = UIUtil.createImage(g, width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(49);
        }
        return bufferedImage;
    }

    public static void drawImage(Graphics g, Image image, int x, int y, ImageObserver observer) {
        UIUtil.drawImage(g, image, x, y, -1, -1, observer);
    }

    public static void drawImage(Graphics g, Image image, @Nullable Rectangle dstBounds, ImageObserver observer) {
        UIUtil.drawImage(g, image, dstBounds, null, observer);
    }

    public static void drawImage(Graphics g, Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, ImageObserver observer) {
        boolean srcSizeUndefined;
        Image drawImage = image;
        if (image instanceof JBHiDPIScaledImage && (drawImage = ((JBHiDPIScaledImage)image).getDelegate()) == null) {
            drawImage = image;
        }
        int dx = 0;
        int dy = 0;
        int dw = -1;
        int dh = -1;
        if (dstBounds != null) {
            dx = dstBounds.x;
            dy = dstBounds.y;
            dw = dstBounds.width;
            dh = dstBounds.height;
        }
        boolean dstSizeUndefined = dw == -1 && dh == -1;
        int sx = 0;
        int sy = 0;
        int sw = -1;
        int sh = -1;
        if (srcBounds != null) {
            sx = srcBounds.x;
            sy = srcBounds.y;
            sw = srcBounds.width;
            sh = srcBounds.height;
        }
        boolean bl = srcSizeUndefined = sw == -1 && sh == -1;
        if (dstSizeUndefined && srcSizeUndefined) {
            UIUtil.drawImage(g, image, null, dx, dy, -1, -1, observer);
        } else {
            if (dstSizeUndefined) {
                dw = ImageUtil.getUserWidth(image);
                dh = ImageUtil.getUserHeight(image);
            }
            if (srcSizeUndefined) {
                sw = ImageUtil.getRealWidth(image);
                sh = ImageUtil.getRealHeight(image);
            }
            g.drawImage(drawImage, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, observer);
        }
    }

    @Deprecated
    public static void drawImage(Graphics g, Image image, int x, int y, int width, int height, ImageObserver observer) {
        UIUtil.drawImage(g, image, null, x, y, width, height, observer);
    }

    private static void drawImage(Graphics g, Image image, @Nullable BufferedImageOp op, int x, int y, int width, int height, ImageObserver observer) {
        double scale = 1.0;
        Graphics invG = null;
        boolean srcSizeUndefined = width == -1 && height == -1;
        int dstw = ImageUtil.getUserWidth(image);
        int dsth = ImageUtil.getUserHeight(image);
        if (image instanceof JBHiDPIScaledImage) {
            AffineTransform tx;
            JBHiDPIScaledImage hidpiImage = (JBHiDPIScaledImage)image;
            Image delegate = hidpiImage.getDelegate();
            if (delegate != null) {
                image = delegate;
            }
            scale = hidpiImage.getScale();
            if (srcSizeUndefined && scale == (tx = ((Graphics2D)g).getTransform()).getScaleX()) {
                double gScaleX = tx.getScaleX();
                double gScaleY = tx.getScaleY();
                tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
                tx.translate((double)x * gScaleX, (double)y * gScaleY);
                invG = (Graphics2D)g.create();
                ((Graphics2D)invG).setTransform(tx);
            }
        }
        if (op != null && image instanceof BufferedImage) {
            image = op.filter((BufferedImage)image, null);
        }
        if (invG != null) {
            invG.drawImage(image, 0, 0, observer);
            invG.dispose();
        } else if (srcSizeUndefined) {
            g.drawImage(image, x, y, dstw, dsth, observer);
        } else {
            int srcw = (int)Math.ceil((double)width * scale);
            int srch = (int)Math.ceil((double)height * scale);
            g.drawImage(image, x, y, x + width, y + height, 0, 0, srcw, srch, observer);
        }
    }

    public static void drawImage(Graphics g, BufferedImage image, BufferedImageOp op, int x, int y) {
        UIUtil.drawImage(g, image, op, x, y, -1, -1, null);
    }

    public static void paintWithXorOnRetina(@NotNull Dimension size, @NotNull Graphics g, Consumer<Graphics2D> paintRoutine) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(50);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(51);
        }
        UIUtil.paintWithXorOnRetina(size, g, true, paintRoutine);
    }

    public static void paintWithXorOnRetina(@NotNull Dimension size, @NotNull Graphics g, boolean useRetinaCondition, Consumer<Graphics2D> paintRoutine) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(52);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(53);
        }
        if (!useRetinaCondition || !UIUtil.isJreHiDPI((Graphics2D)g) || Registry.is("ide.mac.retina.disableDrawingFix")) {
            paintRoutine.consume((Graphics2D)g);
        } else {
            Rectangle rect = g.getClipBounds();
            if (rect == null) {
                rect = new Rectangle(size);
            }
            BufferedImage image = new BufferedImage(rect.width * 2, rect.height * 2, 1);
            Graphics2D imageGraphics = (Graphics2D)((Image)image).getGraphics();
            imageGraphics.scale(2.0, 2.0);
            imageGraphics.translate(-rect.x, -rect.y);
            imageGraphics.setClip(rect.x, rect.y, rect.width, rect.height);
            paintRoutine.consume(imageGraphics);
            image.flush();
            imageGraphics.dispose();
            ((Graphics2D)g).scale(0.5, 0.5);
            g.drawImage(image, rect.x * 2, rect.y * 2, null);
        }
    }

    public static void setupComposite(@NotNull Graphics2D g) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(54);
        }
        g.setComposite(X_RENDER_ACTIVE.getValue() != false ? AlphaComposite.SrcOver : AlphaComposite.Src);
    }

    public static void dispatchAllInvocationEvents() {
        while (UIUtil.dispatchInvocationEvent()) {
        }
    }

    public static boolean dispatchInvocationEvent() {
        assert (EdtInvocationManager.getInstance().isEventDispatchThread()) : Thread.currentThread() + "; EDT: " + UIUtil.getEventQueueThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        AWTEvent event = eventQueue.peekEvent();
        if (event == null) {
            return false;
        }
        try {
            event = eventQueue.getNextEvent();
            if (event instanceof InvocationEvent) {
                eventQueue.getClass().getDeclaredMethod("dispatchEvent", AWTEvent.class).invoke((Object)eventQueue, event);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.rethrowAllAsUnchecked(e.getCause());
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return true;
    }

    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = ReflectionUtil.getDeclaredMethod(EventQueue.class, "getDispatchThread", new Class[0]);
            return (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void pump() {
        assert (!SwingUtilities.isEventDispatchThread());
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                queue.offer(queue);
            }
        });
        try {
            queue.take();
        }
        catch (InterruptedException e) {
            LOG.error(e);
        }
    }

    public static void addAwtListener(final AWTEventListener listener, long mask, Disposable parent) {
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, mask);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            }
        });
    }

    public static void addParentChangeListener(@NotNull Component component, @NotNull PropertyChangeListener listener) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(55);
        }
        if (listener == null) {
            UIUtil.$$$reportNull$$$0(56);
        }
        component.addPropertyChangeListener("ancestor", listener);
    }

    public static void removeParentChangeListener(@NotNull Component component, @NotNull PropertyChangeListener listener) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(57);
        }
        if (listener == null) {
            UIUtil.$$$reportNull$$$0(58);
        }
        component.removePropertyChangeListener("ancestor", listener);
    }

    public static void drawVDottedLine(Graphics2D g, int lineX, int startY, int endY, @Nullable Color bgColor, Color fgColor) {
        if (bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, lineX, startY, lineX, endY);
        }
        g.setColor(fgColor);
        for (int i = startY / 2 * 2; i < endY; i += 2) {
            g.drawRect(lineX, i, 0, 0);
        }
    }

    public static void drawHDottedLine(Graphics2D g, int startX, int endX, int lineY, @Nullable Color bgColor, Color fgColor) {
        if (bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, startX, lineY, endX, lineY);
        }
        g.setColor(fgColor);
        for (int i = startX / 2 * 2; i < endX; i += 2) {
            g.drawRect(i, lineY, 0, 0);
        }
    }

    public static void drawDottedLine(Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, Color fgColor) {
        if (x1 == x2) {
            UIUtil.drawVDottedLine(g, x1, y1, y2, bgColor, fgColor);
        } else if (y1 == y2) {
            UIUtil.drawHDottedLine(g, x1, x2, y1, bgColor, fgColor);
        } else {
            throw new IllegalArgumentException("Only vertical or horizontal lines are supported");
        }
    }

    public static void drawStringWithHighlighting(Graphics g, String s, int x, int y, Color foreground, Color highlighting) {
        g.setColor(highlighting);
        boolean isRetina = UIUtil.isJreHiDPI((Graphics2D)g);
        float scale = 1.0f / JBUI.sysScale((Graphics2D)g);
        for (float i = (float)(x - 1); i <= (float)(x + 1); i += isRetina ? scale : 1.0f) {
            for (float j = (float)(y - 1); j <= (float)(y + 1); j += isRetina ? scale : 1.0f) {
                ((Graphics2D)g).drawString(s, i, j);
            }
        }
        g.setColor(foreground);
        g.drawString(s, x, y);
    }

    public static void drawCenteredString(Graphics2D g, Rectangle rect, String str, boolean horzCentered, boolean vertCentered) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int textWidth = fm.stringWidth(str) - 1;
        int x = horzCentered ? Math.max(rect.x, rect.x + (rect.width - textWidth) / 2) : rect.x;
        int y = vertCentered ? Math.max(rect.y, rect.y + rect.height / 2 + fm.getAscent() * 2 / 5) : rect.y;
        Shape oldClip = g.getClip();
        g.clip(rect);
        g.drawString(str, x, y);
        g.setClip(oldClip);
    }

    public static void drawCenteredString(Graphics2D g, Rectangle rect, String str) {
        UIUtil.drawCenteredString(g, rect, str, true, true);
    }

    public static boolean isFocusAncestor(@NotNull JComponent component) {
        Component owner;
        if (component == null) {
            UIUtil.$$$reportNull$$$0(59);
        }
        if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            return false;
        }
        if (owner == component) {
            return true;
        }
        return SwingUtilities.isDescendingFrom(owner, component);
    }

    public static boolean isCloseClick(MouseEvent e) {
        return UIUtil.isCloseClick(e, 501);
    }

    public static boolean isCloseClick(MouseEvent e, int effectiveType) {
        if (e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 2 || e.getButton() == 1 && e.isShiftDown();
    }

    public static boolean isActionClick(MouseEvent e) {
        return UIUtil.isActionClick(e, 501);
    }

    public static boolean isActionClick(MouseEvent e, int effectiveType) {
        return UIUtil.isActionClick(e, effectiveType, false);
    }

    public static boolean isActionClick(MouseEvent e, int effectiveType, boolean allowShift) {
        if (!allowShift && UIUtil.isCloseClick(e) || e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 1;
    }

    @NotNull
    public static Color getBgFillColor(@NotNull Component c) {
        Component parent;
        if (c == null) {
            UIUtil.$$$reportNull$$$0(60);
        }
        Color color = (parent = UIUtil.findNearestOpaque(c)) == null ? c.getBackground() : parent.getBackground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(61);
        }
        return color;
    }

    @Nullable
    public static Component findNearestOpaque(Component c) {
        return UIUtil.findParentByCondition(c, new Condition<Component>(){

            @Override
            public boolean value(Component component) {
                return component.isOpaque();
            }
        });
    }

    @Nullable
    public static Component findParentByCondition(@Nullable Component c, @NotNull Condition<Component> condition) {
        if (condition == null) {
            UIUtil.$$$reportNull$$$0(62);
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!condition.value(eachParent)) continue;
            return eachParent;
        }
        return null;
    }

    @Deprecated
    public static <T extends Component> T findParentByClass(@NotNull Component c, Class<T> cls) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(63);
        }
        return (T)((Component)UIUtil.getParentOfType(cls, c));
    }

    @Nullable
    public static Component getDeepestComponentAt(@NotNull Component parent, int x, int y) {
        Component component;
        if (parent == null) {
            UIUtil.$$$reportNull$$$0(64);
        }
        if ((component = SwingUtilities.getDeepestComponentAt(parent, x, y)) != null && component.getParent() instanceof JRootPane) {
            JRootPane rootPane = (JRootPane)component.getParent();
            Point point = SwingUtilities.convertPoint(parent, new Point(x, y), rootPane.getLayeredPane());
            component = SwingUtilities.getDeepestComponentAt(rootPane.getLayeredPane(), point.x, point.y);
            if (component == null) {
                point = SwingUtilities.convertPoint(parent, new Point(x, y), rootPane.getContentPane());
                component = SwingUtilities.getDeepestComponentAt(rootPane.getContentPane(), point.x, point.y);
            }
        }
        return component;
    }

    @Language(value="HTML")
    public static String getCssFontDeclaration(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(65);
        }
        return UIUtil.getCssFontDeclaration(font, null, null, null);
    }

    @Language(value="HTML")
    public static String getCssFontDeclaration(@NotNull Font font, @Nullable Color fgColor, @Nullable Color linkColor, @Nullable String liImg) {
        URL resource;
        if (font == null) {
            UIUtil.$$$reportNull$$$0(66);
        }
        StringBuilder builder = new StringBuilder().append("<style>\n");
        String familyAndSize = "font-family:'" + font.getFamily() + "'; font-size:" + font.getSize() + "pt;";
        builder.append("body, div, td, p {").append(familyAndSize);
        if (fgColor != null) {
            builder.append(" color:#").append(ColorUtil.toHex(fgColor)).append(';');
        }
        builder.append("}\n");
        builder.append("a {").append(familyAndSize);
        if (linkColor != null) {
            builder.append(" color:#").append(ColorUtil.toHex(linkColor)).append(';');
        }
        builder.append("}\n");
        builder.append("code {font-size:").append(font.getSize()).append("pt;}\n");
        URL uRL = resource = liImg != null ? SystemInfo.class.getResource(liImg) : null;
        if (resource != null) {
            builder.append("ul {list-style-image:url('").append(StringUtil.escapeCharCharacters(resource.toExternalForm())).append("');}\n");
        }
        return builder.append("</style>").toString();
    }

    public static boolean isWinLafOnVista() {
        return SystemInfo.isWinVistaOrNewer && "Windows".equals(UIManager.getLookAndFeel().getName());
    }

    public static boolean isStandardMenuLAF() {
        return UIUtil.isWinLafOnVista() || UIUtil.isUnderGTKLookAndFeel();
    }

    public static Color getFocusedFillColor() {
        return UIUtil.toAlpha(UIUtil.getListSelectionBackground(), 100);
    }

    public static Color getFocusedBoundsColor() {
        return UIUtil.getBoundsColor();
    }

    public static Color getBoundsColor() {
        return UIUtil.getBorderColor();
    }

    public static Color getBoundsColor(boolean focused) {
        return focused ? UIUtil.getFocusedBoundsColor() : UIUtil.getBoundsColor();
    }

    public static Color toAlpha(Color color, int alpha) {
        Color actual = color != null ? color : Color.black;
        return new Color(actual.getRed(), actual.getGreen(), actual.getBlue(), alpha);
    }

    public static boolean isFocusable(JComponent component) {
        return component != null && component.isFocusable() && component.isEnabled() && component.isShowing();
    }

    @Deprecated
    public static void requestFocus(final @NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(67);
        }
        if (c.isShowing()) {
            c.requestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    c.requestFocus();
                }
            });
        }
    }

    public static void dispose(Component c) {
        MouseWheelListener[] mouseWheelListeners;
        MouseMotionListener[] motionListeners;
        MouseListener[] mouseListeners;
        if (c == null) {
            return;
        }
        for (MouseListener each : mouseListeners = c.getMouseListeners()) {
            c.removeMouseListener(each);
        }
        for (MouseMotionListener each : motionListeners = c.getMouseMotionListeners()) {
            c.removeMouseMotionListener(each);
        }
        for (MouseWheelListener each : mouseWheelListeners = c.getMouseWheelListeners()) {
            c.removeMouseWheelListener(each);
        }
        if (c instanceof AbstractButton) {
            ActionListener[] listeners;
            for (ActionListener listener : listeners = ((AbstractButton)c).getActionListeners()) {
                ((AbstractButton)c).removeActionListener(listener);
            }
        }
    }

    public static void disposeProgress(final JProgressBar progress) {
        if (!UIUtil.isUnderNativeMacLookAndFeel()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progress.setUI(null);
            }
        });
    }

    @Nullable
    public static Component findUltimateParent(Component c) {
        if (c == null) {
            return null;
        }
        Component eachParent = c;
        while (eachParent.getParent() != null) {
            eachParent = eachParent.getParent();
        }
        return eachParent;
    }

    public static Color getHeaderActiveColor() {
        return ACTIVE_HEADER_COLOR;
    }

    public static Color getHeaderInactiveColor() {
        return INACTIVE_HEADER_COLOR;
    }

    public static Color getBorderColor() {
        return UIUtil.isUnderDarcula() ? Gray._50 : BORDER_COLOR;
    }

    public static Font getTitledBorderFont() {
        Font defFont = UIUtil.getLabelFont();
        return defFont.deriveFont((float)defFont.getSize() - 1.0f);
    }

    public static Color getBorderInactiveColor() {
        return UIUtil.getBorderColor();
    }

    public static Color getBorderActiveColor() {
        return UIUtil.getBorderColor();
    }

    public static Color getBorderSeparatorColor() {
        return UIUtil.getBorderColor();
    }

    @Nullable
    public static StyleSheet loadStyleSheet(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        try {
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.loadRules(new InputStreamReader(url.openStream(), "UTF-8"), url);
            return styleSheet;
        }
        catch (IOException e) {
            LOG.warn(url + " loading failed", e);
            return null;
        }
    }

    public static HTMLEditorKit getHTMLEditorKit() {
        return UIUtil.getHTMLEditorKit(true);
    }

    public static HTMLEditorKit getHTMLEditorKit(boolean noGapsBetweenParagraphs) {
        return new JBHtmlEditorKit(noGapsBetweenParagraphs);
    }

    public static FontUIResource getFontWithFallback(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(68);
        }
        return UIUtil.getFontWithFallback(font.getFamily(), font.getStyle(), font.getSize());
    }

    public static FontUIResource getFontWithFallback(@Nullable String familyName, @JdkConstants.FontStyle int style, int size) {
        Font fontWithFallback = new StyleContext().getFont(familyName, style, size);
        return fontWithFallback instanceof FontUIResource ? (FontUIResource)fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public static <T> T htmlInjectionGuard(T toRender) {
        if (toRender instanceof String && ((String)toRender).toLowerCase(Locale.US).startsWith("<html>")) {
            return (T)("<html>" + StringUtil.escapeXml((String)toRender));
        }
        return toRender;
    }

    public static void removeScrollBorder(Component c) {
        for (JScrollPane scrollPane : UIUtil.uiTraverser(c).filter(JScrollPane.class)) {
            if (!UIUtil.uiParents(scrollPane, true).takeWhile(Conditions.notEqualTo(c)).filter(Conditions.not(Conditions.instanceOf(JPanel.class, JLayeredPane.class))).isEmpty()) continue;
            Integer keepBorderSides = UIUtil.getClientProperty((Object)scrollPane, KEEP_BORDER_SIDES);
            if (keepBorderSides != null) {
                if (scrollPane.getBorder() instanceof LineBorder) {
                    Color color = ((LineBorder)scrollPane.getBorder()).getLineColor();
                    scrollPane.setBorder(new SideBorder(color, keepBorderSides));
                    continue;
                }
                scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), keepBorderSides));
                continue;
            }
            scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), 0));
        }
    }

    public static Point getCenterPoint(Dimension container, Dimension child) {
        return UIUtil.getCenterPoint(new Rectangle(container), child);
    }

    public static Point getCenterPoint(Rectangle container, Dimension child) {
        return new Point(container.x + (container.width - child.width) / 2, container.y + (container.height - child.height) / 2);
    }

    public static String toHtml(String html) {
        return UIUtil.toHtml(html, 0);
    }

    @NonNls
    public static String toHtml(String html, int hPadding) {
        html = CLOSE_TAG_PATTERN.matcher(html).replaceAll("<$1$2></$1>");
        Font font = UIUtil.getLabelFont();
        String family = font != null ? font.getFamily() : "Tahoma";
        int size = font != null ? font.getSize() : JBUI.scale(11);
        return "<html><style>body { font-family: " + family + "; font-size: " + size + ";} ul li {list-style-type:circle;}</style>" + UIUtil.addPadding(html, hPadding) + "</html>";
    }

    public static String addPadding(String html, int hPadding) {
        return String.format("<p style=\"margin: 0 %dpx 0 %dpx;\">%s</p>", hPadding, hPadding, html);
    }

    @NotNull
    public static String convertSpace2Nbsp(@NotNull String html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(69);
        }
        StringBuilder result = new StringBuilder();
        int braces = 0;
        for (int currentPos = 0; currentPos < html.length(); ++currentPos) {
            String each = html.substring(currentPos, currentPos + 1);
            if ("<".equals(each)) {
                ++braces;
            } else if (">".equals(each)) {
                --braces;
            }
            if (" ".equals(each) && braces == 0) {
                result.append("&nbsp;");
                continue;
            }
            result.append(each);
        }
        String string = result.toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(70);
        }
        return string;
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(71);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            EdtInvocationManager.getInstance().invokeLater(runnable);
        }
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(72);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                EdtInvocationManager.getInstance().invokeAndWait(runnable);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    public static <T> T invokeAndWaitIfNeeded(final @NotNull Computable<T> computable) {
        if (computable == null) {
            UIUtil.$$$reportNull$$$0(73);
        }
        final Ref result = Ref.create();
        UIUtil.invokeAndWaitIfNeeded(new Runnable(){

            @Override
            public void run() {
                result.set(computable.compute());
            }
        });
        return result.get();
    }

    public static void invokeAndWaitIfNeeded(final @NotNull ThrowableRunnable runnable) throws Throwable {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(74);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            final Ref ref = Ref.create();
            EdtInvocationManager.getInstance().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        ref.set(throwable);
                    }
                }
            });
            if (!ref.isNull()) {
                throw (Throwable)ref.get();
            }
        }
    }

    public static boolean isFocusProxy(@Nullable Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(FOCUS_PROXY_KEY));
    }

    public static void setFocusProxy(JComponent c, boolean isProxy) {
        c.putClientProperty(FOCUS_PROXY_KEY, isProxy ? Boolean.TRUE : null);
    }

    public static void maybeInstall(InputMap map, String action, KeyStroke stroke) {
        if (map.get(stroke) == null) {
            map.put(stroke, action);
        }
    }

    public static void changeBackGround(Component component, Color background) {
        Color oldBackGround = component.getBackground();
        if (background == null || !background.equals(oldBackGround)) {
            component.setBackground(background);
        }
    }

    public static String getSystemLookAndFeelClassName() {
        if (systemLaFClassName != null) {
            return systemLaFClassName;
        }
        if (SystemInfo.isLinux) {
            try {
                String name = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                Class<?> cls = Class.forName(name);
                LookAndFeel laf = (LookAndFeel)cls.newInstance();
                if (laf.isSupportedLookAndFeel()) {
                    systemLaFClassName = name;
                    return systemLaFClassName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        systemLaFClassName = UIManager.getSystemLookAndFeelClassName();
        return systemLaFClassName;
    }

    public static void initDefaultLAF() {
        try {
            UIManager.setLookAndFeel(UIUtil.getSystemLookAndFeelClassName());
            UIUtil.initSystemFontData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initSystemFontData() {
        Font winFont;
        if (ourSystemFontData != null) {
            return;
        }
        Font font = UIUtil.getLabelFont();
        Float forcedScale = null;
        if (Registry.is("ide.ui.scale.override")) {
            forcedScale = Float.valueOf((float)Registry.get("ide.ui.scale").asDouble());
        } else if (SystemInfo.isLinux) {
            Object value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
            if (value instanceof Integer) {
                int dpi = (Integer)value / 1024;
                if (dpi < 50) {
                    dpi = 50;
                }
                float scale = JBUI.discreteScale((float)dpi / 96.0f);
                DEF_SYSTEM_FONT_SIZE = (float)font.getSize() / scale;
            } else {
                forcedScale = Float.valueOf(UIUtil.getScreenScale());
            }
        } else if (SystemInfo.isWindows && (winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            font = winFont;
        }
        if (forcedScale != null) {
            font = font.deriveFont(DEF_SYSTEM_FONT_SIZE * forcedScale.floatValue());
        }
        ourSystemFontData = Pair.create(font.getName(), font.getSize());
    }

    @Nullable
    public static Pair<String, Integer> getSystemFontData() {
        return ourSystemFontData;
    }

    private static float getScreenScale() {
        int dpi = 96;
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return JBUI.discreteScale((float)dpi / 96.0f);
    }

    public static void addKeyboardShortcut(JComponent target, final AbstractButton button, KeyStroke keyStroke) {
        target.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (button.isEnabled()) {
                    button.doClick();
                }
            }
        }, keyStroke, 0);
    }

    public static void installComboBoxCopyAction(JComboBox comboBox) {
        Component editorComponent;
        ComboBoxEditor editor = comboBox.getEditor();
        Component component = editorComponent = editor != null ? editor.getEditorComponent() : null;
        if (!(editorComponent instanceof JTextComponent)) {
            return;
        }
        InputMap inputMap = ((JTextComponent)editorComponent).getInputMap();
        for (KeyStroke keyStroke : inputMap.allKeys()) {
            if (!"copy-to-clipboard".equals(inputMap.get(keyStroke))) continue;
            comboBox.getInputMap().put(keyStroke, "copy-to-clipboard");
        }
        comboBox.getActionMap().put("copy-to-clipboard", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str;
                Component component;
                if (!(e.getSource() instanceof JComboBox)) {
                    return;
                }
                JComboBox comboBox = (JComboBox)e.getSource();
                Object selectedItem = comboBox.getSelectedItem();
                String text = selectedItem instanceof String ? (String)selectedItem : ((component = comboBox.getRenderer().getListCellRendererComponent(new JList(), selectedItem, 0, false, false)) instanceof JLabel ? ((JLabel)component).getText() : (component != null ? ((str = component.toString()) == null || str.startsWith(component.getClass().getName() + "[") ? null : str) : null));
                if (text != null) {
                    JTextField textField = new JTextField(text);
                    textField.selectAll();
                    textField.copy();
                }
            }
        });
    }

    @Nullable
    public static ComboPopup getComboBoxPopup(@NotNull JComboBox comboBox) {
        ComboBoxUI ui;
        if (comboBox == null) {
            UIUtil.$$$reportNull$$$0(75);
        }
        if ((ui = comboBox.getUI()) instanceof BasicComboBoxUI) {
            return ReflectionUtil.getField(BasicComboBoxUI.class, ui, ComboPopup.class, "popup");
        }
        return null;
    }

    public static void fixFormattedField(JFormattedTextField field) {
        if (SystemInfo.isMac) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            int commandKeyMask = toolkit.getMenuShortcutKeyMask();
            InputMap inputMap = field.getInputMap();
            KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, commandKeyMask);
            inputMap.put(copyKeyStroke, "copy-to-clipboard");
            KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, commandKeyMask);
            inputMap.put(pasteKeyStroke, "paste-from-clipboard");
            KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, commandKeyMask);
            inputMap.put(cutKeyStroke, "cut-to-clipboard");
        }
    }

    public static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics;
    }

    public static int getSelectedButton(ButtonGroup group) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (group.isSelected(button.getModel())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setSelectedButton(ButtonGroup group, int index) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            group.setSelected(button.getModel(), index == i);
            ++i;
        }
    }

    public static boolean isSelectionButtonDown(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(76);
        }
        return e.isShiftDown() || e.isControlDown() || e.isMetaDown();
    }

    public static boolean isToggleListSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(77);
        }
        return SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
    }

    public static void setComboBoxEditorBounds(int x, int y, int width, int height, JComponent editor) {
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            editor.reshape(x, y, width - 4, height - 1);
        } else {
            editor.reshape(x, y, width, height);
        }
    }

    public static int fixComboBoxHeight(int height) {
        return SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel() ? 28 : height;
    }

    public static boolean isDescendingFrom(@Nullable Component child, @NotNull Component parent) {
        if (parent == null) {
            UIUtil.$$$reportNull$$$0(78);
        }
        while (child != null && child != parent) {
            child = child instanceof JPopupMenu ? ((JPopupMenu)child).getInvoker() : child.getParent();
        }
        return child == parent;
    }

    @Nullable
    public static <T> T getParentOfType(@NotNull Class<? extends T> type, Component component) {
        if (type == null) {
            UIUtil.$$$reportNull$$$0(79);
        }
        while (component != null) {
            if (type.isInstance(component)) {
                return (T)component;
            }
            component = component.getParent();
        }
        return null;
    }

    @NotNull
    public static JBIterable<Component> uiParents(@Nullable Component c, boolean strict) {
        JBIterable<Component> jBIterable = strict ? JBIterable.generate(c, COMPONENT_PARENT).skip(1) : JBIterable.generate(c, COMPONENT_PARENT);
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(80);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component) {
        if (!(component instanceof Container)) {
            JBIterable<Component> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                UIUtil.$$$reportNull$$$0(81);
            }
            return jBIterable;
        }
        Container container = (Container)component;
        JBIterable<Component> jBIterable = JBIterable.of(container.getComponents());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(82);
        }
        return jBIterable;
    }

    @NotNull
    public static JBTreeTraverser<Component> uiTraverser(@Nullable Component component) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)UI_TRAVERSER.withRoot(component);
        if (jBTreeTraverser == null) {
            UIUtil.$$$reportNull$$$0(83);
        }
        return jBTreeTraverser;
    }

    public static void scrollListToVisibleIfNeeded(final @NotNull JList list) {
        if (list == null) {
            UIUtil.$$$reportNull$$$0(84);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle cellBounds;
                Rectangle visibleRect;
                int selectedIndex = list.getSelectedIndex();
                if (selectedIndex >= 0 && !(visibleRect = list.getVisibleRect()).contains(cellBounds = list.getCellBounds(selectedIndex, selectedIndex))) {
                    list.scrollRectToVisible(cellBounds);
                }
            }
        });
    }

    @Nullable
    public static <T extends JComponent> T findComponentOfType(JComponent parent, Class<T> cls) {
        if (parent == null || cls.isAssignableFrom(parent.getClass())) {
            JComponent t = parent;
            return (T)t;
        }
        for (Component component : parent.getComponents()) {
            T comp;
            if (!(component instanceof JComponent) || (comp = UIUtil.findComponentOfType((JComponent)component, cls)) == null) continue;
            return comp;
        }
        return null;
    }

    public static <T extends JComponent> List<T> findComponentsOfType(JComponent parent, Class<T> cls) {
        ArrayList result = new ArrayList();
        UIUtil.findComponentsOfType(parent, cls, result);
        return result;
    }

    private static <T extends JComponent> void findComponentsOfType(JComponent parent, Class<T> cls, ArrayList<T> result) {
        if (parent == null) {
            return;
        }
        if (cls.isAssignableFrom(parent.getClass())) {
            JComponent t = parent;
            result.add(t);
        }
        for (Component c : parent.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            UIUtil.findComponentsOfType((JComponent)c, cls, result);
        }
    }

    @Nullable
    public static JRootPane getRootPane(Component c) {
        JRootPane root = UIUtil.getParentOfType(JRootPane.class, c);
        if (root != null) {
            return root;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            WeakReference pane;
            if (!(eachParent instanceof JComponent) || (pane = (WeakReference)((JComponent)eachParent).getClientProperty(ROOT_PANE)) == null) continue;
            return (JRootPane)pane.get();
        }
        return null;
    }

    public static void setFutureRootPane(JComponent c, JRootPane pane) {
        c.putClientProperty(ROOT_PANE, new WeakReference<JRootPane>(pane));
    }

    public static boolean isMeaninglessFocusOwner(@Nullable Component c) {
        if (c == null || !c.isShowing()) {
            return true;
        }
        return c instanceof JFrame || c instanceof JDialog || c instanceof JWindow || c instanceof JRootPane || UIUtil.isFocusProxy(c);
    }

    @NotNull
    public static Timer createNamedTimer(final @NonNls @NotNull String name, int delay, @NotNull ActionListener listener) {
        if (name == null) {
            UIUtil.$$$reportNull$$$0(85);
        }
        if (listener == null) {
            UIUtil.$$$reportNull$$$0(86);
        }
        Timer timer = new Timer(delay, listener){

            public String toString() {
                return name;
            }
        };
        if (timer == null) {
            UIUtil.$$$reportNull$$$0(87);
        }
        return timer;
    }

    @NotNull
    public static Timer createNamedTimer(final @NonNls @NotNull String name, int delay) {
        if (name == null) {
            UIUtil.$$$reportNull$$$0(88);
        }
        Timer timer = new Timer(delay, null){

            public String toString() {
                return name;
            }
        };
        if (timer == null) {
            UIUtil.$$$reportNull$$$0(89);
        }
        return timer;
    }

    public static boolean isDialogRootPane(JRootPane rootPane) {
        if (rootPane != null) {
            Object isDialog = rootPane.getClientProperty("DIALOG_ROOT_PANE");
            return isDialog instanceof Boolean && (Boolean)isDialog != false;
        }
        return false;
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(PanelWithAnchor ... panels) {
        return UIUtil.mergeComponentsWithAnchor(Arrays.asList(panels));
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(Collection<? extends PanelWithAnchor> panels) {
        JComponent maxWidthAnchor = null;
        int maxWidth = 0;
        for (PanelWithAnchor panelWithAnchor : panels) {
            int anchorWidth;
            JComponent anchor = panelWithAnchor != null ? panelWithAnchor.getAnchor() : null;
            if (anchor == null || maxWidth >= (anchorWidth = anchor.getPreferredSize().width)) continue;
            maxWidth = anchorWidth;
            maxWidthAnchor = anchor;
        }
        for (PanelWithAnchor panelWithAnchor : panels) {
            if (panelWithAnchor == null) continue;
            panelWithAnchor.setAnchor(maxWidthAnchor);
        }
        return maxWidthAnchor;
    }

    public static void setNotOpaqueRecursively(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(90);
        }
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            return;
        }
        if (component.getBackground().equals(UIUtil.getPanelBackground()) || component instanceof JScrollPane || component instanceof JViewport || component instanceof JLayeredPane) {
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
            if (component instanceof Container) {
                for (Component c : ((Container)component).getComponents()) {
                    UIUtil.setNotOpaqueRecursively(c);
                }
            }
        }
    }

    public static void setBackgroundRecursively(@NotNull Component component, @NotNull Color bg) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(91);
        }
        if (bg == null) {
            UIUtil.$$$reportNull$$$0(92);
        }
        component.setBackground(bg);
        if (component instanceof Container) {
            for (Component c : ((Container)component).getComponents()) {
                UIUtil.setBackgroundRecursively(c, bg);
            }
        }
    }

    public static void addInsets(@NotNull JComponent component, int top, int left, int bottom, int right) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(93);
        }
        UIUtil.addBorder(component, BorderFactory.createEmptyBorder(top, left, bottom, right));
    }

    public static void addInsets(@NotNull JComponent component, @NotNull Insets insets) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(94);
        }
        if (insets == null) {
            UIUtil.$$$reportNull$$$0(95);
        }
        UIUtil.addInsets(component, insets.top, insets.left, insets.bottom, insets.right);
    }

    public static void adjustWindowToMinimumSize(final Window window) {
        if (window == null) {
            return;
        }
        Dimension minSize = window.getMinimumSize();
        Dimension size = window.getSize();
        final Dimension newSize = new Dimension(Math.max(size.width, minSize.width), Math.max(size.height, minSize.height));
        if (!newSize.equals(size)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (window.isShowing()) {
                        window.setSize(newSize);
                    }
                }
            });
        }
    }

    @Nullable
    public static Color getColorAt(Icon icon, int x, int y) {
        if (0 <= x && x < icon.getIconWidth() && 0 <= y && y < icon.getIconHeight()) {
            BufferedImage image = UIUtil.createImage(icon.getIconWidth(), icon.getIconHeight(), 1);
            icon.paintIcon(null, image.getGraphics(), 0, 0);
            int[] pixels = new int[1];
            PixelGrabber pixelGrabber = new PixelGrabber(image, x, y, 1, 1, pixels, 0, 1);
            try {
                pixelGrabber.grabPixels();
                return new Color(pixels[0]);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getLcdContrastValue() {
        int lcdContrastValue = Registry.get("lcd.contrast.value").asInteger();
        if (lcdContrastValue == 0) {
            if (SystemInfo.isMacIntel64) {
                lcdContrastValue = UIUtil.isUnderDarcula() ? 140 : 230;
            } else {
                Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                if (map == null) {
                    lcdContrastValue = 140;
                } else {
                    Object o = map.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                    int n = lcdContrastValue = o == null ? 140 : (Integer)o;
                }
            }
        }
        if (lcdContrastValue < 100 || lcdContrastValue > 250) {
            lcdContrastValue = 140;
        }
        return lcdContrastValue;
    }

    public static void addBorder(JComponent component, Border border) {
        if (component != null && border != null) {
            Border old = component.getBorder();
            if (old != null) {
                border = BorderFactory.createCompoundBorder(border, old);
            }
            component.setBorder(border);
        }
    }

    public static Color getDecoratedRowColor() {
        return DECORATED_ROW_BG_COLOR;
    }

    @NotNull
    public static Paint getGradientPaint(float x1, float y1, @NotNull Color c1, float x2, float y2, @NotNull Color c2) {
        if (c1 == null) {
            UIUtil.$$$reportNull$$$0(96);
        }
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(97);
        }
        Paint paint = Registry.is("ui.no.bangs.and.whistles") ? ColorUtil.mix(c1, c2, 0.5) : new GradientPaint(x1, y1, c1, x2, y2, c2);
        if (paint == null) {
            UIUtil.$$$reportNull$$$0(98);
        }
        return paint;
    }

    @Nullable
    public static Point getLocationOnScreen(@NotNull JComponent component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(99);
        }
        int dx = 0;
        int dy = 0;
        for (Container c = component; c != null; c = c.getParent()) {
            if (c.isShowing()) {
                Point locationOnScreen = c.getLocationOnScreen();
                locationOnScreen.translate(dx, dy);
                return locationOnScreen;
            }
            Point location = c.getLocation();
            dx += location.x;
            dy += location.y;
        }
        return null;
    }

    @NotNull
    public static Window getActiveWindow() {
        Window[] windows;
        for (Window each : windows = Window.getWindows()) {
            if (!each.isVisible() || !each.isActive()) continue;
            Window window = each;
            if (window == null) {
                UIUtil.$$$reportNull$$$0(100);
            }
            return window;
        }
        Frame frame = JOptionPane.getRootFrame();
        if (frame == null) {
            UIUtil.$$$reportNull$$$0(101);
        }
        return frame;
    }

    public static void suppressFocusStealing(Window window) {
        if (SystemInfo.isMac) {
            return;
        }
        if (Registry.is("suppress.focus.stealing")) {
            UIUtil.setAutoRequestFocus(window, false);
        }
    }

    public static void setAutoRequestFocus(Window onWindow, boolean set) {
        if (!SystemInfo.isMac) {
            try {
                onWindow.getClass().getMethod("setAutoRequestFocus", Boolean.TYPE).invoke((Object)onWindow, set);
            }
            catch (NoSuchMethodException e) {
                LOG.debug(e);
            }
            catch (InvocationTargetException e) {
                LOG.debug(e);
            }
            catch (IllegalAccessException e) {
                LOG.debug(e);
            }
        }
    }

    public static String getDebugText(Component c) {
        StringBuilder builder = new StringBuilder();
        UIUtil.getAllTextsRecursivelyImpl(c, builder);
        return builder.toString();
    }

    private static void getAllTextsRecursivelyImpl(Component component, StringBuilder builder) {
        String candidate = "";
        if (component instanceof JLabel) {
            candidate = ((JLabel)component).getText();
        }
        if (component instanceof JTextComponent) {
            candidate = ((JTextComponent)component).getText();
        }
        if (component instanceof AbstractButton) {
            candidate = ((AbstractButton)component).getText();
        }
        if (StringUtil.isNotEmpty(candidate)) {
            candidate = candidate.replaceAll("<a href=\"#inspection/[^)]+\\)", "");
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(StringUtil.removeHtmlTags(candidate).trim());
        }
        if (component instanceof Container) {
            Component[] components;
            for (Component child : components = ((Container)component).getComponents()) {
                UIUtil.getAllTextsRecursivelyImpl(child, builder);
            }
        }
    }

    public static boolean isAncestor(@NotNull Component ancestor, @Nullable Component descendant) {
        if (ancestor == null) {
            UIUtil.$$$reportNull$$$0(102);
        }
        while (descendant != null) {
            if (descendant == ancestor) {
                return true;
            }
            descendant = descendant.getParent();
        }
        return false;
    }

    public static void resetUndoRedoActions(@NotNull JTextComponent textComponent) {
        UndoManager undoManager;
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(103);
        }
        if ((undoManager = UIUtil.getClientProperty((Object)textComponent, UNDO_MANAGER)) != null) {
            undoManager.discardAllEdits();
        }
    }

    public static void addUndoRedoActions(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(104);
        }
        if (textComponent.getClientProperty(UNDO_MANAGER) instanceof UndoManager) {
            return;
        }
        UndoManager undoManager = new UndoManager();
        textComponent.putClientProperty(UNDO_MANAGER, undoManager);
        textComponent.getDocument().addUndoableEditListener(undoManager);
        textComponent.getDocument().addDocumentListener(SET_TEXT_CHECKER);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, SystemInfo.isMac ? 4 : 2), "undoKeystroke");
        textComponent.getActionMap().put("undoKeystroke", UNDO_ACTION);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, (SystemInfo.isMac ? 4 : 2) | 1), "redoKeystroke");
        textComponent.getActionMap().put("redoKeystroke", REDO_ACTION);
    }

    @Nullable
    public static UndoManager getUndoManager(Component component) {
        Object o;
        if (component instanceof JTextComponent && (o = ((JTextComponent)component).getClientProperty(UNDO_MANAGER)) instanceof UndoManager) {
            return (UndoManager)o;
        }
        return null;
    }

    public static void playSoundFromResource(final String resourceName) {
        final Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return;
        }
        UIUtil.playSoundFromStream(new Factory<InputStream>(){

            @Override
            public InputStream create() {
                return callerClass.getResourceAsStream(resourceName);
            }
        });
    }

    public static void playSoundFromStream(final Factory<InputStream> streamProducer) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Clip clip = AudioSystem.getClip();
                    InputStream stream = (InputStream)streamProducer.create();
                    if (!stream.markSupported()) {
                        stream = new BufferedInputStream(stream);
                    }
                    AudioInputStream inputStream = AudioSystem.getAudioInputStream(stream);
                    clip.open(inputStream);
                    clip.start();
                }
                catch (Exception ignore) {
                    LOG.info(ignore);
                }
            }
        }, "play sound").start();
    }

    @Nullable
    public static String getCurrentKeyboardLayout() {
        InputContext instance = InputContext.getInstance();
        Class<?> instanceClass = instance.getClass();
        Class<?> superclass = instanceClass.getSuperclass();
        if (superclass.getName().equals("sun.awt.im.InputContext")) {
            try {
                Object inputMethodLocator = ReflectionUtil.getField(superclass, instance, null, "inputMethodLocator");
                Locale locale = ReflectionUtil.getField(inputMethodLocator.getClass(), inputMethodLocator, Locale.class, "locale");
                return locale.getLanguage().toUpperCase(Locale.getDefault());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getRealFontFamily(String genericFontFamily) {
        if (ourRealFontFamilies != null && ourRealFontFamilies.get(genericFontFamily) != null) {
            return ourRealFontFamilies.get(genericFontFamily);
        }
        String pattern = "Real Font Family";
        List<String> GENERIC = Arrays.asList("Dialog", "DialogInput", "Monospaced", "SansSerif", "Serif");
        int patternSize = 50;
        BufferedImage image = UIUtil.createImage(1, 1, 2);
        Graphics graphics = image.getGraphics();
        graphics.setFont(new Font(genericFontFamily, 0, patternSize));
        Rectangle2D patternBounds = graphics.getFontMetrics().getStringBounds(pattern, graphics);
        for (String family : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (GENERIC.contains(family)) continue;
            graphics.setFont(new Font(family, 0, patternSize));
            if (!graphics.getFontMetrics().getStringBounds(pattern, graphics).equals(patternBounds)) continue;
            if (ourRealFontFamilies == null) {
                ourRealFontFamilies = new HashMap<String, String>();
            }
            ourRealFontFamilies.put(genericFontFamily, family);
            return family;
        }
        return genericFontFamily;
    }

    @NotNull
    public static String rightArrow() {
        String string = FontUtil.rightArrow(UIUtil.getLabelFont());
        if (string == null) {
            UIUtil.$$$reportNull$$$0(105);
        }
        return string;
    }

    @NotNull
    public static String upArrow(@NotNull String defaultValue) {
        if (defaultValue == null) {
            UIUtil.$$$reportNull$$$0(106);
        }
        String string = FontUtil.upArrow(UIUtil.getLabelFont(), defaultValue);
        if (string == null) {
            UIUtil.$$$reportNull$$$0(107);
        }
        return string;
    }

    public static EmptyBorder getTextAlignBorder(@NotNull JToggleButton alignSource) {
        if (alignSource == null) {
            UIUtil.$$$reportNull$$$0(108);
        }
        ButtonUI ui = alignSource.getUI();
        int leftGap = alignSource.getIconTextGap();
        Border border = alignSource.getBorder();
        if (border != null) {
            leftGap += border.getBorderInsets((Component)alignSource).left;
        }
        if (ui instanceof BasicRadioButtonUI) {
            leftGap += ((BasicRadioButtonUI)alignSource.getUI()).getDefaultIcon().getIconWidth();
        } else {
            Method method = ReflectionUtil.getMethod(ui.getClass(), "getDefaultIcon", JComponent.class);
            if (method != null) {
                try {
                    Object o = method.invoke((Object)ui, alignSource);
                    if (o instanceof Icon) {
                        leftGap += ((Icon)o).getIconWidth();
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return new EmptyBorder(0, leftGap, 0, 0);
    }

    public static void configureNumericFormattedTextField(@NotNull JFormattedTextField textField) {
        if (textField == null) {
            UIUtil.$$$reportNull$$$0(109);
        }
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setParseIntegerOnly(true);
        format.setGroupingUsed(false);
        NumberFormatter numberFormatter = new NumberFormatter(format);
        numberFormatter.setMinimum(Integer.valueOf(0));
        textField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        textField.setHorizontalAlignment(11);
        textField.setColumns(4);
    }

    @Nullable
    public static Window getWindow(@Nullable Component component) {
        return component == null ? null : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
    }

    public static void toFront(@Nullable Window window) {
        if (window instanceof Frame) {
            ((Frame)window).setState(0);
        }
        if (window != null) {
            window.toFront();
        }
    }

    public static Image getDebugImage(Component component) {
        BufferedImage image = UIUtil.createImage(component, component.getWidth(), component.getHeight(), 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.RED);
        graphics.fillRect(0, 0, component.getWidth() + 1, component.getHeight() + 1);
        component.paint(graphics);
        return image;
    }

    public static boolean hasScrollPane(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(110);
        }
        return UIUtil.hasComponentOfType(component, JScrollPane.class);
    }

    public static boolean hasComponentOfType(Component component, Class<?> ... types) {
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(component.getClass())) continue;
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (!UIUtil.hasComponentOfType(container.getComponent(i), types)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setColumns(JTextComponent textComponent, int columns) {
        if (textComponent instanceof JTextField) {
            ((JTextField)textComponent).setColumns(columns);
        }
        if (textComponent instanceof JTextArea) {
            ((JTextArea)textComponent).setColumns(columns);
        }
    }

    public static int getLineHeight(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(111);
        }
        return textComponent.getFontMetrics(textComponent.getFont()).getHeight();
    }

    public static JComponent getPreferredFocusedComponent(Container container) {
        Container parent = container;
        if (parent == null) {
            return null;
        }
        FocusTraversalPolicy policy = parent.getFocusTraversalPolicy();
        while (policy == null) {
            if ((parent = parent.getParent()) == null) {
                return null;
            }
            policy = parent.getFocusTraversalPolicy();
        }
        Component component = policy.getFirstComponent(container);
        return component instanceof JComponent ? (JComponent)component : null;
    }

    public static ComponentStyle getComponentStyle(Component component) {
        if (component instanceof JComponent) {
            Object property = ((JComponent)component).getClientProperty("JComponent.sizeVariant");
            if ("large".equals(property)) {
                return ComponentStyle.LARGE;
            }
            if ("small".equals(property)) {
                return ComponentStyle.SMALL;
            }
            if ("mini".equals(property)) {
                return ComponentStyle.MINI;
            }
        }
        return ComponentStyle.REGULAR;
    }

    public static void redirectKeystrokes(@NotNull Disposable disposable, final @NotNull JComponent source, final @NotNull JComponent target, final KeyStroke ... keyStrokes) {
        if (disposable == null) {
            UIUtil.$$$reportNull$$$0(112);
        }
        if (source == null) {
            UIUtil.$$$reportNull$$$0(113);
        }
        if (target == null) {
            UIUtil.$$$reportNull$$$0(114);
        }
        if (keyStrokes == null) {
            UIUtil.$$$reportNull$$$0(115);
        }
        final KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke keyStrokeForEvent = KeyStroke.getKeyStrokeForEvent(e);
                for (KeyStroke stroke : keyStrokes) {
                    if (stroke.isOnKeyRelease() || !stroke.equals(keyStrokeForEvent)) continue;
                    target.dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                KeyStroke keyStrokeForEvent = KeyStroke.getKeyStrokeForEvent(e);
                for (KeyStroke stroke : keyStrokes) {
                    if (!stroke.isOnKeyRelease() || !stroke.equals(keyStrokeForEvent)) continue;
                    target.dispatchEvent(e);
                }
            }
        };
        source.addKeyListener(keyAdapter);
        Disposer.register(disposable, new Disposable(){

            @Override
            public void dispose() {
                source.removeKeyListener(keyAdapter);
            }
        });
    }

    public static void repaintViewport(@NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(116);
        }
        if (!c.isDisplayable() || !c.isVisible()) {
            return;
        }
        Container p = c.getParent();
        if (p instanceof JViewport) {
            p.repaint();
        }
    }

    public static void setCursor(Component component, Cursor cursor) {
        if (component.isCursorSet() && component.getCursor() == cursor) {
            return;
        }
        component.setCursor(cursor);
    }

    public static boolean haveCommonOwner(Component c1, Component c2) {
        Window owner;
        if (c1 == null || c2 == null) {
            return false;
        }
        Window c1Ancestor = UIUtil.findWindowAncestor(c1);
        Window c2Ancestor = UIUtil.findWindowAncestor(c2);
        HashSet<Window> ownerSet = new HashSet<Window>();
        for (owner = c1Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            ownerSet.add(owner);
        }
        for (owner = c2Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            if (!ownerSet.contains(owner)) continue;
            return true;
        }
        return false;
    }

    private static Window findWindowAncestor(@NotNull Component c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(117);
        }
        return c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
    }

    public static boolean isHelpButton(JComponent button) {
        return button instanceof JButton && "help".equals(button.getClientProperty("JButton.buttonType"));
    }

    static {
        UIUtil.blockATKWrapper();
        HTMLEditorKit kit = new HTMLEditorKit();
        DEFAULT_HTML_KIT_CSS = kit.getStyleSheet();
        kit.setStyleSheet(null);
        UIManager.getDefaults().put("javax.swing.JLabel.userStyleSheet", JBHtmlEditorKit.createStyleSheet());
        X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

            @Override
            @NotNull
            protected Boolean compute() {
                Boolean bl;
                if (!SystemInfo.isXWindow) {
                    Boolean bl2 = false;
                    if (bl2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return bl2;
                }
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                    Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                    bl = (Boolean)method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    Boolean bl3 = false;
                    if (bl3 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return bl3;
                }
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
            }
        };
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        DEFAULT_GRAY_FILTER = new GrayFilter(true, 70);
        DARCULA_GRAY_FILTER = new GrayFilter(true, 20);
        CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
        KEEP_BORDER_SIDES = Key.create("keepBorderSides");
        UNDO_MANAGER = Key.create("undoManager");
        REDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canRedo()) {
                    manager.redo();
                }
            }
        };
        UNDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canUndo()) {
                    manager.undo();
                }
            }
        };
        UNFOCUSED_SELECTION_COLOR = Gray._212;
        ACTIVE_HEADER_COLOR = new Color(160, 186, 213);
        INACTIVE_HEADER_COLOR = Gray._128;
        BORDER_COLOR = Color.LIGHT_GRAY;
        CONTRAST_BORDER_COLOR = new JBColor(new NotNullProducer<Color>(){
            final Color color = new JBColor(0x9B9B9B, 0x4B4B4B);

            @Override
            @NotNull
            public Color produce() {
                if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
                    Gray gray = Gray.xC9;
                    if (gray == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return gray;
                }
                Color color = this.color;
                if (color == null) {
                    4.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$4", "produce"));
            }
        });
        SIDE_PANEL_BACKGROUND = new JBColor(new NotNullProducer<Color>(){
            final JBColor myDefaultValue = new JBColor(new Color(15133680), new Color(4080460));

            @Override
            @NotNull
            public Color produce() {
                Color color = UIManager.getColor("SidePanel.background");
                Color color2 = color == null ? this.myDefaultValue : color;
                if (color2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                return color2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$5", "produce"));
            }
        });
        AQUA_SEPARATOR_FOREGROUND_COLOR = new JBColor(Gray._223, Gray.x51);
        AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, Gray.x51);
        TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
        PANEL_REGULAR_INSETS = new Insets(8, 12, 8, 12);
        PANEL_SMALL_INSETS = new Insets(5, 8, 5, 8);
        DEBUG_MARKER_BORDER = new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 0, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics g2 = g.create();
                try {
                    g2.setColor(JBColor.RED);
                    UIUtil.drawDottedRectangle(g2, x, y, x + width - 1, y + height - 1);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        };
        DEF_SYSTEM_FONT_SIZE = 12.0f;
        ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
        ourDefaultIconMethodsCache = new ConcurrentHashMap<Class, Ref<Method>>();
        GTK_AMBIANCE_TEXT_COLOR = new Color(223, 219, 210);
        GTK_AMBIANCE_BACKGROUND_COLOR = new Color(67, 66, 63);
        NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");
        UI_TRAVERSER = JBTreeTraverser.from(new Function<Component, JBIterable<Component>>(){

            @Override
            public JBIterable<Component> fun(@NotNull Component c) {
                if (c == null) {
                    17.$$$reportNull$$$0(0);
                }
                JBIterable<Object> result = c instanceof JMenu ? JBIterable.of(((JMenu)c).getMenuComponents()) : (c instanceof JComboBox && UIUtil.isUnderAquaLookAndFeel() ? JBIterable.empty() : UIUtil.uiChildren(c));
                if (c instanceof JComponent) {
                    JPopupMenu jpm;
                    JComponent jc = (JComponent)c;
                    Iterable<? extends Component> orphans = UIUtil.getClientProperty((Object)jc, NOT_IN_HIERARCHY_COMPONENTS);
                    if (orphans != null) {
                        result = result.append(orphans);
                    }
                    if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                        result = result.append(Collections.singletonList(jpm));
                    }
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/ui/UIUtil$17", "fun"));
            }
        });
        COMPONENT_PARENT = new Function.Mono<Component>(){

            @Override
            public Component fun(Component c) {
                return c.getParent();
            }
        };
        DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
        SET_TEXT_CHECKER = new DocumentAdapter(){

            @Override
            protected void textChanged(DocumentEvent e) {
                Document document = e.getDocument();
                if (document instanceof AbstractDocument) {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
                        UndoableEditListener[] undoableEditListeners;
                        if (!element.getClassName().equals(JTextComponent.class.getName()) || !element.getMethodName().equals("setText")) continue;
                        for (final UndoableEditListener listener : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                            if (!(listener instanceof UndoManager)) continue;
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    ((UndoManager)listener).discardAllEdits();
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 61: 
            case 70: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 98: 
            case 100: 
            case 101: 
            case 105: 
            case 107: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 61: 
            case 70: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 98: 
            case 100: 
            case 101: 
            case 105: 
            case 107: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 3: 
            case 15: 
            case 17: 
            case 19: 
            case 51: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 55: 
            case 57: 
            case 59: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 99: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 12: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 22: 
            case 40: 
            case 65: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 24: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 61: 
            case 70: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 98: 
            case 100: 
            case 101: 
            case 105: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 29: 
            case 30: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cb";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 56: 
            case 58: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 60: 
            case 63: 
            case 67: 
            case 116: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 64: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 71: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 85: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 103: 
            case 104: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignSource";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStrokes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "splitText";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMnemonic";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageForGraphics";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getBgFillColor";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSpace2Nbsp";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "uiParents";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "uiChildren";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "uiTraverser";
                break;
            }
            case 87: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedTimer";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientPaint";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "upArrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decorateFrame";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyStyle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drawFramingLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fixOSXEditorBackground";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isClientPropertyTrue";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlBody";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStringY";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "drawLabelDottedRectangle";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLabelTextBounds";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getHighestGlyphHeight";
                break;
            }
            case 24: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 61: 
            case 70: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 98: 
            case 100: 
            case 101: 
            case 105: 
            case 107: {
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setActionNameAndMnemonic";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "assignMnemonic";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFont";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxTextHorizontalOffset";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeMnemonic";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayMnemonicIndex";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isValidFont";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "paintWithXorOnRetina";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setupComposite";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addParentChangeListener";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "removeParentChangeListener";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isFocusAncestor";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getBgFillColor";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findParentByClass";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAt";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getCssFontDeclaration";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallback";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "convertSpace2Nbsp";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getComboBoxPopup";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionButtonDown";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isToggleListSelectionEvent";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isDescendingFrom";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "scrollListToVisibleIfNeeded";
                break;
            }
            case 85: 
            case 86: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "createNamedTimer";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "setNotOpaqueRecursively";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundRecursively";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getGradientPaint";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getLocationOnScreen";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "resetUndoRedoActions";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "addUndoRedoActions";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getTextAlignBorder";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericFormattedTextField";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "hasScrollPane";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getLineHeight";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "redirectKeystrokes";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "repaintViewport";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "findWindowAncestor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 61: 
            case 70: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 98: 
            case 100: 
            case 101: 
            case 105: 
            case 107: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TextPainter {
        private final List<Pair<String, LineInfo>> myLines = new ArrayList<Pair<String, LineInfo>>();
        private boolean myDrawShadow = UIUtil.isUnderDarcula();
        private Color myShadowColor = UIUtil.isUnderDarcula() ? Gray._0.withAlpha(100) : Gray._220;
        private float myLineSpacing = 1.0f;
        private Font myFont;
        private Color myColor;

        public TextPainter withShadow(boolean drawShadow) {
            this.myDrawShadow = drawShadow;
            return this;
        }

        public TextPainter withShadow(boolean drawShadow, Color shadowColor) {
            this.myDrawShadow = drawShadow;
            this.myShadowColor = shadowColor;
            return this;
        }

        public TextPainter withLineSpacing(float lineSpacing) {
            this.myLineSpacing = lineSpacing;
            return this;
        }

        public TextPainter withColor(Color color) {
            this.myColor = color;
            return this;
        }

        public TextPainter withFont(Font font) {
            this.myFont = font;
            return this;
        }

        public TextPainter appendLine(String text) {
            if (text == null || text.isEmpty()) {
                return this;
            }
            this.myLines.add(Pair.create(text, new LineInfo()));
            return this;
        }

        public TextPainter underlined(@Nullable Color color) {
            if (!this.myLines.isEmpty()) {
                LineInfo info = this.myLines.get(this.myLines.size() - 1).getSecond();
                info.underlined = true;
                info.underlineColor = color;
            }
            return this;
        }

        public TextPainter withBullet(char c) {
            if (!this.myLines.isEmpty()) {
                LineInfo info = this.myLines.get(this.myLines.size() - 1).getSecond();
                info.withBullet = true;
                info.bulletChar = c;
            }
            return this;
        }

        public TextPainter withBullet() {
            return this.withBullet('\u2022');
        }

        public TextPainter underlined() {
            return this.underlined(null);
        }

        public TextPainter smaller() {
            if (!this.myLines.isEmpty()) {
                this.myLines.get(this.myLines.size() - 1).getSecond().smaller = true;
            }
            return this;
        }

        public TextPainter center() {
            if (!this.myLines.isEmpty()) {
                this.myLines.get(this.myLines.size() - 1).getSecond().center = true;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(final @NotNull Graphics g, PairFunction<Integer, Integer, Couple<Integer>> _position) {
            if (g == null) {
                TextPainter.$$$reportNull$$$0(0);
            }
            GraphicsUtil.setupAntialiasing(g, true, true);
            final int[] maxWidth = new int[]{0};
            final int[] height = new int[]{0};
            final int[] maxBulletWidth = new int[]{0};
            Font oldFont = null;
            Color oldColor = null;
            if (this.myFont != null) {
                oldFont = g.getFont();
                g.setFont(this.myFont);
            }
            if (this.myColor != null) {
                oldColor = g.getColor();
                g.setColor(this.myColor);
            }
            try {
                ContainerUtil.process(this.myLines, new Processor<Pair<String, LineInfo>>(){

                    @Override
                    public boolean process(Pair<String, LineInfo> pair) {
                        LineInfo info = pair.getSecond();
                        Font old = null;
                        if (info.smaller) {
                            old = g.getFont();
                            g.setFont(old.deriveFont((float)old.getSize() * 0.7f));
                        }
                        FontMetrics fm = g.getFontMetrics();
                        int bulletWidth = info.withBullet ? fm.stringWidth(" " + info.bulletChar) : 0;
                        maxBulletWidth[0] = Math.max(maxBulletWidth[0], bulletWidth);
                        maxWidth[0] = Math.max(fm.stringWidth(pair.getFirst().replace("<shortcut>", "").replace("</shortcut>", "") + bulletWidth), maxWidth[0]);
                        height[0] = (int)((float)height[0] + (float)(fm.getHeight() + fm.getLeading()) * TextPainter.this.myLineSpacing);
                        if (old != null) {
                            g.setFont(old);
                        }
                        return true;
                    }
                });
                final Couple<Integer> position = _position.fun(maxWidth[0] + 20, height[0]);
                assert (position != null);
                final int[] yOffset = new int[]{(Integer)position.getSecond()};
                ContainerUtil.process(this.myLines, new Processor<Pair<String, LineInfo>>(){

                    @Override
                    public boolean process(Pair<String, LineInfo> pair) {
                        LineInfo info = pair.getSecond();
                        String text = (String)pair.first;
                        String shortcut = "";
                        if (((String)pair.first).contains("<shortcut>")) {
                            shortcut = text.substring(text.indexOf("<shortcut>") + "<shortcut>".length(), text.indexOf("</shortcut>"));
                            text = text.substring(0, text.indexOf("<shortcut>"));
                        }
                        Font old = null;
                        if (info.smaller) {
                            old = g.getFont();
                            g.setFont(old.deriveFont((float)old.getSize() * 0.7f));
                        }
                        int x = (Integer)position.getFirst() + maxBulletWidth[0] + 10;
                        FontMetrics fm = g.getFontMetrics();
                        int xOffset = x;
                        if (info.center) {
                            xOffset = x + (maxWidth[0] - fm.stringWidth(text)) / 2;
                        }
                        if (TextPainter.this.myDrawShadow) {
                            int xOff = UIUtil.isUnderDarcula() ? 1 : 0;
                            int yOff = 1;
                            Color oldColor = g.getColor();
                            g.setColor(TextPainter.this.myShadowColor);
                            if (info.withBullet) {
                                g.drawString(info.bulletChar + " ", x - fm.stringWidth(" " + info.bulletChar) + xOff, yOffset[0] + yOff);
                            }
                            g.drawString(text, xOffset + xOff, yOffset[0] + yOff);
                            g.setColor(oldColor);
                        }
                        if (info.withBullet) {
                            g.drawString(info.bulletChar + " ", x - fm.stringWidth(" " + info.bulletChar), yOffset[0]);
                        }
                        g.drawString(text, xOffset, yOffset[0]);
                        if (!StringUtil.isEmpty(shortcut)) {
                            Color oldColor = g.getColor();
                            g.setColor(new JBColor(new Color(82, 99, 155), new Color(88, 157, 246)));
                            g.drawString(shortcut, xOffset + fm.stringWidth(text + (UIUtil.isUnderDarcula() ? " " : "")), yOffset[0]);
                            g.setColor(oldColor);
                        }
                        if (info.underlined) {
                            Color c = null;
                            if (info.underlineColor != null) {
                                c = g.getColor();
                                g.setColor(info.underlineColor);
                            }
                            UIUtil.drawLine(g, x - maxBulletWidth[0] - 10, yOffset[0] + fm.getDescent(), x + maxWidth[0] + 10, yOffset[0] + fm.getDescent());
                            if (c != null) {
                                g.setColor(c);
                            }
                            if (TextPainter.this.myDrawShadow) {
                                c = g.getColor();
                                g.setColor(TextPainter.this.myShadowColor);
                                UIUtil.drawLine(g, x - maxBulletWidth[0] - 10, yOffset[0] + fm.getDescent() + 1, x + maxWidth[0] + 10, yOffset[0] + fm.getDescent() + 1);
                                g.setColor(c);
                            }
                        }
                        yOffset[0] = (int)((float)yOffset[0] + (float)(fm.getHeight() + fm.getLeading()) * TextPainter.this.myLineSpacing);
                        if (old != null) {
                            g.setFont(old);
                        }
                        return true;
                    }
                });
            }
            finally {
                if (oldFont != null) {
                    g.setFont(oldFont);
                }
                if (oldColor != null) {
                    g.setColor(oldColor);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/util/ui/UIUtil$TextPainter", "draw"));
        }

        private static class LineInfo {
            private boolean underlined;
            private boolean withBullet;
            private char bulletChar;
            private Color underlineColor;
            private boolean smaller;
            private boolean center;

            private LineInfo() {
            }
        }
    }

    public static class JBHtmlEditorKit
    extends HTMLEditorKit {
        private final StyleSheet style = JBHtmlEditorKit.createStyleSheet();

        public JBHtmlEditorKit() {
            this(true);
        }

        public JBHtmlEditorKit(boolean noGapsBetweenParagraphs) {
            if (noGapsBetweenParagraphs) {
                this.style.addRule("p { margin-top: 0; }");
            }
        }

        @Override
        public StyleSheet getStyleSheet() {
            return this.style;
        }

        public static StyleSheet createStyleSheet() {
            StyleSheet style = new StyleSheet();
            style.addStyleSheet(UIUtil.isUnderDarcula() ? (StyleSheet)UIManager.getDefaults().get("StyledEditorKit.JBDefaultStyle") : DEFAULT_HTML_KIT_CSS);
            style.addRule("code { font-size: 100%; }");
            style.addRule("small { font-size: small; }");
            return style;
        }

        @Override
        public void install(final JEditorPane pane) {
            super.install(pane);
            if (pane != null) {
                pane.addPropertyChangeListener("editorKit", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        Font font = UIUtil.getLabelFont();
                        assert (font instanceof FontUIResource);
                        if (SystemInfo.isWindows) {
                            font = UIUtil.getFontWithFallback("Tahoma", font.getStyle(), font.getSize());
                        }
                        pane.setFont(font);
                        pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                        pane.removePropertyChangeListener(this);
                    }
                });
            }
        }
    }

    static final class DetectRetinaKit {
        private static final Map<GraphicsDevice, Boolean> devicesToRetinaSupportCacheMap = ContainerUtil.createWeakMap();

        DetectRetinaKit() {
        }

        static boolean isOracleMacRetinaDevice(GraphicsDevice device) {
            Boolean isRetina = devicesToRetinaSupportCacheMap.get(device);
            if (isRetina != null) {
                return isRetina;
            }
            Method getScaleFactorMethod = null;
            try {
                getScaleFactorMethod = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (NoSuchMethodException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (Exception e) {
                LOG.debug(e);
                LOG.debug("CGraphicsDevice.getScaleFactor(): probably it is Java 9");
            }
            try {
                isRetina = getScaleFactorMethod == null || (Integer)getScaleFactorMethod.invoke((Object)device, new Object[0]) != 1;
            }
            catch (IllegalAccessException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Access issue");
                isRetina = false;
            }
            catch (InvocationTargetException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Invocation issue");
                isRetina = false;
            }
            catch (IllegalArgumentException e) {
                LOG.debug("object is not an instance of declaring class: " + device.getClass().getName());
                isRetina = false;
            }
            devicesToRetinaSupportCacheMap.put(device, isRetina);
            return isRetina;
        }

        private static boolean isMacRetina(Graphics2D g) {
            GraphicsDevice device = g.getDeviceConfiguration().getDevice();
            return DetectRetinaKit.isOracleMacRetinaDevice(device);
        }

        private static boolean isRetina() {
            if (SystemInfo.isMac) {
                GraphicsDevice[] devices;
                GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (GraphicsDevice device : devices = e.getScreenDevices()) {
                    if (!DetectRetinaKit.isOracleMacRetinaDevice(device)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum FontColor {
        NORMAL,
        BRIGHTER;

    }

    public static enum ComponentStyle {
        LARGE,
        REGULAR,
        SMALL,
        MINI;

    }

    public static enum FontSize {
        NORMAL,
        SMALL,
        MINI;

    }
}

