/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.guess.impl.ExpressionTypeMemoryState;
import com.intellij.codeInsight.guess.impl.MethodPattern;
import com.intellij.codeInsight.guess.impl.MethodPatternMap;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaInstanceofValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuessManagerImpl
extends GuessManager {
    private final MethodPatternMap myMethodPatternMap = new MethodPatternMap();
    private final Project myProject;
    private static final int CHECK_USAGE = 1;
    private static final int CHECK_UP = 2;
    private static final int CHECK_DOWN = 4;

    private void initMethodPatterns() {
        this.myMethodPatternMap.addPattern(new MethodPattern("add", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("contains", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("remove", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("add", 2, 1));
        this.myMethodPatternMap.addPattern(new MethodPattern("addElement", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("elementAt", 1, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("firstElement", 0, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastElement", 0, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("get", 1, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("indexOf", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("indexOf", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastIndexOf", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastIndexOf", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("insertElementAt", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("removeElement", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("set", 2, 1));
        this.myMethodPatternMap.addPattern(new MethodPattern("setElementAt", 2, 0));
    }

    public GuessManagerImpl(Project project) {
        this.initMethodPatterns();
        this.myProject = project;
    }

    @Override
    @NotNull
    public PsiType[] guessContainerElementType(PsiExpression containerExpr, TextRange rangeToIgnore) {
        PsiElement refElement;
        HashSet<PsiType> typesSet = new HashSet<PsiType>();
        PsiType type = containerExpr.getType();
        PsiType elemType = GuessManagerImpl.getGenericElementType(type);
        if (elemType != null) {
            PsiType[] psiTypeArray = new PsiType[]{elemType};
            if (psiTypeArray == null) {
                GuessManagerImpl.$$$reportNull$$$0(0);
            }
            return psiTypeArray;
        }
        if (containerExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)containerExpr).resolve()) instanceof PsiVariable) {
            PsiFile file = refElement.getContainingFile();
            if (file == null) {
                file = containerExpr.getContainingFile();
            }
            HashSet<PsiVariable> checkedVariables = new HashSet<PsiVariable>();
            this.addTypesByVariable(typesSet, (PsiVariable)refElement, file, checkedVariables, 5, rangeToIgnore);
            checkedVariables.clear();
            this.addTypesByVariable(typesSet, (PsiVariable)refElement, file, checkedVariables, 2, rangeToIgnore);
        }
        PsiType[] psiTypeArray = typesSet.toArray(PsiType.createArray(typesSet.size()));
        if (psiTypeArray == null) {
            GuessManagerImpl.$$$reportNull$$$0(1);
        }
        return psiTypeArray;
    }

    @Nullable
    private static PsiType getGenericElementType(PsiType collectionType) {
        PsiClassType classType;
        PsiType[] parameters;
        if (collectionType instanceof PsiClassType && (parameters = (classType = (PsiClassType)collectionType).getParameters()).length == 1) {
            return parameters[0];
        }
        return null;
    }

    @Override
    @NotNull
    public PsiType[] guessTypeToCast(PsiExpression expr) {
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>(this.getControlFlowExpressionTypeConjuncts(expr));
        this.addExprTypesWhenContainerElement(types, expr);
        this.addExprTypesByDerivedClasses(types, expr);
        PsiType[] psiTypeArray = types.toArray(PsiType.createArray(types.size()));
        if (psiTypeArray == null) {
            GuessManagerImpl.$$$reportNull$$$0(2);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public MultiMap<PsiExpression, PsiType> getControlFlowExpressionTypes(@NotNull PsiExpression forPlace) {
        MultiMap<PsiExpression, PsiType> typeMap;
        if (forPlace == null) {
            GuessManagerImpl.$$$reportNull$$$0(3);
        }
        MultiMap<PsiExpression, PsiType> multiMap = (typeMap = GuessManagerImpl.buildDataflowTypeMap(forPlace, false)) != null ? typeMap : MultiMap.empty();
        if (multiMap == null) {
            GuessManagerImpl.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    @Nullable
    private static MultiMap<PsiExpression, PsiType> buildDataflowTypeMap(PsiExpression forPlace, boolean onlyForPlace) {
        TypeConstraint initial;
        ExpressionTypeInstructionVisitor visitor;
        DataFlowRunner runner;
        PsiType type = forPlace.getType();
        if (type == null) {
            return null;
        }
        PsiElement scope = DfaPsiUtil.getTopmostBlockInSameClass(forPlace);
        if (scope == null) {
            PsiFile file = forPlace.getContainingFile();
            if (!(file instanceof PsiCodeFragment)) {
                return MultiMap.empty();
            }
            scope = file;
        }
        if ((runner = new DataFlowRunner(){

            @Override
            @NotNull
            protected DfaMemoryState createMemoryState() {
                ExpressionTypeMemoryState expressionTypeMemoryState = new ExpressionTypeMemoryState(this.getFactory());
                if (expressionTypeMemoryState == null) {
                    1.$$$reportNull$$$0(0);
                }
                return expressionTypeMemoryState;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/guess/impl/GuessManagerImpl$1", "createMemoryState"));
            }
        }).analyzeMethodWithInlining(scope, visitor = new ExpressionTypeInstructionVisitor(forPlace, onlyForPlace, initial = TypeConstraint.EMPTY.withInstanceofValue(runner.getFactory().createDfaType(type)))) == RunnerResult.OK) {
            return visitor.getResult();
        }
        return null;
    }

    private static PsiElement getTopmostBlock(PsiElement scope) {
        PsiFile file;
        PsiCodeBlock lastCodeBlock;
        assert (scope.isValid());
        PsiElement lastScope = scope;
        while ((lastCodeBlock = PsiTreeUtil.getParentOfType(lastScope, PsiCodeBlock.class, true)) != null) {
            lastScope = lastCodeBlock;
        }
        if (lastScope == scope && (file = scope.getContainingFile()) instanceof PsiCodeFragment) {
            return file;
        }
        return lastScope;
    }

    private void addExprTypesByDerivedClasses(LinkedHashSet<PsiType> set, PsiExpression expr) {
        PsiType type = expr.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClass refClass = PsiUtil.resolveClassInType(type);
        if (refClass == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance(this.myProject);
        PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(5);
        ClassInheritorsSearch.search(refClass).forEach(new PsiElementProcessorAdapter(processor));
        if (processor.isOverflow()) {
            return;
        }
        for (PsiClass derivedClass : processor.getCollection()) {
            if (derivedClass instanceof PsiAnonymousClass) continue;
            PsiClassType derivedType = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(derivedClass);
            set.add(derivedType);
        }
    }

    private void addExprTypesWhenContainerElement(LinkedHashSet<PsiType> set, PsiExpression expr) {
        PsiExpression qualifier;
        PsiMethodCallExpression callExpr;
        PsiReferenceExpression methodExpr;
        String methodName;
        MethodPattern pattern;
        if (expr instanceof PsiMethodCallExpression && (pattern = this.myMethodPatternMap.findPattern(methodName = (methodExpr = (callExpr = (PsiMethodCallExpression)expr).getMethodExpression()).getReferenceName(), callExpr.getArgumentList().getExpressionCount())) != null && pattern.parameterIndex < 0 && (qualifier = methodExpr.getQualifierExpression()) != null) {
            PsiType[] types;
            for (PsiType type : types = this.guessContainerElementType(qualifier, null)) {
                if (type instanceof PsiClassType && ((PsiClassType)type).resolve() instanceof PsiAnonymousClass) continue;
                set.add(type);
            }
        }
    }

    private void addTypesByVariable(HashSet<PsiType> typesSet, PsiVariable var, PsiFile scopeFile, HashSet<PsiVariable> checkedVariables, int flags, TextRange rangeToIgnore) {
        if (!checkedVariables.add(var)) {
            return;
        }
        LocalSearchScope searchScope = new LocalSearchScope(scopeFile);
        if (BitUtil.isSet(flags, 1) || BitUtil.isSet(flags, 4)) {
            for (PsiReference varRef : ReferencesSearch.search(var, searchScope, false)) {
                PsiParameter[] parameters;
                PsiMethodCallExpression methodCall;
                PsiMethod method;
                PsiType type;
                PsiElement ref = varRef.getElement();
                if (BitUtil.isSet(flags, 1) && (type = GuessManagerImpl.guessElementTypeFromReference(this.myMethodPatternMap, ref, rangeToIgnore)) != null && !(type instanceof PsiPrimitiveType)) {
                    typesSet.add(type);
                }
                if (!BitUtil.isSet(flags, 4) || !(ref.getParent() instanceof PsiExpressionList) || !(ref.getParent().getParent() instanceof PsiMethodCallExpression)) continue;
                PsiExpressionList list = (PsiExpressionList)ref.getParent();
                PsiExpression[] args = list.getExpressions();
                int argIndex = -1;
                for (int j = 0; j < args.length; ++j) {
                    PsiExpression arg = args[j];
                    if (!arg.equals(ref)) continue;
                    argIndex = j;
                    break;
                }
                if ((method = (PsiMethod)(methodCall = (PsiMethodCallExpression)list.getParent()).getMethodExpression().resolve()) == null || argIndex >= (parameters = method.getParameterList().getParameters()).length) continue;
                this.addTypesByVariable(typesSet, parameters[argIndex], method.getContainingFile(), checkedVariables, flags | 1, rangeToIgnore);
            }
        }
        if (BitUtil.isSet(flags, 2) && var instanceof PsiParameter && var.getParent() instanceof PsiParameterList && var.getParent().getParent() instanceof PsiMethod) {
            PsiParameterList list = (PsiParameterList)var.getParent();
            PsiParameter[] parameters = list.getParameters();
            int argIndex = -1;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                if (!parameter.equals(var)) continue;
                argIndex = i;
                break;
            }
            PsiMethod method = (PsiMethod)var.getParent().getParent();
            for (PsiReference methodRef : ReferencesSearch.search(method, searchScope, false)) {
                PsiElement refElement;
                PsiExpression arg;
                PsiMethodCallExpression methodCall;
                PsiExpression[] args;
                PsiElement ref = methodRef.getElement();
                if (!(ref.getParent() instanceof PsiMethodCallExpression) || (args = (methodCall = (PsiMethodCallExpression)ref.getParent()).getArgumentList().getExpressions()).length <= argIndex || !((arg = args[argIndex]) instanceof PsiReferenceExpression) || !((refElement = ((PsiReferenceExpression)arg).resolve()) instanceof PsiVariable)) continue;
                this.addTypesByVariable(typesSet, (PsiVariable)refElement, scopeFile, checkedVariables, flags | 1, rangeToIgnore);
            }
        }
    }

    @Nullable
    private static PsiType guessElementTypeFromReference(MethodPatternMap methodPatternMap, PsiElement ref, TextRange rangeToIgnore) {
        PsiMethodCallExpression methodCall;
        PsiExpression[] args;
        String methodName;
        MethodPattern pattern;
        PsiReferenceExpression parentExpr;
        PsiElement refParent = ref.getParent();
        if (refParent instanceof PsiReferenceExpression && ref.equals((parentExpr = (PsiReferenceExpression)refParent).getQualifierExpression()) && parentExpr.getParent() instanceof PsiMethodCallExpression && (pattern = methodPatternMap.findPattern(methodName = parentExpr.getReferenceName(), (args = (methodCall = (PsiMethodCallExpression)parentExpr.getParent()).getArgumentList().getExpressions()).length)) != null) {
            if (pattern.parameterIndex < 0) {
                if (methodCall.getParent() instanceof PsiTypeCastExpression && (rangeToIgnore == null || !rangeToIgnore.contains(methodCall.getTextRange()))) {
                    return ((PsiTypeCastExpression)methodCall.getParent()).getType();
                }
            } else {
                return args[pattern.parameterIndex].getType();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<PsiType> getControlFlowExpressionTypeConjuncts(@NotNull PsiExpression expr) {
        PsiElement parent;
        PsiElement target;
        PsiExpression place;
        if (expr == null) {
            GuessManagerImpl.$$$reportNull$$$0(5);
        }
        if ((place = PsiUtil.skipParenthesizedExprDown(expr)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)place).resolve()) instanceof PsiParameter && (parent = target.getParent()) instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression) {
            List<PsiType> list = GuessManagerImpl.getTypesFromDfa(expr);
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (place == null) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        GuessTypeVisitor visitor = new GuessTypeVisitor(place);
        GuessManagerImpl.getTopmostBlock(place).accept(visitor);
        if (visitor.isDfaNeeded()) {
            List<PsiType> list = GuessManagerImpl.getTypesFromDfa(expr);
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<PsiType> list = visitor.mySpecificType == null ? Collections.emptyList() : Collections.singletonList(GuessManagerImpl.tryGenerify(expr, visitor.mySpecificType));
        if (list == null) {
            GuessManagerImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static List<PsiType> getTypesFromDfa(@NotNull PsiExpression expr) {
        Collection<PsiType> conjuncts;
        MultiMap<PsiExpression, PsiType> fromDfa;
        if (expr == null) {
            GuessManagerImpl.$$$reportNull$$$0(10);
        }
        if ((fromDfa = GuessManagerImpl.buildDataflowTypeMap(expr, true)) != null && !(conjuncts = fromDfa.get(expr)).isEmpty()) {
            Set<PsiType> flatTypes = PsiIntersectionType.flatten(conjuncts.toArray(PsiType.EMPTY_ARRAY), new LinkedHashSet<PsiType>());
            List<PsiType> list = ContainerUtil.mapNotNull(flatTypes, type -> {
                if (expr == null) {
                    GuessManagerImpl.$$$reportNull$$$0(13);
                }
                return GuessManagerImpl.tryGenerify(expr, type);
            });
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<PsiType> list = Collections.emptyList();
        if (list == null) {
            GuessManagerImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static PsiType tryGenerify(PsiExpression expression, PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return type;
        }
        PsiClassType classType = (PsiClassType)type;
        if (!classType.isRaw()) {
            return classType;
        }
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            return classType;
        }
        PsiType expressionType = expression.getType();
        if (!(expressionType instanceof PsiClassType)) {
            return classType;
        }
        return GenericsUtil.getExpectedGenericType(expression, psiClass, (PsiClassType)expressionType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forPlace";
                break;
            }
            case 5: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "guessContainerElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "guessTypeToCast";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlowExpressionTypes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlowExpressionTypeConjuncts";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesFromDfa";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowExpressionTypes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowExpressionTypeConjuncts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypesFromDfa";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTypesFromDfa$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExpressionTypeInstructionVisitor
    extends StandardInstructionVisitor {
        private final TypeConstraint myInitial;
        private MultiMap<PsiExpression, PsiType> myResult;
        private final PsiElement myForPlace;
        private TypeConstraint myConstraint;
        private final boolean myOnlyForPlace;

        private ExpressionTypeInstructionVisitor(@NotNull PsiElement forPlace, boolean onlyForPlace, TypeConstraint initial) {
            if (forPlace == null) {
                ExpressionTypeInstructionVisitor.$$$reportNull$$$0(0);
            }
            this.myConstraint = null;
            this.myOnlyForPlace = onlyForPlace;
            this.myForPlace = PsiUtil.skipParenthesizedExprUp(forPlace);
            this.myInitial = initial;
        }

        MultiMap<PsiExpression, PsiType> getResult() {
            if (this.myConstraint != null && this.myForPlace instanceof PsiExpression) {
                PsiType type = this.myConstraint.getPsiType();
                if (type instanceof PsiIntersectionType) {
                    this.myResult.putValues((PsiExpression)this.myForPlace, Arrays.asList(((PsiIntersectionType)type).getConjuncts()));
                } else if (type != null) {
                    this.myResult.putValue((PsiExpression)this.myForPlace, type);
                }
            }
            return this.myResult;
        }

        @Contract(value="null -> false")
        private boolean isInteresting(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            return !this.myOnlyForPlace || this.myForPlace instanceof PsiExpression && ExpressionTypeMemoryState.EXPRESSION_HASHING_STRATEGY.equals((Object)((PsiExpression)this.myForPlace), (Object)expression);
        }

        @Override
        public DfaInstructionState[] visitInstanceof(InstanceofInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiExpression psiOperand = instruction.getLeft();
            if (!this.isInteresting(psiOperand)) {
                return super.visitInstanceof(instruction, runner, memState);
            }
            DfaValue type = memState.pop();
            DfaValue operand = memState.pop();
            DfaValue relation = runner.getFactory().createCondition(operand, DfaRelationValue.RelationType.IS, type);
            memState.push(new DfaInstanceofValue(runner.getFactory(), psiOperand, instruction.getCastType(), relation, false));
            return new DfaInstructionState[]{new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState)};
        }

        @Override
        public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiExpression psiOperand = instruction.getCasted();
            if (this.isInteresting(psiOperand)) {
                ((ExpressionTypeMemoryState)memState).setExpressionType(psiOperand, instruction.getCastTo());
            }
            return super.visitTypeCast(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiExpression left = instruction.getLExpression();
            PsiExpression right = instruction.getRExpression();
            if (left != null && right != null) {
                ((ExpressionTypeMemoryState)memState).removeExpressionType(left);
            }
            return super.visitAssign(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            if (this.myForPlace == instruction.getCallExpression()) {
                this.addToResult(((ExpressionTypeMemoryState)memState).getStates());
            }
            DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
            if (this.myForPlace == instruction.getCallExpression()) {
                this.addConstraints(states);
            }
            return states;
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            if (this.myForPlace == instruction.getPlace()) {
                this.addToResult(((ExpressionTypeMemoryState)memState).getStates());
            }
            DfaInstructionState[] states = super.visitPush(instruction, runner, memState);
            if (this.myForPlace == instruction.getPlace()) {
                this.addConstraints(states);
            }
            return states;
        }

        private void addConstraints(DfaInstructionState[] states) {
            for (DfaInstructionState state : states) {
                DfaMemoryState memoryState = state.getMemoryState();
                if (this.myConstraint == TypeConstraint.EMPTY) {
                    return;
                }
                TypeConstraint constraint = memoryState.getValueFact(memoryState.peek(), DfaFactType.TYPE_CONSTRAINT);
                if (constraint == null) {
                    constraint = this.myInitial;
                }
                if (constraint == null) continue;
                TypeConstraint typeConstraint = this.myConstraint = this.myConstraint == null ? constraint : this.myConstraint.union(constraint);
                if (this.myConstraint != null) continue;
                this.myConstraint = TypeConstraint.EMPTY;
                return;
            }
        }

        private void addToResult(MultiMap<PsiExpression, PsiType> map) {
            if (this.myResult == null) {
                this.myResult = MultiMap.createSet(ExpressionTypeMemoryState.EXPRESSION_HASHING_STRATEGY);
                this.myResult.putAllValues(map);
            } else {
                Iterator<PsiExpression> iterator = this.myResult.keySet().iterator();
                while (iterator.hasNext()) {
                    PsiExpression psiExpression = iterator.next();
                    if (this.myResult.get(psiExpression).equals(map.get(psiExpression))) continue;
                    iterator.remove();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forPlace", "com/intellij/codeInsight/guess/impl/GuessManagerImpl$ExpressionTypeInstructionVisitor", "<init>"));
        }
    }

    static class GuessTypeVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NotNull
        private final PsiExpression myPlace;
        PsiType mySpecificType;
        private boolean myNeedDfa;
        private boolean myDeclared;
        private int myStart;

        GuessTypeVisitor(@NotNull PsiExpression place) {
            if (place == null) {
                GuessTypeVisitor.$$$reportNull$$$0(0);
            }
            this.myPlace = place;
            this.myStart = place.getTextRange().getStartOffset();
        }

        private void handleAssignment(@Nullable PsiExpression expression) {
            PsiType rawType;
            if (expression == null) {
                return;
            }
            PsiType type = expression.getType();
            PsiType psiType = rawType = type instanceof PsiClassType ? ((PsiClassType)type).rawType() : type;
            if (rawType == null) {
                return;
            }
            if (this.mySpecificType == null) {
                this.mySpecificType = rawType;
            } else if (!this.mySpecificType.equals(rawType)) {
                this.myNeedDfa = true;
                this.stopWalking();
            }
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            if (ExpressionTypeMemoryState.EXPRESSION_HASHING_STRATEGY.equals((Object)expression.getLExpression(), (Object)this.myPlace)) {
                this.handleAssignment(expression.getRExpression());
            }
            super.visitAssignmentExpression(expression);
        }

        @Override
        public void visitLocalVariable(PsiLocalVariable variable) {
            if (ExpressionUtils.isReferenceTo(this.myPlace, variable)) {
                this.myDeclared = true;
                this.handleAssignment(variable.getInitializer());
            }
            super.visitLocalVariable(variable);
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            if (ExpressionTypeMemoryState.EXPRESSION_HASHING_STRATEGY.equals((Object)expression.getOperand(), (Object)this.myPlace)) {
                this.myNeedDfa = true;
                this.stopWalking();
            }
            super.visitTypeCastExpression(expression);
        }

        @Override
        public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
            if (ExpressionTypeMemoryState.EXPRESSION_HASHING_STRATEGY.equals((Object)expression.getOperand(), (Object)this.myPlace)) {
                this.myNeedDfa = true;
                this.stopWalking();
            }
            super.visitInstanceOfExpression(expression);
        }

        @Override
        public void visitElement(PsiElement element) {
            if (element.getTextRange().getStartOffset() > this.myStart) {
                this.stopWalking();
            }
            super.visitElement(element);
        }

        public boolean isDfaNeeded() {
            if (this.myNeedDfa) {
                return true;
            }
            if (this.myDeclared || this.mySpecificType == null) {
                return true;
            }
            PsiType type = this.myPlace.getType();
            PsiType rawType = type instanceof PsiClassType ? ((PsiClassType)type).rawType() : type;
            return !this.mySpecificType.equals(rawType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/guess/impl/GuessManagerImpl$GuessTypeVisitor", "<init>"));
        }
    }
}

