/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardcodedContracts {
    private static final List<MethodContract> ARRAY_RANGE_CONTRACTS = ContainerUtil.immutableList(HardcodedContracts.nonnegativeArgumentContract(1), HardcodedContracts.nonnegativeArgumentContract(2), MethodContract.singleConditionContract(ContractValue.argument(1), DfaRelationValue.RelationType.GT, ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), MethodContract.ValueConstraint.THROW_EXCEPTION), MethodContract.singleConditionContract(ContractValue.argument(2), DfaRelationValue.RelationType.GT, ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), MethodContract.ValueConstraint.THROW_EXCEPTION), MethodContract.singleConditionContract(ContractValue.argument(1), DfaRelationValue.RelationType.GT, ContractValue.argument(2), MethodContract.ValueConstraint.THROW_EXCEPTION));
    private static final CallMapper<ContractProvider> HARDCODED_CONTRACTS = new CallMapper<ContractProvider>().register((CallMatcher)CallMatcher.staticCall("java.lang.System", "exit").parameterCount(1), ContractProvider.single(() -> HardcodedContracts.standardContract(MethodContract.ValueConstraint.THROW_EXCEPTION, new MethodContract.ValueConstraint[0]))).register(CallMatcher.anyOf(CallMatcher.staticCall("com.google.common.base.Preconditions", "checkNotNull"), CallMatcher.staticCall("java.util.Objects", "requireNonNull")), (call, cnt) -> cnt > 0 ? HardcodedContracts.failIfNull(0, cnt) : null).register((CallMatcher)CallMatcher.staticCall("com.google.common.base.Preconditions", "checkArgument", "checkState"), (call, cnt) -> {
        if (cnt == 0) {
            return null;
        }
        MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(cnt);
        constraints[0] = MethodContract.ValueConstraint.FALSE_VALUE;
        return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
    }).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "charAt", "codePointAt").parameterCount(1), ContractProvider.list(() -> Arrays.asList(HardcodedContracts.nonnegativeArgumentContract(0), HardcodedContracts.specialFieldRangeContract(0, DfaRelationValue.RelationType.LT, SpecialField.STRING_LENGTH)))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.String", "substring", "subSequence").parameterCount(2), CallMatcher.instanceCall("java.lang.String", "substring").parameterCount(1)), (call, cnt) -> HardcodedContracts.getSubstringContracts(cnt == 2)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "isEmpty").parameterCount(0), ContractProvider.list(SpecialField.STRING_LENGTH::getEmptyContracts)).register((CallMatcher)CallMatcher.instanceCall("java.util.Collection", "isEmpty").parameterCount(0), ContractProvider.list(SpecialField.COLLECTION_SIZE::getEmptyContracts)).register((CallMatcher)CallMatcher.instanceCall("java.util.Map", "isEmpty").parameterCount(0), ContractProvider.list(SpecialField.MAP_SIZE::getEmptyContracts)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "equals", "equalsIgnoreCase").parameterCount(1), ContractProvider.list(SpecialField.STRING_LENGTH::getEqualsContracts)).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Set", "equals").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.List", "equals").parameterTypes("java.lang.Object")), ContractProvider.list(SpecialField.COLLECTION_SIZE::getEqualsContracts)).register((CallMatcher)CallMatcher.instanceCall("java.util.Map", "equals").parameterTypes("java.lang.Object"), ContractProvider.list(SpecialField.MAP_SIZE::getEqualsContracts)).register((CallMatcher)CallMatcher.instanceCall("java.util.Collection", "contains").parameterCount(1), ContractProvider.single(() -> MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.FALSE_VALUE))).register((CallMatcher)CallMatcher.instanceCall("java.util.Map", "containsKey", "containsValue").parameterCount(1), ContractProvider.single(() -> MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.MAP_SIZE), DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.FALSE_VALUE))).register((CallMatcher)CallMatcher.instanceCall("java.util.List", "get").parameterTypes("int"), ContractProvider.list(() -> Arrays.asList(HardcodedContracts.nonnegativeArgumentContract(0), HardcodedContracts.specialFieldRangeContract(0, DfaRelationValue.RelationType.LT, SpecialField.COLLECTION_SIZE)))).register((CallMatcher)CallMatcher.instanceCall("java.util.SortedSet", "first", "last").parameterCount(0), ContractProvider.single(() -> MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.THROW_EXCEPTION))).register((CallMatcher)CallMatcher.staticCall("java.util.Arrays", "binarySearch", "fill", "parallelPrefix", "parallelSort", "sort", "spliterator", "stream"), (call, cnt) -> cnt >= 3 ? ARRAY_RANGE_CONTRACTS : null).register((CallMatcher)CallMatcher.staticCall("org.mockito.ArgumentMatchers", "argThat").parameterCount(1), ContractProvider.single(() -> new StandardMethodContract(new MethodContract.ValueConstraint[]{MethodContract.ValueConstraint.ANY_VALUE}, MethodContract.ValueConstraint.ANY_VALUE)));

    private static StandardMethodContract standardContract(MethodContract.ValueConstraint returnValue, MethodContract.ValueConstraint ... args) {
        return new StandardMethodContract(args, returnValue);
    }

    public static List<MethodContract> getHardcodedContracts(@NotNull PsiMethod method, @Nullable PsiMethodCallExpression call) {
        List<MethodContract> contracts2;
        PsiClass owner;
        if (method == null) {
            HardcodedContracts.$$$reportNull$$$0(0);
        }
        if ((owner = method.getContainingClass()) == null || InjectedLanguageManager.getInstance(owner.getProject()).isInjectedFragment(owner.getContainingFile())) {
            return Collections.emptyList();
        }
        int paramCount = method.getParameterList().getParametersCount();
        String className = owner.getQualifiedName();
        if (className == null) {
            return Collections.emptyList();
        }
        ContractProvider provider = HARDCODED_CONTRACTS.mapFirst(method);
        if (provider != null && (contracts2 = provider.getContracts(call, paramCount)) != null) {
            return contracts2;
        }
        String methodName = method.getName();
        if ("org.apache.commons.lang.Validate".equals(className) || "org.apache.commons.lang3.Validate".equals(className) || "org.springframework.util.Assert".equals(className)) {
            if (("isTrue".equals(methodName) || "state".equals(methodName)) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.FALSE_VALUE;
                return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
            if ("notNull".equals(methodName) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.NULL_VALUE;
                return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else {
            if (HardcodedContracts.isJunit(className) || HardcodedContracts.isTestng(className) || className.startsWith("com.google.common.truth.") || className.startsWith("org.assertj.core.api.")) {
                return HardcodedContracts.handleTestFrameworks(paramCount, className, methodName, call);
            }
            if (TypeUtils.isOptional(owner)) {
                if (DfaOptionalSupport.isOptionalGetMethodName(methodName) || "orElseThrow".equals(methodName)) {
                    return Arrays.asList(HardcodedContracts.optionalAbsentContract(MethodContract.ValueConstraint.THROW_EXCEPTION), MethodContract.trivialContract(MethodContract.ValueConstraint.NOT_NULL_VALUE));
                }
                if ("isPresent".equals(methodName)) {
                    return Arrays.asList(HardcodedContracts.optionalAbsentContract(MethodContract.ValueConstraint.FALSE_VALUE), MethodContract.trivialContract(MethodContract.ValueConstraint.TRUE_VALUE));
                }
            } else if (MethodUtils.isEquals(method)) {
                return Collections.singletonList(HardcodedContracts.standardContract(MethodContract.ValueConstraint.FALSE_VALUE, MethodContract.ValueConstraint.NULL_VALUE));
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<MethodContract> getSubstringContracts(boolean endLimited) {
        ArrayList<MethodContract> contracts2 = new ArrayList<MethodContract>(5);
        contracts2.add(HardcodedContracts.nonnegativeArgumentContract(0));
        contracts2.add(HardcodedContracts.specialFieldRangeContract(0, DfaRelationValue.RelationType.LE, SpecialField.STRING_LENGTH));
        if (endLimited) {
            contracts2.add(HardcodedContracts.nonnegativeArgumentContract(1));
            contracts2.add(HardcodedContracts.specialFieldRangeContract(1, DfaRelationValue.RelationType.LE, SpecialField.STRING_LENGTH));
            contracts2.add(MethodContract.singleConditionContract(ContractValue.argument(0), DfaRelationValue.RelationType.LE.getNegated(), ContractValue.argument(1), MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        ArrayList<MethodContract> arrayList = contracts2;
        if (arrayList == null) {
            HardcodedContracts.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    static MethodContract optionalAbsentContract(MethodContract.ValueConstraint returnValue) {
        return MethodContract.singleConditionContract(ContractValue.qualifier(), DfaRelationValue.RelationType.IS, ContractValue.optionalValue(false), returnValue);
    }

    static MethodContract nonnegativeArgumentContract(int argNumber) {
        return MethodContract.singleConditionContract(ContractValue.argument(argNumber), DfaRelationValue.RelationType.LT, ContractValue.zero(), MethodContract.ValueConstraint.THROW_EXCEPTION);
    }

    static MethodContract specialFieldRangeContract(int index, DfaRelationValue.RelationType type, SpecialField specialField) {
        return MethodContract.singleConditionContract(ContractValue.argument(index), type.getNegated(), ContractValue.qualifier().specialField(specialField), MethodContract.ValueConstraint.THROW_EXCEPTION);
    }

    private static boolean isJunit(String className) {
        return className.startsWith("junit.framework.") || className.startsWith("org.junit.") || className.equals("org.testng.AssertJUnit");
    }

    private static boolean isJunit5(String className) {
        return className.startsWith("org.junit.jupiter.");
    }

    private static boolean isTestng(String className) {
        return className.startsWith("org.testng.") && !className.equals("org.testng.AssertJUnit");
    }

    private static boolean isNotNullMatcher(PsiExpression expr) {
        if (expr instanceof PsiMethodCallExpression) {
            PsiExpression[] args;
            PsiExpression[] equalArgs;
            PsiExpression[] notArgs;
            String calledName = ((PsiMethodCallExpression)expr).getMethodExpression().getReferenceName();
            if ("notNullValue".equals(calledName)) {
                return true;
            }
            if ("not".equals(calledName) && (notArgs = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length == 1 && notArgs[0] instanceof PsiMethodCallExpression && "equalTo".equals(((PsiMethodCallExpression)notArgs[0]).getMethodExpression().getReferenceName()) && (equalArgs = ((PsiMethodCallExpression)notArgs[0]).getArgumentList().getExpressions()).length == 1 && ExpressionUtils.isNullLiteral(equalArgs[0])) {
                return true;
            }
            if ("is".equals(calledName) && (args = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length == 1) {
                return HardcodedContracts.isNotNullMatcher(args[0]);
            }
        }
        return false;
    }

    private static List<MethodContract> handleTestFrameworks(int paramCount, String className, String methodName, @Nullable PsiMethodCallExpression call) {
        if (("assertThat".equals(methodName) || "assumeThat".equals(methodName) || "that".equals(methodName)) && call != null) {
            return HardcodedContracts.handleAssertThat(paramCount, call);
        }
        if (!HardcodedContracts.isJunit(className) && !HardcodedContracts.isTestng(className)) {
            return Collections.emptyList();
        }
        boolean testng = HardcodedContracts.isTestng(className);
        if ("fail".equals(methodName)) {
            return Collections.singletonList(new StandardMethodContract(StandardMethodContract.createConstraintArray(paramCount), MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if (paramCount == 0) {
            return Collections.emptyList();
        }
        int checkedParam = testng || HardcodedContracts.isJunit5(className) ? 0 : paramCount - 1;
        MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
        if ("assertTrue".equals(methodName) || "assumeTrue".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.FALSE_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertFalse".equals(methodName) || "assumeFalse".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.TRUE_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertNull".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.NOT_NULL_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertNotNull".equals(methodName) || "assumeNotNull".equals(methodName)) {
            return HardcodedContracts.failIfNull(checkedParam, paramCount);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<MethodContract> handleAssertThat(int paramCount, @NotNull PsiMethodCallExpression call) {
        PsiExpression[] args;
        if (call == null) {
            HardcodedContracts.$$$reportNull$$$0(2);
        }
        if ((args = call.getArgumentList().getExpressions()).length == paramCount) {
            for (int i = 1; i < args.length; ++i) {
                if (!HardcodedContracts.isNotNullMatcher(args[i])) continue;
                List<MethodContract> list = HardcodedContracts.failIfNull(i - 1, paramCount);
                if (list == null) {
                    HardcodedContracts.$$$reportNull$$$0(3);
                }
                return list;
            }
            if (args.length == 1 && HardcodedContracts.hasNotNullChainCall(call)) {
                List<MethodContract> list = HardcodedContracts.failIfNull(0, 1);
                if (list == null) {
                    HardcodedContracts.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        List<MethodContract> list = Collections.emptyList();
        if (list == null) {
            HardcodedContracts.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static boolean hasNotNullChainCall(PsiMethodCallExpression call) {
        JBIterable<PsiElement> exprParents = SyntaxTraverser.psiApi().parents(call).takeWhile(e -> !(e instanceof PsiStatement) && !(e instanceof PsiMember));
        return ContainerUtil.exists(exprParents, HardcodedContracts::isNotNullCall);
    }

    private static boolean isNotNullCall(PsiElement ref) {
        return ref instanceof PsiReferenceExpression && "isNotNull".equals(((PsiReferenceExpression)ref).getReferenceName()) && ref.getParent() instanceof PsiMethodCallExpression;
    }

    @NotNull
    private static List<MethodContract> failIfNull(int argIndex, int argCount) {
        MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(argCount);
        constraints[argIndex] = MethodContract.ValueConstraint.NULL_VALUE;
        List<MethodContract> list = Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        if (list == null) {
            HardcodedContracts.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static boolean isHardcodedPure(PsiMethod method) {
        PsiParameter[] parameters;
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String className = aClass.getQualifiedName();
        if (className == null) {
            return false;
        }
        String name = method.getName();
        if ("java.util.Objects".equals(className) && "requireNonNull".equals(name) && (parameters = method.getParameterList().getParameters()).length == 2 && parameters[1].getType().getCanonicalText().contains("Supplier")) {
            return false;
        }
        if ("java.lang.System".equals(className)) {
            return false;
        }
        if ("java.util.Arrays".equals(className)) {
            return name.equals("binarySearch") || name.equals("spliterator") || name.equals("stream");
        }
        return true;
    }

    public static boolean hasHardcodedContracts(@Nullable PsiElement element) {
        if (element instanceof PsiMethod) {
            return !HardcodedContracts.getHardcodedContracts((PsiMethod)element, null).isEmpty();
        }
        if (element instanceof PsiParameter) {
            PsiElement parent = element.getParent();
            return parent != null && HardcodedContracts.hasHardcodedContracts(parent.getParent());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/HardcodedContracts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/HardcodedContracts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstringContracts";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "handleAssertThat";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "failIfNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHardcodedContracts";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleAssertThat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    static interface ContractProvider {
        public List<MethodContract> getContracts(PsiMethodCallExpression var1, int var2);

        public static ContractProvider single(Supplier<MethodContract> supplier) {
            return (call, paramCount) -> Collections.singletonList(supplier.get());
        }

        public static ContractProvider list(Supplier<List<MethodContract>> supplier) {
            return (call, paramCount) -> (List)supplier.get();
        }
    }
}

