/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class NullParameterConstraintChecker
extends DataFlowRunner {
    private final Set<PsiParameter> myPossiblyViolatedParameters;
    private final Set<PsiParameter> myUsedParameters;
    private final Set<PsiParameter> myParametersWithSuccessfulExecutionInNotNullState;

    private NullParameterConstraintChecker(Collection<PsiParameter> parameters) {
        super(false, true);
        this.myPossiblyViolatedParameters = new THashSet(parameters);
        this.myParametersWithSuccessfulExecutionInNotNullState = new THashSet();
        this.myUsedParameters = new THashSet();
    }

    @NotNull
    static PsiParameter[] checkMethodParameters(PsiMethod method) {
        if (method.getBody() == null) {
            if (PsiParameter.EMPTY_ARRAY == null) {
                NullParameterConstraintChecker.$$$reportNull$$$0(0);
            }
            return PsiParameter.EMPTY_ARRAY;
        }
        SmartList<PsiParameter> nullableParameters = new SmartList<PsiParameter>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            PsiParameter parameter = parameters[index];
            if (parameter.getType() instanceof PsiPrimitiveType || NullableNotNullManager.isNotNull(parameter) || NullableNotNullManager.isNullable(parameter) || !JavaNullMethodArgumentUtil.hasNullArgument(method, index)) continue;
            nullableParameters.add(parameter);
        }
        if (nullableParameters.isEmpty()) {
            if (PsiParameter.EMPTY_ARRAY == null) {
                NullParameterConstraintChecker.$$$reportNull$$$0(1);
            }
            return PsiParameter.EMPTY_ARRAY;
        }
        NullParameterConstraintChecker checker = new NullParameterConstraintChecker(nullableParameters);
        checker.analyzeMethod(method.getBody(), new StandardInstructionVisitor());
        PsiParameter[] psiParameterArray = (PsiParameter[])checker.myPossiblyViolatedParameters.stream().filter(checker.myUsedParameters::contains).filter(checker.myParametersWithSuccessfulExecutionInNotNullState::contains).toArray(PsiParameter[]::new);
        if (psiParameterArray == null) {
            NullParameterConstraintChecker.$$$reportNull$$$0(2);
        }
        return psiParameterArray;
    }

    @Override
    @NotNull
    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
        PsiModifierListOwner psiVariable;
        DfaValue value;
        PsiModifierListOwner psiVar;
        DfaValue var;
        Instruction instruction;
        if (visitor == null) {
            NullParameterConstraintChecker.$$$reportNull$$$0(3);
        }
        if (instructionState == null) {
            NullParameterConstraintChecker.$$$reportNull$$$0(4);
        }
        if ((instruction = instructionState.getInstruction()) instanceof PushInstruction && (var = ((PushInstruction)instruction).getValue()) instanceof DfaVariableValue && (psiVar = ((DfaVariableValue)var).getPsiVariable()) instanceof PsiParameter) {
            this.myUsedParameters.add((PsiParameter)psiVar);
        }
        if (instruction instanceof AssignInstruction && (value = ((AssignInstruction)instruction).getAssignedValue()) instanceof DfaVariableValue && (psiVariable = ((DfaVariableValue)value).getPsiVariable()) instanceof PsiParameter) {
            this.myPossiblyViolatedParameters.remove(psiVariable);
        }
        if (instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException()) {
            DfaMemoryState memState = instructionState.getMemoryState();
            for (PsiParameter parameter : this.myPossiblyViolatedParameters.toArray(PsiParameter.EMPTY_ARRAY)) {
                DfaVariableValue dfaVar = this.getFactory().getVarFactory().createVariableValue(parameter, false);
                if (memState.isNotNull(dfaVar)) {
                    this.myParametersWithSuccessfulExecutionInNotNullState.add(parameter);
                    continue;
                }
                this.myPossiblyViolatedParameters.remove(parameter);
            }
        }
        DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(visitor, instructionState);
        if (dfaInstructionStateArray == null) {
            NullParameterConstraintChecker.$$$reportNull$$$0(5);
        }
        return dfaInstructionStateArray;
    }

    @Override
    @NotNull
    protected DfaMemoryState createMemoryState() {
        MyDfaMemoryState myDfaMemoryState = new MyDfaMemoryState(this.getFactory());
        if (myDfaMemoryState == null) {
            NullParameterConstraintChecker.$$$reportNull$$$0(6);
        }
        return myDfaMemoryState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "checkMethodParameters";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptInstruction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemoryState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDfaMemoryState
    extends DfaMemoryStateImpl {
        protected MyDfaMemoryState(DfaValueFactory factory) {
            super(factory);
            for (PsiParameter parameter : NullParameterConstraintChecker.this.myPossiblyViolatedParameters) {
                this.setVariableState(this.getFactory().getVarFactory().createVariableValue(parameter, false), new DfaVariableState(DfaFactMap.EMPTY.with(DfaFactType.CAN_BE_NULL, true)));
            }
        }

        protected MyDfaMemoryState(MyDfaMemoryState toCopy) {
            super(toCopy);
        }

        @Override
        public void flushVariable(@NotNull DfaVariableValue variable) {
            PsiModifierListOwner psi;
            if (variable == null) {
                MyDfaMemoryState.$$$reportNull$$$0(0);
            }
            if ((psi = variable.getPsiVariable()) instanceof PsiParameter && NullParameterConstraintChecker.this.myPossiblyViolatedParameters.contains(psi)) {
                return;
            }
            super.flushVariable(variable);
        }

        @Override
        @NotNull
        public DfaMemoryStateImpl createCopy() {
            MyDfaMemoryState myDfaMemoryState = new MyDfaMemoryState(this);
            if (myDfaMemoryState == null) {
                MyDfaMemoryState.$$$reportNull$$$0(1);
            }
            return myDfaMemoryState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker$MyDfaMemoryState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker$MyDfaMemoryState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCopy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "flushVariable";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

