/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedImport;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.unusedImport.ImportsAreUsedVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.DeleteImportFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnusedImportInspection
extends GlobalSimpleInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "UNUSED_IMPORT";
    public static final String DISPLAY_NAME = InspectionsBundle.message("unused.import.display.name", new Object[0]);

    @Override
    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (file == null) {
            UnusedImportInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            UnusedImportInspection.$$$reportNull$$$0(1);
        }
        if (problemsHolder == null) {
            UnusedImportInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            UnusedImportInspection.$$$reportNull$$$0(3);
        }
        if (problemDescriptionsProcessor == null) {
            UnusedImportInspection.$$$reportNull$$$0(4);
        }
        if (!(file instanceof PsiJavaFile) || FileTypeUtils.isInServerPageFile(file)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        ImportsAreUsedVisitor visitor = new ImportsAreUsedVisitor(javaFile);
        javaFile.accept(visitor);
        for (PsiImportStatementBase unusedImportStatement : visitor.getUnusedImportStatements()) {
            if (unusedImportStatement.getImportReference() == null || PsiTreeUtil.skipWhitespacesForward(unusedImportStatement) instanceof PsiErrorElement) continue;
            problemsHolder.registerProblem((PsiElement)unusedImportStatement, InspectionGadgetsBundle.message("unused.import.problem.descriptor", new Object[0]), new DeleteImportFix());
        }
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            UnusedImportInspection.$$$reportNull$$$0(5);
        }
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            UnusedImportInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean worksInBatchModeOnly() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unusedImport/UnusedImportInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unusedImport/UnusedImportInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

