/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.SmartFMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Presentation
implements Cloneable {
    private SmartFMap<String, Object> myUserMap = SmartFMap.emptyMap();
    @NonNls
    public static final String PROP_TEXT = "text";
    @NonNls
    public static final String PROP_MNEMONIC_KEY = "mnemonicKey";
    @NonNls
    public static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    @NonNls
    public static final String PROP_DESCRIPTION = "description";
    @NonNls
    public static final String PROP_ICON = "icon";
    @NonNls
    public static final String PROP_DISABLED_ICON = "disabledIcon";
    @NonNls
    public static final String PROP_SELECTED_ICON = "selectedIcon";
    @NonNls
    public static final String PROP_HOVERED_ICON = "hoveredIcon";
    @NonNls
    public static final String PROP_VISIBLE = "visible";
    @NonNls
    public static final String PROP_ENABLED = "enabled";
    public static final double DEFAULT_WEIGHT = 0.0;
    public static final double HIGHER_WEIGHT = 42.0;
    public static final double EVEN_HIGHER_WEIGHT = 239.0;
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    private String myText;
    private String myDescription;
    private Icon myIcon;
    private Icon myDisabledIcon;
    private Icon myHoveredIcon;
    private Icon mySelectedIcon;
    private int myMnemonic;
    private int myDisplayedMnemonicIndex = -1;
    private boolean myVisible = true;
    private boolean myEnabled = true;
    private double myWeight = 0.0;

    public Presentation() {
    }

    public Presentation(String text2) {
        this.myText = text2;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    @Nullable
    public String getText() {
        return this.myText;
    }

    public void setText(@Nullable String text2, boolean mayContainMnemonic) {
        int oldMnemonic = this.myMnemonic;
        int oldDisplayedMnemonicIndex = this.myDisplayedMnemonicIndex;
        String oldText = this.myText;
        this.myMnemonic = 0;
        this.myDisplayedMnemonicIndex = -1;
        if (text2 != null) {
            if (text2.indexOf(27) >= 0) {
                text2 = text2.replace('\u001b', '&');
            }
            if (mayContainMnemonic) {
                StringBuilder plainText = new StringBuilder();
                int backShift = 0;
                for (int i = 0; i < text2.length(); ++i) {
                    char ch = text2.charAt(i);
                    if (this.myMnemonic == 0 && (ch == '_' || ch == '&')) {
                        if (++i >= text2.length()) break;
                        ch = text2.charAt(i);
                        if (ch != '_' && ch != '&') {
                            if (UISettings.getInstance().getDisableMnemonicsInControls()) {
                                this.myMnemonic = 0;
                                this.myDisplayedMnemonicIndex = -1;
                            } else {
                                this.myMnemonic = Character.toUpperCase(ch);
                                this.myDisplayedMnemonicIndex = i - 1 - backShift;
                            }
                        } else if (this.myMnemonic == 0) {
                            ++backShift;
                        }
                    }
                    plainText.append(ch);
                }
                this.myText = plainText.length() == 0 ? "" : plainText.toString();
            } else {
                this.myText = text2.isEmpty() ? "" : text2;
            }
        } else {
            this.myText = null;
        }
        this.myChangeSupport.firePropertyChange(PROP_TEXT, oldText, this.myText);
        if (this.myMnemonic != oldMnemonic) {
            this.myChangeSupport.firePropertyChange(PROP_MNEMONIC_KEY, new Integer(oldMnemonic), new Integer(this.myMnemonic));
        }
        if (this.myDisplayedMnemonicIndex != oldDisplayedMnemonicIndex) {
            this.myChangeSupport.firePropertyChange(PROP_MNEMONIC_INDEX, new Integer(oldDisplayedMnemonicIndex), new Integer(this.myDisplayedMnemonicIndex));
        }
    }

    public void setText(String text2) {
        this.setText(text2, true);
    }

    public String getTextWithMnemonic() {
        if (this.myText != null && this.myDisplayedMnemonicIndex > -1) {
            return this.myText.substring(0, this.myDisplayedMnemonicIndex) + "_" + this.myText.substring(this.myDisplayedMnemonicIndex);
        }
        return this.myText;
    }

    public void restoreTextWithMnemonic(Presentation presentation) {
        this.setText(presentation.getTextWithMnemonic());
    }

    public static String restoreTextWithMnemonic(@Nullable String text2, int mnemonic) {
        if (text2 == null) {
            return null;
        }
        for (int i = 0; i < text2.length(); ++i) {
            if (Character.toUpperCase(text2.charAt(i)) != mnemonic) continue;
            return text2.substring(0, i) + "_" + text2.substring(i);
        }
        return text2;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        String oldDescription = this.myDescription;
        this.myDescription = description;
        this.myChangeSupport.firePropertyChange(PROP_DESCRIPTION, oldDescription, this.myDescription);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(@Nullable Icon icon) {
        Icon oldIcon = this.myIcon;
        if (oldIcon == icon) {
            return;
        }
        this.myIcon = icon;
        this.myChangeSupport.firePropertyChange(PROP_ICON, oldIcon, this.myIcon);
    }

    public Icon getDisabledIcon() {
        return this.myDisabledIcon;
    }

    public void setDisabledIcon(@Nullable Icon icon) {
        Icon oldDisabledIcon = this.myDisabledIcon;
        this.myDisabledIcon = icon;
        this.myChangeSupport.firePropertyChange(PROP_DISABLED_ICON, oldDisabledIcon, this.myDisabledIcon);
    }

    public Icon getHoveredIcon() {
        return this.myHoveredIcon;
    }

    public void setHoveredIcon(@Nullable Icon hoveredIcon) {
        Icon old = this.myHoveredIcon;
        this.myHoveredIcon = hoveredIcon;
        this.myChangeSupport.firePropertyChange(PROP_HOVERED_ICON, old, this.myHoveredIcon);
    }

    public Icon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        Icon old = this.mySelectedIcon;
        this.mySelectedIcon = selectedIcon;
        this.myChangeSupport.firePropertyChange(PROP_SELECTED_ICON, old, this.mySelectedIcon);
    }

    public int getMnemonic() {
        return this.myMnemonic;
    }

    public int getDisplayedMnemonicIndex() {
        return this.myDisplayedMnemonicIndex;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.myVisible;
        this.myVisible = visible;
        this.firePropertyChange(PROP_VISIBLE, oldVisible, this.myVisible);
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.myEnabled;
        this.myEnabled = enabled;
        this.firePropertyChange(PROP_ENABLED, oldEnabled, this.myEnabled);
    }

    public final void setEnabledAndVisible(boolean enabled) {
        this.setEnabled(enabled);
        this.setVisible(enabled);
    }

    private void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Presentation clone() {
        Presentation presentation = new Presentation();
        presentation.copyFrom(this);
        return presentation;
    }

    public void copyFrom(Presentation presentation) {
        this.setText(presentation.getTextWithMnemonic(), presentation.myDisplayedMnemonicIndex > -1);
        this.setDescription(presentation.getDescription());
        this.setIcon(presentation.getIcon());
        this.setSelectedIcon(presentation.getSelectedIcon());
        this.setDisabledIcon(presentation.getDisabledIcon());
        this.setHoveredIcon(presentation.getHoveredIcon());
        this.setVisible(presentation.isVisible());
        this.setEnabled(presentation.isEnabled());
    }

    @Nullable
    public Object getClientProperty(@NonNls @NotNull String key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(0);
        }
        return this.myUserMap.get(key);
    }

    public void putClientProperty(@NonNls @NotNull String key, @Nullable Object value) {
        Object oldValue;
        if (key == null) {
            Presentation.$$$reportNull$$$0(1);
        }
        if (Comparing.equal(oldValue = this.myUserMap.get(key), value)) {
            return;
        }
        this.myUserMap = value == null ? this.myUserMap.minus(key) : this.myUserMap.plus(key, value);
        this.myChangeSupport.firePropertyChange(key, oldValue, value);
    }

    public double getWeight() {
        return this.myWeight;
    }

    public void setWeight(double weight) {
        this.myWeight = weight;
    }

    public String toString() {
        return this.myText + " (" + this.myDescription + ")";
    }

    public boolean isEnabledAndVisible() {
        return this.isEnabled() && this.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "key";
        objectArray2[1] = "com/intellij/openapi/actionSystem/Presentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getClientProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "putClientProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

