/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;

public interface DiffPolicy {
    public static final DiffPolicy LINES_WO_FORMATTING = new LineBlocks(ComparisonPolicy.IGNORE_SPACE);
    public static final DiffPolicy DEFAULT_LINES = new LineBlocks(ComparisonPolicy.DEFAULT);

    @NotNull
    public DiffFragment[] buildFragments(@NotNull DiffString var1, @NotNull DiffString var2) throws FilesTooBigForDiffException;

    @NotNull
    public DiffFragment[] buildFragments(@NotNull String var1, @NotNull String var2) throws FilesTooBigForDiffException;

    public static class ByChar
    implements DiffPolicy {
        private final ComparisonPolicy myComparisonPolicy;

        public ByChar(ComparisonPolicy comparisonPolicy) {
            this.myComparisonPolicy = comparisonPolicy;
        }

        @Override
        @NotNull
        public DiffFragment[] buildFragments(@NotNull String text1, @NotNull String text2) throws FilesTooBigForDiffException {
            if (text1 == null) {
                ByChar.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                ByChar.$$$reportNull$$$0(1);
            }
            DiffFragment[] diffFragmentArray = this.buildFragments(DiffString.create(text1), DiffString.create(text2));
            if (diffFragmentArray == null) {
                ByChar.$$$reportNull$$$0(2);
            }
            return diffFragmentArray;
        }

        @Override
        @NotNull
        public DiffFragment[] buildFragments(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
            if (text1 == null) {
                ByChar.$$$reportNull$$$0(3);
            }
            if (text2 == null) {
                ByChar.$$$reportNull$$$0(4);
            }
            DiffFragment[] diffFragmentArray = this.myComparisonPolicy.buildFragments(ByChar.splitByChar(text1), ByChar.splitByChar(text2));
            if (diffFragmentArray == null) {
                ByChar.$$$reportNull$$$0(5);
            }
            return diffFragmentArray;
        }

        private static DiffString[] splitByChar(@NotNull DiffString text2) {
            if (text2 == null) {
                ByChar.$$$reportNull$$$0(6);
            }
            DiffString[] result2 = new DiffString[text2.length()];
            for (int i = 0; i < result2.length; ++i) {
                result2[i] = text2.substring(i, i + 1);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/processing/DiffPolicy$ByChar";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/processing/DiffPolicy$ByChar";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFragments";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "splitByChar";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class LineBlocks
    implements DiffPolicy {
        private final ComparisonPolicy myComparisonPolicy;

        public LineBlocks(ComparisonPolicy comparisonPolicy) {
            this.myComparisonPolicy = comparisonPolicy;
        }

        @Override
        @NotNull
        public DiffFragment[] buildFragments(@NotNull String text1, @NotNull String text2) throws FilesTooBigForDiffException {
            if (text1 == null) {
                LineBlocks.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                LineBlocks.$$$reportNull$$$0(1);
            }
            DiffFragment[] diffFragmentArray = this.buildFragments(DiffString.create(text1), DiffString.create(text2));
            if (diffFragmentArray == null) {
                LineBlocks.$$$reportNull$$$0(2);
            }
            return diffFragmentArray;
        }

        @Override
        @NotNull
        public DiffFragment[] buildFragments(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
            if (text1 == null) {
                LineBlocks.$$$reportNull$$$0(3);
            }
            if (text2 == null) {
                LineBlocks.$$$reportNull$$$0(4);
            }
            DiffString[] strings1 = text1.tokenize();
            DiffString[] strings2 = text2.tokenize();
            DiffFragment[] diffFragmentArray = this.myComparisonPolicy.buildDiffFragmentsFromLines(strings1, strings2);
            if (diffFragmentArray == null) {
                LineBlocks.$$$reportNull$$$0(5);
            }
            return diffFragmentArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/processing/DiffPolicy$LineBlocks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/processing/DiffPolicy$LineBlocks";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFragments";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

