/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderEnumeratorSettings;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.OrderRootsEnumeratorImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OrderEnumeratorBase
extends OrderEnumerator
implements OrderEnumeratorSettings {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.OrderEnumeratorBase");
    private boolean myProductionOnly;
    private boolean myCompileOnly;
    private boolean myRuntimeOnly;
    private boolean myWithoutJdk;
    private boolean myWithoutLibraries;
    boolean myWithoutDepModules;
    private boolean myWithoutModuleSourceEntries;
    boolean myRecursively;
    boolean myRecursivelyExportedOnly;
    private boolean myExportedOnly;
    private Condition<OrderEntry> myCondition;
    RootModelProvider myModulesProvider;
    private final OrderRootsCache myCache;

    OrderEnumeratorBase(@Nullable OrderRootsCache cache) {
        this.myCache = cache;
    }

    @NotNull
    static List<OrderEnumerationHandler> getCustomHandlers(@NotNull Module module) {
        if (module == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(0);
        }
        SmartList<OrderEnumerationHandler> customHandlers = null;
        for (OrderEnumerationHandler.Factory handlerFactory : OrderEnumerationHandler.EP_NAME.getExtensions()) {
            if (!handlerFactory.isApplicable(module)) continue;
            if (customHandlers == null) {
                customHandlers = new SmartList<OrderEnumerationHandler>();
            }
            customHandlers.add(handlerFactory.createHandler(module));
        }
        List<OrderEnumerationHandler> list = customHandlers == null ? Collections.emptyList() : customHandlers;
        if (list == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public OrderEnumerator productionOnly() {
        this.myProductionOnly = true;
        return this;
    }

    @Override
    public OrderEnumerator compileOnly() {
        this.myCompileOnly = true;
        return this;
    }

    @Override
    public OrderEnumerator runtimeOnly() {
        this.myRuntimeOnly = true;
        return this;
    }

    @Override
    public OrderEnumerator withoutSdk() {
        this.myWithoutJdk = true;
        return this;
    }

    @Override
    public OrderEnumerator withoutLibraries() {
        this.myWithoutLibraries = true;
        return this;
    }

    @Override
    public OrderEnumerator withoutDepModules() {
        this.myWithoutDepModules = true;
        return this;
    }

    @Override
    public OrderEnumerator withoutModuleSourceEntries() {
        this.myWithoutModuleSourceEntries = true;
        return this;
    }

    @Override
    public OrderEnumerator recursively() {
        this.myRecursively = true;
        return this;
    }

    @Override
    public OrderEnumerator exportedOnly() {
        if (this.myRecursively) {
            this.myRecursivelyExportedOnly = true;
        } else {
            this.myExportedOnly = true;
        }
        return this;
    }

    @Override
    public OrderEnumerator satisfying(Condition<OrderEntry> condition) {
        this.myCondition = condition;
        return this;
    }

    @Override
    public OrderEnumerator using(@NotNull RootModelProvider provider) {
        if (provider == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(2);
        }
        this.myModulesProvider = provider;
        return this;
    }

    @Override
    public OrderRootsEnumerator classes() {
        return new OrderRootsEnumeratorImpl(this, OrderRootType.CLASSES);
    }

    @Override
    public OrderRootsEnumerator sources() {
        return new OrderRootsEnumeratorImpl(this, OrderRootType.SOURCES);
    }

    @Override
    public OrderRootsEnumerator roots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(3);
        }
        return new OrderRootsEnumeratorImpl(this, rootType);
    }

    @Override
    public OrderRootsEnumerator roots(@NotNull NotNullFunction<OrderEntry, OrderRootType> rootTypeProvider) {
        if (rootTypeProvider == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(4);
        }
        return new OrderRootsEnumeratorImpl(this, rootTypeProvider);
    }

    ModuleRootModel getRootModel(Module module) {
        if (this.myModulesProvider != null) {
            return this.myModulesProvider.getRootModel(module);
        }
        return ModuleRootManager.getInstance(module);
    }

    public OrderRootsCache getCache() {
        LOG.assertTrue(this.myCache != null, "Caching is not supported for ModifiableRootModel");
        LOG.assertTrue(this.myCondition == null, "Caching not supported for OrderEnumerator with 'satisfying(Condition)' option");
        LOG.assertTrue(this.myModulesProvider == null, "Caching not supported for OrderEnumerator with 'using(ModulesProvider)' option");
        return this.myCache;
    }

    public int getFlags() {
        int flags = 0;
        if (this.myProductionOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myCompileOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRuntimeOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutJdk) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutLibraries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutDepModules) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutModuleSourceEntries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursively) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursivelyExportedOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myExportedOnly) {
            flags |= 1;
        }
        return flags;
    }

    @Override
    public boolean shouldRecurse(@NotNull ModuleOrderEntry entry, @NotNull List<OrderEnumerationHandler> handlers) {
        if (entry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(5);
        }
        if (handlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(6);
        }
        ProcessEntryAction action = this.shouldAddOrRecurse(entry, true, handlers);
        return action.type == ProcessEntryActionType.RECURSE;
    }

    private ProcessEntryAction shouldAddOrRecurse(OrderEntry entry, boolean firstLevel, List<OrderEnumerationHandler> customHandlers) {
        ModuleOrderEntry moduleOrderEntry;
        Module depModule;
        boolean exported;
        OrderEnumerationHandler handler;
        if (this.myCondition != null && !this.myCondition.value(entry)) {
            return ProcessEntryAction.SKIP;
        }
        if (entry instanceof JdkOrderEntry && (this.myWithoutJdk || !firstLevel)) {
            return ProcessEntryAction.SKIP;
        }
        if (this.myWithoutLibraries && entry instanceof LibraryOrderEntry) {
            return ProcessEntryAction.SKIP;
        }
        if (this.myWithoutDepModules) {
            if (!this.myRecursively && entry instanceof ModuleOrderEntry) {
                return ProcessEntryAction.SKIP;
            }
            if (entry instanceof ModuleSourceOrderEntry && !this.isRootModuleModel(((ModuleSourceOrderEntry)entry).getRootModel())) {
                return ProcessEntryAction.SKIP;
            }
        }
        if (this.myWithoutModuleSourceEntries && entry instanceof ModuleSourceOrderEntry) {
            return ProcessEntryAction.SKIP;
        }
        OrderEnumerationHandler.AddDependencyType shouldAdd = OrderEnumerationHandler.AddDependencyType.DEFAULT;
        Iterator<OrderEnumerationHandler> iterator = customHandlers.iterator();
        while (iterator.hasNext() && (shouldAdd = (handler = iterator.next()).shouldAddDependency(entry, this)) == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
        }
        if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD) {
            return ProcessEntryAction.SKIP;
        }
        boolean bl = exported = !(entry instanceof JdkOrderEntry);
        if (entry instanceof ExportableOrderEntry) {
            ExportableOrderEntry exportableEntry = (ExportableOrderEntry)entry;
            if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
                boolean forTestCompile;
                DependencyScope scope = exportableEntry.getScope();
                boolean bl2 = forTestCompile = scope.isForTestCompile() || scope == DependencyScope.RUNTIME && OrderEnumeratorBase.shouldAddRuntimeDependenciesToTestCompilationClasspath(customHandlers);
                if (this.myCompileOnly && !scope.isForProductionCompile() && !forTestCompile) {
                    return ProcessEntryAction.SKIP;
                }
                if (this.myRuntimeOnly && !scope.isForProductionRuntime() && !scope.isForTestRuntime()) {
                    return ProcessEntryAction.SKIP;
                }
                if (this.myProductionOnly && (!scope.isForProductionCompile() && !scope.isForProductionRuntime() || this.myCompileOnly && !scope.isForProductionCompile() || this.myRuntimeOnly && !scope.isForProductionRuntime())) {
                    return ProcessEntryAction.SKIP;
                }
            }
            exported = exportableEntry.isExported();
        }
        if (!exported) {
            if (this.myExportedOnly) {
                return ProcessEntryAction.SKIP;
            }
            if (this.myRecursivelyExportedOnly && !firstLevel) {
                return ProcessEntryAction.SKIP;
            }
        }
        if (this.myRecursively && entry instanceof ModuleOrderEntry && (depModule = (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) != null && OrderEnumeratorBase.shouldProcessRecursively(customHandlers)) {
            return ProcessEntryAction.RECURSE(depModule);
        }
        if (this.myWithoutDepModules && entry instanceof ModuleOrderEntry) {
            return ProcessEntryAction.SKIP;
        }
        return ProcessEntryAction.PROCESS;
    }

    protected void processEntries(ModuleRootModel rootModel, PairProcessor<OrderEntry, List<OrderEnumerationHandler>> processor, Set<Module> processed2, boolean firstLevel, List<OrderEnumerationHandler> customHandlers) {
        if (processed2 != null && !processed2.add(rootModel.getModule())) {
            return;
        }
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            ProcessEntryAction action = this.shouldAddOrRecurse(entry, firstLevel, customHandlers);
            if (action.type == ProcessEntryActionType.SKIP) continue;
            if (action.type == ProcessEntryActionType.RECURSE) {
                this.processEntries(this.getRootModel(action.recurseOnModule), processor, processed2, false, customHandlers);
                continue;
            }
            assert (action.type == ProcessEntryActionType.PROCESS);
            if (processor.process(entry, customHandlers)) continue;
            return;
        }
    }

    private static boolean shouldAddRuntimeDependenciesToTestCompilationClasspath(List<OrderEnumerationHandler> customHandlers) {
        for (OrderEnumerationHandler handler : customHandlers) {
            if (!handler.shouldAddRuntimeDependenciesToTestCompilationClasspath()) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldProcessRecursively(List<OrderEnumerationHandler> customHandlers) {
        for (OrderEnumerationHandler handler : customHandlers) {
            if (handler.shouldProcessDependenciesRecursively()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(@NotNull Processor<OrderEntry> processor) {
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(7);
        }
        this.forEach((OrderEntry entry, List<OrderEnumerationHandler> handlers) -> {
            if (processor == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(27);
            }
            return processor.process((OrderEntry)entry);
        });
    }

    protected abstract void forEach(@NotNull PairProcessor<OrderEntry, List<OrderEnumerationHandler>> var1);

    @Override
    public void forEachLibrary(@NotNull Processor<Library> processor) {
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(8);
        }
        this.forEach((OrderEntry entry, List<OrderEnumerationHandler> handlers) -> {
            Library library;
            if (processor == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(26);
            }
            if (entry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)entry).getLibrary()) != null) {
                return processor.process(library);
            }
            return true;
        });
    }

    @Override
    public void forEachModule(@NotNull Processor<Module> processor) {
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(9);
        }
        this.forEach((OrderEntry orderEntry, List<OrderEnumerationHandler> customHandlers) -> {
            Module module;
            if (processor == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(25);
            }
            if (this.myRecursively && orderEntry instanceof ModuleSourceOrderEntry) {
                Module module2 = ((ModuleSourceOrderEntry)orderEntry).getRootModel().getModule();
                return processor.process(module2);
            }
            if (!(!(orderEntry instanceof ModuleOrderEntry) || this.myRecursively && OrderEnumeratorBase.shouldProcessRecursively(customHandlers) || (module = ((ModuleOrderEntry)orderEntry).getModule()) == null)) {
                return processor.process(module);
            }
            return true;
        });
    }

    @Override
    public <R> R process(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(10);
        }
        OrderEntryProcessor processor = new OrderEntryProcessor(policy, initialValue);
        this.forEach(processor);
        return (R)processor.myValue;
    }

    static boolean shouldIncludeTestsFromDependentModulesToTestClasspath(@NotNull List<OrderEnumerationHandler> customHandlers) {
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(11);
        }
        for (OrderEnumerationHandler handler : customHandlers) {
            if (handler.shouldIncludeTestsFromDependentModulesToTestClasspath()) continue;
            return false;
        }
        return true;
    }

    static boolean addCustomRootsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<VirtualFile> result2, @NotNull List<OrderEnumerationHandler> customHandlers) {
        if (forOrderEntry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(12);
        }
        if (type == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(14);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(15);
        }
        for (OrderEnumerationHandler handler : customHandlers) {
            ArrayList<String> urls = new ArrayList<String>();
            boolean added = handler.addCustomRootsForLibrary(forOrderEntry, type, urls);
            for (String url : urls) {
                ContainerUtil.addIfNotNull(result2, VirtualFileManager.getInstance().findFileByUrl(url));
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    static boolean addCustomRootUrlsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<String> result2, @NotNull List<OrderEnumerationHandler> customHandlers) {
        if (forOrderEntry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(16);
        }
        if (type == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(17);
        }
        if (result2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(18);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(19);
        }
        for (OrderEnumerationHandler handler : customHandlers) {
            ArrayList<String> urls = new ArrayList<String>();
            boolean added = handler.addCustomRootsForLibrary(forOrderEntry, type, urls);
            result2.addAll(urls);
            if (!added) continue;
            return true;
        }
        return false;
    }

    static boolean addCustomRootsForModule(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<VirtualFile> result2, boolean includeProduction, boolean includeTests, @NotNull List<OrderEnumerationHandler> customHandlers) {
        if (type == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(20);
        }
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(21);
        }
        if (result2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(22);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(23);
        }
        for (OrderEnumerationHandler handler : customHandlers) {
            ArrayList<String> urls = new ArrayList<String>();
            boolean added = handler.addCustomModuleRoots(type, rootModel, urls, includeProduction, includeTests);
            for (String url : urls) {
                ContainerUtil.addIfNotNull(result2, VirtualFileManager.getInstance().findFileByUrl(url));
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRuntimeOnly() {
        return this.myRuntimeOnly;
    }

    @Override
    public boolean isCompileOnly() {
        return this.myCompileOnly;
    }

    @Override
    public boolean isProductionOnly() {
        return this.myProductionOnly;
    }

    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(24);
        }
        return false;
    }

    public abstract void processRootModules(@NotNull Processor<Module> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderEnumeratorBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypeProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customHandlers";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forOrderEntry";
                break;
            }
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderEnumeratorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomHandlers";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "using";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "roots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecurse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forEachLibrary";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forEachModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldIncludeTestsFromDependentModulesToTestClasspath";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootsForLibrary";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootUrlsForLibrary";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootsForModule";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isRootModuleModel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forEachModule$2";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forEachLibrary$1";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forEach$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OrderEntryProcessor<R>
    implements PairProcessor<OrderEntry, List<OrderEnumerationHandler>> {
        private R myValue;
        private final RootPolicy<R> myPolicy;

        private OrderEntryProcessor(RootPolicy<R> policy, R initialValue) {
            this.myPolicy = policy;
            this.myValue = initialValue;
        }

        @Override
        public boolean process(OrderEntry orderEntry, List<OrderEnumerationHandler> customHandlers) {
            this.myValue = orderEntry.accept(this.myPolicy, this.myValue);
            return true;
        }
    }

    protected static class ProcessEntryAction {
        public ProcessEntryActionType type;
        @Nullable
        Module recurseOnModule;
        public static final ProcessEntryAction SKIP = new ProcessEntryAction(ProcessEntryActionType.SKIP);
        public static final ProcessEntryAction PROCESS = new ProcessEntryAction(ProcessEntryActionType.PROCESS);

        private ProcessEntryAction(ProcessEntryActionType type) {
            this.type = type;
        }

        static ProcessEntryAction RECURSE(@NotNull Module module) {
            if (module == null) {
                ProcessEntryAction.$$$reportNull$$$0(0);
            }
            ProcessEntryAction result2 = new ProcessEntryAction(ProcessEntryActionType.RECURSE);
            result2.recurseOnModule = module;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/OrderEnumeratorBase$ProcessEntryAction", "RECURSE"));
        }
    }

    protected static enum ProcessEntryActionType {
        SKIP,
        RECURSE,
        PROCESS;

    }
}

