/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.util.containers.ContainerUtil;
import java.beans.Introspector;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class GCUtil {
    public static void tryForceGC() {
        GCUtil.tryGcSoftlyReachableObjects();
        WeakReference<Object> weakReference = new WeakReference<Object>(new Object());
        do {
            System.gc();
        } while (weakReference.get() != null);
    }

    public static void tryGcSoftlyReachableObjects() {
        ReferenceQueue q = new ReferenceQueue();
        SoftReference<Object> ref = new SoftReference<Object>(new Object(), q);
        ArrayList<SoftReference> list = ContainerUtil.newArrayListWithCapacity(100 + GCUtil.useReference(ref));
        System.gc();
        long freeMemory = Runtime.getRuntime().freeMemory();
        for (int i = 0; i < 100 && q.poll() == null; ++i) {
            int bytes = Math.min((int)((double)freeMemory * 0.05), 0x3FFFFFFF);
            list.add(new SoftReference<byte[]>(new byte[bytes]));
        }
        list.ensureCapacity(list.size() + GCUtil.useReference(ref));
        for (SoftReference createdReference : list) {
            createdReference.clear();
        }
    }

    private static int useReference(SoftReference<Object> ref) {
        Object o = ref.get();
        return o == null ? 0 : Math.abs(o.hashCode()) % 10;
    }

    public static void clearBeanInfoCache() {
        Introspector.flushCaches();
    }
}

