/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OptionTagBinding
extends BasePrimitiveBinding {
    private final String myTagName;
    private final String myNameAttribute;
    private final String myValueAttribute;

    public OptionTagBinding(@NotNull MutableAccessor accessor, @Nullable OptionTag optionTag) {
        if (accessor == null) {
            OptionTagBinding.$$$reportNull$$$0(0);
        }
        super(accessor, optionTag == null ? null : optionTag.value(), optionTag == null ? null : optionTag.converter());
        if (optionTag == null) {
            this.myTagName = "option";
            this.myNameAttribute = "name";
            this.myValueAttribute = "value";
        } else {
            this.myNameAttribute = optionTag.nameAttribute();
            this.myValueAttribute = optionTag.valueAttribute();
            String tagName = optionTag.tag();
            if (StringUtil.isEmpty(this.myNameAttribute) && "option".equals(tagName)) {
                tagName = this.myAccessor.getName();
            }
            this.myTagName = tagName;
        }
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable SerializationFilter filter) {
        if (o == null) {
            OptionTagBinding.$$$reportNull$$$0(1);
        }
        Object value = this.myAccessor.read(o);
        Element targetElement = new Element(this.myTagName);
        if (!StringUtil.isEmpty(this.myNameAttribute)) {
            targetElement.setAttribute(this.myNameAttribute, this.myName);
        }
        if (value == null) {
            return targetElement;
        }
        Converter<Object> converter = this.getConverter();
        if (converter == null) {
            if (this.myBinding == null) {
                targetElement.setAttribute(this.myValueAttribute, XmlSerializerImpl.removeControlChars(XmlSerializerImpl.convertToString(value)));
            } else if (this.myBinding instanceof BeanBinding && this.myValueAttribute.isEmpty()) {
                ((BeanBinding)this.myBinding).serializeInto(value, targetElement, filter);
            } else {
                Object node = this.myBinding.serialize(value, targetElement, filter);
                if (node != null && targetElement != node) {
                    OptionTagBinding.addContent(targetElement, node);
                }
            }
        } else {
            String text2 = converter.toString(value);
            if (text2 != null) {
                targetElement.setAttribute(this.myValueAttribute, XmlSerializerImpl.removeControlChars(text2));
            }
        }
        return targetElement;
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        Attribute valueAttribute;
        if (context == null) {
            OptionTagBinding.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OptionTagBinding.$$$reportNull$$$0(3);
        }
        if ((valueAttribute = element.getAttribute(this.myValueAttribute)) == null) {
            if (this.myValueAttribute.isEmpty()) {
                assert (this.myBinding != null);
                this.myAccessor.set(context, this.myBinding.deserializeUnsafe(context, element));
            } else {
                List children = element.getChildren();
                if (children.isEmpty()) {
                    this.myAccessor.set(context, null);
                } else {
                    Object newValue;
                    assert (this.myBinding != null);
                    Object oldValue = this.myAccessor.read(context);
                    if (oldValue != (newValue = Binding.deserializeList(this.myBinding, oldValue, children))) {
                        this.myAccessor.set(context, newValue);
                    }
                }
            }
        } else {
            String value = valueAttribute.getValue();
            if (this.myConverter == null) {
                try {
                    XmlSerializerImpl.doSet(context, value, this.myAccessor, XmlSerializerImpl.typeToClass(this.myAccessor.getGenericType()));
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot set value for field " + this.myName, e);
                }
            } else {
                this.myAccessor.set(context, this.myConverter.fromString(value));
            }
        }
        Object object = context;
        if (object == null) {
            OptionTagBinding.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            OptionTagBinding.$$$reportNull$$$0(5);
        }
        if (!element.getName().equals(this.myTagName)) {
            return false;
        }
        String name = element.getAttributeValue(this.myNameAttribute);
        if (StringUtil.isEmpty(this.myNameAttribute)) {
            return name == null || name.equals(this.myName);
        }
        return name != null && name.equals(this.myName);
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.myName + ", binding=" + this.myBinding + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/OptionTagBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/OptionTagBinding";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

