/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ClassWithoutNoArgConstructorInspection
extends BaseInspection {
    public boolean m_ignoreClassesWithNoConstructors = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.without.no.arg.constructor.display.name", new Object[0]);
        if (string == null) {
            ClassWithoutNoArgConstructorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("class.without.no.arg.constructor.ignore.option", new Object[0]), this, "m_ignoreClassesWithNoConstructors");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.without.no.arg.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassWithoutNoArgConstructorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithoutNoArgConstructorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javabeans/ClassWithoutNoArgConstructorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassWithoutNoArgConstructorVisitor
    extends BaseInspectionVisitor {
        private ClassWithoutNoArgConstructorVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ClassWithoutNoArgConstructorVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (ClassWithoutNoArgConstructorInspection.this.m_ignoreClassesWithNoConstructors && !this.classHasConstructor(aClass)) {
                return;
            }
            if (this.classHasNoArgConstructor(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean classHasNoArgConstructor(PsiClass aClass) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                PsiParameterList parameterList = constructor.getParameterList();
                if (!parameterList.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean classHasConstructor(PsiClass aClass) {
            PsiMethod[] constructors = aClass.getConstructors();
            return constructors.length != 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/javabeans/ClassWithoutNoArgConstructorInspection$ClassWithoutNoArgConstructorVisitor", "visitClass"));
        }
    }
}

