/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.resources.ImplicitResourceCloser;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoCloseableResourceInspectionBase
extends ResourceInspection {
    private static final CallMatcher CLOSE = CallMatcher.instanceCall("java.lang.AutoCloseable", "close");
    private static final List<String> DEFAULT_IGNORED_TYPES = Arrays.asList("java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream");
    public boolean ignoreFromMethodCall = false;
    public boolean showWarningForStreamHoldingResource = true;
    final List<String> ignoredTypes = new ArrayList<String>(DEFAULT_IGNORED_TYPES);
    protected final MethodMatcher myMethodMatcher;
    CallMatcher STREAM_HOLDING_RESOURCE = CallMatcher.staticCall("java.nio.file.Files", "lines", "walk", "list", "find");

    public AutoCloseableResourceInspectionBase() {
        this.myMethodMatcher = new MethodMatcher().add("java.util.Formatter", "format").add("java.io.Writer", "append").add("com.google.common.base.Preconditions", "checkNotNull").add("org.hibernate.Session", "close").add("java.io.PrintWriter", "printf").finishDefault();
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("auto.closeable.resource.display.name", new Object[0]);
        if (string == null) {
            AutoCloseableResourceInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("resource" == null) {
            AutoCloseableResourceInspectionBase.$$$reportNull$$$0(1);
        }
        return "resource";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String text2 = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("auto.closeable.resource.problem.descriptor", text2);
        if (string == null) {
            AutoCloseableResourceInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean buildQuickfix = (Boolean)infos[1];
        if (!buildQuickfix) {
            return null;
        }
        return new AutoCloseableResourceFix();
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            AutoCloseableResourceInspectionBase.$$$reportNull$$$0(3);
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            String ignoredTypesString;
            String name = option.getAttributeValue("name");
            if (!"ignoredTypes".equals(name) || (ignoredTypesString = option.getAttributeValue("value")) == null) continue;
            this.ignoredTypes.clear();
            AutoCloseableResourceInspectionBase.parseString(ignoredTypesString, this.ignoredTypes);
        }
        this.myMethodMatcher.readSettings(node);
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            AutoCloseableResourceInspectionBase.$$$reportNull$$$0(4);
        }
        this.writeBooleanOption(node, "ignoreFromMethodCall", false);
        this.writeBooleanOption(node, "anyMethodMayClose", true);
        if (!DEFAULT_IGNORED_TYPES.equals(this.ignoredTypes)) {
            String ignoredTypesString = AutoCloseableResourceInspectionBase.formatString(this.ignoredTypes);
            node.addContent(new Element("option").setAttribute("name", "ignoredTypes").setAttribute("value", ignoredTypesString));
        }
        this.myMethodMatcher.writeSettings(node);
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression) {
        return TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.AutoCloseable") && (this.isStreamHoldingResource(expression) || !TypeUtils.expressionHasTypeOrSubtype(expression, this.ignoredTypes));
    }

    private boolean isStreamHoldingResource(PsiExpression expression) {
        return this.showWarningForStreamHoldingResource && this.STREAM_HOLDING_RESOURCE.matches(ObjectUtils.tryCast(expression, PsiMethodCallExpression.class));
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel7OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AutoCloseableResourceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AutoCloseableResourceVisitor
    extends BaseInspectionVisitor {
        private AutoCloseableResourceVisitor() {
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (this.isSafelyClosedResource(expression)) {
                return;
            }
            this.registerNewExpressionError(expression, expression.getType(), Boolean.FALSE);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (AutoCloseableResourceInspectionBase.this.ignoreFromMethodCall || AutoCloseableResourceInspectionBase.this.myMethodMatcher.matches(expression) || this.isSafelyClosedResource(expression)) {
                return;
            }
            this.registerMethodCallError(expression, expression.getType(), !AutoCloseableResourceInspectionBase.this.isStreamHoldingResource(expression));
        }

        @Override
        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            super.visitMethodReferenceExpression(expression);
            if (!expression.isConstructor()) {
                return;
            }
            PsiType type = PsiMethodReferenceUtil.getQualifierType(expression);
            if (!InheritanceUtil.isInheritor(type, "java.lang.AutoCloseable")) {
                return;
            }
            for (String ignoredType : AutoCloseableResourceInspectionBase.this.ignoredTypes) {
                if (!InheritanceUtil.isInheritor(type, ignoredType)) continue;
                return;
            }
            this.registerError((PsiElement)expression, type, Boolean.FALSE);
        }

        private boolean isSafelyClosedResource(PsiExpression expression) {
            if (!AutoCloseableResourceInspectionBase.this.isResourceCreation(expression)) {
                return true;
            }
            if (CLOSE.test(ExpressionUtils.getCallForQualifier(expression))) {
                return true;
            }
            PsiVariable variable = ResourceInspection.getVariable(expression);
            if (variable instanceof PsiResourceVariable || AutoCloseableResourceInspectionBase.this.isResourceEscapingFromMethod(variable, expression)) {
                return true;
            }
            if (variable == null) {
                return false;
            }
            return StreamEx.of((Object[])Extensions.getExtensions(ImplicitResourceCloser.EP_NAME)).anyMatch(closer -> closer.isSafelyClosed(variable));
        }
    }

    private class AutoCloseableResourceFix
    extends InspectionGadgetsFix {
        private AutoCloseableResourceFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("auto.closeable.resource.quickfix", new Object[0]);
            if (string == null) {
                AutoCloseableResourceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType(element, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return;
            }
            AutoCloseableResourceInspectionBase.this.myMethodMatcher.add(methodCallExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase$AutoCloseableResourceFix", "getFamilyName"));
        }
    }
}

