/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageLoader
implements Serializable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");
    public static final int CACHED_IMAGE_MAX_SIZE = (int)Math.round(Registry.doubleValue("ide.cached.image.max.size") * 1024.0 * 1024.0);
    private static final ConcurrentMap<String, Image> ourCache = ContainerUtil.createConcurrentSoftValueMap();
    private static LoadFunction measureLoad;
    public static final Component ourComponent;

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(0);
        }
        return ImageLoader.loadFromUrl(url, true);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(1);
        }
        return ImageLoader.loadFromUrl(url, allowFloatScaling, null);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling, ImageFilter filter) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(2);
        }
        return ImageLoader.loadFromUrl(url, allowFloatScaling, true, new ImageFilter[]{filter}, JBUI.ScaleContext.create());
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, final boolean allowFloatScaling, boolean useCache, ImageFilter[] filters, final JBUI.ScaleContext ctx) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(3);
        }
        return ImageDescList.create(url.toString(), null, UIUtil.isUnderDarcula(), allowFloatScaling, ctx).load(ImageConverterChain.create().withFilter(filters).with(new ImageConverter(){

            @Override
            public Image convert(Image source, ImageDesc desc) {
                if (source != null && desc.type != ImageDesc.Type.SVG) {
                    double scale = ImageLoader.adjustScaleFactor(allowFloatScaling, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
                    if (desc.scale > 1.0) {
                        scale /= desc.scale;
                    }
                    source = ImageLoader.scaleImage(source, scale);
                }
                return source;
            }
        }).withHiDPI(ctx), useCache);
    }

    private static double adjustScaleFactor(boolean allowFloatScaling, double scale) {
        return allowFloatScaling ? scale : (JBUI.isHiDPI(scale) ? 2.0 : 1.0);
    }

    @NotNull
    public static Image scaleImage(Image image, double scale) {
        if (scale == 1.0) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(4);
            }
            return image2;
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(scale);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(5);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            Image image3 = image;
            if (image3 == null) {
                ImageLoader.$$$reportNull$$$0(6);
            }
            return image3;
        }
        int width = (int)Math.round(scale * (double)w);
        int height = (int)Math.round(scale * (double)h);
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(7);
        }
        return bufferedImage;
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        Class callerClass;
        if (s == null) {
            ImageLoader.$$$reportNull$$$0(8);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return null;
        }
        return ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(9);
        }
        if (aClass == null) {
            ImageLoader.$$$reportNull$$$0(10);
        }
        JBUI.ScaleContext ctx = JBUI.ScaleContext.create();
        return ImageDescList.create(path, aClass, UIUtil.isUnderDarcula(), true, ctx).load(ImageConverterChain.create().withHiDPI(ctx));
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(11);
        }
        return ImageLoader.loadFromStream(inputStream, 1);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(12);
        }
        return ImageLoader.loadFromStream(inputStream, scale, null);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, int scale, ImageFilter filter) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(13);
        }
        Image image = ImageLoader.load(inputStream, scale);
        ImageDesc desc = new ImageDesc("", null, scale, ImageDesc.Type.UNDEFINED);
        return ImageConverterChain.create().withFilter(filter).withHiDPI(JBUI.ScaleContext.create()).convert(image, desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image load(@NotNull InputStream inputStream, double scale) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(14);
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be 1 or greater");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            ImageLoader.waitForImage(image);
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }

    public static boolean isGoodSize(Icon icon) {
        return IconLoader.isGoodSize(icon);
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file) {
        if (file == null) {
            ImageLoader.$$$reportNull$$$0(15);
        }
        return ImageLoader.getFileNames(file, false, false);
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file, boolean dark, boolean retina) {
        if (file == null) {
            ImageLoader.$$$reportNull$$$0(16);
        }
        new UnsupportedOperationException("unsupported method").printStackTrace();
        return new ArrayList<Pair<String, Integer>>();
    }

    static {
        ourComponent = new Component(){};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ImageLoader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ImageLoader";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFromResource";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFileNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImageConverterChain
    extends ArrayList<ImageConverter> {
        private ImageConverterChain() {
        }

        public static ImageConverterChain create() {
            return new ImageConverterChain();
        }

        public ImageConverterChain withFilter(ImageFilter[] filters) {
            ImageConverterChain chain = this;
            for (ImageFilter filter : filters) {
                chain = chain.withFilter(filter);
            }
            return chain;
        }

        public ImageConverterChain withFilter(final ImageFilter filter) {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    return ImageUtil.filter(source, filter);
                }
            });
        }

        public ImageConverterChain withHiDPI(final JBUI.ScaleContext ctx) {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    if (source != null && UIUtil.isJreHiDPI(ctx)) {
                        return RetinaImage.createFrom(source, ctx.getScale(JBUI.ScaleType.SYS_SCALE), (ImageObserver)ourComponent);
                    }
                    return source;
                }
            });
        }

        public ImageConverterChain with(ImageConverter f) {
            this.add(f);
            return this;
        }

        public Image convert(Image image, ImageDesc desc) {
            for (ImageConverter f : this) {
                image = f.convert(image, desc);
            }
            return image;
        }
    }

    private static interface ImageConverter {
        public Image convert(@Nullable Image var1, ImageDesc var2);
    }

    private static class ImageDescList
    extends ArrayList<ImageDesc> {
        private ImageDescList() {
        }

        @Nullable
        public Image load() {
            return this.load(ImageConverterChain.create());
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters) {
            if (converters == null) {
                ImageDescList.$$$reportNull$$$0(0);
            }
            return this.load(converters, true);
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters, boolean useCache) {
            if (converters == null) {
                ImageDescList.$$$reportNull$$$0(1);
            }
            for (ImageDesc desc : this) {
                try {
                    Image image = desc.load(useCache);
                    if (image == null) continue;
                    LOG.debug("Loaded image: " + desc);
                    return converters.convert(image, desc);
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        public static ImageDescList create(@NotNull String file, @Nullable Class cls, boolean dark, boolean allowFloatScaling, JBUI.ScaleContext ctx) {
            if (file == null) {
                ImageDescList.$$$reportNull$$$0(2);
            }
            ImageDescList vars = new ImageDescList();
            boolean ideSvgIconSupport = Registry.is("ide.svg.icon");
            boolean retina = JBUI.isHiDPI(ctx.getScale(JBUI.ScaleType.PIX_SCALE));
            if (retina || dark || ideSvgIconSupport) {
                String name = FileUtil.getNameWithoutExtension(file);
                String ext = FileUtilRt.getExtension(file);
                double scale = ImageLoader.adjustScaleFactor(allowFloatScaling, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
                if (ideSvgIconSupport && dark) {
                    vars.add(new ImageDesc(name + "_dark.svg", cls, scale, ImageDesc.Type.SVG));
                }
                if (ideSvgIconSupport) {
                    vars.add(new ImageDesc(name + ".svg", cls, scale, ImageDesc.Type.SVG));
                }
                if (dark && retina) {
                    vars.add(new ImageDesc(name + "@2x_dark." + ext, cls, 2.0, ImageDesc.Type.PNG));
                }
                if (dark) {
                    vars.add(new ImageDesc(name + "_dark." + ext, cls, 1.0, ImageDesc.Type.PNG));
                }
                if (retina) {
                    vars.add(new ImageDesc(name + "@2x." + ext, cls, 2.0, ImageDesc.Type.PNG));
                }
            }
            vars.add(new ImageDesc(file, cls, 1.0, ImageDesc.Type.PNG, true));
            return vars;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ImageLoader$ImageDescList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ImageDesc {
        public final String path;
        @Nullable
        public final Class cls;
        public final double scale;
        public final Type type;
        public final boolean original;

        public ImageDesc(String path, Class cls, double scale, Type type) {
            this(path, cls, scale, type, false);
        }

        public ImageDesc(String path, Class cls, double scale, Type type, boolean original) {
            this.path = path;
            this.cls = cls;
            this.scale = scale;
            this.type = type;
            this.original = original;
        }

        @Nullable
        public Image load() throws IOException {
            return this.load(true);
        }

        @Nullable
        public Image load(boolean useCache) throws IOException {
            Image image;
            String cacheKey = null;
            InputStream stream = null;
            URL url = null;
            if (this.cls != null && (stream = this.cls.getResourceAsStream(this.path)) == null) {
                return null;
            }
            if (stream == null) {
                URLConnection connection;
                if (useCache) {
                    cacheKey = this.path + (this.type == Type.SVG ? "_@" + this.scale + "x" : "");
                    image = (Image)ourCache.get(cacheKey);
                    if (image != null) {
                        return image;
                    }
                }
                if ((connection = (url = new URL(this.path)).openConnection()) instanceof HttpURLConnection) {
                    if (!this.original) {
                        return null;
                    }
                    connection.addRequestProperty("User-Agent", "IntelliJ");
                }
                stream = connection.getInputStream();
            }
            if ((image = this.type.load(url, stream, this.scale)) != null && cacheKey != null && image.getWidth(null) * image.getHeight(null) * 4 <= CACHED_IMAGE_MAX_SIZE) {
                ourCache.put(cacheKey, image);
            }
            return image;
        }

        public String toString() {
            return this.path + ", scale: " + this.scale + ", type: " + (Object)((Object)this.type);
        }

        public static enum Type {
            PNG,
            SVG{

                @Override
                public Image load(final URL url, final InputStream is, final double scale) throws IOException {
                    LoadFunction f = new LoadFunction(){

                        @Override
                        public Image load(LoadFunction delegate, Type type) throws IOException {
                            return SVGLoader.load(url, is, scale);
                        }
                    };
                    if (measureLoad != null) {
                        return measureLoad.load(f, SVG);
                    }
                    return f.load(null, null);
                }
            }
            ,
            UNDEFINED;


            public Image load(URL url, final InputStream is, final double scale) throws IOException {
                LoadFunction f = new LoadFunction(){

                    @Override
                    public Image load(LoadFunction delegate, Type type) {
                        return ImageLoader.load(is, scale);
                    }
                };
                if (measureLoad != null) {
                    return measureLoad.load(f, PNG);
                }
                return f.load(null, null);
            }
        }
    }

    public static interface LoadFunction {
        public Image load(@Nullable LoadFunction var1, @Nullable ImageDesc.Type var2) throws IOException;
    }
}

