/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

class OffsetTranslator
implements Disposable {
    static final Key<OffsetTranslator> RANGE_TRANSLATION = Key.create("completion.rangeTranslation");
    private final PsiFile myOriginalFile;
    private final Document myCopyDocument;
    private final LinkedList<DocumentEvent> myTranslation = new LinkedList();

    OffsetTranslator(final Document originalDocument, final PsiFile originalFile, Document copyDocument, int start, int end, String replacement) {
        this.myOriginalFile = originalFile;
        this.myCopyDocument = copyDocument;
        this.myCopyDocument.putUserData(RANGE_TRANSLATION, this);
        this.myTranslation.addFirst(new DocumentEventImpl(copyDocument, start, originalDocument.getImmutableCharSequence().subSequence(start, end), replacement, 0L, false));
        Disposer.register(originalFile.getProject(), this);
        final LinkedList sinceCommit = new LinkedList();
        originalDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void documentChanged(DocumentEvent e) {
                if (OffsetTranslator.this.isUpToDate()) {
                    DocumentEventImpl inverse = new DocumentEventImpl(originalDocument, e.getOffset(), e.getNewFragment(), e.getOldFragment(), 0L, false);
                    sinceCommit.addLast(inverse);
                }
            }
        }, this);
        originalFile.getProject().getMessageBus().connect(this).subscribe(PsiModificationTracker.TOPIC, new PsiModificationTracker.Listener(){
            long lastModCount;
            {
                this.lastModCount = originalFile.getViewProvider().getModificationStamp();
            }

            @Override
            public void modificationCountChanged() {
                if (OffsetTranslator.this.isUpToDate() && this.lastModCount != originalFile.getViewProvider().getModificationStamp()) {
                    OffsetTranslator.this.myTranslation.addAll(sinceCommit);
                    sinceCommit.clear();
                }
            }
        });
    }

    private boolean isUpToDate() {
        return this == this.myCopyDocument.getUserData(RANGE_TRANSLATION) && this.myOriginalFile.isValid();
    }

    @Override
    public void dispose() {
        if (this.isUpToDate()) {
            this.myCopyDocument.putUserData(RANGE_TRANSLATION, null);
        }
    }

    @Nullable
    Integer translateOffset(Integer offset) {
        for (DocumentEvent event : this.myTranslation) {
            if ((offset = OffsetTranslator.translateOffset(offset, event)) != null) continue;
            return null;
        }
        return offset;
    }

    @Nullable
    private static Integer translateOffset(int offset, DocumentEvent event) {
        if (event.getOffset() < offset && offset < event.getOffset() + event.getNewLength()) {
            if (event.getOldLength() == 0) {
                return event.getOffset();
            }
            return null;
        }
        return offset <= event.getOffset() ? offset : offset - event.getNewLength() + event.getOldLength();
    }
}

