/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiProvidesStatement;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeProvidesStatementsFix
extends MergeModuleStatementsFix<PsiProvidesStatement> {
    private final String myInterfaceName;

    MergeProvidesStatementsFix(@NotNull PsiJavaModule javaModule, @NotNull String interfaceName) {
        if (javaModule == null) {
            MergeProvidesStatementsFix.$$$reportNull$$$0(0);
        }
        if (interfaceName == null) {
            MergeProvidesStatementsFix.$$$reportNull$$$0(1);
        }
        super(javaModule);
        this.myInterfaceName = interfaceName;
    }

    @Override
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("java.9.merge.module.statements.fix.name", "provides", this.myInterfaceName);
        if (string == null) {
            MergeProvidesStatementsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("java.9.merge.module.statements.fix.family.name", "provides");
        if (string == null) {
            MergeProvidesStatementsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getReplacementText(@NotNull List<PsiProvidesStatement> statementsToMerge) {
        List<String> implementationNames;
        if (statementsToMerge == null) {
            MergeProvidesStatementsFix.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!(implementationNames = MergeProvidesStatementsFix.getImplementationNames(statementsToMerge)).isEmpty());
        String string = "provides " + this.myInterfaceName + ' ' + "with" + ' ' + MergeProvidesStatementsFix.joinUniqueNames(implementationNames);
        if (string == null) {
            MergeProvidesStatementsFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static List<String> getImplementationNames(@NotNull List<PsiProvidesStatement> statements) {
        if (statements == null) {
            MergeProvidesStatementsFix.$$$reportNull$$$0(6);
        }
        List list = StreamEx.of(statements).map(PsiProvidesStatement::getImplementationList).nonNull().flatMap(implementationList -> Arrays.stream(implementationList.getReferenceElements())).nonNull().map(PsiJavaCodeReferenceElement::getQualifiedName).nonNull().toList();
        if (list == null) {
            MergeProvidesStatementsFix.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<PsiProvidesStatement> getStatementsToMerge(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            MergeProvidesStatementsFix.$$$reportNull$$$0(8);
        }
        List list = ((StreamEx)StreamEx.of(javaModule.getProvides().iterator()).filter(statement -> {
            PsiJavaCodeReferenceElement reference = statement.getInterfaceReference();
            return reference != null && this.myInterfaceName.equals(reference.getQualifiedName());
        })).toList();
        if (list == null) {
            MergeProvidesStatementsFix.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public static MergeModuleStatementsFix createFix(@Nullable PsiProvidesStatement statement) {
        String interfaceName;
        PsiJavaCodeReferenceElement interfaceReference;
        PsiElement parent;
        if (statement != null && (parent = statement.getParent()) instanceof PsiJavaModule && (interfaceReference = statement.getInterfaceReference()) != null && (interfaceName = interfaceReference.getQualifiedName()) != null) {
            return new MergeProvidesStatementsFix((PsiJavaModule)parent, interfaceName);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementsToMerge";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsToMerge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImplementationNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStatementsToMerge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

