/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ContractChecker
extends DataFlowRunner {
    private final PsiMethod myMethod;
    private final StandardMethodContract myContract;
    private final Set<PsiElement> myViolations = ContainerUtil.newHashSet();
    private final Set<PsiElement> myNonViolations = ContainerUtil.newHashSet();
    private final Set<PsiElement> myFailures = ContainerUtil.newHashSet();

    private ContractChecker(PsiMethod method, StandardMethodContract contract) {
        super(false, true);
        this.myMethod = method;
        this.myContract = contract;
    }

    static Map<PsiElement, String> checkContractClause(PsiMethod method, StandardMethodContract contract) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return Collections.emptyMap();
        }
        ContractChecker checker = new ContractChecker(method, contract);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        DfaMemoryState initialState = checker.createMemoryState();
        DfaValueFactory factory = checker.getFactory();
        for (int i = 0; i < contract.arguments.length; ++i) {
            MethodContract.ValueConstraint constraint = contract.arguments[i];
            DfaConstValue comparisonValue = constraint.getComparisonValue(factory);
            if (comparisonValue == null) continue;
            boolean negated = constraint.shouldUseNonEqComparison();
            DfaVariableValue dfaParam = factory.getVarFactory().createVariableValue(parameters[i], false);
            initialState.applyCondition(factory.createCondition(dfaParam, DfaRelationValue.RelationType.equivalence(!negated), comparisonValue));
        }
        checker.analyzeMethod(body, new StandardInstructionVisitor(), false, Collections.singletonList(initialState));
        return checker.getErrors();
    }

    @Override
    @NotNull
    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
        DfaMemoryState memState;
        if (visitor == null) {
            ContractChecker.$$$reportNull$$$0(0);
        }
        if (instructionState == null) {
            ContractChecker.$$$reportNull$$$0(1);
        }
        if ((memState = instructionState.getMemoryState()).isEphemeral()) {
            DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(visitor, instructionState);
            if (dfaInstructionStateArray == null) {
                ContractChecker.$$$reportNull$$$0(2);
            }
            return dfaInstructionStateArray;
        }
        Instruction instruction = instructionState.getInstruction();
        if (instruction instanceof CheckReturnValueInstruction) {
            PsiExpression anchor = ((CheckReturnValueInstruction)instruction).getReturn();
            DfaValue retValue = memState.pop();
            if (this.breaksContract(retValue, this.myContract.returnValue, memState)) {
                this.myViolations.add(anchor);
            } else {
                this.myNonViolations.add(anchor);
            }
            DfaInstructionState[] dfaInstructionStateArray = InstructionVisitor.nextInstruction(instruction, this, memState);
            if (dfaInstructionStateArray == null) {
                ContractChecker.$$$reportNull$$$0(3);
            }
            return dfaInstructionStateArray;
        }
        if (instruction instanceof ReturnInstruction && ((ReturnInstruction)instruction).isViaException() && this.myContract.returnValue != MethodContract.ValueConstraint.NOT_NULL_VALUE) {
            ContainerUtil.addIfNotNull(this.myFailures, ((ReturnInstruction)instruction).getAnchor());
        }
        if (instruction instanceof MethodCallInstruction && ((MethodCallInstruction)instruction).getMethodType() == MethodCallInstruction.MethodType.REGULAR_METHOD_CALL) {
            if (this.myContract.returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION) {
                ContainerUtil.addIfNotNull(this.myFailures, ((MethodCallInstruction)instruction).getCallExpression());
                if (DfaInstructionState.EMPTY_ARRAY == null) {
                    ContractChecker.$$$reportNull$$$0(4);
                }
                return DfaInstructionState.EMPTY_ARRAY;
            }
            if (ContractChecker.weCannotInferAnythingAboutMethodReturnValue((MethodCallInstruction)instruction)) {
                DfaInstructionState[] dfaInstructionStateArray = this.markEverythingEphemeral(visitor, instructionState);
                if (dfaInstructionStateArray == null) {
                    ContractChecker.$$$reportNull$$$0(5);
                }
                return dfaInstructionStateArray;
            }
        }
        DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(visitor, instructionState);
        if (dfaInstructionStateArray == null) {
            ContractChecker.$$$reportNull$$$0(6);
        }
        return dfaInstructionStateArray;
    }

    private static boolean weCannotInferAnythingAboutMethodReturnValue(MethodCallInstruction instruction) {
        PsiMethod target = instruction.getTargetMethod();
        return instruction.getContracts().isEmpty() && target != null && !target.isConstructor();
    }

    @NotNull
    private DfaInstructionState[] markEverythingEphemeral(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
        DfaInstructionState[] result2;
        if (visitor == null) {
            ContractChecker.$$$reportNull$$$0(7);
        }
        if (instructionState == null) {
            ContractChecker.$$$reportNull$$$0(8);
        }
        for (DfaInstructionState state : result2 = super.acceptInstruction(visitor, instructionState)) {
            state.getMemoryState().markEphemeral();
        }
        if (result2 == null) {
            ContractChecker.$$$reportNull$$$0(9);
        }
        return result2;
    }

    private Map<PsiElement, String> getErrors() {
        HashMap<PsiElement, String> errors = ContainerUtil.newHashMap();
        for (PsiElement element : this.myViolations) {
            if (this.myNonViolations.contains(element)) continue;
            errors.put(element, "Contract clause '" + this.myContract + "' is violated");
        }
        if (this.myContract.returnValue != MethodContract.ValueConstraint.THROW_EXCEPTION) {
            for (PsiElement element : this.myFailures) {
                errors.put(element, "Contract clause '" + this.myContract + "' is violated: exception might be thrown instead of returning " + (Object)((Object)this.myContract.returnValue));
            }
        } else if (this.myFailures.isEmpty() && errors.isEmpty()) {
            PsiIdentifier nameIdentifier = this.myMethod.getNameIdentifier();
            errors.put(nameIdentifier != null ? nameIdentifier : this.myMethod, "Contract clause '" + this.myContract + "' is violated: no exception is thrown");
        }
        return errors;
    }

    private boolean breaksContract(DfaValue retValue, MethodContract.ValueConstraint constraint, DfaMemoryState state) {
        switch (constraint) {
            case NULL_VALUE: {
                return state.isNotNull(retValue);
            }
            case NOT_NULL_VALUE: {
                return state.isNull(retValue);
            }
            case TRUE_VALUE: {
                return ContractChecker.isEquivalentTo(retValue, this.getFactory().getConstFactory().getFalse(), state);
            }
            case FALSE_VALUE: {
                return ContractChecker.isEquivalentTo(retValue, this.getFactory().getConstFactory().getTrue(), state);
            }
            case THROW_EXCEPTION: {
                return true;
            }
        }
        return false;
    }

    private static boolean isEquivalentTo(DfaValue val, DfaConstValue constValue, DfaMemoryState state) {
        return val == constValue || val instanceof DfaVariableValue && constValue == state.getConstantValue((DfaVariableValue)val);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionState";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractChecker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptInstruction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "markEverythingEphemeral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptInstruction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markEverythingEphemeral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

