/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class ControlFlow {
    private final List<Instruction> myInstructions = new ArrayList<Instruction>();
    private final TObjectIntHashMap<PsiElement> myElementToStartOffsetMap = new TObjectIntHashMap();
    private final TObjectIntHashMap<PsiElement> myElementToEndOffsetMap = new TObjectIntHashMap();
    private final DfaValueFactory myFactory;

    public ControlFlow(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    public Instruction[] getInstructions() {
        return this.myInstructions.toArray(new Instruction[0]);
    }

    public int getInstructionCount() {
        return this.myInstructions.size();
    }

    public ControlFlowOffset getNextOffset() {
        final int currentSize = this.myInstructions.size();
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return currentSize;
            }
        };
    }

    public void startElement(PsiElement psiElement) {
        this.myElementToStartOffsetMap.put((Object)psiElement, this.myInstructions.size());
    }

    public void finishElement(PsiElement psiElement) {
        this.myElementToEndOffsetMap.put((Object)psiElement, this.myInstructions.size());
    }

    public void addInstruction(Instruction instruction) {
        instruction.setIndex(this.myInstructions.size());
        this.myInstructions.add(instruction);
    }

    public void removeVariable(@Nullable PsiVariable variable) {
        if (variable == null) {
            return;
        }
        this.addInstruction(new FlushVariableInstruction(this.myFactory.getVarFactory().createVariableValue(variable, false)));
    }

    public Stream<DfaVariableValue> accessedVariables() {
        return ((StreamEx)StreamEx.of(this.myInstructions).select(PushInstruction.class).remove(PushInstruction::isReferenceWrite)).map(PushInstruction::getValue).select(DfaVariableValue.class).distinct();
    }

    public ControlFlowOffset getStartOffset(final PsiElement element) {
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return ControlFlow.this.myElementToStartOffsetMap.get((Object)element);
            }
        };
    }

    public ControlFlowOffset getEndOffset(final PsiElement element) {
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return ControlFlow.this.myElementToEndOffsetMap.get((Object)element);
            }
        };
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        List<Instruction> instructions = this.myInstructions;
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            result2.append(Integer.toString(i)).append(": ").append(instruction.toString());
            result2.append("\n");
        }
        return result2.toString();
    }

    static ControlFlowOffset deltaOffset(final ControlFlowOffset delegate, final int delta) {
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return delegate.getInstructionOffset() + delta;
            }
        };
    }

    public static abstract class ControlFlowOffset {
        public abstract int getInstructionOffset();

        public String toString() {
            return String.valueOf(this.getInstructionOffset());
        }
    }
}

