/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.configurationStore.DefaultStateSerializerKt;
import com.intellij.core.CoreModuleManager;
import com.intellij.mock.MockProject;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.stores.DirectoryStorageUtil;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.JdomKt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class CoreProjectLoader {
    public static boolean loadProject(MockProject project, @NotNull VirtualFile virtualFile) throws IOException, JDOMException {
        VirtualFile ideaDir;
        if (virtualFile == null) {
            CoreProjectLoader.$$$reportNull$$$0(0);
        }
        if ((ideaDir = ProjectKt.getProjectStoreDirectory(virtualFile)) != null) {
            project.setBaseDir(virtualFile);
            CoreProjectLoader.loadDirectoryProject(project, ideaDir);
            return true;
        }
        return false;
    }

    private static void loadDirectoryProject(MockProject project, @NotNull VirtualFile dotIdea) throws IOException, JDOMException {
        VirtualFile libraries;
        VirtualFile modulesXml;
        if (dotIdea == null) {
            CoreProjectLoader.$$$reportNull$$$0(1);
        }
        if ((modulesXml = dotIdea.findChild("modules.xml")) == null) {
            throw new FileNotFoundException("Missing 'modules.xml' in " + dotIdea.getPath());
        }
        Map<String, Element> storageData = CoreProjectLoader.loadStorageFile(project, modulesXml);
        Element moduleManagerState = storageData.get("ProjectModuleManager");
        if (moduleManagerState == null) {
            throw new JDOMException("cannot find ProjectModuleManager state in modules.xml");
        }
        CoreModuleManager moduleManager = (CoreModuleManager)ModuleManager.getInstance(project);
        moduleManager.loadState(moduleManagerState);
        VirtualFile miscXml = dotIdea.findChild("misc.xml");
        if (miscXml != null) {
            storageData = CoreProjectLoader.loadStorageFile(project, miscXml);
            Element projectRootManagerState = storageData.get("ProjectRootManager");
            if (projectRootManagerState == null) {
                throw new JDOMException("cannot find ProjectRootManager state in misc.xml");
            }
            ((ProjectRootManagerImpl)ProjectRootManager.getInstance(project)).loadState(projectRootManagerState);
        }
        if ((libraries = dotIdea.findChild("libraries")) != null) {
            Map<String, Element> data = DirectoryStorageUtil.loadFrom(libraries, PathMacroManager.getInstance(project));
            Element libraryTable = DefaultStateSerializerKt.deserializeState(DirectoryStorageUtil.getCompositeState(data, new ProjectLibraryTable.LibraryStateSplitter()), Element.class, null);
            ((LibraryTableBase)ProjectLibraryTable.getInstance(project)).loadState(libraryTable);
        }
        moduleManager.loadModules();
        project.projectOpened();
    }

    @NotNull
    static Map<String, Element> loadStorageFile(@NotNull ComponentManager componentManager, @NotNull VirtualFile modulesXml) throws JDOMException, IOException {
        if (componentManager == null) {
            CoreProjectLoader.$$$reportNull$$$0(2);
        }
        if (modulesXml == null) {
            CoreProjectLoader.$$$reportNull$$$0(3);
        }
        Map<String, Element> map = FileStorageCoreUtil.load(JdomKt.loadElement(modulesXml.getInputStream()), PathMacroManager.getInstance(componentManager));
        if (map == null) {
            CoreProjectLoader.$$$reportNull$$$0(4);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotIdea";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesXml";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/core/CoreProjectLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/core/CoreProjectLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadStorageFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadDirectoryProject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadStorageFile";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

