/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableRunnable;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WriteCommandAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.command.WriteCommandAction");
    private static final String DEFAULT_COMMAND_NAME = "Undefined";
    private static final String DEFAULT_GROUP_ID = null;
    private final String myCommandName;
    private final String myGroupID;
    private final Project myProject;
    private final PsiFile[] myPsiFiles;

    @NotNull
    public static Builder writeCommandAction(Project project) {
        BuilderImpl builderImpl = new BuilderImpl(project, new PsiFile[0]);
        if (builderImpl == null) {
            WriteCommandAction.$$$reportNull$$$0(0);
        }
        return builderImpl;
    }

    @NotNull
    public static Builder writeCommandAction(@NotNull PsiFile first, PsiFile ... others) {
        if (first == null) {
            WriteCommandAction.$$$reportNull$$$0(1);
        }
        if (others == null) {
            WriteCommandAction.$$$reportNull$$$0(2);
        }
        BuilderImpl builderImpl = new BuilderImpl(first.getProject(), ArrayUtil.prepend(first, others));
        if (builderImpl == null) {
            WriteCommandAction.$$$reportNull$$$0(3);
        }
        return builderImpl;
    }

    protected WriteCommandAction(@Nullable Project project, PsiFile ... files) {
        this(project, DEFAULT_COMMAND_NAME, files);
    }

    protected WriteCommandAction(@Nullable Project project, @Nullable String commandName, PsiFile ... files) {
        this(project, commandName, DEFAULT_GROUP_ID, files);
    }

    protected WriteCommandAction(@Nullable Project project, @Nullable String commandName, @Nullable String groupID, PsiFile ... files) {
        this.myCommandName = commandName;
        this.myGroupID = groupID;
        this.myProject = project;
        if (files == null) {
            LOG.warn("'files' parameter must not be null", new Throwable());
        }
        this.myPsiFiles = files == null || files.length == 0 ? PsiFile.EMPTY_ARRAY : files;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final String getCommandName() {
        return this.myCommandName;
    }

    public String getGroupID() {
        return this.myGroupID;
    }

    @Override
    @NotNull
    public RunResult<T> execute() {
        Application application = ApplicationManager.getApplication();
        boolean dispatchThread = application.isDispatchThread();
        if (!dispatchThread && application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
            throw new IllegalStateException();
        }
        RunResult result2 = new RunResult(this);
        if (dispatchThread) {
            this.performWriteCommandAction(result2);
        } else {
            try {
                TransactionGuard.getInstance().submitTransactionAndWait(() -> this.performWriteCommandAction(result2));
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        RunResult runResult = result2;
        if (runResult == null) {
            WriteCommandAction.$$$reportNull$$$0(4);
        }
        return runResult;
    }

    private void performWriteCommandAction(@NotNull RunResult<T> result2) {
        if (result2 == null) {
            WriteCommandAction.$$$reportNull$$$0(5);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(this.myPsiFiles))) {
            return;
        }
        RunResult[] results = new RunResult[]{result2};
        this.doExecuteCommand(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            results[0].run();
            results[0] = null;
        }));
    }

    protected boolean isGlobalUndoAction() {
        return false;
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
    }

    protected boolean shouldRecordActionForActiveDocument() {
        return true;
    }

    public void performCommand() throws Throwable {
        RunResult[] results = new RunResult[]{new RunResult(this)};
        Ref exception = new Ref();
        this.doExecuteCommand(() -> {
            exception.set(results[0].run().getThrowable());
            results[0] = null;
        });
        Throwable throwable = (Throwable)exception.get();
        if (throwable != null) {
            throw throwable;
        }
    }

    private void doExecuteCommand(Runnable runnable) {
        Runnable wrappedRunnable = () -> {
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.getProject());
            }
            runnable.run();
        };
        CommandProcessor.getInstance().executeCommand(this.getProject(), wrappedRunnable, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy(), this.shouldRecordActionForActiveDocument());
    }

    public static void runWriteCommandAction(Project project, @NotNull Runnable runnable) {
        if (runnable == null) {
            WriteCommandAction.$$$reportNull$$$0(6);
        }
        WriteCommandAction.runWriteCommandAction(project, DEFAULT_COMMAND_NAME, DEFAULT_GROUP_ID, runnable, new PsiFile[0]);
    }

    public static void runWriteCommandAction(Project project, @Nullable String commandName, @Nullable String groupID, final @NotNull Runnable runnable, PsiFile ... files) {
        if (runnable == null) {
            WriteCommandAction.$$$reportNull$$$0(7);
        }
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(8);
        }
        new Simple(project, commandName, groupID, files){

            @Override
            protected void run() throws Throwable {
                runnable.run();
            }
        }.execute();
    }

    public static <T> T runWriteCommandAction(Project project, final @NotNull Computable<T> computable) {
        if (computable == null) {
            WriteCommandAction.$$$reportNull$$$0(9);
        }
        return new WriteCommandAction<T>(project, new PsiFile[0]){

            @Override
            protected void run(@NotNull Result<T> result2) throws Throwable {
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                result2.setResult(computable.compute());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$2", "run"));
            }
        }.execute().getResultObject();
    }

    public static <T, E extends Throwable> T runWriteCommandAction(Project project, final @NotNull ThrowableComputable<T, E> computable) throws E {
        RunResult<T> result2;
        Throwable t;
        if (computable == null) {
            WriteCommandAction.$$$reportNull$$$0(10);
        }
        if ((t = (result2 = new WriteCommandAction<T>(project, "", new PsiFile[0]){

            @Override
            protected void run(@NotNull Result<T> result2) throws Throwable {
                if (result2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                result2.setResult(computable.compute());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$3", "run"));
            }
        }.execute()).getThrowable()) != null) {
            Throwable e = t;
            throw e;
        }
        return result2.throwException().getResultObject();
    }

    public static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<PsiFile> psiFiles) {
        if (project == null) {
            WriteCommandAction.$$$reportNull$$$0(11);
        }
        if (psiFiles == null) {
            WriteCommandAction.$$$reportNull$$$0(12);
        }
        return FileModificationService.getInstance().preparePsiElementsForWrite(psiFiles);
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_GROUP_ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/WriteCommandAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "others";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "writeCommandAction";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/WriteCommandAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeCommandAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performWriteCommandAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWriteCommandAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Simple<T>
    extends WriteCommandAction<T> {
        protected Simple(Project project, PsiFile ... files) {
            super(project, files);
        }

        protected Simple(Project project, String commandName, PsiFile ... files) {
            super(project, commandName, files);
        }

        protected Simple(Project project, String name, String groupID, PsiFile ... files) {
            super(project, name, groupID, files);
        }

        @Override
        protected void run(@NotNull Result<T> result2) throws Throwable {
            if (result2 == null) {
                Simple.$$$reportNull$$$0(0);
            }
            this.run();
        }

        protected abstract void run() throws Throwable;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$Simple", "run"));
        }
    }

    private static class BuilderImpl
    implements Builder {
        private final Project myProject;
        private final PsiFile[] myFiles;
        private String myCommandName = "Undefined";
        private String myGroupId = WriteCommandAction.access$000();

        private BuilderImpl(Project project, PsiFile ... files) {
            this.myProject = project;
            this.myFiles = files;
        }

        @Override
        @NotNull
        public Builder withName(String name) {
            this.myCommandName = name;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(0);
            }
            return builderImpl;
        }

        @Override
        @NotNull
        public Builder withGroupId(String groupId) {
            this.myGroupId = groupId;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(1);
            }
            return builderImpl;
        }

        @Override
        public <E extends Throwable> void run(final @NotNull ThrowableRunnable<E> action) throws E {
            if (action == null) {
                BuilderImpl.$$$reportNull$$$0(2);
            }
            new WriteCommandAction(this.myProject, this.myCommandName, this.myGroupId, this.myFiles){

                @Override
                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    action.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl$1", "run"));
                }
            }.execute();
        }

        @Override
        public <R, E extends Throwable> R compute(final @NotNull ThrowableComputable<R, E> action) throws E {
            if (action == null) {
                BuilderImpl.$$$reportNull$$$0(3);
            }
            return (R)new WriteCommandAction<R>(this.myProject, this.myCommandName, this.myGroupId, this.myFiles){

                @Override
                protected void run(@NotNull Result<R> result2) throws Throwable {
                    if (result2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    result2.setResult(action.compute());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl$2", "run"));
                }
            }.execute().getResultObject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/command/WriteCommandAction$BuilderImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withGroupId";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/command/WriteCommandAction$BuilderImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Builder {
        @NotNull
        public Builder withName(@Nullable String var1);

        @NotNull
        public Builder withGroupId(@Nullable String var1);

        public <E extends Throwable> void run(@NotNull ThrowableRunnable<E> var1) throws E;

        public <R, E extends Throwable> R compute(@NotNull ThrowableComputable<R, E> var1) throws E;
    }
}

