/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.Pluralizer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.StringFactory;
import com.intellij.util.text.StringTokenizer;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    @NonNls
    private static final String VOWELS = "aeiouy";
    @NonNls
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    @NonNls
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    private static final MyHtml2Text html2TextParser = new MyHtml2Text();
    public static final NotNullFunction<String, String> QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "\"" + s + "\"";
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$1", "fun"));
        }
    };
    public static final NotNullFunction<String, String> SINGLE_QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "'" + s + "'";
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$2", "fun"));
        }
    };
    @NotNull
    public static final Function<String, String> TRIMMER = new Function<String, String>(){

        @Override
        @Nullable
        public String fun(@Nullable String s) {
            return StringUtil.trim(s);
        }
    };
    @NonNls
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    @NonNls
    private static final List<String> REPLACES_REFS = Arrays.asList("&lt;", "&gt;", "&amp;", "&#39;", "&quot;");
    @NonNls
    private static final List<String> REPLACES_DISP = Arrays.asList("<", ">", "&", "'", "\"");
    @NonNls
    private static final List<String> MN_QUOTED = Arrays.asList("&&", "__");
    @NonNls
    private static final List<String> MN_CHARS = Arrays.asList("&", "_");
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-eA-E]{4}");

    @NotNull
    public static MergingCharSequence replaceSubSequence(@NotNull CharSequence charSeq, int start, int end, @NotNull CharSequence replacement) {
        if (charSeq == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        MergingCharSequence mergingCharSequence = new MergingCharSequence(new MergingCharSequence(charSeq.subSequence(0, start), replacement), charSeq.subSequence(end, charSeq.length()));
        if (mergingCharSequence == null) {
            StringUtil.$$$reportNull$$$0(2);
        }
        return mergingCharSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsInStringLongestFirst(@NotNull String find) {
        if (find == null) {
            StringUtil.$$$reportNull$$$0(3);
        }
        List<String> words = StringUtil.getWordsIn(find);
        Collections.sort(words, new Comparator<String>(){

            @Override
            public int compare(@NotNull String o1, @NotNull String o2) {
                if (o1 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (o2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return o2.length() - o1.length();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "o1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "o2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/util/text/StringUtil$3";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        List<String> list = words;
        if (list == null) {
            StringUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapePattern(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(5);
        }
        String string = StringUtil.replace(StringUtil.replace(text2, "'", "''"), "{", "'{'");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Function<T, String> createToStringFunction(@NotNull Class<T> cls) {
        if (cls == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        Function function = new Function<T, String>(){

            @Override
            public String fun(@NotNull T o) {
                if (o == null) {
                    4.$$$reportNull$$$0(0);
                }
                return o.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/util/text/StringUtil$4", "fun"));
            }
        };
        if (function == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        return function;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NonNls @NotNull String text2, @NonNls @NotNull String oldS, @NonNls @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        String string = StringUtil.replace(text2, oldS, newS, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceIgnoreCase(@NonNls @NotNull String text2, @NonNls @NotNull String oldS, @NonNls @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(13);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(14);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(15);
        }
        String string = StringUtil.replace(text2, oldS, newS, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        String string = buffer.replace(oldChar, newChar);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Contract(pure=true)
    public static String replace(@NonNls @NotNull String text2, @NonNls @NotNull String oldS, @NonNls @NotNull String newS, boolean ignoreCase) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        if (text2.length() < oldS.length()) {
            return text2;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text2.length()) {
            int index;
            int n = index = ignoreCase ? StringUtil.indexOfIgnoreCase(text2, oldS, i) : text2.indexOf(oldS, i);
            if (index < 0) {
                if (i == 0) {
                    return text2;
                }
                newText.append(text2, i, text2.length());
                break;
            }
            if (newText == null) {
                if (text2.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text2.length() - i);
            }
            newText.append(text2, i, index);
            newText.append(newS);
            i = index + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(24);
        }
        int sourceCount = where.length();
        for (int i = Math.max(fromIndex, 0); i < sourceCount; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(25);
        }
        for (int i = Math.min(fromIndex, where.length() - 1); i >= 0; --i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(26);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(27);
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String suffix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, boolean convertBreaks) {
        if (html == null) {
            StringUtil.$$$reportNull$$$0(32);
        }
        if (convertBreaks) {
            html = html.replaceAll("<br/?>", "\n\n");
        }
        String string = html.replaceAll("<(.|\n)*?>", "");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase();
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(34);
        }
        String string = StringUtil.getPackageName(fqName, '.');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName, char separator) {
        int lastPointIdx;
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(36);
        }
        if ((lastPointIdx = fqName.lastIndexOf(separator)) >= 0) {
            String string = fqName.substring(0, lastPointIdx);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(37);
            }
            return string;
        }
        if ("" == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(39);
        }
        int count = 0;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text2.length() && text2.charAt(i + 1) == '\n') {
                ++i;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(40);
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeLineBreak(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(41);
        }
        StringBuilder buffer = new StringBuilder(text2.length());
        block4: for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(43);
        }
        return (len = text2.length()) > 0 && StringUtil.isLineBreak(text2.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int lineColToOffset(@NotNull CharSequence text2, int line, int col) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(44);
        }
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text2.length()) {
                return -1;
            }
            char c = text2.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text2.length() - 1 && text2.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text2, int offset) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(45);
        }
        int curLine = 0;
        for (int curOffset = 0; curOffset < offset; ++curOffset) {
            if (curOffset == text2.length()) {
                return -1;
            }
            char c = text2.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset >= text2.length() - 1 || text2.charAt(curOffset + 1) != '\n') continue;
            ++curOffset;
        }
        return curLine;
    }

    @Contract(pure=true)
    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(46);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(47);
        }
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(48);
        }
        String string = StringUtil.fixCapitalization(s, ourPrepositions, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromLowerCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(50);
        }
        String string = StringUtil.fixCapitalization(s, ourPrepositions, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String toTitleCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(52);
        }
        String string = StringUtil.fixCapitalization(s, ArrayUtil.EMPTY_STRING_ARRAY, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    @NotNull
    private static String fixCapitalization(@NotNull String s, @NotNull String[] prepositions, boolean title) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(54);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(55);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < s.length(); ++i) {
            int j;
            char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char currChar = s.charAt(i);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title && !Character.isUpperCase(currChar)) continue;
            for (j = i; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
            }
            if (!title && j > i + 1 && !Character.isLowerCase(s.charAt(i + 1)) || StringUtil.isPreposition(s, i, j - 1, prepositions)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(i, title ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        String string = buffer == null ? s : buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(56);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(57);
        }
        return StringUtil.isPreposition(s, firstChar, lastChar, ourPrepositions);
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, @NotNull String[] prepositions) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(58);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(59);
        }
        for (String preposition : prepositions) {
            boolean found = false;
            if (lastChar - firstChar + 1 == preposition.length()) {
                found = true;
                for (int j = 0; j < preposition.length(); ++j) {
                    if (StringUtil.toLowerCase(s.charAt(firstChar + j)) == preposition.charAt(j)) continue;
                    found = false;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static NotNullFunction<String, String> escaper(final boolean escapeSlash, final @Nullable String additionalChars) {
        NotNullFunction<String, String> notNullFunction = new NotNullFunction<String, String>(){

            @Override
            @NotNull
            public String fun(@NotNull String dom) {
                if (dom == null) {
                    6.$$$reportNull$$$0(0);
                }
                StringBuilder builder = new StringBuilder(dom.length());
                StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder);
                String string = builder.toString();
                if (string == null) {
                    6.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dom";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fun";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fun";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (notNullFunction == null) {
            StringUtil.$$$reportNull$$$0(60);
        }
        return notNullFunction;
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(61);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(62);
        }
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        CharSequence hexCode = StringUtilRt.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(72);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(74);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(75);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(76);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(77);
        }
        return string;
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        char ch;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(78);
        }
        return (ch = s.charAt(ind)) == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        return s.length() > 1 && StringUtil.isQuoteAt(s, 0) && s.charAt(0) == s.charAt(s.length() - 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(80);
        }
        if (StringUtil.isQuotedString(s)) {
            String string = s.substring(1, s.length() - 1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(81);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(82);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(83);
        }
        if (s.length() > 1 && quotationChar == s.charAt(0) && quotationChar == s.charAt(s.length() - 1)) {
            String string = s.substring(1, s.length() - 1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(84);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(85);
        }
        return string;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(86);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(87);
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String word) {
        String plural;
        if (word == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        if ((plural = Pluralizer.PLURALIZER.plural(word)) != null) {
            String string = plural;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(89);
            }
            return string;
        }
        if (word.endsWith("s")) {
            String string = Pluralizer.restoreCase(word, word + "es");
            if (string == null) {
                StringUtil.$$$reportNull$$$0(90);
            }
            return string;
        }
        String string = Pluralizer.restoreCase(word, word + "s");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(91);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text2, boolean allWords) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(92);
        }
        String string = StringUtil.capitalizeWords(text2, " \t\n\r\f", allWords, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(93);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text2, @NotNull String tokenizerDelim, boolean allWords, boolean leaveOriginalDelims) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(94);
        }
        if (tokenizerDelim == null) {
            StringUtil.$$$reportNull$$$0(95);
        }
        java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(text2, tokenizerDelim, leaveOriginalDelims);
        StringBuilder out = new StringBuilder(text2.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelims && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        String string = out.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(96);
        }
        return string;
    }

    @Contract(pure=true)
    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    @Contract(pure=true)
    public static boolean isVowel(char c) {
        return VOWELS.indexOf(c) >= 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(97);
        }
        if (s.isEmpty()) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(98);
            }
            return string;
        }
        if (s.length() == 1) {
            String string = StringUtilRt.toUpperCase(s).toString();
            if (string == null) {
                StringUtil.$$$reportNull$$$0(99);
            }
            return string;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(100);
            }
            return string;
        }
        String string = StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(101);
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return s != null && !s.isEmpty() && Character.isUpperCase(s.charAt(0));
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(102);
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(103);
            }
            return string;
        }
        String string = StringUtil.capitalize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(104);
        }
        return string;
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(105);
        }
        if (chars instanceof String || chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(106);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull char[] chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(107);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars[off]);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(108);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(109);
        }
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull char[] chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(110);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars[off];
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(111);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars.charAt(off);
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(112);
        }
        return StringUtil.stringHashCodeIgnoreWhitespaces(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string, String ... prefixes) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(113);
        }
        if (prefixes == null) {
            StringUtil.$$$reportNull$$$0(114);
        }
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(115);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(116);
        }
        String string = StringUtil.trimEnd(s, suffix, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(117);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(118);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(119);
        }
        boolean bl = endsWith = ignoreCase ? StringUtil.endsWithIgnoreCase(s, suffix) : s.endsWith(suffix);
        if (endsWith) {
            String string = s.substring(0, s.length() - suffix.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(120);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(121);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(122);
        }
        if (StringUtil.endsWithChar(s, suffix)) {
            String string = s.substring(0, s.length() - 1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(123);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(124);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLog(@NotNull String text2, int limit) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(125);
        }
        if (limit > 5 && text2.length() > limit) {
            String string = text2.substring(0, limit - 5) + " ...\n";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(126);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(127);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(128);
        }
        String string2 = StringUtil.trimLeading((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(129);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimLeading(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(130);
        }
        for (index = 0; index < string.length() && Character.isWhitespace(string.charAt(index)); ++index) {
        }
        CharSequence charSequence = string.subSequence(index, string.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(131);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(132);
        }
        for (index = 0; index < string.length() && string.charAt(index) == symbol; ++index) {
        }
        String string2 = string.substring(index);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(133);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder trimLeading(@NotNull StringBuilder builder, char symbol) {
        int index;
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(134);
        }
        for (index = 0; index < builder.length() && builder.charAt(index) == symbol; ++index) {
        }
        if (index > 0) {
            builder.delete(0, index);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(135);
        }
        return stringBuilder;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(136);
        }
        String string2 = StringUtil.trimTrailing((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(137);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimTrailing(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(138);
        }
        for (index = string.length() - 1; index >= 0 && Character.isWhitespace(string.charAt(index)); --index) {
        }
        CharSequence charSequence = string.subSequence(0, index + 1);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(139);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(140);
        }
        for (index = string.length() - 1; index >= 0 && string.charAt(index) == symbol; --index) {
        }
        String string2 = string.substring(0, index + 1);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(141);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder trimTrailing(@NotNull StringBuilder builder, char symbol) {
        int index;
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(142);
        }
        for (index = builder.length() - 1; index >= 0 && builder.charAt(index) == symbol; --index) {
        }
        builder.setLength(index + 1);
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(143);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimStart(@NotNull String s, @NonNls @NotNull String prefix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(144);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        if (s.startsWith(prefix)) {
            String string = s.substring(prefix.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(146);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimExtensions(@NotNull String name) {
        int index;
        if (name == null) {
            StringUtil.$$$reportNull$$$0(148);
        }
        String string = (index = name.indexOf(46)) < 0 ? name : name.substring(0, index);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(149);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String base, int n) {
        if (base == null) {
            StringUtil.$$$reportNull$$$0(150);
        }
        if (n == 1) {
            String string = base;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(151);
            }
            return string;
        }
        String string = StringUtil.pluralize(base);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(152);
        }
        return string;
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(153);
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value, String defaultValue) {
        return StringUtil.isEmpty(value) ? defaultValue : value;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return !StringUtil.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @Contract(pure=true)
    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        String string = StringUtil.notNullize(s, "");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(154);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(155);
        }
        String string = s == null ? defaultValue : s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(156);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s) {
        return StringUtil.nullize(s, false);
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        if (nullizeSpaces ? StringUtil.isEmptyOrSpaces(s) : StringUtil.isEmpty(s)) {
            return null;
        }
        return s;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        if (StringUtil.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(157);
        }
        String string = ExceptionUtil.getThrowableText(aThrowable);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(158);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable, @NonNls @NotNull String stackFrameSkipPattern) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(159);
        }
        if (stackFrameSkipPattern == null) {
            StringUtil.$$$reportNull$$$0(160);
        }
        String string = ExceptionUtil.getThrowableText(aThrowable, stackFrameSkipPattern);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(161);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            StringUtil.$$$reportNull$$$0(162);
        }
        return ExceptionUtil.getMessage(e);
    }

    @NotNull
    @Contract(pure=true)
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        String string = StringFactory.createShared(buffer);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(163);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String repeat(@NotNull String s, int count) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(164);
        }
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(165);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(166);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(s.length());
        boolean inQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separator && !inQuotes) {
                if (builder.length() <= 0) continue;
                result2.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i > 0 && s.charAt(i - 1) == '\\')) {
                inQuotes = !inQuotes;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result2.add(builder.toString());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(167);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(168);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(169);
        }
        List<String> list = StringUtil.split(s, separator, true);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(170);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(171);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(172);
        }
        List<CharSequence> list = StringUtil.split(s, separator, true, true);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(173);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(174);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(175);
        }
        List<String> list = StringUtil.split(s, separator, excludeSeparator, true);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(176);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(177);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(178);
        }
        List<CharSequence> list = StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(179);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(180);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(181);
        }
        if (separator.length() == 0) {
            List<CharSequence> list = Collections.singletonList(s);
            if (list == null) {
                StringUtil.$$$reportNull$$$0(182);
            }
            return list;
        }
        ArrayList<CharSequence> result2 = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result2.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result2.add(s.subSequence(pos, s.length()));
        }
        ArrayList<CharSequence> arrayList = result2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(183);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(184);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(185);
        }
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator<String> iterator = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    7.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$7", "iterator"));
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(186);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(final @NotNull java.util.StringTokenizer tokenizer) {
        if (tokenizer == null) {
            StringUtil.$$$reportNull$$$0(187);
        }
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator<String> iterator = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    8.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$8", "iterator"));
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(188);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsIn(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(189);
        }
        SmartList<String> result2 = null;
        int start = -1;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text2.length() - 1 && start != -1) {
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(text2.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            if (result2 == null) {
                result2 = new SmartList<String>();
            }
            result2.add(text2.substring(start, i));
            start = -1;
        }
        if (result2 == null) {
            List<String> list = ContainerUtil.emptyList();
            if (list == null) {
                StringUtil.$$$reportNull$$$0(190);
            }
            return list;
        }
        SmartList<String> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(191);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static List<TextRange> getWordIndicesIn(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(192);
        }
        List<TextRange> list = StringUtil.getWordIndicesIn(text2, null);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(193);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<TextRange> getWordIndicesIn(@NotNull String text2, @Nullable Set<Character> separatorsSet) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(194);
        }
        SmartList<TextRange> result2 = new SmartList<TextRange>();
        int start = -1;
        for (int i = 0; i < text2.length(); ++i) {
            boolean isIdentifierPart;
            char c = text2.charAt(i);
            boolean bl = separatorsSet == null ? Character.isJavaIdentifierPart(c) : (isIdentifierPart = !separatorsSet.contains(Character.valueOf(c)));
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text2.length() - 1 && start != -1) {
                result2.add(new TextRange(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result2.add(new TextRange(start, i));
            start = -1;
        }
        SmartList<TextRange> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(195);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(196);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(197);
        }
        String string = StringUtil.join(strings, 0, strings.length, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(198);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, int startIndex, int endIndex, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(199);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(200);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result2.append(separator);
            }
            result2.append(strings[i]);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(201);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] zip(@NotNull String[] strings1, @NotNull String[] strings2, String separator) {
        if (strings1 == null) {
            StringUtil.$$$reportNull$$$0(202);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(203);
        }
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result2 = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = strings1[i] + separator + strings2[i];
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(204);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] surround(@NotNull String[] strings1, String prefix, String suffix) {
        if (strings1 == null) {
            StringUtil.$$$reportNull$$$0(205);
        }
        String[] result2 = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = prefix + strings1[i] + suffix;
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(206);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull T[] items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(207);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(208);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(209);
        }
        String string = StringUtil.join(Arrays.asList(items), f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(210);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(211);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(212);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(213);
        }
        if (items.isEmpty()) {
            if ("" == null) {
                StringUtil.$$$reportNull$$$0(214);
            }
            return "";
        }
        if (items.size() == 1) {
            String string = StringUtil.notNullize(f.fun(items.iterator().next()));
            if (string == null) {
                StringUtil.$$$reportNull$$$0(215);
            }
            return string;
        }
        String string = StringUtil.join(items, f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(216);
        }
        return string;
    }

    @Contract(pure=true)
    public static String join(@NotNull Iterable<?> items, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(217);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(218);
        }
        StringBuilder result2 = new StringBuilder();
        for (Object item : items) {
            result2.append(item).append(separator);
        }
        if (result2.length() > 0) {
            result2.setLength(result2.length() - separator.length());
        }
        return result2.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(219);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(220);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(221);
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(items, f, separator, result2);
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(222);
        }
        return string;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator, @NotNull StringBuilder result2) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(223);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(224);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(225);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(226);
        }
        boolean isFirst = true;
        for (T item : items) {
            String string = f.fun(item);
            if (string == null || string.isEmpty()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(227);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(228);
        }
        if (strings.size() <= 1) {
            String string = StringUtil.notNullize(ContainerUtil.getFirstItem(strings));
            if (string == null) {
                StringUtil.$$$reportNull$$$0(229);
            }
            return string;
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(strings, separator, result2);
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(230);
        }
        return string;
    }

    public static void join(@NotNull Collection<String> strings, @NotNull String separator, @NotNull StringBuilder result2) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(231);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(232);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(233);
        }
        boolean isFirst = true;
        for (String string : strings) {
            if (string == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull int[] strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(234);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(235);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                result2.append(separator);
            }
            result2.append(strings[i]);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(236);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(String ... strings) {
        if (strings == null || strings.length == 0) {
            if ("" == null) {
                StringUtil.$$$reportNull$$$0(237);
            }
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            builder.append(string);
        }
        String string = builder.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(238);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String stripQuotesAroundValue(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(239);
        }
        if ((len = text2.length()) > 0) {
            int to;
            int from = StringUtil.isQuoteAt(text2, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text2, len - 1) ? len - 1 : len;
            if (from > 0 || to < len) {
                String string = text2.substring(from, to);
                if (string == null) {
                    StringUtil.$$$reportNull$$$0(240);
                }
                return string;
            }
        }
        String string = text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(241);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize) {
        String string = StringUtil.formatFileSize(fileSize, null);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(242);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize, String spaceBeforeUnits) {
        String string = StringUtil.formatValue(fileSize, null, new String[]{"B", "K", "M", "G", "T", "P", "E"}, new long[]{1000L, 1000L, 1000L, 1000L, 1000L, 1000L}, spaceBeforeUnits);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(243);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatDuration(long duration) {
        String string = StringUtil.formatDuration(duration, null);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(244);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatDuration(long duration, String spaceBeforeUnits) {
        String string = StringUtil.formatValue(duration, " ", new String[]{"ms", "s", "m", "h", "d", "w", "mo", "yr", "c", "ml", "ep"}, new long[]{1000L, 60L, 60L, 24L, 7L, 4L, 12L, 100L, 10L, 10000L}, spaceBeforeUnits);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(245);
        }
        return string;
    }

    @NotNull
    private static String formatValue(long value, String partSeparator, String[] units, long[] multipliers, String spaceBeforeUnits) {
        int i;
        StringBuilder sb = new StringBuilder();
        long count = value;
        long remainder = 0L;
        for (i = 0; i < units.length; ++i) {
            long multiplier;
            long l = multiplier = i < multipliers.length ? multipliers[i] : -1L;
            if (multiplier == -1L || count < multiplier) break;
            remainder = count % multiplier;
            count /= multiplier;
            if (partSeparator == null || remainder == 0L && sb.length() <= 0) continue;
            sb.insert(0, units[i]);
            if (spaceBeforeUnits != null) {
                sb.insert(0, spaceBeforeUnits);
            }
            sb.insert(0, remainder).insert(0, partSeparator);
        }
        if (partSeparator != null || remainder == 0L) {
            sb.insert(0, units[i]);
            if (spaceBeforeUnits != null) {
                sb.insert(0, spaceBeforeUnits);
            }
            sb.insert(0, count);
        } else if (remainder > 0L) {
            sb.append(String.format(Locale.US, "%.2f", (double)count + (double)remainder / (double)multipliers[i - 1]));
            if (spaceBeforeUnits != null) {
                sb.append(spaceBeforeUnits);
            }
            sb.append(units[i]);
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(246);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String unpluralize(@NotNull String word) {
        String singular;
        if (word == null) {
            StringUtil.$$$reportNull$$$0(247);
        }
        if ((singular = Pluralizer.PLURALIZER.singular(word)) != null) {
            return singular;
        }
        if (word.endsWith("es")) {
            return StringUtil.nullize(StringUtil.trimEnd(word, "es", true));
        }
        if (word.endsWith("s")) {
            return StringUtil.nullize(StringUtil.trimEnd(word, "s", true));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean containsAlphaCharacters(@NotNull String value) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(248);
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(249);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(250);
        }
        return chars.length() > value.length() ? StringUtil.containsAnyChar(value, chars, 0, value.length()) : StringUtil.containsAnyChar(chars, value, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(251);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(252);
        }
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(253);
        }
        return value.indexOf(ch) >= 0;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String firstLetterToUpperCase(@Nullable String displayString) {
        if (displayString == null || displayString.isEmpty()) {
            return displayString;
        }
        char firstChar = displayString.charAt(0);
        char uppedFirstChar = StringUtil.toUpperCase(firstChar);
        if (uppedFirstChar == firstChar) {
            return displayString;
        }
        char[] buffer = displayString.toCharArray();
        buffer[0] = uppedFirstChar;
        return StringFactory.createShared(buffer);
    }

    @NotNull
    @Contract(pure=true)
    public static String strip(@NotNull String s, @NotNull CharFilter filter) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(254);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(255);
        }
        StringBuilder result2 = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result2.append(ch);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(256);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(257);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(258);
        }
        List<String> list = StringUtil.findMatches(s, pattern, 1);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(259);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern, int groupIndex) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(260);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(261);
        }
        SmartList<String> result2 = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result2.add(group);
        }
        SmartList<String> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(262);
        }
        return smartList;
    }

    @Contract(pure=true)
    public static int findFirst(@NotNull CharSequence s, @NotNull CharFilter filter) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(263);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(264);
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceSubstring(@NotNull String string, @NotNull TextRange range, @NotNull String replacement) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(265);
        }
        if (range == null) {
            StringUtil.$$$reportNull$$$0(266);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(267);
        }
        String string2 = range.replace(string, replacement);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(268);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWithWhitespace(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(269);
        }
        return !text2.isEmpty() && Character.isWhitespace(text2.charAt(0));
    }

    @Contract(pure=true)
    public static boolean isChar(CharSequence seq, int index, char c) {
        return index >= 0 && index < seq.length() && seq.charAt(index) == c;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(270);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(271);
        }
        if ((l1 = text2.length()) < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text2.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, int startIndex, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(272);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(273);
        }
        if ((l1 = text2.length() - startIndex) < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text2.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text2, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(274);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(275);
        }
        if ((l1 = text2.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text2.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(276);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(277);
        }
        String string = s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(278);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(279);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(280);
        }
        return StringUtil.commonPrefixLength(s1, s2, false);
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2, boolean ignoreCase) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(281);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(282);
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && StringUtil.charsMatch(s1.charAt(i), s2.charAt(i), ignoreCase); ++i) {
        }
        return i;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(283);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(284);
        }
        String string = s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(285);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(286);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(287);
        }
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(288);
        }
        return StringUtil.indexOf(s, c, start, end) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(289);
        }
        return StringUtil.indexOf(s, c, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(290);
        }
        return StringUtil.indexOf(s, c, start, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(291);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(292);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(293);
        }
        return StringUtil.indexOf(sequence, infix) >= 0;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(294);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(295);
        }
        return StringUtil.indexOf(sequence, infix, 0);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(296);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(297);
        }
        return StringUtil.indexOf(sequence, infix, start, sequence.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start, int end) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(298);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(299);
        }
        for (int i = start; i <= end - infix.length(); ++i) {
            if (!StringUtil.startsWith(sequence, i, infix)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(300);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.charsMatch(s.charAt(i), c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull char[] s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(301);
        }
        end = Math.min(end, s.length);
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.charsMatch(s[i], c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfSubstringEnd(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(302);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(303);
        }
        if ((i = text2.indexOf(subString)) == -1) {
            return -1;
        }
        return i + subString.length();
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(304);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(305);
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(306);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(307);
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(308);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(309);
        }
        return StringUtil.indexOfAny((CharSequence)s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(310);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(311);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(312);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(313);
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    @Contract(pure=true)
    public static String substringBefore(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(314);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(315);
        }
        if ((i = text2.indexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(0, i);
    }

    @NotNull
    @Contract(pure=true)
    public static String substringBeforeLast(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(316);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(317);
        }
        if ((i = text2.lastIndexOf(subString)) == -1) {
            String string = text2;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(318);
            }
            return string;
        }
        String string = text2.substring(0, i);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(319);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String substringAfter(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(320);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(321);
        }
        if ((i = text2.indexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(i + subString.length());
    }

    @Nullable
    @Contract(pure=true)
    public static String substringAfterLast(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(322);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(323);
        }
        if ((i = text2.lastIndexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(i + subString.length());
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(324);
        }
        return StringUtilRt.lastIndexOf(s, c, start, end);
    }

    @NotNull
    @Contract(pure=true)
    public static String first(@NotNull String text2, int maxLength, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(325);
        }
        String string = text2.length() > maxLength ? text2.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(326);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence first(@NotNull CharSequence text2, int length, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(327);
        }
        CharSequence charSequence = text2.length() > length ? text2.subSequence(0, length) + (appendEllipsis ? "..." : "") : text2;
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(328);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence last(@NotNull CharSequence text2, int length, boolean prependEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(329);
        }
        CharSequence charSequence = text2.length() > length ? (prependEllipsis ? "..." : "") + text2.subSequence(text2.length() - length, text2.length()) : text2;
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(330);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String firstLast(@NotNull String text2, int length) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(331);
        }
        String string = text2.length() > length ? text2.subSequence(0, length / 2) + "\u2026" + text2.subSequence(text2.length() - length / 2 - 1, text2.length()) : text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(332);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChar(@NotNull String str, char character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(333);
        }
        String string = StringUtil.escapeChars(str, character);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(334);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChars(@NotNull String str, char ... character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(335);
        }
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            StringUtil.escapeChar(buf, c);
        }
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(336);
        }
        return string;
    }

    public static void escapeChar(@NotNull StringBuilder buf, char character) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(337);
        }
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(338);
        }
        String string = StringUtil.escapeChar(str, '\"');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(339);
        }
        return string;
    }

    public static void escapeQuotes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(340);
        }
        StringUtil.escapeChar(buf, '\"');
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(341);
        }
        String string = StringUtil.escapeChar(str, '/');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(342);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(343);
        }
        String string = StringUtil.escapeChar(str, '\\');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(344);
        }
        return string;
    }

    public static void escapeSlashes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(345);
        }
        StringUtil.escapeChar(buf, '/');
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(346);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '/');
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(347);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(348);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(349);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeChar(@NotNull String str, char unescapeChar) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(350);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(351);
        }
        return string;
    }

    private static void unescapeChar(@NotNull StringBuilder buf, @NotNull String str, char unescapeChar) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(352);
        }
        if (str == null) {
            StringUtil.$$$reportNull$$$0(353);
        }
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(@NotNull StringBuilder builder) {
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(354);
        }
        StringUtil.quote(builder, '\"');
    }

    public static void quote(@NotNull StringBuilder builder, char quotingChar) {
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(355);
        }
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    @NotNull
    @Contract(pure=true)
    public static String wrapWithDoubleQuote(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(356);
        }
        String string = '\"' + str + "\"";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(357);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescapeXml(@Nullable String text2) {
        return text2 == null ? null : StringUtil.replace(text2, REPLACES_REFS, REPLACES_DISP);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text2) {
        return text2 == null ? null : StringUtil.replace(text2, REPLACES_DISP, REPLACES_REFS);
    }

    public static String removeHtmlTags(@Nullable String htmlString) {
        if (StringUtil.isEmpty(htmlString)) {
            return htmlString;
        }
        try {
            html2TextParser.parse(new StringReader(htmlString));
        }
        catch (IOException e) {
            LOG.error(e);
        }
        return html2TextParser.getText();
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeMnemonics(@Nullable String text2) {
        return text2 == null ? null : StringUtil.replace(text2, MN_CHARS, MN_QUOTED);
    }

    @NotNull
    @Contract(pure=true)
    public static String htmlEmphasize(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(358);
        }
        String string = "<b><code>" + StringUtil.escapeXml(text2) + "</code></b>";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(359);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeToRegexp(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(360);
        }
        StringBuilder result2 = new StringBuilder(text2.length());
        String string = StringUtil.escapeToRegexp(text2, result2).toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(361);
        }
        return string;
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text2, @NotNull StringBuilder builder) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(362);
        }
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(363);
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            builder.append('\\').append(c);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(364);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull char[] chars, int startOffset, int backslashOffset) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(365);
        }
        if (chars[backslashOffset] != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = chars[i] == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull CharSequence text2, int startOffset, int backslashOffset) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(366);
        }
        if (text2.charAt(backslashOffset) != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = text2.charAt(i) == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull String[] from, @NotNull String[] to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(367);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(368);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(369);
        }
        String string = StringUtil.replace(text2, Arrays.asList(from), Arrays.asList(to));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(370);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull List<String> from, @NotNull List<String> to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(371);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(372);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(373);
        }
        assert (from.size() == to.size());
        StringBuilder result2 = null;
        block0: for (int i = 0; i < text2.length(); ++i) {
            for (int j = 0; j < from.size(); ++j) {
                String toReplace = from.get(j);
                String replaceWith = to.get(j);
                int len = toReplace.length();
                if (!text2.regionMatches(i, toReplace, 0, len)) continue;
                if (result2 == null) {
                    result2 = new StringBuilder(text2.length());
                    result2.append(text2, 0, i);
                }
                result2.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            if (result2 == null) continue;
            result2.append(text2.charAt(i));
        }
        String string = result2 == null ? text2 : result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(374);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] filterEmptyStrings(@NotNull String[] strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(375);
        }
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && !string.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            if (strings == null) {
                StringUtil.$$$reportNull$$$0(376);
            }
            return strings;
        }
        String[] result2 = ArrayUtil.newStringArray(strings.length - emptyCount);
        int count = 0;
        for (String string : strings) {
            if (string == null || string.isEmpty()) continue;
            result2[count++] = string;
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(377);
        }
        return result2;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(378);
        }
        return StringUtil.countChars(text2, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(379);
        }
        return StringUtil.countChars(text2, c, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int offset, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(380);
        }
        return StringUtil.countChars(text2, c, offset, text2.length(), stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int start, int end, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(381);
        }
        int count = 0;
        int len = Math.min(text2.length(), end);
        for (int i = start; i < len; ++i) {
            if (text2.charAt(i) == c) {
                ++count;
                continue;
            }
            if (stopAtOtherChar) break;
        }
        return count;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalsOnly(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(382);
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            b.append(s.charAt(i));
        }
        String string = b.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(383);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String joinOrNull(String ... args) {
        if (args == null) {
            StringUtil.$$$reportNull$$$0(384);
        }
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Nullable
    @Contract(pure=true)
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        if (methodName == null) {
            StringUtil.$$$reportNull$$$0(385);
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(386);
        }
        if ((len = text2.length()) == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text2.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeProperty(@NotNull String input, boolean isKey) {
        if (input == null) {
            StringUtil.$$$reportNull$$$0(387);
        }
        StringBuilder escaped = new StringBuilder(input.length());
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        String string = escaped.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(388);
        }
        return string;
    }

    @Contract(pure=true)
    public static String getQualifiedName(@Nullable String packageName, String className) {
        if (packageName == null || packageName.isEmpty()) {
            return className;
        }
        return packageName + '.' + className;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[._\\-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts;
            boolean left = part1.length > idx;
            String[] stringArray = parts = left ? part1 : part2;
            while (idx < parts.length) {
                String p = parts[idx];
                int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(389);
        }
        int res = 0;
        for (int i = 0; i < text2.length() && (i = text2.indexOf(c, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text2, @NotNull String s) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(390);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(391);
        }
        int res = 0;
        for (int i = 0; i < text2.length() && (i = text2.indexOf(s, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    public static int getIgnoreCaseOccurrenceCount(@NotNull String text2, @NotNull String s) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(392);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(393);
        }
        int res = 0;
        for (int i = 0; i < text2.length() && (i = StringUtil.indexOfIgnoreCase(text2, s, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(394);
        }
        if (StringUtil.isEmptyOrSpaces(name)) {
            String string = name;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(395);
            }
            return string;
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            String string = "an" + Character.toUpperCase(c) + name.substring(1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(396);
            }
            return string;
        }
        String string = "a" + Character.toUpperCase(c) + name.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(397);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(398);
        }
        StringBuilder result2 = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result2.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result2.append("_");
            }
            result2.append(ch);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(399);
        }
        return string;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(400);
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            throw new AssertionError((Object)("Wrong line separators: '" + context + "' at offset " + slashRIndex));
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String tail(@NotNull String s, int idx) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(401);
        }
        String string = idx >= s.length() ? "" : s.substring(idx, s.length());
        if (string == null) {
            StringUtil.$$$reportNull$$$0(402);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLines(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(403);
        }
        String[] stringArray = StringUtil.splitByLines(string, true);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(404);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLines(@NotNull String string, boolean excludeEmptyStrings) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(405);
        }
        String[] stringArray = (excludeEmptyStrings ? EOL_SPLIT_PATTERN : EOL_SPLIT_PATTERN_WITH_EMPTY).split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(406);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLinesDontTrim(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(407);
        }
        String[] stringArray = EOL_SPLIT_DONT_TRIM_PATTERN.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(408);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLinesKeepSeparators(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(409);
        }
        String[] stringArray = EOL_SPLIT_KEEP_SEPARATORS.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(410);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static List<Pair<String, Integer>> getWordsWithOffset(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(411);
        }
        ArrayList<Pair<String, Integer>> res = ContainerUtil.newArrayList();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name.length() <= 0) continue;
                res.add(Pair.create(name.toString(), startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name.append(s.charAt(i));
        }
        ArrayList<Pair<String, Integer>> arrayList = res;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(412);
        }
        return arrayList;
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    @Contract(pure=true)
    public static int hashCode(@NotNull CharSequence s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(413);
        }
        return StringUtil.stringHashCode(s);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (StringUtil.charsEqualIgnoreCase(s1.charAt(i), s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if (s1.charAt(index1) == s2.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringUtil.isWhiteSpace(s1.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringUtil.isWhiteSpace(s2.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringUtil.isWhiteSpace(s1.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringUtil.isWhiteSpace(s2.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        char c;
        int start2;
        char c2;
        int start1;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(414);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(415);
        }
        int end1 = s1.length();
        int end2 = s2.length();
        for (start1 = 0; start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(start1)); ++start1) {
        }
        while (start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(end1 - 1))) {
            --end1;
        }
        for (start2 = 0; start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(start2)); ++start2) {
        }
        while (start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(end2 - 1))) {
            --end2;
        }
        CharSequenceSubSequence ts1 = new CharSequenceSubSequence(s1, start1, end1);
        CharSequenceSubSequence ts2 = new CharSequenceSubSequence(s2, start2, end2);
        return StringUtil.equals(ts1, ts2);
    }

    @Contract(pure=true)
    public static boolean findIgnoreCase(@Nullable String toFind, String ... where) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(416);
        }
        for (String string : where) {
            if (!StringUtil.equalsIgnoreCase(toFind, string)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return StringUtil.compare(c1, c2, ignoreCase) == 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatLinks(@NotNull String message) {
        if (message == null) {
            StringUtil.$$$reportNull$$$0(417);
        }
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z0-9./\\-+]+");
        StringBuffer result2 = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result2, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result2);
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(418);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(419);
        }
        String string = StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(420);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimMiddle(@NotNull String text2, int maxLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(421);
        }
        String string = StringUtil.shortenTextWithEllipsis(text2, maxLength, maxLength >> 1, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(422);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, @NotNull String symbol) {
        int textLength;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(423);
        }
        if (symbol == null) {
            StringUtil.$$$reportNull$$$0(424);
        }
        if ((textLength = text2.length()) > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            assert (prefixLength > 0);
            String string = text2.substring(0, prefixLength) + symbol + text2.substring(textLength - suffixLength);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(425);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(426);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(427);
        }
        String symbol = useEllipsisSymbol ? "\u2026" : "...";
        String string = StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, symbol);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(428);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength, boolean useEllipsisSymbol) {
        if (path == null) {
            StringUtil.$$$reportNull$$$0(429);
        }
        String string = StringUtil.shortenTextWithEllipsis(path, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(430);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength) {
        if (path == null) {
            StringUtil.$$$reportNull$$$0(431);
        }
        String string = StringUtil.shortenPathWithEllipsis(path, maxLength, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(432);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return StringUtil.charsMatch(a, b, true);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String a) {
        return a == null ? null : StringUtilRt.toUpperCase(a).toString();
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    @Nullable
    public static LineSeparator detectSeparators(@NotNull CharSequence text2) {
        int index;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(433);
        }
        if ((index = StringUtil.indexOfAny(text2, "\n\r")) == -1) {
            return null;
        }
        LineSeparator lineSeparator = StringUtil.getLineSeparatorAt(text2, index);
        if (lineSeparator == null) {
            throw new AssertionError();
        }
        return lineSeparator;
    }

    @Nullable
    public static LineSeparator getLineSeparatorAt(@NotNull CharSequence text2, int index) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(434);
        }
        if (index < 0 || index >= text2.length()) {
            return null;
        }
        char ch = text2.charAt(index);
        if (ch == '\r') {
            return index + 1 < text2.length() && text2.charAt(index + 1) == '\n' ? LineSeparator.CRLF : LineSeparator.CR;
        }
        return ch == '\n' ? LineSeparator.LF : null;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(435);
        }
        String string = StringUtilRt.convertLineSeparators(text2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(436);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, boolean keepCarriageReturn) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(437);
        }
        String string = StringUtilRt.convertLineSeparators(text2, keepCarriageReturn);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(438);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(439);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(440);
        }
        String string = StringUtilRt.convertLineSeparators(text2, newSeparator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(441);
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(442);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(443);
        }
        String string = StringUtilRt.convertLineSeparators(text2, newSeparator, offsetsToKeep);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(444);
        }
        return string;
    }

    @Contract(pure=true)
    public static int parseInt(String string, int defaultValue) {
        return StringUtilRt.parseInt(string, defaultValue);
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string, long defaultValue) {
        return StringUtilRt.parseLong(string, defaultValue);
    }

    @Contract(pure=true)
    public static double parseDouble(String string, double defaultValue) {
        return StringUtilRt.parseDouble(string, defaultValue);
    }

    @Contract(pure=true)
    public static boolean parseBoolean(String string, boolean defaultValue) {
        return StringUtilRt.parseBoolean(string, defaultValue);
    }

    @Contract(pure=true)
    public static <E extends Enum<E>> E parseEnum(@NotNull String string, E defaultValue, @NotNull Class<E> clazz) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(445);
        }
        if (clazz == null) {
            StringUtil.$$$reportNull$$$0(446);
        }
        return StringUtilRt.parseEnum(string, defaultValue, clazz);
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull Class aClass) {
        if (aClass == null) {
            StringUtil.$$$reportNull$$$0(447);
        }
        String string = StringUtilRt.getShortName(aClass);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(448);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(449);
        }
        String string = StringUtilRt.getShortName(fqName);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(450);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName, char separator) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(451);
        }
        String string = StringUtilRt.getShortName(fqName, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(452);
        }
        return string;
    }

    public static boolean isShortNameOf(@NotNull String fqName, @NotNull String shortName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(453);
        }
        if (shortName == null) {
            StringUtil.$$$reportNull$$$0(454);
        }
        int separator = 46;
        if (fqName.length() < shortName.length()) {
            return false;
        }
        if (fqName.length() == shortName.length()) {
            return fqName.equals(shortName);
        }
        int diff = fqName.length() - shortName.length();
        if (fqName.charAt(diff - 1) != '.') {
            return false;
        }
        return fqName.regionMatches(diff, shortName, 0, shortName.length());
    }

    @Contract(value="null->null;!null->!null")
    static String toShortString(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return o.toString();
        }
        String className = o.getClass().getName();
        String s = o.toString();
        if (!s.startsWith(className)) {
            return s;
        }
        return s.length() > className.length() && !Character.isLetter(s.charAt(className.length())) ? StringUtil.trimStart(s, className) : s;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence, long delay) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(455);
        }
        final long myTime = System.currentTimeMillis() + delay;
        BombedCharSequence bombedCharSequence = new BombedCharSequence(sequence){

            @Override
            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
        if (bombedCharSequence == null) {
            StringUtil.$$$reportNull$$$0(456);
        }
        return bombedCharSequence;
    }

    public static boolean trimEnd(@NotNull StringBuilder buffer, @NotNull CharSequence end) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(457);
        }
        if (end == null) {
            StringUtil.$$$reportNull$$$0(458);
        }
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isBetween(@NotNull String string, @NotNull String smallPart, @NotNull String bigPart) {
        String s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(459);
        }
        if (smallPart == null) {
            StringUtil.$$$reportNull$$$0(460);
        }
        if (bigPart == null) {
            StringUtil.$$$reportNull$$$0(461);
        }
        return (s = string.toLowerCase()).startsWith(smallPart.toLowerCase()) && bigPart.toLowerCase().startsWith(s);
    }

    public static boolean hasUpperCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeEscapeSequences(String text2) {
        if (text2 == null) {
            return null;
        }
        Matcher matcher = UNICODE_CHAR.matcher(text2);
        if (!matcher.find()) {
            return text2;
        }
        matcher.reset();
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text2.length());
        while (matcher.find()) {
            sb.append(text2.substring(lastEnd, matcher.start()));
            char c = (char)Integer.parseInt(matcher.group().substring(2), 16);
            sb.append(c);
            lastEnd = matcher.end();
        }
        sb.append(text2.substring(lastEnd, text2.length()));
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(@NotNull byte[] bytes) {
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(462);
        }
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(digits.charAt(b >> 4 & 0xF)).append(digits.charAt(b & 0xF));
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(463);
        }
        return string;
    }

    public static boolean startsWithConcatenationOf(@NotNull String string, @NotNull String firstPrefix, @NotNull String secondPrefix) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(464);
        }
        if (firstPrefix == null) {
            StringUtil.$$$reportNull$$$0(465);
        }
        if (secondPrefix == null) {
            StringUtil.$$$reportNull$$$0(466);
        }
        return StringUtil.startsWithConcatenation(string, firstPrefix, secondPrefix);
    }

    @Contract(pure=true)
    public static boolean isLatinAlphanumeric(@Nullable CharSequence str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: 
            case 186: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 195: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 210: 
            case 214: 
            case 215: 
            case 216: 
            case 222: 
            case 229: 
            case 230: 
            case 236: 
            case 237: 
            case 238: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 256: 
            case 259: 
            case 262: 
            case 268: 
            case 278: 
            case 285: 
            case 318: 
            case 319: 
            case 326: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 339: 
            case 342: 
            case 344: 
            case 347: 
            case 349: 
            case 351: 
            case 357: 
            case 359: 
            case 361: 
            case 364: 
            case 370: 
            case 374: 
            case 376: 
            case 377: 
            case 383: 
            case 388: 
            case 395: 
            case 396: 
            case 397: 
            case 399: 
            case 402: 
            case 404: 
            case 406: 
            case 408: 
            case 410: 
            case 412: 
            case 418: 
            case 420: 
            case 422: 
            case 425: 
            case 426: 
            case 428: 
            case 430: 
            case 432: 
            case 436: 
            case 438: 
            case 441: 
            case 444: 
            case 448: 
            case 450: 
            case 452: 
            case 456: 
            case 463: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: 
            case 186: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 195: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 210: 
            case 214: 
            case 215: 
            case 216: 
            case 222: 
            case 229: 
            case 230: 
            case 236: 
            case 237: 
            case 238: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 256: 
            case 259: 
            case 262: 
            case 268: 
            case 278: 
            case 285: 
            case 318: 
            case 319: 
            case 326: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 339: 
            case 342: 
            case 344: 
            case 347: 
            case 349: 
            case 351: 
            case 357: 
            case 359: 
            case 361: 
            case 364: 
            case 370: 
            case 374: 
            case 376: 
            case 377: 
            case 383: 
            case 388: 
            case 395: 
            case 396: 
            case 397: 
            case 399: 
            case 402: 
            case 404: 
            case 406: 
            case 408: 
            case 410: 
            case 412: 
            case 418: 
            case 420: 
            case 422: 
            case 425: 
            case 426: 
            case 428: 
            case 430: 
            case 432: 
            case 436: 
            case 438: 
            case 441: 
            case 444: 
            case 448: 
            case 450: 
            case 452: 
            case 456: 
            case 463: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSeq";
                break;
            }
            case 1: 
            case 267: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: 
            case 186: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 195: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 210: 
            case 214: 
            case 215: 
            case 216: 
            case 222: 
            case 229: 
            case 230: 
            case 236: 
            case 237: 
            case 238: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 256: 
            case 259: 
            case 262: 
            case 268: 
            case 278: 
            case 285: 
            case 318: 
            case 319: 
            case 326: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 339: 
            case 342: 
            case 344: 
            case 347: 
            case 349: 
            case 351: 
            case 357: 
            case 359: 
            case 361: 
            case 364: 
            case 370: 
            case 374: 
            case 376: 
            case 377: 
            case 383: 
            case 388: 
            case 395: 
            case 396: 
            case 397: 
            case 399: 
            case 402: 
            case 404: 
            case 406: 
            case 408: 
            case 410: 
            case 412: 
            case 418: 
            case 420: 
            case 422: 
            case 425: 
            case 426: 
            case 428: 
            case 430: 
            case 432: 
            case 436: 
            case 438: 
            case 441: 
            case 444: 
            case 448: 
            case 450: 
            case 452: 
            case 456: 
            case 463: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "find";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 19: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 92: 
            case 94: 
            case 125: 
            case 189: 
            case 192: 
            case 194: 
            case 239: 
            case 269: 
            case 270: 
            case 272: 
            case 274: 
            case 302: 
            case 314: 
            case 316: 
            case 320: 
            case 322: 
            case 325: 
            case 327: 
            case 329: 
            case 331: 
            case 358: 
            case 360: 
            case 362: 
            case 366: 
            case 367: 
            case 371: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 386: 
            case 389: 
            case 390: 
            case 392: 
            case 419: 
            case 421: 
            case 423: 
            case 427: 
            case 433: 
            case 434: 
            case 435: 
            case 437: 
            case 439: 
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldS";
                break;
            }
            case 11: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newS";
                break;
            }
            case 17: 
            case 62: 
            case 64: 
            case 67: 
            case 70: 
            case 87: 
            case 153: 
            case 457: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 416: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 28: 
            case 30: 
            case 61: 
            case 63: 
            case 66: 
            case 69: 
            case 333: 
            case 335: 
            case 338: 
            case 341: 
            case 343: 
            case 346: 
            case 348: 
            case 350: 
            case 353: 
            case 356: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 29: 
            case 116: 
            case 119: 
            case 275: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 31: 
            case 145: 
            case 271: 
            case 273: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 34: 
            case 36: 
            case 449: 
            case 451: 
            case 453: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 46: 
            case 276: 
            case 279: 
            case 281: 
            case 283: 
            case 286: 
            case 414: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 47: 
            case 277: 
            case 280: 
            case 282: 
            case 284: 
            case 287: 
            case 415: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 58: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 86: 
            case 97: 
            case 102: 
            case 115: 
            case 118: 
            case 122: 
            case 144: 
            case 164: 
            case 166: 
            case 168: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 184: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 300: 
            case 301: 
            case 304: 
            case 306: 
            case 308: 
            case 310: 
            case 312: 
            case 324: 
            case 382: 
            case 391: 
            case 393: 
            case 400: 
            case 401: 
            case 411: 
            case 413: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepositions";
                break;
            }
            case 88: 
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizerDelim";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 250: 
            case 252: 
            case 305: 
            case 307: 
            case 309: 
            case 311: 
            case 313: 
            case 365: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 113: 
            case 128: 
            case 130: 
            case 132: 
            case 136: 
            case 138: 
            case 140: 
            case 265: 
            case 403: 
            case 405: 
            case 407: 
            case 409: 
            case 445: 
            case 459: 
            case 464: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 134: 
            case 142: 
            case 354: 
            case 355: 
            case 363: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 148: 
            case 394: 
            case 398: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 157: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 169: 
            case 172: 
            case 175: 
            case 178: 
            case 181: 
            case 197: 
            case 200: 
            case 209: 
            case 213: 
            case 218: 
            case 221: 
            case 225: 
            case 228: 
            case 232: 
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 196: 
            case 199: 
            case 227: 
            case 231: 
            case 234: 
            case 375: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 202: 
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 207: 
            case 211: 
            case 217: 
            case 219: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 208: 
            case 212: 
            case 220: 
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 226: 
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 248: 
            case 249: 
            case 251: 
            case 253: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 255: 
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 258: 
            case 261: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 266: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 292: 
            case 294: 
            case 296: 
            case 298: 
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 293: 
            case 295: 
            case 297: 
            case 299: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 303: 
            case 315: 
            case 317: 
            case 321: 
            case 323: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 337: 
            case 340: 
            case 345: 
            case 352: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 368: 
            case 372: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 369: 
            case 373: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 384: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 385: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 387: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 417: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 424: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 429: 
            case 431: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 440: 
            case 443: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 446: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 447: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 458: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 460: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallPart";
                break;
            }
            case 461: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigPart";
                break;
            }
            case 462: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 465: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstPrefix";
                break;
            }
            case 466: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubSequence";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsInStringLongestFirst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "escapePattern";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringFunction";
                break;
            }
            case 12: 
            case 370: 
            case 374: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreCase";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceChar";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 35: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeLineBreak";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "wordsToBeginFromUpperCase";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "wordsToBeginFromLowerCase";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "toTitleCase";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCapitalization";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "escaper";
                break;
            }
            case 65: 
            case 68: 
            case 71: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringCharacters";
                break;
            }
            case 81: 
            case 82: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 151: 
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 93: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWords";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLog";
                break;
            }
            case 129: 
            case 131: 
            case 133: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 137: 
            case 139: 
            case 141: 
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExtensions";
                break;
            }
            case 154: 
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 158: 
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "repeatSymbol";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 186: 
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 190: 
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsIn";
                break;
            }
            case 193: 
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordIndicesIn";
                break;
            }
            case 198: 
            case 201: 
            case 210: 
            case 214: 
            case 215: 
            case 216: 
            case 222: 
            case 229: 
            case 230: 
            case 236: 
            case 237: 
            case 238: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 204: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "surround";
                break;
            }
            case 240: 
            case 241: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesAroundValue";
                break;
            }
            case 242: 
            case 243: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 244: 
            case 245: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 246: {
                objectArray = objectArray2;
                objectArray2[1] = "formatValue";
                break;
            }
            case 256: {
                objectArray = objectArray2;
                objectArray2[1] = "strip";
                break;
            }
            case 259: 
            case 262: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatches";
                break;
            }
            case 268: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubstring";
                break;
            }
            case 278: {
                objectArray = objectArray2;
                objectArray2[1] = "commonPrefix";
                break;
            }
            case 285: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuffix";
                break;
            }
            case 318: 
            case 319: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeLast";
                break;
            }
            case 326: 
            case 328: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 330: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLast";
                break;
            }
            case 334: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChar";
                break;
            }
            case 336: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChars";
                break;
            }
            case 339: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeQuotes";
                break;
            }
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSlashes";
                break;
            }
            case 344: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeBackSlashes";
                break;
            }
            case 347: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSlashes";
                break;
            }
            case 349: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackSlashes";
                break;
            }
            case 351: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 357: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithDoubleQuote";
                break;
            }
            case 359: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
            case 361: 
            case 364: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 376: 
            case 377: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyStrings";
                break;
            }
            case 383: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalsOnly";
                break;
            }
            case 388: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeProperty";
                break;
            }
            case 395: 
            case 396: 
            case 397: {
                objectArray = objectArray2;
                objectArray2[1] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 399: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaIdentifier";
                break;
            }
            case 402: {
                objectArray = objectArray2;
                objectArray2[1] = "tail";
                break;
            }
            case 404: 
            case 406: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesDontTrim";
                break;
            }
            case 410: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesKeepSeparators";
                break;
            }
            case 412: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsWithOffset";
                break;
            }
            case 418: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLinks";
                break;
            }
            case 420: 
            case 425: 
            case 426: 
            case 428: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextWithEllipsis";
                break;
            }
            case 422: {
                objectArray = objectArray2;
                objectArray2[1] = "trimMiddle";
                break;
            }
            case 430: 
            case 432: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenPathWithEllipsis";
                break;
            }
            case 436: 
            case 438: 
            case 441: 
            case 444: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 448: 
            case 450: 
            case 452: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 456: {
                objectArray = objectArray2;
                objectArray2[1] = "newBombedCharSequence";
                break;
            }
            case 463: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: 
            case 186: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 195: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 210: 
            case 214: 
            case 215: 
            case 216: 
            case 222: 
            case 229: 
            case 230: 
            case 236: 
            case 237: 
            case 238: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 256: 
            case 259: 
            case 262: 
            case 268: 
            case 278: 
            case 285: 
            case 318: 
            case 319: 
            case 326: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 339: 
            case 342: 
            case 344: 
            case 347: 
            case 349: 
            case 351: 
            case 357: 
            case 359: 
            case 361: 
            case 364: 
            case 370: 
            case 374: 
            case 376: 
            case 377: 
            case 383: 
            case 388: 
            case 395: 
            case 396: 
            case 397: 
            case 399: 
            case 402: 
            case 404: 
            case 406: 
            case 408: 
            case 410: 
            case 412: 
            case 418: 
            case 420: 
            case 422: 
            case 425: 
            case 426: 
            case 428: 
            case 430: 
            case 432: 
            case 436: 
            case 438: 
            case 441: 
            case 444: 
            case 448: 
            case 450: 
            case 452: 
            case 456: 
            case 463: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWordsInStringLongestFirst";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "escapePattern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createToStringFunction";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 367: 
            case 368: 
            case 369: 
            case 371: 
            case 372: 
            case 373: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreCase";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceChar";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIgnoreCase";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreCase";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakCount";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "containsLineBreak";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "escapeLineBreak";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "endsWithLineBreak";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lineColToOffset";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineNumber";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromUpperCase";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromLowerCase";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "toTitleCase";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "fixCapitalization";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isPreposition";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 76: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringCharacters";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isQuoteAt";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 80: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 88: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 92: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWords";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenation";
                break;
            }
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 122: 
            case 457: 
            case 458: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "trimLog";
                break;
            }
            case 128: 
            case 130: 
            case 132: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
            case 136: 
            case 138: 
            case 140: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "trimExtensions";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "repeatSymbol";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 157: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 184: 
            case 185: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "getWordsIn";
                break;
            }
            case 192: 
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "getWordIndicesIn";
                break;
            }
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 207: 
            case 208: 
            case 209: 
            case 211: 
            case 212: 
            case 213: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesAroundValue";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "containsAlphaCharacters";
                break;
            }
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 254: 
            case 255: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 257: 
            case 258: 
            case 260: 
            case 261: {
                objectArray = objectArray;
                objectArray[2] = "findMatches";
                break;
            }
            case 263: 
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 265: 
            case 266: 
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstring";
                break;
            }
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 270: 
            case 271: 
            case 272: 
            case 273: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 274: 
            case 275: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 276: 
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefix";
                break;
            }
            case 279: 
            case 280: 
            case 281: 
            case 282: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefixLength";
                break;
            }
            case 283: 
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffix";
                break;
            }
            case 286: 
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 288: 
            case 292: 
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 302: 
            case 303: {
                objectArray = objectArray;
                objectArray[2] = "indexOfSubstringEnd";
                break;
            }
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 312: 
            case 313: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfAny";
                break;
            }
            case 314: 
            case 315: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 316: 
            case 317: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 320: 
            case 321: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 322: 
            case 323: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 324: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 325: 
            case 327: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 329: {
                objectArray = objectArray;
                objectArray[2] = "last";
                break;
            }
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "firstLast";
                break;
            }
            case 333: 
            case 337: {
                objectArray = objectArray;
                objectArray[2] = "escapeChar";
                break;
            }
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "escapeChars";
                break;
            }
            case 338: 
            case 340: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 341: 
            case 345: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlashes";
                break;
            }
            case 343: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashes";
                break;
            }
            case 346: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSlashes";
                break;
            }
            case 348: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackSlashes";
                break;
            }
            case 350: 
            case 352: 
            case 353: {
                objectArray = objectArray;
                objectArray[2] = "unescapeChar";
                break;
            }
            case 354: 
            case 355: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 356: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithDoubleQuote";
                break;
            }
            case 358: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 360: 
            case 362: 
            case 363: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 365: 
            case 366: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedBackslash";
                break;
            }
            case 375: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyStrings";
                break;
            }
            case 378: {
                objectArray = objectArray;
                objectArray[2] = "countNewLines";
                break;
            }
            case 379: 
            case 380: 
            case 381: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 382: {
                objectArray = objectArray;
                objectArray[2] = "capitalsOnly";
                break;
            }
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "joinOrNull";
                break;
            }
            case 385: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "isJavaIdentifier";
                break;
            }
            case 387: {
                objectArray = objectArray;
                objectArray[2] = "escapeProperty";
                break;
            }
            case 389: 
            case 390: 
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 392: 
            case 393: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreCaseOccurrenceCount";
                break;
            }
            case 394: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 398: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaIdentifier";
                break;
            }
            case 400: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 401: {
                objectArray = objectArray;
                objectArray[2] = "tail";
                break;
            }
            case 403: 
            case 405: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 407: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesDontTrim";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesKeepSeparators";
                break;
            }
            case 411: {
                objectArray = objectArray;
                objectArray[2] = "getWordsWithOffset";
                break;
            }
            case 413: {
                objectArray = objectArray;
                objectArray[2] = "hashCode";
                break;
            }
            case 414: 
            case 415: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 416: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreCase";
                break;
            }
            case 417: {
                objectArray = objectArray;
                objectArray[2] = "formatLinks";
                break;
            }
            case 419: 
            case 423: 
            case 424: 
            case 427: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextWithEllipsis";
                break;
            }
            case 421: {
                objectArray = objectArray;
                objectArray[2] = "trimMiddle";
                break;
            }
            case 429: 
            case 431: {
                objectArray = objectArray;
                objectArray[2] = "shortenPathWithEllipsis";
                break;
            }
            case 433: {
                objectArray = objectArray;
                objectArray[2] = "detectSeparators";
                break;
            }
            case 434: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorAt";
                break;
            }
            case 435: 
            case 437: 
            case 439: 
            case 440: 
            case 442: 
            case 443: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 445: 
            case 446: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 447: 
            case 449: 
            case 451: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 453: 
            case 454: {
                objectArray = objectArray;
                objectArray[2] = "isShortNameOf";
                break;
            }
            case 455: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
            case 459: 
            case 460: 
            case 461: {
                objectArray = objectArray;
                objectArray[2] = "isBetween";
                break;
            }
            case 462: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 464: 
            case 465: 
            case 466: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenationOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: 
            case 186: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 195: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 210: 
            case 214: 
            case 215: 
            case 216: 
            case 222: 
            case 229: 
            case 230: 
            case 236: 
            case 237: 
            case 238: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 256: 
            case 259: 
            case 262: 
            case 268: 
            case 278: 
            case 285: 
            case 318: 
            case 319: 
            case 326: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 339: 
            case 342: 
            case 344: 
            case 347: 
            case 349: 
            case 351: 
            case 357: 
            case 359: 
            case 361: 
            case 364: 
            case 370: 
            case 374: 
            case 376: 
            case 377: 
            case 383: 
            case 388: 
            case 395: 
            case 396: 
            case 397: 
            case 399: 
            case 402: 
            case 404: 
            case 406: 
            case 408: 
            case 410: 
            case 412: 
            case 418: 
            case 420: 
            case 422: 
            case 425: 
            case 426: 
            case 428: 
            case 430: 
            case 432: 
            case 436: 
            case 438: 
            case 441: 
            case 444: 
            case 448: 
            case 450: 
            case 452: 
            case 456: 
            case 463: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class BombedCharSequence
    implements CharSequence {
        private final CharSequence delegate;
        private int i;

        public BombedCharSequence(@NotNull CharSequence sequence) {
            if (sequence == null) {
                BombedCharSequence.$$$reportNull$$$0(0);
            }
            this.delegate = sequence;
        }

        @Override
        public int length() {
            this.check();
            return this.delegate.length();
        }

        @Override
        public char charAt(int i) {
            this.check();
            return this.delegate.charAt(i);
        }

        protected void check() {
            if ((++this.i & 0x3FF) == 0) {
                this.checkCanceled();
            }
        }

        @Override
        @NotNull
        public String toString() {
            this.check();
            String string = this.delegate.toString();
            if (string == null) {
                BombedCharSequence.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected abstract void checkCanceled();

        @Override
        @NotNull
        public CharSequence subSequence(int i, int i1) {
            this.check();
            CharSequence charSequence = this.delegate.subSequence(i, i1);
            if (charSequence == null) {
                BombedCharSequence.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();

        private MyHtml2Text() {
        }

        public void parse(Reader in) throws IOException {
            this.myBuffer.setLength(0);
            new ParserDelegator().parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char[] text2, int pos) {
            this.myBuffer.append(text2);
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        private void handleTag(HTML.Tag tag) {
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(SystemProperties.getLineSeparator());
            }
        }

        public String getText() {
            return this.myBuffer.toString();
        }
    }
}

