/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.JavaVariableConflictResolver;
import com.intellij.psi.scope.processor.ConflictFilterProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public class VariableResolverProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.VARIABLE;
    private boolean myStaticScopeFlag;
    private final PsiClass myAccessClass;
    private PsiElement myCurrentFileContext;

    public VariableResolverProcessor(@NotNull PsiJavaCodeReferenceElement place, @NotNull PsiFile placeFile) {
        if (place == null) {
            VariableResolverProcessor.$$$reportNull$$$0(0);
        }
        if (placeFile == null) {
            VariableResolverProcessor.$$$reportNull$$$0(1);
        }
        super(place.getReferenceName(), ourFilter, new PsiConflictResolver[]{new JavaVariableConflictResolver()}, new SmartList<CandidateInfo>(), place, placeFile);
        PsiClass access = null;
        PsiElement qualifier = place.getQualifier();
        if (qualifier instanceof PsiExpression) {
            JavaResolveResult accessClass = PsiUtil.getAccessObjectClass((PsiExpression)qualifier);
            PsiElement element = accessClass.getElement();
            if (element instanceof PsiTypeParameter) {
                PsiElementFactory factory = JavaPsiFacade.getInstance(placeFile.getProject()).getElementFactory();
                PsiClassType type = factory.createType((PsiTypeParameter)element);
                PsiType accessType = accessClass.getSubstitutor().substitute(type);
                if (accessType instanceof PsiArrayType) {
                    LanguageLevel languageLevel = PsiUtil.getLanguageLevel(placeFile);
                    access = factory.getArrayClass(languageLevel);
                } else if (accessType instanceof PsiClassType) {
                    access = ((PsiClassType)accessType).resolve();
                }
            } else if (element instanceof PsiClass) {
                access = (PsiClass)element;
            }
        }
        this.myAccessClass = access;
    }

    @Override
    protected boolean stopAtFoundResult(JavaResolveResult cachedResult) {
        if (super.stopAtFoundResult(cachedResult)) {
            PsiElement element;
            JavaCodeFragment.VisibilityChecker visibilityChecker;
            if (this.myPlaceFile instanceof JavaCodeFragment && (visibilityChecker = ((JavaCodeFragment)this.myPlaceFile).getVisibilityChecker()) != null && (element = cachedResult.getElement()) instanceof PsiMember) {
                PsiMember member = (PsiMember)element;
                return JavaResolveUtil.isAccessible(member, member.getContainingClass(), member.getModifierList(), this.myPlace, this.myAccessClass, cachedResult.getCurrentFileResolveScope(), null);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            VariableResolverProcessor.$$$reportNull$$$0(2);
        }
        super.handleEvent(event, associated);
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    @Override
    public void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor) {
        if (element == null) {
            VariableResolverProcessor.$$$reportNull$$$0(3);
        }
        if (substitutor == null) {
            VariableResolverProcessor.$$$reportNull$$$0(4);
        }
        boolean staticProblem = this.myStaticScopeFlag && !((PsiModifierListOwner)element).hasModifierProperty("static") && (element instanceof PsiField || !(element instanceof PsiVariable) || !PsiUtil.isCompileTimeConstant((PsiVariable)element));
        this.add(new CandidateInfo(element, substitutor, this.myPlace, this.myAccessClass, staticProblem, this.myCurrentFileContext));
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.VARIABLE || kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            VariableResolverProcessor.$$$reportNull$$$0(5);
        }
        if (state == null) {
            VariableResolverProcessor.$$$reportNull$$$0(6);
        }
        if (!(element instanceof PsiField) && (this.myName == null || PsiUtil.checkName(element, this.myName, this.myPlace))) {
            super.execute(element, state);
            return this.myResults.isEmpty();
        }
        return super.execute(element, state);
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            VariableResolverProcessor.$$$reportNull$$$0(7);
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/resolve/VariableResolverProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

