/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightTreeUtil {
    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull IElementType type) {
        if (tree == null) {
            LightTreeUtil.$$$reportNull$$$0(0);
        }
        if (type == null) {
            LightTreeUtil.$$$reportNull$$$0(1);
        }
        if (node == null) {
            return null;
        }
        List<LighterASTNode> children = tree.getChildren(node);
        for (int i = 0; i < children.size(); ++i) {
            LighterASTNode child = children.get(i);
            if (child.getTokenType() != type) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            LightTreeUtil.$$$reportNull$$$0(2);
        }
        if (types == null) {
            LightTreeUtil.$$$reportNull$$$0(3);
        }
        if (node == null) {
            return null;
        }
        List<LighterASTNode> children = tree.getChildren(node);
        for (int i = 0; i < children.size(); ++i) {
            LighterASTNode child = children.get(i);
            if (!types.contains(child.getTokenType())) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        if (tree == null) {
            LightTreeUtil.$$$reportNull$$$0(4);
        }
        if (node == null) {
            LightTreeUtil.$$$reportNull$$$0(5);
        }
        if (type == null) {
            LightTreeUtil.$$$reportNull$$$0(6);
        }
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, type);
        assert (child != null) : "Required child " + type + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            LightTreeUtil.$$$reportNull$$$0(7);
        }
        return lighterASTNode;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            LightTreeUtil.$$$reportNull$$$0(8);
        }
        if (node == null) {
            LightTreeUtil.$$$reportNull$$$0(9);
        }
        if (types == null) {
            LightTreeUtil.$$$reportNull$$$0(10);
        }
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, types);
        assert (child != null) : "Required child " + types + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            LightTreeUtil.$$$reportNull$$$0(11);
        }
        return lighterASTNode;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        if (tree == null) {
            LightTreeUtil.$$$reportNull$$$0(12);
        }
        if (node == null) {
            LightTreeUtil.$$$reportNull$$$0(13);
        }
        if (type == null) {
            LightTreeUtil.$$$reportNull$$$0(14);
        }
        List<LighterASTNode> result2 = null;
        List<LighterASTNode> children = tree.getChildren(node);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (child.getTokenType() != type) continue;
            if (result2 == null) {
                result2 = new SmartList<LighterASTNode>();
            }
            result2.add(child);
        }
        List<LighterASTNode> list = result2 != null ? result2 : Collections.emptyList();
        if (list == null) {
            LightTreeUtil.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            LightTreeUtil.$$$reportNull$$$0(16);
        }
        if (node == null) {
            LightTreeUtil.$$$reportNull$$$0(17);
        }
        if (types == null) {
            LightTreeUtil.$$$reportNull$$$0(18);
        }
        List<LighterASTNode> children = tree.getChildren(node);
        List<LighterASTNode> result2 = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (!types.contains(child.getTokenType())) continue;
            if (result2 == null) {
                result2 = new SmartList<LighterASTNode>();
            }
            result2.add(child);
        }
        List<LighterASTNode> list = result2 != null ? result2 : Collections.emptyList();
        if (list == null) {
            LightTreeUtil.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public static String toFilteredString(@NotNull LighterAST tree, @NotNull LighterASTNode node, @Nullable TokenSet skipTypes) {
        int length;
        if (tree == null) {
            LightTreeUtil.$$$reportNull$$$0(20);
        }
        if (node == null) {
            LightTreeUtil.$$$reportNull$$$0(21);
        }
        if ((length = node.getEndOffset() - node.getStartOffset()) < 0) {
            length = 0;
            Logger.getInstance(LightTreeUtil.class).error("tree=" + tree + " node=" + node);
        }
        StringBuilder buffer = new StringBuilder(length);
        LightTreeUtil.toBuffer(tree, node, buffer, skipTypes);
        String string = buffer.toString();
        if (string == null) {
            LightTreeUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    public static void toBuffer(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (tree == null) {
            LightTreeUtil.$$$reportNull$$$0(23);
        }
        if (node == null) {
            LightTreeUtil.$$$reportNull$$$0(24);
        }
        if (buffer == null) {
            LightTreeUtil.$$$reportNull$$$0(25);
        }
        if (skipTypes != null && skipTypes.contains(node.getTokenType())) {
            return;
        }
        if (node instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node).getText());
            return;
        }
        if (node instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node).getText());
            return;
        }
        List<LighterASTNode> children = tree.getChildren(node);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LightTreeUtil.toBuffer(tree, children.get(i), buffer, skipTypes);
        }
    }

    @Nullable
    public static LighterASTNode getParentOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types, @NotNull TokenSet stopAt) {
        if (tree == null) {
            LightTreeUtil.$$$reportNull$$$0(26);
        }
        if (types == null) {
            LightTreeUtil.$$$reportNull$$$0(27);
        }
        if (stopAt == null) {
            LightTreeUtil.$$$reportNull$$$0(28);
        }
        if (node == null) {
            return null;
        }
        node = tree.getParent(node);
        while (node != null) {
            IElementType type = node.getTokenType();
            if (types.contains(type)) {
                return node;
            }
            if (stopAt.contains(type)) {
                return null;
            }
            node = tree.getParent(node);
        }
        return null;
    }

    @Nullable
    public static LighterASTNode findLeafElementAt(@NotNull LighterAST tree, int offset) {
        LighterASTNode eachNode;
        if (tree == null) {
            LightTreeUtil.$$$reportNull$$$0(29);
        }
        if (!LightTreeUtil.containsOffset(eachNode = tree.getRoot(), offset)) {
            return null;
        }
        while (eachNode != null) {
            List<LighterASTNode> children = tree.getChildren(eachNode);
            if (children.isEmpty()) {
                return eachNode;
            }
            eachNode = LightTreeUtil.findChildAtOffset(offset, children);
        }
        return null;
    }

    private static LighterASTNode findChildAtOffset(int offset, List<LighterASTNode> children) {
        return (LighterASTNode)((Object)ContainerUtil.find(children, node -> LightTreeUtil.containsOffset(node, offset)));
    }

    private static boolean containsOffset(LighterASTNode node, int offset) {
        return node.getStartOffset() <= offset && node.getEndOffset() > offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 10: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/LightTreeUtil";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/LightTreeUtil";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredChildOfType";
                break;
            }
            case 15: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "toFilteredString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "firstChildOfType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requiredChildOfType";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 22: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "toFilteredString";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "toBuffer";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findLeafElementAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

