/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiUtil
extends PsiUtilCore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PsiUtil");
    public static final int ACCESS_LEVEL_PUBLIC = 4;
    public static final int ACCESS_LEVEL_PROTECTED = 3;
    public static final int ACCESS_LEVEL_PACKAGE_LOCAL = 2;
    public static final int ACCESS_LEVEL_PRIVATE = 1;
    public static final Key<Boolean> VALID_VOID_TYPE_IN_CODE_FRAGMENT = Key.create("VALID_VOID_TYPE_IN_CODE_FRAGMENT");
    private static final Set<String> IGNORED_NAMES = ContainerUtil.newTroveSet("ignore", "ignore1", "ignore2", "ignore3", "ignore4", "ignore5", "ignored", "ignored1", "ignored2", "ignored3", "ignored4", "ignored5");
    private static final String[] accessModifiers = new String[]{"private", "packageLocal", "protected", "public"};
    public static final Key<LanguageLevel> FILE_LANGUAGE_LEVEL_KEY = Key.create("FORCE_LANGUAGE_LEVEL");
    public static final Comparator<PsiElement> BY_POSITION = (o1, o2) -> PsiUtil.compareElementsByPosition(o1, o2);

    private PsiUtil() {
    }

    public static boolean isOnAssignmentLeftHand(@NotNull PsiExpression expr) {
        PsiElement parent;
        if (expr == null) {
            PsiUtil.$$$reportNull$$$0(0);
        }
        return (parent = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class)) instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent).getLExpression(), expr, false);
    }

    public static boolean isAccessibleFromPackage(@NotNull PsiModifierListOwner element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(1);
        }
        if (aPackage == null) {
            PsiUtil.$$$reportNull$$$0(2);
        }
        if (element.hasModifierProperty("public")) {
            return true;
        }
        return !element.hasModifierProperty("private") && JavaPsiFacade.getInstance(element.getProject()).isInPackage(element, aPackage);
    }

    public static boolean isAccessedForWriting(@NotNull PsiExpression expr) {
        if (expr == null) {
            PsiUtil.$$$reportNull$$$0(3);
        }
        if (PsiUtil.isOnAssignmentLeftHand(expr)) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return PsiUtil.isIncrementDecrementOperation(parent);
    }

    public static boolean isAccessedForReading(@NotNull PsiExpression expr) {
        PsiElement parent;
        if (expr == null) {
            PsiUtil.$$$reportNull$$$0(4);
        }
        return !((parent = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class)) instanceof PsiAssignmentExpression) || !PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent).getLExpression(), expr, false) || ((PsiAssignmentExpression)parent).getOperationTokenType() != JavaTokenType.EQ;
    }

    public static boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(5);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(6);
        }
        return PsiUtil.isAccessible(place.getProject(), member, place, accessObjectClass);
    }

    public static boolean isAccessible(@NotNull Project project, @NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(7);
        }
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(8);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(9);
        }
        return JavaPsiFacade.getInstance(project).getResolveHelper().isAccessible(member, place, accessObjectClass);
    }

    @NotNull
    public static JavaResolveResult getAccessObjectClass(@NotNull PsiExpression expression) {
        JavaResolveResult resolveResult;
        if (expression == null) {
            PsiUtil.$$$reportNull$$$0(10);
        }
        if (expression instanceof PsiSuperExpression) {
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(11);
            }
            return javaResolveResult;
        }
        PsiType type = expression.getType();
        JavaResolveResult accessObject = PsiUtil.getAccessObjectClass(type, expression.getProject());
        if (accessObject != null) {
            JavaResolveResult javaResolveResult = accessObject;
            if (javaResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(12);
            }
            return javaResolveResult;
        }
        if (type == null && expression instanceof PsiReferenceExpression && (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement() instanceof PsiClass) {
            JavaResolveResult javaResolveResult = resolveResult;
            if (javaResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(13);
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiUtil.$$$reportNull$$$0(14);
        }
        return javaResolveResult;
    }

    private static JavaResolveResult getAccessObjectClass(PsiType type, Project project) {
        PsiType upperBound;
        PsiType lub;
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolveGenerics();
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolveGenerics();
        }
        if (type instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)type).getUpperBound()) instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)upperBound).resolve();
            PsiFile containingFile = resolved != null ? resolved.getContainingFile() : null;
            String packageName = containingFile instanceof PsiClassOwner ? ((PsiClassOwner)containingFile).getPackageName() : null;
            String classText = StringUtil.isEmptyOrSpaces(packageName) ? "" : "package " + packageName + ";\n ";
            classText = classText + "class I<T extends " + upperBound.getCanonicalText() + "> {}";
            PsiJavaFile file = (PsiJavaFile)PsiFileFactory.getInstance(project).createFileFromText("inference_dummy.java", JavaLanguage.INSTANCE, (CharSequence)classText);
            PsiTypeParameter freshParameter = file.getClasses()[0].getTypeParameters()[0];
            return new ClassCandidateInfo(freshParameter, PsiSubstitutor.EMPTY);
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.getAccessObjectClass(((PsiArrayType)type).getComponentType(), project);
        }
        return null;
    }

    public static boolean isConstantExpression(@Nullable PsiExpression expression) {
        return expression != null && JavaPsiFacade.getInstance(expression.getProject()).isConstantExpression(expression);
    }

    public static void addException(@NotNull PsiMethod method, @NotNull @NonNls String exceptionFQName) throws IncorrectOperationException {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(15);
        }
        if (exceptionFQName == null) {
            PsiUtil.$$$reportNull$$$0(16);
        }
        PsiClass exceptionClass = JavaPsiFacade.getInstance(method.getProject()).findClass(exceptionFQName, method.getResolveScope());
        PsiUtil.addException(method, exceptionClass, exceptionFQName);
    }

    public static void addException(@NotNull PsiMethod method, @NotNull PsiClass exceptionClass) throws IncorrectOperationException {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(17);
        }
        if (exceptionClass == null) {
            PsiUtil.$$$reportNull$$$0(18);
        }
        PsiUtil.addException(method, exceptionClass, exceptionClass.getQualifiedName());
    }

    private static void addException(@NotNull PsiMethod method, @Nullable PsiClass exceptionClass, @Nullable String exceptionName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(19);
        }
        assert (exceptionClass != null || exceptionName != null) : "One of exceptionName, exceptionClass must be not null";
        PsiReferenceList throwsList = method.getThrowsList();
        PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
        boolean replaced = false;
        for (PsiJavaCodeReferenceElement ref2 : refs) {
            if (ref2.isReferenceTo(exceptionClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)ref2.resolve();
            if (exceptionClass == null || aClass == null) continue;
            if (aClass.isInheritor(exceptionClass, true)) {
                PsiJavaCodeReferenceElement ref1;
                if (replaced) {
                    ref2.delete();
                    continue;
                }
                PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
                if (exceptionName != null) {
                    ref1 = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
                } else {
                    PsiClassType type = factory.createType(exceptionClass);
                    ref1 = factory.createReferenceElementByType(type);
                }
                ref2.replace(ref1);
                replaced = true;
                continue;
            }
            if (!exceptionClass.isInheritor(aClass, true)) continue;
            return;
        }
        if (replaced) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        if (exceptionName != null) {
            ref = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
        } else {
            PsiClassType type = factory.createType(exceptionClass);
            ref = factory.createReferenceElementByType(type);
        }
        throwsList.add(ref);
    }

    public static void removeException(@NotNull PsiMethod method, @NonNls String exceptionClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(20);
        }
        for (PsiJavaCodeReferenceElement ref : refs = method.getThrowsList().getReferenceElements()) {
            if (!ref.getCanonicalText().equals(exceptionClass)) continue;
            ref.delete();
        }
    }

    public static boolean isVariableNameUnique(@NotNull String name, @NotNull PsiElement place) {
        PsiResolveHelper helper;
        if (name == null) {
            PsiUtil.$$$reportNull$$$0(21);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(22);
        }
        return (helper = JavaPsiFacade.getInstance(place.getProject()).getResolveHelper()).resolveAccessibleReferencedVariable(name, place) == null;
    }

    @Nullable
    public static PsiElement getTopLevelEnclosingCodeBlock(@Nullable PsiElement element, PsiElement scope) {
        PsiElement blockSoFar = null;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpression) || parent instanceof PsiLambdaExpression) {
                if (element instanceof PsiCodeBlock || element instanceof PsiForStatement || element instanceof PsiForeachStatement) {
                    blockSoFar = element;
                }
                if (parent instanceof PsiMethod && parent.getParent() instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)parent.getParent()) || parent instanceof PsiClassInitializer && !(parent.getParent() instanceof PsiAnonymousClass)) break;
                if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                    blockSoFar = element;
                }
                if (parent instanceof PsiClassLevelDeclarationStatement) {
                    parent = parent.getParent();
                }
                if (element instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)element)) break;
                if (element instanceof PsiFile && PsiUtilCore.getTemplateLanguageFile(element) != null) {
                    return element;
                }
            }
            if (element == scope) break;
            element = parent;
        }
        return blockSoFar;
    }

    public static boolean isLocalOrAnonymousClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(23);
        }
        return psiClass instanceof PsiAnonymousClass || PsiUtil.isLocalClass(psiClass);
    }

    public static boolean isLocalClass(@NotNull PsiClass psiClass) {
        PsiElement parent;
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(24);
        }
        if ((parent = psiClass.getParent()) instanceof PsiDeclarationStatement && parent.getParent() instanceof PsiCodeBlock) {
            return true;
        }
        if (parent instanceof PsiClass) {
            return PsiUtil.isLocalOrAnonymousClass((PsiClass)parent);
        }
        return false;
    }

    public static boolean isAbstractClass(@NotNull PsiClass clazz) {
        PsiModifierList modifierList;
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(25);
        }
        return (modifierList = clazz.getModifierList()) != null && modifierList.hasModifierProperty("abstract");
    }

    @Nullable
    public static PsiElement getVariableCodeBlock(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            PsiUtil.$$$reportNull$$$0(26);
        }
        PsiElement codeBlock = null;
        if (variable instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)variable).getDeclarationScope();
            if (declarationScope instanceof PsiCatchSection) {
                codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
            } else if (declarationScope instanceof PsiForeachStatement) {
                codeBlock = ((PsiForeachStatement)declarationScope).getBody();
            } else if (declarationScope instanceof PsiMethod) {
                codeBlock = ((PsiMethod)declarationScope).getBody();
            } else if (declarationScope instanceof PsiLambdaExpression) {
                codeBlock = ((PsiLambdaExpression)declarationScope).getBody();
            }
        } else {
            if (variable instanceof PsiResourceVariable) {
                PsiElement resourceList = variable.getParent();
                return resourceList != null ? resourceList.getParent() : null;
            }
            if (variable instanceof PsiLocalVariable && variable.getParent() instanceof PsiForStatement) {
                return variable.getParent();
            }
            if (variable instanceof PsiField && context != null) {
                PsiClass aClass = ((PsiField)variable).getContainingClass();
                while (context != null && context.getParent() != aClass) {
                    if (!((context = context.getParent()) instanceof PsiClassLevelDeclarationStatement)) continue;
                    return null;
                }
                return context instanceof PsiMethod ? ((PsiMethod)context).getBody() : (context instanceof PsiClassInitializer ? ((PsiClassInitializer)context).getBody() : null);
            }
            PsiElement scope = variable.getParent() == null ? null : variable.getParent().getParent();
            codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock(variable, scope);
            if (codeBlock != null && codeBlock.getParent() instanceof PsiSwitchStatement) {
                codeBlock = codeBlock.getParent().getParent();
            }
        }
        return codeBlock;
    }

    @Contract(value="null -> false")
    public static boolean isIncrementDecrementOperation(@Nullable PsiElement element) {
        if (element instanceof PsiUnaryExpression) {
            IElementType sign = ((PsiUnaryExpression)element).getOperationTokenType();
            return sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS;
        }
        return false;
    }

    @AccessLevel
    public static int getAccessLevel(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            PsiUtil.$$$reportNull$$$0(27);
        }
        if (modifierList.hasModifierProperty("private")) {
            return 1;
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            return 2;
        }
        if (modifierList.hasModifierProperty("protected")) {
            return 3;
        }
        return 4;
    }

    @PsiModifier.ModifierConstant
    @NotNull
    public static String getAccessModifier(@AccessLevel int accessLevel) {
        String modifier;
        assert (accessLevel > 0 && accessLevel <= accessModifiers.length) : accessLevel;
        String string = modifier = accessModifiers[accessLevel - 1];
        if (string == null) {
            PsiUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    public static boolean isStatement(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(29);
        }
        PsiElement parent = element.getParent();
        if (element instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions;
            if (!(parent instanceof PsiForStatement)) {
                return false;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            if (element != forStatement.getInitialization() && element != forStatement.getUpdate()) {
                return false;
            }
            PsiExpressionList expressionList = ((PsiExpressionListStatement)element).getExpressionList();
            for (PsiExpression expression : expressions = expressionList.getExpressions()) {
                if (PsiUtil.isStatement(expression)) continue;
                return false;
            }
            return true;
        }
        if (element instanceof PsiExpressionStatement) {
            return PsiUtil.isStatement(((PsiExpressionStatement)element).getExpression());
        }
        if (element instanceof PsiDeclarationStatement) {
            if (parent instanceof PsiCodeBlock) {
                return true;
            }
            if (parent instanceof PsiCodeFragment) {
                return true;
            }
            if (!(parent instanceof PsiForStatement) || ((PsiForStatement)parent).getBody() == element) {
                return false;
            }
        }
        if (element instanceof PsiStatement) {
            return true;
        }
        if (element instanceof PsiAssignmentExpression) {
            return true;
        }
        if (PsiUtil.isIncrementDecrementOperation(element)) {
            return true;
        }
        if (element instanceof PsiMethodCallExpression) {
            return true;
        }
        if (element instanceof PsiNewExpression) {
            return !(((PsiNewExpression)element).getType() instanceof PsiArrayType);
        }
        return element instanceof PsiCodeBlock;
    }

    @Nullable
    public static PsiElement getEnclosingStatement(PsiElement element) {
        while (element != null) {
            if (element.getParent() instanceof PsiCodeBlock) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement getElementInclusiveRange(@NotNull PsiElement scope, @NotNull TextRange range) {
        PsiElement psiElement;
        if (scope == null) {
            PsiUtil.$$$reportNull$$$0(30);
        }
        if (range == null) {
            PsiUtil.$$$reportNull$$$0(31);
        }
        for (psiElement = scope.findElementAt(range.getStartOffset()); psiElement != null && !psiElement.getTextRange().contains(range); psiElement = psiElement.getParent()) {
            if (psiElement != scope) continue;
            return null;
        }
        return psiElement;
    }

    @Nullable
    public static PsiClass resolveClassInType(@Nullable PsiType type) {
        PsiType lub;
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveClassInType(((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolve();
        }
        return null;
    }

    @Nullable
    public static PsiClass resolveClassInClassTypeOnly(@Nullable PsiType type) {
        return type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
    }

    @NotNull
    public static PsiClassType.ClassResolveResult resolveGenericsClassInType(@Nullable PsiType type) {
        PsiType lub;
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
            if (classResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(32);
            }
            return classResolveResult;
        }
        if (type instanceof PsiArrayType) {
            PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType(((PsiArrayType)type).getComponentType());
            if (classResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(33);
            }
            return classResolveResult;
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)lub).resolveGenerics();
            if (classResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(34);
            }
            return classResolveResult;
        }
        PsiClassType.ClassResolveResult classResolveResult = PsiClassType.ClassResolveResult.EMPTY;
        if (classResolveResult == null) {
            PsiUtil.$$$reportNull$$$0(35);
        }
        return classResolveResult;
    }

    @NotNull
    public static PsiType convertAnonymousToBaseType(@NotNull PsiType type) {
        PsiClass psiClass;
        if (type == null) {
            PsiUtil.$$$reportNull$$$0(36);
        }
        if ((psiClass = PsiUtil.resolveClassInType(type)) instanceof PsiAnonymousClass) {
            type = PsiTypesUtil.createArrayType(((PsiAnonymousClass)psiClass).getBaseClassType(), type.getArrayDimensions());
        }
        PsiType psiType = type;
        if (psiType == null) {
            PsiUtil.$$$reportNull$$$0(37);
        }
        return psiType;
    }

    public static boolean isApplicable(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpressionList argList) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(38);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(39);
        }
        if (argList == null) {
            PsiUtil.$$$reportNull$$$0(40);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList) != 1;
    }

    public static boolean isApplicable(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpression[] argList) {
        PsiType[] types;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(41);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(42);
        }
        if (argList == null) {
            PsiUtil.$$$reportNull$$$0(43);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, types = ContainerUtil.map2Array(argList, PsiType.class, PsiExpression.EXPRESSION_TO_TYPE), PsiUtil.getLanguageLevel(method)) != 1;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpressionList argList) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(44);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(45);
        }
        if (argList == null) {
            PsiUtil.$$$reportNull$$$0(46);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList.getExpressionTypes(), PsiUtil.getLanguageLevel(argList));
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiType[] args, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(47);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(48);
        }
        if (args == null) {
            PsiUtil.$$$reportNull$$$0(49);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(50);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args, languageLevel, true, true);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiType[] args, @NotNull LanguageLevel languageLevel, boolean allowUncheckedConversion, boolean checkVarargs) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(51);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(52);
        }
        if (args == null) {
            PsiUtil.$$$reportNull$$$0(53);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(54);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args, languageLevel, allowUncheckedConversion, checkVarargs, ApplicabilityChecker.ASSIGNABILITY_CHECKER);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiType[] args, @NotNull LanguageLevel languageLevel, boolean allowUncheckedConversion, boolean checkVarargs, @NotNull ApplicabilityChecker function) {
        boolean isRaw;
        PsiParameter[] parms;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(55);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(56);
        }
        if (args == null) {
            PsiUtil.$$$reportNull$$$0(57);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(58);
        }
        if (function == null) {
            PsiUtil.$$$reportNull$$$0(59);
        }
        if (args.length < (parms = method.getParameterList().getParameters()).length - 1) {
            return 1;
        }
        PsiClass containingClass = method.getContainingClass();
        boolean bl = isRaw = containingClass != null && PsiUtil.isRawSubstitutor(method, substitutorForMethod) && PsiUtil.isRawSubstitutor(containingClass, substitutorForMethod);
        if (!PsiUtil.areFirstArgumentsApplicable(args, parms, languageLevel, substitutorForMethod, isRaw, allowUncheckedConversion, function)) {
            return 1;
        }
        if (args.length == parms.length) {
            PsiType erasedParamType;
            if (parms.length == 0) {
                return 3;
            }
            PsiType parmType = PsiUtil.getParameterType(parms[parms.length - 1], languageLevel, substitutorForMethod);
            PsiType argType = args[args.length - 1];
            if (argType == null) {
                return 1;
            }
            if (function.isApplicable(parmType, argType, allowUncheckedConversion, parms.length - 1)) {
                return 3;
            }
            if (isRaw && (erasedParamType = TypeConversionUtil.erasure(parmType)) != null && function.isApplicable(erasedParamType, argType, allowUncheckedConversion, parms.length - 1)) {
                return 3;
            }
        }
        if (checkVarargs && method.isVarArgs() && languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0) {
            PsiParameter lastParameter;
            if (args.length < parms.length) {
                return 2;
            }
            PsiParameter psiParameter = lastParameter = parms.length == 0 ? null : parms[parms.length - 1];
            if (lastParameter == null || !lastParameter.isVarArgs()) {
                return 1;
            }
            PsiType lastParmType = PsiUtil.getParameterType(lastParameter, languageLevel, substitutorForMethod);
            if (!(lastParmType instanceof PsiArrayType)) {
                return 1;
            }
            if ((lastParmType = ((PsiArrayType)lastParmType).getComponentType()) instanceof PsiCapturedWildcardType && !JavaVersionService.getInstance().isAtLeast(((PsiCapturedWildcardType)lastParmType).getContext(), JavaSdkVersion.JDK_1_8)) {
                lastParmType = ((PsiCapturedWildcardType)lastParmType).getWildcard();
            }
            if (lastParmType instanceof PsiClassType) {
                lastParmType = ((PsiClassType)lastParmType).setLanguageLevel(languageLevel);
            }
            for (int i = parms.length - 1; i < args.length; ++i) {
                PsiType argType = args[i];
                if (argType != null && function.isApplicable(lastParmType, argType, allowUncheckedConversion, i)) continue;
                return 1;
            }
            return 2;
        }
        return 1;
    }

    private static boolean areFirstArgumentsApplicable(@NotNull PsiType[] args, @NotNull PsiParameter[] parms, @NotNull LanguageLevel languageLevel, @NotNull PsiSubstitutor substitutorForMethod, boolean isRaw, boolean allowUncheckedConversion, ApplicabilityChecker function) {
        if (args == null) {
            PsiUtil.$$$reportNull$$$0(60);
        }
        if (parms == null) {
            PsiUtil.$$$reportNull$$$0(61);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(62);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(63);
        }
        for (int i = 0; i < parms.length - 1; ++i) {
            PsiType substErasure;
            PsiType type = args[i];
            if (type == null) {
                return false;
            }
            PsiParameter parameter = parms[i];
            PsiType substitutedParmType = PsiUtil.getParameterType(parameter, languageLevel, substitutorForMethod);
            if (!(isRaw ? (substErasure = TypeConversionUtil.erasure(substitutedParmType)) != null && !function.isApplicable(substErasure, type, allowUncheckedConversion, i) : !function.isApplicable(substitutedParmType, type, allowUncheckedConversion, i))) continue;
            return false;
        }
        return true;
    }

    private static PsiType getParameterType(@NotNull PsiParameter parameter, @NotNull LanguageLevel languageLevel, @NotNull PsiSubstitutor substitutor) {
        PsiType parmType;
        if (parameter == null) {
            PsiUtil.$$$reportNull$$$0(64);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(65);
        }
        if (substitutor == null) {
            PsiUtil.$$$reportNull$$$0(66);
        }
        if ((parmType = parameter.getType()) instanceof PsiClassType) {
            parmType = ((PsiClassType)parmType).setLanguageLevel(languageLevel);
        }
        return substitutor.substitute(parmType);
    }

    public static boolean equalOnEquivalentClasses(PsiClassType thisClassType, @NotNull PsiClass aClass, PsiClassType otherClassType, @NotNull PsiClass bClass) {
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(67);
        }
        if (bClass == null) {
            PsiUtil.$$$reportNull$$$0(68);
        }
        PsiClassType capture1 = !PsiCapturedWildcardType.isCapture() ? thisClassType : (PsiClassType)PsiUtil.captureToplevelWildcards(thisClassType, aClass);
        PsiClassType capture2 = !PsiCapturedWildcardType.isCapture() ? otherClassType : (PsiClassType)PsiUtil.captureToplevelWildcards(otherClassType, bClass);
        PsiClassType.ClassResolveResult result1 = capture1.resolveGenerics();
        PsiClassType.ClassResolveResult result2 = capture2.resolveGenerics();
        return PsiUtil.equalOnEquivalentClasses(result1.getSubstitutor(), aClass, result2.getSubstitutor(), bClass);
    }

    private static boolean equalOnEquivalentClasses(@NotNull PsiSubstitutor s1, @NotNull PsiClass aClass, @NotNull PsiSubstitutor s2, @NotNull PsiClass bClass) {
        PsiTypeParameter[] typeParameters2;
        if (s1 == null) {
            PsiUtil.$$$reportNull$$$0(69);
        }
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(70);
        }
        if (s2 == null) {
            PsiUtil.$$$reportNull$$$0(71);
        }
        if (bClass == null) {
            PsiUtil.$$$reportNull$$$0(72);
        }
        if (aClass.hasTypeParameters() != bClass.hasTypeParameters()) {
            return true;
        }
        PsiTypeParameter[] typeParameters1 = aClass.getTypeParameters();
        if (typeParameters1.length != (typeParameters2 = bClass.getTypeParameters()).length) {
            return false;
        }
        for (int i = 0; i < typeParameters1.length; ++i) {
            PsiType substituted2 = s2.substitute(typeParameters2[i]);
            PsiType substituted1 = s1.substitute(typeParameters1[i]);
            if (Comparing.equal(substituted1, substituted2)) continue;
            return false;
        }
        if (aClass.hasModifierProperty("static")) {
            return true;
        }
        PsiClass containingClass1 = aClass.getContainingClass();
        PsiClass containingClass2 = bClass.getContainingClass();
        if (containingClass1 != null && containingClass2 != null) {
            return PsiUtil.equalOnEquivalentClasses(s1, containingClass1, s2, containingClass2);
        }
        return containingClass1 == null && containingClass2 == null;
    }

    public static boolean isCompileTimeConstant(@NotNull PsiField field) {
        if (field == null) {
            PsiUtil.$$$reportNull$$$0(73);
        }
        return PsiUtil.isCompileTimeConstant((PsiVariable)field);
    }

    public static boolean isCompileTimeConstant(@NotNull PsiVariable field) {
        if (field == null) {
            PsiUtil.$$$reportNull$$$0(74);
        }
        return field.hasModifierProperty("final") && (TypeConversionUtil.isPrimitiveAndNotNull(field.getType()) || field.getType().equalsToText("java.lang.String")) && field.hasInitializer() && PsiUtil.isConstantExpression(field.getInitializer());
    }

    public static boolean allMethodsHaveSameSignature(@NotNull PsiMethod[] methods) {
        if (methods == null) {
            PsiUtil.$$$reportNull$$$0(75);
        }
        if (methods.length == 0) {
            return true;
        }
        MethodSignature methodSignature = methods[0].getSignature(PsiSubstitutor.EMPTY);
        for (int i = 1; i < methods.length; ++i) {
            PsiMethod method = methods[i];
            if (methodSignature.equals(method.getSignature(PsiSubstitutor.EMPTY))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiExpression deparenthesizeExpression(PsiExpression expression) {
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiTypeCastExpression)) break;
            expression = ((PsiTypeCastExpression)expression).getOperand();
        }
        return expression;
    }

    public static boolean isInnerClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(76);
        }
        return !aClass.hasModifierProperty("static") && aClass.getContainingClass() != null;
    }

    @Nullable
    public static PsiElement findModifierInList(@NotNull PsiModifierList modifierList, @NonNls String modifier) {
        PsiElement[] children;
        if (modifierList == null) {
            PsiUtil.$$$reportNull$$$0(77);
        }
        for (PsiElement child : children = modifierList.getChildren()) {
            if (!child.getText().equals(modifier)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static PsiClass getTopLevelClass(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(78);
        }
        if ((file = element.getContainingFile()) instanceof PsiClassOwner) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = ((PsiClassOwner)file).getClasses()) {
                if (!PsiTreeUtil.isAncestor(aClass, element, false)) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    public static PsiModifierListOwner getEnclosingStaticElement(@NotNull PsiElement place, @Nullable PsiClass aClass) {
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(79);
        }
        LOG.assertTrue(aClass == null || !place.isPhysical() || PsiTreeUtil.isContextAncestor(aClass, place, false));
        for (PsiElement parent = place; parent != aClass && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (!(parent instanceof PsiModifierListOwner) || !((PsiModifierListOwner)parent).hasModifierProperty("static")) continue;
            return (PsiModifierListOwner)parent;
        }
        return null;
    }

    @Nullable
    public static PsiType getTypeByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(80);
        }
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    @NotNull
    public static PsiType captureToplevelWildcards(@NotNull PsiType type, @NotNull PsiElement context) {
        PsiClassType.ClassResolveResult result2;
        PsiClass aClass;
        if (type == null) {
            PsiUtil.$$$reportNull$$$0(81);
        }
        if (context == null) {
            PsiUtil.$$$reportNull$$$0(82);
        }
        if (type instanceof PsiClassType && (aClass = (result2 = ((PsiClassType)type).resolveGenerics()).getElement()) != null) {
            PsiSubstitutor substitutor;
            PsiSubstitutor captureSubstitutor = substitutor = result2.getSubstitutor();
            for (PsiTypeParameter psiTypeParameter : PsiUtil.typeParametersIterable(aClass)) {
                PsiType substituted = substitutor.substitute(psiTypeParameter);
                if (!(substituted instanceof PsiWildcardType)) continue;
                captureSubstitutor = captureSubstitutor.put(psiTypeParameter, PsiCapturedWildcardType.create((PsiWildcardType)substituted, context, psiTypeParameter));
            }
            if (captureSubstitutor != substitutor) {
                HashMap<PsiTypeParameter, PsiType> substitutionMap = null;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiCapturedWildcardType capturedWildcard;
                    PsiType substituted = substitutor.substitute(typeParameter);
                    if (!(substituted instanceof PsiWildcardType)) continue;
                    if (substitutionMap == null) {
                        substitutionMap = new HashMap<PsiTypeParameter, PsiType>(substitutor.getSubstitutionMap());
                    }
                    LOG.assertTrue((capturedWildcard = (PsiCapturedWildcardType)captureSubstitutor.substitute(typeParameter)) != null);
                    PsiType upperBound = PsiCapturedWildcardType.captureUpperBound(typeParameter, (PsiWildcardType)substituted, captureSubstitutor);
                    if (upperBound != null) {
                        capturedWildcard.setUpperBound(upperBound);
                    }
                    substitutionMap.put(typeParameter, capturedWildcard);
                }
                if (substitutionMap != null) {
                    PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
                    PsiSubstitutor newSubstitutor = psiElementFactory.createSubstitutor(substitutionMap);
                    PsiClassType psiClassType = psiElementFactory.createType(aClass, newSubstitutor);
                    if (psiClassType == null) {
                        PsiUtil.$$$reportNull$$$0(83);
                    }
                    return psiClassType;
                }
            }
        }
        PsiType psiType = type;
        if (psiType == null) {
            PsiUtil.$$$reportNull$$$0(84);
        }
        return psiType;
    }

    public static PsiType recaptureWildcards(PsiType type, PsiElement context) {
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass != null) {
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                PsiSubstitutor resultSubstitution = null;
                for (PsiTypeParameter parameter : substitutor.getSubstitutionMap().keySet()) {
                    PsiType substitute = substitutor.substitute(parameter);
                    if (!(substitute instanceof PsiCapturedWildcardType)) continue;
                    if (resultSubstitution == null) {
                        resultSubstitution = substitutor;
                    }
                    resultSubstitution = resultSubstitution.put(parameter, ((PsiCapturedWildcardType)substitute).getWildcard());
                }
                if (resultSubstitution != null) {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory(context.getProject());
                    return PsiUtil.captureToplevelWildcards(factory.createType(aClass, resultSubstitution), context);
                }
            }
        } else if (type instanceof PsiArrayType) {
            return PsiUtil.recaptureWildcards(((PsiArrayType)type).getComponentType(), context).createArrayType();
        }
        return type;
    }

    public static boolean isInsideJavadocComment(PsiElement element) {
        return PsiTreeUtil.getParentOfType(element, PsiDocComment.class, true) != null;
    }

    @NotNull
    public static List<PsiTypeElement> getParameterTypeElements(@NotNull PsiParameter parameter) {
        PsiTypeElement typeElement;
        if (parameter == null) {
            PsiUtil.$$$reportNull$$$0(85);
        }
        List<PsiTypeElement> list = (typeElement = parameter.getTypeElement()) != null && typeElement.getType() instanceof PsiDisjunctionType ? PsiTreeUtil.getChildrenOfTypeAsList(typeElement, PsiTypeElement.class) : Collections.singletonList(typeElement);
        if (list == null) {
            PsiUtil.$$$reportNull$$$0(86);
        }
        return list;
    }

    public static void checkIsIdentifier(@NotNull PsiManager manager, String text2) throws IncorrectOperationException {
        if (manager == null) {
            PsiUtil.$$$reportNull$$$0(87);
        }
        if (!PsiNameHelper.getInstance(manager.getProject()).isIdentifier(text2)) {
            throw new IncorrectOperationException(PsiBundle.message("0.is.not.an.identifier", text2));
        }
    }

    @Nullable
    public static VirtualFile getJarFile(@NotNull PsiElement candidate) {
        VirtualFile file;
        if (candidate == null) {
            PsiUtil.$$$reportNull$$$0(88);
        }
        if ((file = candidate.getContainingFile().getVirtualFile()) != null && file.getFileSystem().getProtocol().equals("jar")) {
            return VfsUtilCore.getVirtualFileForJar(file);
        }
        return file;
    }

    public static boolean isAnnotationMethod(PsiElement element) {
        if (!(element instanceof PsiAnnotationMethod)) {
            return false;
        }
        PsiClass psiClass = ((PsiAnnotationMethod)element).getContainingClass();
        return psiClass != null && psiClass.isAnnotationType();
    }

    @PsiModifier.ModifierConstant
    public static String getMaximumModifierForMember(PsiClass aClass, boolean allowPublicAbstract) {
        String modifier = "public";
        if (!allowPublicAbstract && aClass.hasModifierProperty("abstract") && !aClass.isEnum()) {
            modifier = "protected";
        } else if (aClass.hasModifierProperty("packageLocal") || aClass.isEnum()) {
            modifier = "packageLocal";
        } else if (aClass.hasModifierProperty("private")) {
            modifier = "private";
        }
        return modifier;
    }

    @NotNull
    public static Iterator<PsiTypeParameter> typeParametersIterator(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(89);
        }
        Iterator<PsiTypeParameter> iterator = PsiUtil.typeParametersIterable(owner).iterator();
        if (iterator == null) {
            PsiUtil.$$$reportNull$$$0(90);
        }
        return iterator;
    }

    @NotNull
    public static Iterable<PsiTypeParameter> typeParametersIterable(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(91);
        }
        ArrayList<PsiTypeParameter> result2 = null;
        for (PsiTypeParameterListOwner currentOwner = owner; currentOwner != null; currentOwner = currentOwner.getContainingClass()) {
            PsiTypeParameter[] typeParameters = currentOwner.getTypeParameters();
            if (typeParameters.length > 0) {
                if (result2 == null) {
                    result2 = new ArrayList<PsiTypeParameter>(typeParameters.length);
                }
                for (int i = typeParameters.length - 1; i >= 0; --i) {
                    result2.add(typeParameters[i]);
                }
            }
            if (currentOwner.hasModifierProperty("static")) break;
        }
        if (result2 == null) {
            EmptyIterable<PsiTypeParameter> emptyIterable = EmptyIterable.getInstance();
            if (emptyIterable == null) {
                PsiUtil.$$$reportNull$$$0(92);
            }
            return emptyIterable;
        }
        ArrayList<PsiTypeParameter> arrayList = result2;
        if (arrayList == null) {
            PsiUtil.$$$reportNull$$$0(93);
        }
        return arrayList;
    }

    public static boolean canBeOverridden(@NotNull PsiMethod method) {
        PsiClass parentClass;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(94);
        }
        return (parentClass = method.getContainingClass()) != null && !method.isConstructor() && !method.hasModifierProperty("static") && !method.hasModifierProperty("final") && !method.hasModifierProperty("private") && !(parentClass instanceof PsiAnonymousClass) && !parentClass.hasModifierProperty("final");
    }

    public static boolean canBeOverriden(@NotNull PsiMethod method) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(95);
        }
        return PsiUtil.canBeOverridden(method);
    }

    @NotNull
    public static PsiElement[] mapElements(@NotNull ResolveResult[] candidates) {
        if (candidates == null) {
            PsiUtil.$$$reportNull$$$0(96);
        }
        PsiElement[] result2 = new PsiElement[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            result2[i] = candidates[i].getElement();
        }
        if (result2 == null) {
            PsiUtil.$$$reportNull$$$0(97);
        }
        return result2;
    }

    @Nullable
    public static PsiMember findEnclosingConstructorOrInitializer(PsiElement expression) {
        PsiMember parent = (PsiMember)PsiTreeUtil.getParentOfType(expression, PsiClassInitializer.class, PsiEnumConstantInitializer.class, PsiMethod.class, PsiField.class);
        if (parent instanceof PsiMethod && !((PsiMethod)parent).isConstructor()) {
            return null;
        }
        if (parent instanceof PsiField && parent.hasModifierProperty("static")) {
            return null;
        }
        return parent;
    }

    public static boolean checkName(@NotNull PsiElement element, @NotNull String name, PsiElement context) {
        PsiMetaData data;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(98);
        }
        if (name == null) {
            PsiUtil.$$$reportNull$$$0(99);
        }
        if (element instanceof PsiMetaOwner && (data = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            return name.equals(data.getName(context));
        }
        return element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName());
    }

    public static boolean isRawSubstitutor(@NotNull PsiTypeParameterListOwner owner, @NotNull PsiSubstitutor substitutor) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(100);
        }
        if (substitutor == null) {
            PsiUtil.$$$reportNull$$$0(101);
        }
        if (substitutor == PsiSubstitutor.EMPTY) {
            return false;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutor.substitute(parameter) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLanguageLevel5OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(102);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_5);
    }

    public static boolean isLanguageLevel6OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(103);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_6);
    }

    public static boolean isLanguageLevel7OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(104);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_7);
    }

    public static boolean isLanguageLevel8OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(105);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_8);
    }

    public static boolean isLanguageLevel9OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(106);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_9);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        PsiElement context;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(107);
        }
        if (element instanceof PsiDirectory) {
            LanguageLevel languageLevel = JavaDirectoryService.getInstance().getLanguageLevel((PsiDirectory)element);
            if (languageLevel == null) {
                PsiUtil.$$$reportNull$$$0(108);
            }
            return languageLevel;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiJavaFile) {
            LanguageLevel languageLevel = ((PsiJavaFile)file).getLanguageLevel();
            if (languageLevel == null) {
                PsiUtil.$$$reportNull$$$0(109);
            }
            return languageLevel;
        }
        if (file != null && (context = file.getContext()) != null) {
            if (!context.isValid()) {
                throw new PsiInvalidElementAccessException(context, "Invalid context in " + file + " of " + file.getClass());
            }
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(context);
            if (languageLevel == null) {
                PsiUtil.$$$reportNull$$$0(110);
            }
            return languageLevel;
        }
        PsiResolveHelper instance = PsiResolveHelper.SERVICE.getInstance(element.getProject());
        LanguageLevel languageLevel = instance != null ? instance.getEffectiveLanguageLevel(PsiUtil.getVirtualFile(file)) : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(111);
        }
        return languageLevel;
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull Project project) {
        LanguageLevelProjectExtension instance;
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(112);
        }
        LanguageLevel languageLevel = (instance = LanguageLevelProjectExtension.getInstance(project)) != null ? instance.getLanguageLevel() : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(113);
        }
        return languageLevel;
    }

    public static boolean isInstantiatable(@NotNull PsiClass clazz) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(114);
        }
        return !clazz.hasModifierProperty("abstract") && clazz.hasModifierProperty("public") && PsiUtil.hasDefaultConstructor(clazz);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(115);
        }
        return PsiUtil.hasDefaultConstructor(clazz, false);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz, boolean allowProtected) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(116);
        }
        return PsiUtil.hasDefaultConstructor(clazz, allowProtected, true);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz, boolean allowProtected, boolean checkModifiers) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(117);
        }
        return PsiUtil.hasDefaultCtrInHierarchy(clazz, allowProtected, checkModifiers, null);
    }

    private static boolean hasDefaultCtrInHierarchy(@NotNull PsiClass clazz, boolean allowProtected, boolean checkModifiers, @Nullable Set<PsiClass> visited) {
        PsiMethod[] constructors;
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(118);
        }
        if ((constructors = clazz.getConstructors()).length > 0) {
            for (PsiMethod cls : constructors) {
                if (checkModifiers && !cls.hasModifierProperty("public") && (!allowProtected || !cls.hasModifierProperty("protected")) || !cls.getParameterList().isEmpty()) continue;
                return true;
            }
        } else {
            PsiClass superClass = clazz.getSuperClass();
            if (superClass == null) {
                return true;
            }
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)clazz)) {
                return false;
            }
            return PsiUtil.hasDefaultCtrInHierarchy(superClass, true, true, (Set<PsiClass>)visited);
        }
        return false;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiType extractIterableTypeParameter(@Nullable PsiType psiType, boolean eraseTypeParameter) {
        PsiType type = PsiUtil.substituteTypeParameter(psiType, "java.lang.Iterable", 0, eraseTypeParameter);
        return type != null ? type : PsiUtil.substituteTypeParameter(psiType, "java.util.Collection", 0, eraseTypeParameter);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static PsiType substituteTypeParameter(@Nullable PsiType psiType, @NotNull String superClass, int typeParamIndex, boolean eraseTypeParameter) {
        if (superClass == null) {
            PsiUtil.$$$reportNull$$$0(119);
        }
        if (psiType == null) {
            return null;
        }
        if (!(psiType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)psiType;
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        if (psiClass == null) {
            return null;
        }
        PsiClass baseClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(superClass, psiClass.getResolveScope());
        if (baseClass == null) {
            return null;
        }
        return PsiUtil.substituteType(typeParamIndex, eraseTypeParameter, classResolveResult, psiClass, baseClass);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static PsiType substituteTypeParameter(@Nullable PsiType psiType, @NotNull PsiClass superClass, int typeParamIndex, boolean eraseTypeParameter) {
        if (superClass == null) {
            PsiUtil.$$$reportNull$$$0(120);
        }
        if (psiType == null) {
            return null;
        }
        if (!(psiType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)psiType;
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        if (psiClass == null) {
            return null;
        }
        return PsiUtil.substituteType(typeParamIndex, eraseTypeParameter, classResolveResult, psiClass, superClass);
    }

    @Nullable
    private static PsiType substituteType(int typeParamIndex, boolean eraseTypeParameter, PsiClassType.ClassResolveResult classResolveResult, PsiClass psiClass, PsiClass baseClass) {
        if (!psiClass.isEquivalentTo(baseClass) && !psiClass.isInheritor(baseClass, true)) {
            return null;
        }
        PsiTypeParameter[] parameters = baseClass.getTypeParameters();
        if (parameters.length <= typeParamIndex) {
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(baseClass, psiClass, classResolveResult.getSubstitutor());
        PsiType type = substitutor.substitute(parameters[typeParamIndex]);
        if (type == null && eraseTypeParameter) {
            return TypeConversionUtil.typeParameterErasure(parameters[typeParamIndex]);
        }
        return type;
    }

    public static void setModifierProperty(@NotNull PsiModifierListOwner owner, @NotNull @PsiModifier.ModifierConstant String property2, boolean value) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(121);
        }
        if (property2 == null) {
            PsiUtil.$$$reportNull$$$0(122);
        }
        PsiModifierList modifierList = owner.getModifierList();
        assert (modifierList != null) : owner;
        modifierList.setModifierProperty(property2, value);
    }

    public static boolean isTryBlock(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiTryStatement && element == ((PsiTryStatement)parent).getTryBlock();
    }

    public static boolean isElseBlock(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiIfStatement && element == ((PsiIfStatement)parent).getElseBranch();
    }

    public static boolean isJavaToken(@Nullable PsiElement element, IElementType type) {
        return element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == type;
    }

    public static boolean isJavaToken(@Nullable PsiElement element, @NotNull TokenSet types) {
        if (types == null) {
            PsiUtil.$$$reportNull$$$0(123);
        }
        return element instanceof PsiJavaToken && types.contains(((PsiJavaToken)element).getTokenType());
    }

    public static boolean isCatchParameter(@Nullable PsiElement element) {
        return element instanceof PsiParameter && element.getParent() instanceof PsiCatchSection;
    }

    public static boolean isIgnoredName(@Nullable String name) {
        return name != null && IGNORED_NAMES.contains(name);
    }

    @Nullable
    public static PsiMethod[] getResourceCloserMethodsForType(@NotNull PsiClassType resourceType) {
        PsiClass resourceClass;
        if (resourceType == null) {
            PsiUtil.$$$reportNull$$$0(124);
        }
        if ((resourceClass = resourceType.resolve()) == null) {
            return null;
        }
        Project project = resourceClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiClass autoCloseable = facade.findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope(project));
        if (autoCloseable == null) {
            return null;
        }
        if (JavaClassSupers.getInstance().getSuperClassSubstitutor(autoCloseable, resourceClass, resourceType.getResolveScope(), PsiSubstitutor.EMPTY) == null) {
            return null;
        }
        PsiMethod[] closes = autoCloseable.findMethodsByName("close", false);
        if (closes.length == 1) {
            return resourceClass.findMethodsBySignature(closes[0], true);
        }
        return null;
    }

    @Nullable
    public static PsiExpression skipParenthesizedExprDown(PsiExpression initializer) {
        while (initializer instanceof PsiParenthesizedExpression) {
            initializer = ((PsiParenthesizedExpression)initializer).getExpression();
        }
        return initializer;
    }

    public static PsiElement skipParenthesizedExprUp(PsiElement parent) {
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static void ensureValidType(@NotNull PsiType type) {
        if (type == null) {
            PsiUtil.$$$reportNull$$$0(125);
        }
        PsiUtil.ensureValidType(type, null);
    }

    public static void ensureValidType(@NotNull PsiType type, @Nullable String customMessage) {
        if (type == null) {
            PsiUtil.$$$reportNull$$$0(126);
        }
        if (!type.isValid()) {
            TimeoutUtil.sleep(1L);
            if (type.isValid()) {
                LOG.error("PsiType resurrected: " + type + " of " + type.getClass() + " " + customMessage);
                return;
            }
            if (type instanceof PsiClassType) {
                try {
                    PsiClass psiClass = ((PsiClassType)type).resolve();
                    if (psiClass != null) {
                        PsiUtil.ensureValid(psiClass);
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    throw customMessage == null ? e : new RuntimeException(customMessage, e);
                }
            }
            throw new AssertionError((Object)("Invalid type: " + type + " of class " + type.getClass() + " " + customMessage));
        }
    }

    @Nullable
    public static String getMemberQualifiedName(@NotNull PsiMember member) {
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(127);
        }
        if (member instanceof PsiClass) {
            return ((PsiClass)member).getQualifiedName();
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String className = containingClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        return className + "." + member.getName();
    }

    public static boolean isFromDefaultPackage(PsiClass aClass) {
        return PsiUtil.isFromDefaultPackage((PsiElement)aClass);
    }

    public static boolean isFromDefaultPackage(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile instanceof PsiClassOwner && StringUtil.isEmpty(((PsiClassOwner)containingFile).getPackageName());
    }

    static boolean checkSameExpression(PsiElement templateExpr, PsiExpression expression) {
        return templateExpr.equals(PsiUtil.skipParenthesizedExprDown(expression));
    }

    public static boolean isCondition(PsiElement expr, PsiElement parent) {
        return parent instanceof PsiIfStatement ? PsiUtil.checkSameExpression(expr, ((PsiIfStatement)parent).getCondition()) : (parent instanceof PsiWhileStatement ? PsiUtil.checkSameExpression(expr, ((PsiWhileStatement)parent).getCondition()) : (parent instanceof PsiForStatement ? PsiUtil.checkSameExpression(expr, ((PsiForStatement)parent).getCondition()) : (parent instanceof PsiDoWhileStatement ? PsiUtil.checkSameExpression(expr, ((PsiDoWhileStatement)parent).getCondition()) : parent instanceof PsiConditionalExpression && PsiUtil.checkSameExpression(expr, ((PsiConditionalExpression)parent).getCondition()))));
    }

    @NotNull
    public static PsiReturnStatement[] findReturnStatements(@NotNull PsiMethod method) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(128);
        }
        PsiReturnStatement[] psiReturnStatementArray = PsiUtil.findReturnStatements(method.getBody());
        if (psiReturnStatementArray == null) {
            PsiUtil.$$$reportNull$$$0(129);
        }
        return psiReturnStatementArray;
    }

    @NotNull
    public static PsiReturnStatement[] findReturnStatements(@Nullable PsiCodeBlock body) {
        ArrayList<PsiReturnStatement> vector = new ArrayList<PsiReturnStatement>();
        if (body != null) {
            PsiUtil.addReturnStatements(vector, body);
        }
        PsiReturnStatement[] psiReturnStatementArray = vector.toArray(PsiReturnStatement.EMPTY_ARRAY);
        if (psiReturnStatementArray == null) {
            PsiUtil.$$$reportNull$$$0(130);
        }
        return psiReturnStatementArray;
    }

    private static void addReturnStatements(ArrayList<PsiReturnStatement> vector, PsiElement element) {
        if (element instanceof PsiReturnStatement) {
            vector.add((PsiReturnStatement)element);
        } else if (!(element instanceof PsiClass) && !(element instanceof PsiLambdaExpression)) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                PsiUtil.addReturnStatements(vector, child);
            }
        }
    }

    public static boolean isModuleFile(@NotNull PsiFile file) {
        if (file == null) {
            PsiUtil.$$$reportNull$$$0(131);
        }
        return file instanceof PsiJavaFile && ((PsiJavaFile)file).getModuleDeclaration() != null;
    }

    public static boolean isPackageEmpty(@NotNull PsiDirectory[] directories, @NotNull String packageName) {
        if (directories == null) {
            PsiUtil.$$$reportNull$$$0(132);
        }
        if (packageName == null) {
            PsiUtil.$$$reportNull$$$0(133);
        }
        for (PsiDirectory directory : directories) {
            for (PsiFile file : directory.getFiles()) {
                if (!(file instanceof PsiClassOwner) || !packageName.equals(((PsiClassOwner)file).getPackageName()) || ((PsiClassOwner)file).getClasses().length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static PsiModifierListOwner preferCompiledElement(@NotNull PsiModifierListOwner element) {
        PsiElement original;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(134);
        }
        PsiModifierListOwner psiModifierListOwner = (original = element.getOriginalElement()) instanceof PsiModifierListOwner ? (PsiModifierListOwner)original : element;
        if (psiModifierListOwner == null) {
            PsiUtil.$$$reportNull$$$0(135);
        }
        return psiModifierListOwner;
    }

    public static PsiElement addModuleStatement(@NotNull PsiJavaModule module, @NotNull String text2) {
        if (module == null) {
            PsiUtil.$$$reportNull$$$0(136);
        }
        if (text2 == null) {
            PsiUtil.$$$reportNull$$$0(137);
        }
        PsiJavaParserFacade facade = JavaPsiFacade.getInstance(module.getProject()).getParserFacade();
        PsiStatement statement = facade.createModuleStatementFromText(text2);
        PsiElement anchor = (PsiElement)SyntaxTraverser.psiTraverser().children(module).filter(statement.getClass()).last();
        if (anchor == null) {
            anchor = SyntaxTraverser.psiTraverser().children(module).filter(e -> PsiUtil.isJavaToken(e, JavaTokenType.LBRACE)).first();
        }
        if (anchor == null) {
            throw new IllegalStateException("No anchor in " + Arrays.toString(module.getChildren()));
        }
        return module.addAfter(statement, anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 83: 
            case 84: 
            case 86: 
            case 90: 
            case 92: 
            case 93: 
            case 97: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 129: 
            case 130: 
            case 135: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 83: 
            case 84: 
            case 86: 
            case 90: 
            case 92: 
            case 93: 
            case 97: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 129: 
            case 130: 
            case 135: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: 
            case 29: 
            case 78: 
            case 80: 
            case 98: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 5: 
            case 8: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 6: 
            case 9: 
            case 22: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 83: 
            case 84: 
            case 86: 
            case 90: 
            case 92: 
            case 93: 
            case 97: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 129: 
            case 130: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiUtil";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 51: 
            case 55: 
            case 94: 
            case 95: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionFQName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 21: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 25: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 27: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 36: 
            case 81: 
            case 125: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 39: 
            case 42: 
            case 45: 
            case 48: 
            case 52: 
            case 56: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutorForMethod";
                break;
            }
            case 40: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argList";
                break;
            }
            case 49: 
            case 53: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 50: 
            case 54: 
            case 58: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parms";
                break;
            }
            case 64: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 66: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 67: 
            case 70: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 68: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bClass";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 89: 
            case 91: 
            case 100: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 119: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiUtil";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessObjectClass";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessModifier";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGenericsClassInType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAnonymousToBaseType";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "captureToplevelWildcards";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypeElements";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "typeParametersIterator";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "typeParametersIterable";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "mapElements";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "findReturnStatements";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "preferCompiledElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOnAssignmentLeftHand";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleFromPackage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForWriting";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForReading";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAccessObjectClass";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 83: 
            case 84: 
            case 86: 
            case 90: 
            case 92: 
            case 93: 
            case 97: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 129: 
            case 130: 
            case 135: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeException";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isVariableNameUnique";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isLocalOrAnonymousClass";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isLocalClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractClass";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVariableCodeBlock";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAccessLevel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isStatement";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getElementInclusiveRange";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "convertAnonymousToBaseType";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getApplicabilityLevel";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "areFirstArgumentsApplicable";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "equalOnEquivalentClasses";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isCompileTimeConstant";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "allMethodsHaveSameSignature";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isInnerClass";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findModifierInList";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelClass";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingStaticElement";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByPsiElement";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "captureToplevelWildcards";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeElements";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "checkIsIdentifier";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getJarFile";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "typeParametersIterator";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "typeParametersIterable";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "canBeOverridden";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "canBeOverriden";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "mapElements";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "isRawSubstitutor";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel5OrHigher";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel6OrHigher";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel7OrHigher";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel8OrHigher";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel9OrHigher";
                break;
            }
            case 107: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiatable";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultConstructor";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultCtrInHierarchy";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "substituteTypeParameter";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "isJavaToken";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getResourceCloserMethodsForType";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidType";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getMemberQualifiedName";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "findReturnStatements";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "isModuleFile";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "isPackageEmpty";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "preferCompiledElement";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "addModuleStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 83: 
            case 84: 
            case 86: 
            case 90: 
            case 92: 
            case 93: 
            case 97: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 129: 
            case 130: 
            case 135: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ApplicabilityChecker {
        public static final ApplicabilityChecker ASSIGNABILITY_CHECKER = new ApplicabilityChecker(){

            @Override
            public boolean isApplicable(PsiType left, PsiType right, boolean allowUncheckedConversion, int argId) {
                return TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion);
            }
        };

        public boolean isApplicable(PsiType var1, PsiType var2, boolean var3, int var4);
    }

    public static @interface AccessLevel {
    }
}

