/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SingletonSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentIntKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.IntKeyWeakValueHashMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.SoftKeySoftValueHashMap;
import com.intellij.util.containers.SoftValueHashMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.containers.WeakHashSet;
import com.intellij.util.containers.WeakKeyIntValueHashMap;
import com.intellij.util.containers.WeakKeySoftValueHashMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import com.intellij.util.containers.WeakValueHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil
extends ContainerUtilRt {
    private static final int INSERTION_SORT_THRESHOLD = 10;

    @NotNull
    @Contract(pure=true)
    public static <T> T[] ar(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(1);
        }
        return elements;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = ContainerUtilRt.newHashMap();
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(3);
        }
        HashMap<? extends K, ? extends V> hashMap = ContainerUtilRt.newHashMap(map);
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<K, ? extends V> first, Pair<K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(5);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(6);
        }
        Map<K, ? extends V> map = ContainerUtilRt.newHashMap(first, entries);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull List<K> keys, @NotNull List<V> values) {
        if (keys == null) {
            ContainerUtil.$$$reportNull$$$0(8);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(9);
        }
        Map<K, V> map = ContainerUtilRt.newHashMap(keys, values);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(10);
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        TreeMap treeMap = ContainerUtilRt.newTreeMap();
        if (treeMap == null) {
            ContainerUtil.$$$reportNull$$$0(11);
        }
        return treeMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap(@NotNull Map<K, V> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(12);
        }
        TreeMap<K, V> treeMap = ContainerUtilRt.newTreeMap(map);
        if (treeMap == null) {
            ContainerUtil.$$$reportNull$$$0(13);
        }
        return treeMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        LinkedHashMap linkedHashMap = ContainerUtilRt.newLinkedHashMap();
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        LinkedHashMap linkedHashMap = ContainerUtilRt.newLinkedHashMap(capacity);
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(15);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Map<K, V> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(16);
        }
        LinkedHashMap<K, V> linkedHashMap = ContainerUtilRt.newLinkedHashMap(map);
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(17);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<K, ? extends V> first, Pair<K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(18);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(19);
        }
        LinkedHashMap<K, ? extends V> linkedHashMap = ContainerUtilRt.newLinkedHashMap(first, entries);
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(20);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(21);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(22);
        }
        THashMap tHashMap = new THashMap(strategy);
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(23);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(@NotNull Class<K> keyType) {
        if (keyType == null) {
            ContainerUtil.$$$reportNull$$$0(24);
        }
        EnumMap enumMap = new EnumMap(keyType);
        if (enumMap == null) {
            ContainerUtil.$$$reportNull$$$0(25);
        }
        return enumMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(26);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(27);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        if (identityHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(28);
        }
        return identityHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        LinkedList linkedList = ContainerUtilRt.newLinkedList();
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(29);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(30);
        }
        LinkedList<T> linkedList = ContainerUtilRt.newLinkedList(elements);
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(31);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(32);
        }
        LinkedList<? extends T> linkedList = ContainerUtilRt.newLinkedList(elements);
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(33);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(35);
        }
        ArrayList<E> arrayList = ContainerUtilRt.newArrayList(array);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(37);
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = ContainerUtilRt.newArrayListWithCapacity(size);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(40);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        AbstractList abstractList = new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + this.size);
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(41);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newUnmodifiableList(List<? extends T> originalList) {
        int size = originalList.size();
        if (size == 0) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(42);
            }
            return list;
        }
        if (size == 1) {
            List<T> list = Collections.singletonList(originalList.get(0));
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(43);
            }
            return list;
        }
        List<? extends T> list = Collections.unmodifiableList(ContainerUtil.newArrayList(originalList));
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> unmodifiableOrEmptyCollection(Collection<? extends T> original) {
        int size = original.size();
        if (size == 0) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(45);
            }
            return list;
        }
        Collection<? extends T> collection = Collections.unmodifiableCollection(original);
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(46);
        }
        return collection;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> unmodifiableOrEmptyList(List<? extends T> original) {
        int size = original.size();
        if (size == 0) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(47);
            }
            return list;
        }
        List<? extends T> list = Collections.unmodifiableList(original);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> unmodifiableOrEmptySet(Set<? extends T> original) {
        int size = original.size();
        if (size == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(49);
            }
            return set;
        }
        Set<? extends T> set = Collections.unmodifiableSet(original);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(50);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> unmodifiableOrEmptyMap(Map<? extends K, ? extends V> original) {
        int size = original.size();
        if (size == 0) {
            Map map = Collections.emptyMap();
            if (map == null) {
                ContainerUtil.$$$reportNull$$$0(51);
            }
            return map;
        }
        Map<? extends K, ? extends V> map = Collections.unmodifiableMap(original);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(52);
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList() {
        SmartList smartList = new SmartList();
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(53);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T element) {
        SmartList<T> smartList = new SmartList<T>(element);
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(54);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(55);
        }
        SmartList<T> smartList = new SmartList<T>(elements);
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(56);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = ContainerUtilRt.newHashSet();
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(57);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(int initialCapacity) {
        HashSet hashSet = ContainerUtilRt.newHashSet(initialCapacity);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(58);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(59);
        }
        HashSet<T> hashSet = ContainerUtilRt.newHashSet(elements);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(60);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(61);
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(iterable);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(62);
        }
        return hashSet;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(63);
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(iterator);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(64);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean empty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        Set<Object> set = empty ? Collections.emptySet() : ContainerUtilRt.newHashSet(iterable);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(65);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        LinkedHashSet linkedHashSet = ContainerUtilRt.newLinkedHashSet();
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(66);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(67);
        }
        LinkedHashSet<? extends T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(elements);
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(68);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(69);
        }
        LinkedHashSet<T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(elements);
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(70);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet() {
        THashSet tHashSet = new THashSet();
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(71);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(72);
        }
        THashSet tHashSet = new THashSet(strategy);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(73);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(74);
        }
        THashSet<T> tHashSet = ContainerUtil.newTroveSet(Arrays.asList(elements));
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(75);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, T ... elements) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(76);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(77);
        }
        THashSet tHashSet = new THashSet(Arrays.asList(elements), strategy);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(78);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, @NotNull Collection<T> elements) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(79);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(80);
        }
        THashSet tHashSet = new THashSet(elements, strategy);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(81);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull Collection<T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(82);
        }
        THashSet tHashSet = new THashSet(elements);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(83);
        }
        return tHashSet;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(int initialCapacity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(@NotNull Collection<K> collection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet() {
        TreeSet treeSet = ContainerUtilRt.newTreeSet();
        if (treeSet == null) {
            ContainerUtil.$$$reportNull$$$0(89);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(90);
        }
        TreeSet<? extends T> treeSet = ContainerUtilRt.newTreeSet(elements);
        if (treeSet == null) {
            ContainerUtil.$$$reportNull$$$0(91);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(92);
        }
        TreeSet<T> treeSet = ContainerUtilRt.newTreeSet(elements);
        if (treeSet == null) {
            ContainerUtil.$$$reportNull$$$0(93);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<? super T> comparator) {
        TreeSet<? super T> treeSet = ContainerUtilRt.newTreeSet(comparator);
        if (treeSet == null) {
            ContainerUtil.$$$reportNull$$$0(94);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet() {
        Set set = Collections.newSetFromMap(ContainerUtil.newConcurrentMap());
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(95);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        if (concurrentHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(96);
        }
        return concurrentHashMap;
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> reverse(final @NotNull List<E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(97);
        }
        if (elements.isEmpty()) {
            List list = ContainerUtilRt.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(98);
            }
            return list;
        }
        AbstractList abstractList = new AbstractList<E>(){

            @Override
            public E get(int index) {
                return elements.get(elements.size() - 1 - index);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(99);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> union(@NotNull Map<? extends K, ? extends V> map, @NotNull Map<? extends K, ? extends V> map2) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(100);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(101);
        }
        THashMap result2 = new THashMap(map.size() + map2.size());
        result2.putAll(map);
        result2.putAll(map2);
        THashMap tHashMap = result2;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(102);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> union(@NotNull Set<T> set, @NotNull Set<T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(103);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        Set<T> set3 = ContainerUtil.union(set, set2);
        if (set3 == null) {
            ContainerUtil.$$$reportNull$$$0(105);
        }
        return set3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> union(@NotNull Collection<T> set, @NotNull Collection<T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(106);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(107);
        }
        THashSet result2 = new THashSet(set.size() + set2.size());
        result2.addAll(set);
        result2.addAll(set2);
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(108);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(109);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(110);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(111);
                }
                return set;
            }
        }
        Set set = Collections.unmodifiableSet(new THashSet(Arrays.asList(elements)));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(112);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(113);
        }
        ImmutableListBackedByArray immutableListBackedByArray = new ImmutableListBackedByArray(array);
        if (immutableListBackedByArray == null) {
            ContainerUtil.$$$reportNull$$$0(114);
        }
        return immutableListBackedByArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableSingletonList(E element) {
        ImmutableList<E> immutableList = ImmutableList.singleton(element);
        if (immutableList == null) {
            ContainerUtil.$$$reportNull$$$0(115);
        }
        return immutableList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(@NotNull List<E> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(116);
        }
        ImmutableListBackedByList immutableListBackedByList = new ImmutableListBackedByList(list);
        if (immutableListBackedByList == null) {
            ContainerUtil.$$$reportNull$$$0(117);
        }
        return immutableListBackedByList;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        ImmutableMapBuilder immutableMapBuilder = new ImmutableMapBuilder();
        if (immutableMapBuilder == null) {
            ContainerUtil.$$$reportNull$$$0(118);
        }
        return immutableMapBuilder;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> groupBy(@NotNull Iterable<V> collection, @NotNull NullableFunction<V, K> grouper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(119);
        }
        if (grouper == null) {
            ContainerUtil.$$$reportNull$$$0(120);
        }
        MultiMap<K, V> result2 = MultiMap.createLinked();
        for (V data : collection) {
            K key = grouper.fun(data);
            if (key == null) continue;
            result2.putValue(key, data);
        }
        if (!result2.isEmpty() && result2.keySet().iterator().next() instanceof Comparable) {
            KeyOrderedMultiMap keyOrderedMultiMap = new KeyOrderedMultiMap(result2);
            if (keyOrderedMultiMap == null) {
                ContainerUtil.$$$reportNull$$$0(121);
            }
            return keyOrderedMultiMap;
        }
        MultiMap<K, V> multiMap = result2;
        if (multiMap == null) {
            ContainerUtil.$$$reportNull$$$0(122);
        }
        return multiMap;
    }

    @Contract(pure=true)
    public static <T> T getOrElse(@NotNull List<T> elements, int i, T defaultValue) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(123);
        }
        return elements.size() > i ? elements.get(i) : defaultValue;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> intersection(@NotNull Map<K, V> map1, @NotNull Map<K, V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(124);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(125);
        }
        HashMap res = ContainerUtil.newHashMap();
        HashSet<K> keys = ContainerUtil.newHashSet();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        for (Object k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (v1 != (v2 = map2.get(k)) && (v1 == null || !v1.equals(v2))) continue;
            res.put(k, v1);
        }
        HashMap hashMap = res;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(126);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, Couple<V>> diff(@NotNull Map<K, V> map1, @NotNull Map<K, V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(127);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(128);
        }
        HashMap res = ContainerUtil.newHashMap();
        HashSet<K> keys = ContainerUtil.newHashSet();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        for (Object k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (v1 == (v2 = map2.get(k)) || v1 != null && v1.equals(v2)) continue;
            res.put(k, Couple.of(v1, v2));
        }
        HashMap hashMap = res;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(129);
        }
        return hashMap;
    }

    public static <T> void processSortedListsInOrder(@NotNull List<T> list1, @NotNull List<T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems, @NotNull Consumer<T> processor) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(130);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(131);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(132);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(133);
        }
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            T e;
            if (index1 >= list1.size()) {
                e = list2.get(index2++);
            } else if (index2 >= list2.size()) {
                e = list1.get(index1++);
            } else {
                T element2;
                T element1 = list1.get(index1);
                int c = comparator.compare(element1, element2 = list2.get(index2));
                if (c <= 0) {
                    e = element1;
                    ++index1;
                } else {
                    e = element2;
                    ++index2;
                }
                if (c == 0 && !mergeEqualItems) {
                    processor.consume(e);
                    ++index2;
                    e = element2;
                }
            }
            processor.consume(e);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> mergeSortedLists(@NotNull List<T> list1, @NotNull List<T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(134);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(135);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(136);
        }
        final ArrayList result2 = new ArrayList(list1.size() + list2.size());
        ContainerUtil.processSortedListsInOrder(list1, list2, comparator, mergeEqualItems, new Consumer<T>(){

            @Override
            public void consume(T t) {
                result2.add(t);
            }
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(137);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> subList(@NotNull List<T> list, int from) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(138);
        }
        List<T> list2 = list.subList(from, list.size());
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(139);
        }
        return list2;
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(140);
        }
        if (appendix == null) {
            ContainerUtil.$$$reportNull$$$0(141);
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> iterator) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(142);
        }
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(143);
        }
        while (iterator.hasNext()) {
            T o = iterator.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(144);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(145);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(146);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(147);
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<T> iterator) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(148);
        }
        if (!iterator.hasNext()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(149);
            }
            return list;
        }
        ArrayList list = new ArrayList();
        ContainerUtil.addAll(list, iterator);
        ArrayList arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(150);
        }
        return arrayList;
    }

    @NotNull
    public static <T> Set<T> collectSet(@NotNull Iterator<T> iterator) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(151);
        }
        if (!iterator.hasNext()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(152);
            }
            return set;
        }
        HashSet<T> hashSet = ContainerUtil.newHashSet();
        ContainerUtil.addAll(hashSet, iterator);
        HashSet<T> hashSet2 = hashSet;
        if (hashSet2 == null) {
            ContainerUtil.$$$reportNull$$$0(153);
        }
        return hashSet2;
    }

    @NotNull
    public static <K, V> Map<K, V> newMapFromKeys(@NotNull Iterator<K> keys, @NotNull Convertor<K, V> valueConvertor) {
        if (keys == null) {
            ContainerUtil.$$$reportNull$$$0(154);
        }
        if (valueConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(155);
        }
        HashMap<K, V> map = ContainerUtil.newHashMap();
        while (keys.hasNext()) {
            K key = keys.next();
            map.put(key, valueConvertor.convert(key));
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(156);
        }
        return hashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> newMapFromValues(@NotNull Iterator<V> values, @NotNull Convertor<V, K> keyConvertor) {
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(157);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(158);
        }
        HashMap<K, V> map = ContainerUtil.newHashMap();
        ContainerUtil.fillMapWithValues(map, values, keyConvertor);
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(159);
        }
        return hashMap;
    }

    public static <K, V> void fillMapWithValues(@NotNull Map<K, V> map, @NotNull Iterator<V> values, @NotNull Convertor<V, K> keyConvertor) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(160);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(161);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(162);
        }
        while (values.hasNext()) {
            V value = values.next();
            map.put(keyConvertor.convert(value), value);
        }
    }

    @NotNull
    public static <K, V> Map<K, Set<V>> classify(@NotNull Iterator<V> iterator, @NotNull Convertor<V, K> keyConvertor) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(163);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(164);
        }
        LinkedHashMap<K, LinkedHashSet<V>> hashMap = new LinkedHashMap<K, LinkedHashSet<V>>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            K key = keyConvertor.convert(value);
            LinkedHashSet<V> set = (LinkedHashSet<V>)hashMap.get(key);
            if (set == null) {
                set = new LinkedHashSet<V>();
                hashMap.put(key, set);
            }
            set.add(value);
        }
        LinkedHashMap<K, LinkedHashSet<V>> linkedHashMap = hashMap;
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(165);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> emptyIterator() {
        EmptyIterator emptyIterator = EmptyIterator.getInstance();
        if (emptyIterator == null) {
            ContainerUtil.$$$reportNull$$$0(166);
        }
        return emptyIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> emptyIterable() {
        EmptyIterable emptyIterable = EmptyIterable.getInstance();
        if (emptyIterable == null) {
            ContainerUtil.$$$reportNull$$$0(167);
        }
        return emptyIterable;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(168);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(169);
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<T> processor) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(170);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(171);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list, @NotNull Processor<T> processor) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(172);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(173);
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull T[] iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(174);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(175);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull Iterator<T> iterator, @NotNull Processor<? super T> processor) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(176);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(177);
        }
        while (iterator.hasNext()) {
            if (processor.process(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterable<V> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(178);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(179);
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, final @NotNull T equalTo) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(180);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(181);
        }
        return (T)ContainerUtil.find(iterable, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return equalTo == object || equalTo.equals(object);
            }
        });
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull Iterator<? extends T> iterator, final @NotNull T equalTo) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(182);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(183);
        }
        return ContainerUtil.find(iterator, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return equalTo == object || equalTo.equals(object);
            }
        });
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<V> iterator, @NotNull Condition<T> condition) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(184);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(185);
        }
        while (iterator.hasNext()) {
            V value = iterator.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public static <T, V extends T> V findLast(@NotNull List<V> list, @NotNull Condition<T> condition) {
        int index;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(186);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(187);
        }
        if ((index = ContainerUtil.lastIndexOf(list, condition)) < 0) {
            return null;
        }
        return list.get(index);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2Map(@NotNull T[] collection, @NotNull Function<T, Pair<K, V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(188);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(189);
        }
        Map<K, V> map = ContainerUtil.map2Map(Arrays.asList(collection), mapper);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(190);
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2Map(@NotNull Collection<? extends T> collection, @NotNull Function<T, Pair<K, V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(191);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(192);
        }
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<K, V> pair = mapper.fun(t);
            set.put(pair.first, pair.second);
        }
        THashMap tHashMap = set;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(193);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2MapNotNull(@NotNull T[] collection, @NotNull Function<T, Pair<K, V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(194);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(195);
        }
        Map<K, V> map = ContainerUtil.map2MapNotNull(Arrays.asList(collection), mapper);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(196);
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2MapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<T, Pair<K, V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(197);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(198);
        }
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<K, V> pair = mapper.fun(t);
            if (pair == null) continue;
            set.put(pair.first, pair.second);
        }
        THashMap tHashMap = set;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(199);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> map2Map(@NotNull Collection<Pair<K, V>> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(200);
        }
        THashMap result2 = new THashMap(collection.size());
        for (Pair<K, V> pair : collection) {
            result2.put(pair.first, pair.second);
        }
        THashMap tHashMap = result2;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(201);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Object[] map2Array(@NotNull T[] array, @NotNull Function<T, Object> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(202);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(203);
        }
        Object[] objectArray = ContainerUtil.map2Array(array, Object.class, mapper);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(204);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Object[] map2Array(@NotNull Collection<T> array, @NotNull Function<T, Object> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(205);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(206);
        }
        Object[] objectArray = ContainerUtil.map2Array(array, Object.class, mapper);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(207);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<? super V> aClass, @NotNull Function<T, V> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(208);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(209);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(210);
        }
        V[] VArray = ContainerUtil.map2Array(Arrays.asList(array), aClass, mapper);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(211);
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<? super V> aClass, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(212);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(213);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(214);
        }
        List<V> list = ContainerUtil.map2List(collection, mapper);
        Object[] array = (Object[])Array.newInstance(aClass, list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(215);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull V[] to, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(216);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(218);
        }
        V[] VArray = ContainerUtil.map2List(collection, mapper).toArray(to);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(219);
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(220);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(221);
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(222);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] filter(@NotNull int[] collection, @NotNull TIntProcedure condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(223);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(224);
        }
        TIntArrayList result2 = new TIntArrayList();
        for (int t : collection) {
            if (!condition.execute(t)) continue;
            result2.add(t);
        }
        int[] nArray = result2.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : result2.toNativeArray();
        if (nArray == null) {
            ContainerUtil.$$$reportNull$$$0(225);
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(226);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(227);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(228);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(229);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(231);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> filter(@NotNull Map<K, ? extends V> map, @NotNull Condition<? super K> keyFilter) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(232);
        }
        if (keyFilter == null) {
            ContainerUtil.$$$reportNull$$$0(233);
        }
        HashMap<K, V> result2 = ContainerUtil.newHashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!keyFilter.value(entry.getKey())) continue;
            result2.put(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(234);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(235);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(236);
        }
        if (collection.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(237);
            }
            return list;
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(238);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(239);
        }
        List<Object> list = ContainerUtil.findAll(collection, Condition.NOT_NULL);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(240);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> findAll(@NotNull T[] collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(241);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(242);
        }
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(243);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] findAllAsArray(@NotNull T[] collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(245);
        }
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        Object[] array = (Object[])Array.newInstance(instanceOf, list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(246);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] findAllAsArray(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(247);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(248);
        }
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        Object[] array = (Object[])Array.newInstance(instanceOf, list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(249);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] findAllAsArray(@NotNull T[] collection, @NotNull Condition<? super T> instanceOf) {
        List<Object> list;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(250);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(251);
        }
        if ((list = ContainerUtil.findAll(collection, instanceOf)).size() == collection.length) {
            if (collection == null) {
                ContainerUtil.$$$reportNull$$$0(252);
            }
            return collection;
        }
        Object[] array = (Object[])Array.newInstance(collection.getClass().getComponentType(), list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(253);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> findAll(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(254);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(255);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            T v = t;
            result2.add(v);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(256);
        }
        return smartList;
    }

    public static <T> void removeDuplicates(@NotNull Collection<T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(257);
        }
        HashSet<T> collected = ContainerUtil.newHashSet();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!collected.contains(t)) {
                collected.add(t);
                continue;
            }
            iterator.remove();
        }
    }

    @NotNull
    @Contract(pure=true)
    public static Map<String, String> stringMap(String ... keyValues) {
        if (keyValues == null) {
            ContainerUtil.$$$reportNull$$$0(258);
        }
        HashMap<String, String> result2 = ContainerUtil.newHashMap();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            result2.put(keyValues[i], keyValues[i + 1]);
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(259);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> iterate(@NotNull T[] array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(260);
        }
        Iterator iterator = array.length == 0 ? EmptyIterator.getInstance() : Arrays.asList(array).iterator();
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(261);
        }
        return iterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> iterate(final @NotNull Enumeration<T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(262);
        }
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(263);
        }
        return iterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(@NotNull T[] arrays, @NotNull Condition<? super T> condition) {
        if (arrays == null) {
            ContainerUtil.$$$reportNull$$$0(264);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(265);
        }
        Iterable<? super T> iterable = ContainerUtil.iterate(Arrays.asList(arrays), condition);
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(266);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(267);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(268);
        }
        if (collection.isEmpty()) {
            Iterable<T> iterable = ContainerUtil.emptyIterable();
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(269);
            }
            return iterable;
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator = new Iterator<T>(){
                    private final Iterator<? extends T> impl;
                    private T next;
                    {
                        this.impl = collection.iterator();
                        this.next = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result2 = this.next;
                        this.next = this.findNext();
                        return result2;
                    }

                    @Nullable
                    private T findNext() {
                        while (this.impl.hasNext()) {
                            Object each = this.impl.next();
                            if (!condition.value(each)) continue;
                            return each;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    7.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$7", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(270);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterateBackward(final @NotNull List<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(271);
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator = new Iterator<T>(){
                    private final ListIterator<? extends T> it;
                    {
                        this.it = list.listIterator(list.size());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return this.it.previous();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
                if (iterator == null) {
                    8.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$8", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(272);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, E> Iterable<Pair<T, E>> zip(final @NotNull Iterable<T> iterable1, final @NotNull Iterable<E> iterable2) {
        if (iterable1 == null) {
            ContainerUtil.$$$reportNull$$$0(273);
        }
        if (iterable2 == null) {
            ContainerUtil.$$$reportNull$$$0(274);
        }
        Iterable iterable = new Iterable<Pair<T, E>>(){

            @Override
            @NotNull
            public Iterator<Pair<T, E>> iterator() {
                Iterator iterator = new Iterator<Pair<T, E>>(){
                    private final Iterator<T> i1;
                    private final Iterator<E> i2;
                    {
                        this.i1 = iterable1.iterator();
                        this.i2 = iterable2.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i1.hasNext() && this.i2.hasNext();
                    }

                    @Override
                    public Pair<T, E> next() {
                        return Pair.create(this.i1.next(), this.i2.next());
                    }

                    @Override
                    public void remove() {
                        this.i1.remove();
                        this.i2.remove();
                    }
                };
                if (iterator == null) {
                    9.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$9", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(275);
        }
        return iterable;
    }

    public static <E> void swapElements(@NotNull List<E> list, int index1, int index2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(276);
        }
        E e1 = list.get(index1);
        E e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<?> iterator, @NotNull FilteringIterator.InstanceOf<T> instanceOf) {
        List list;
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(277);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(278);
        }
        List list2 = list = ContainerUtil.collect(FilteringIterator.create(iterator, instanceOf));
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(279);
        }
        return list2;
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(280);
        }
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(281);
        }
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(282);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(283);
        }
        for (A element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(284);
        }
        return c;
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, A ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(285);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(286);
        }
        for (A element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(287);
        }
        return c;
    }

    public static <T> boolean removeAll(@NotNull Collection<T> collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(288);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(289);
        }
        boolean modified = false;
        for (T element : elements) {
            modified |= collection.remove(element);
        }
        return modified;
    }

    public static <T> boolean retainAll(@NotNull Collection<T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(290);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(291);
        }
        boolean modified = false;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (condition.value(next)) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<T> iterable, @NotNull Class<U> aClass) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(292);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(293);
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<T> iterator, @NotNull Class<U> aClass) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(294);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(295);
        }
        return (U)ContainerUtil.find(iterator, FilteringIterator.instanceOf(aClass));
    }

    @Nullable
    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull T[] array, @NotNull Class<U> aClass) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(296);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(297);
        }
        return ContainerUtil.findInstance(Arrays.asList(array), aClass);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull V[] array, @NotNull Function<V, Collection<? extends T>> fun) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(298);
        }
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(299);
        }
        List<? extends T> list = ContainerUtil.concat(Arrays.asList(array), fun);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(300);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(@NotNull Iterable<? extends Collection<T>> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(301);
        }
        ArrayList result2 = new ArrayList();
        for (Collection<T> ts : list) {
            result2.addAll(ts);
        }
        List list2 = result2.isEmpty() ? Collections.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(302);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(boolean appendTail, @NotNull List<? extends T> list, T ... values) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(303);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(304);
        }
        List<? extends T> list2 = appendTail ? ContainerUtil.concat(list, ContainerUtil.list(values)) : ContainerUtil.concat(ContainerUtil.list(values), list);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(305);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> append(@NotNull List<? extends T> list, T ... values) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(306);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(307);
        }
        List<? extends T> list2 = ContainerUtil.concat(list, ContainerUtil.list(values));
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(308);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> prepend(@NotNull List<? extends T> list, T ... values) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(309);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(310);
        }
        List<? extends T> list2 = ContainerUtil.concat(ContainerUtil.list(values), list);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(311);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(312);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(313);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(314);
            }
            return list;
        }
        if (list1.isEmpty()) {
            List<T> list = list2;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(315);
            }
            return list;
        }
        if (list2.isEmpty()) {
            List<T> list = list1;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(316);
            }
            return list;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < size1) {
                    return list1.get(index);
                }
                return list2.get(index - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(317);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            ContainerUtil.$$$reportNull$$$0(318);
        }
        if (iterables.length == 0) {
            Iterable<T> iterable = ContainerUtil.emptyIterable();
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(319);
            }
            return iterable;
        }
        if (iterables.length == 1) {
            Iterable<? extends T> iterable = iterables[0];
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(320);
            }
            return iterable;
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i = 0; i < iterables.length; ++i) {
                    Iterable iterable = iterables[i];
                    iterators[i] = iterable.iterator();
                }
                Iterator iterator = ContainerUtil.concatIterators(iterators);
                if (iterator == null) {
                    11.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$11", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(321);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> concatIterators(Iterator<T> ... iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(322);
        }
        SequenceIterator<T> sequenceIterator = new SequenceIterator<T>(iterators);
        if (sequenceIterator == null) {
            ContainerUtil.$$$reportNull$$$0(323);
        }
        return sequenceIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> concatIterators(@NotNull Collection<Iterator<T>> iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(324);
        }
        SequenceIterator<T> sequenceIterator = new SequenceIterator<T>(iterators);
        if (sequenceIterator == null) {
            ContainerUtil.$$$reportNull$$$0(325);
        }
        return sequenceIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(final T[] ... iterables) {
        if (iterables == null) {
            ContainerUtil.$$$reportNull$$$0(326);
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator i;
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i2 = 0; i2 < iterables.length; ++i2) {
                    Object[] iterable = iterables[i2];
                    iterators[i2] = ContainerUtil.iterate(iterable);
                }
                Iterator iterator = i = ContainerUtil.concatIterators(iterators);
                if (iterator == null) {
                    12.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$12", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(327);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final List<? extends T> ... lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(328);
        }
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        if (size == 0) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(329);
            }
            return list;
        }
        final int finalSize = size;
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= 0 && index < finalSize) {
                    int from = 0;
                    for (List each : lists) {
                        if (from <= index && index < from + each.size()) {
                            return each.get(index - from);
                        }
                        from += each.size();
                    }
                    if (from != finalSize) {
                        throw new ConcurrentModificationException("The list has changed. Its size was " + finalSize + "; now it's " + from);
                    }
                }
                throw new IndexOutOfBoundsException("index: " + index + "; size: " + this.size());
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(330);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(@NotNull List<List<? extends T>> lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(331);
        }
        List[] array = lists.toArray(new List[0]);
        List<T> list = ContainerUtil.concat(array);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(332);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull Iterable<? extends V> list, @NotNull Function<V, Collection<? extends T>> listGenerator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(333);
        }
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(334);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (V v : list) {
            result2.addAll(listGenerator.fun(v));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(335);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(336);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(337);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(338);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(339);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result2.add(t);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(340);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <E extends Enum<E>> EnumSet<E> intersection(@NotNull EnumSet<E> collection1, @NotNull EnumSet<E> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(341);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(342);
        }
        EnumSet<E> result2 = EnumSet.copyOf(collection1);
        result2.retainAll(collection2);
        EnumSet<E> enumSet = result2;
        if (enumSet == null) {
            ContainerUtil.$$$reportNull$$$0(343);
        }
        return enumSet;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable List<T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> getFirstItems(@NotNull List<T> items, int maxItems) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(344);
        }
        List<T> list = items.subList(0, Math.min(maxItems, items.size()));
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(345);
        }
        return list;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T iterateAndGetLastItem(@NotNull Iterable<T> items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(346);
        }
        Iterator<T> itr = items.iterator();
        T res = null;
        while (itr.hasNext()) {
            res = itr.next();
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<T> iterator, final @NotNull Function<T, U> mapper) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(347);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(348);
        }
        Iterator iterator2 = new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(349);
        }
        return iterator2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> filterIterator(final @NotNull Iterator<T> iterator, final @NotNull Condition<T> filter) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(350);
        }
        if (filter == null) {
            ContainerUtil.$$$reportNull$$$0(351);
        }
        Iterator iterator2 = new Iterator<T>(){
            T next;
            boolean hasNext;
            {
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private void findNext() {
                this.hasNext = false;
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    if (!filter.value(t)) continue;
                    this.next = t;
                    this.hasNext = true;
                    break;
                }
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                Object result2 = this.next;
                this.findNext();
                return result2;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(352);
        }
        return iterator2;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list, @Nullable T def) {
        return ContainerUtil.isEmpty(list) ? def : list.get(list.size() - 1);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list) {
        return ContainerUtil.getLastItem(list, null);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> subtract(@NotNull Collection<T> from, @NotNull Collection<T> what) {
        if (from == null) {
            ContainerUtil.$$$reportNull$$$0(353);
        }
        if (what == null) {
            ContainerUtil.$$$reportNull$$$0(354);
        }
        HashSet<T> set = ContainerUtil.newHashSet(from);
        set.removeAll(what);
        Collection<T> collection = set.isEmpty() ? ContainerUtil.emptyList() : set;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(355);
        }
        return collection;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@Nullable Collection<T> c, @NotNull ArrayFactory<T> factory) {
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(356);
        }
        T[] TArray = c != null ? c.toArray(factory.create(c.size())) : factory.create(0);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(357);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (c1 == null) {
            ContainerUtil.$$$reportNull$$$0(358);
        }
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(359);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(360);
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(361);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeCollectionsToArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (c1 == null) {
            ContainerUtil.$$$reportNull$$$0(362);
        }
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(363);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(364);
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(365);
        }
        return TArray;
    }

    public static <T extends Comparable<T>> void sort(@NotNull List<T> list) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(366);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list.get(0);
            if (t0.compareTo(t1 = (Comparable)list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    Comparable tj;
                    Comparable ti = (Comparable)list.get(i);
                    if (ti.compareTo(tj = (Comparable)list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list);
        }
    }

    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(367);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(368);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list.get(i);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list, comparator);
        }
    }

    public static <T extends Comparable<T>> void sort(@NotNull T[] a) {
        int size;
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(369);
        }
        if ((size = a.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (t0.compareTo(t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (ti.compareTo(tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> sorted(@NotNull Collection<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(370);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(371);
        }
        List<? super T> list2 = ContainerUtil.sorted(list, comparator);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(372);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> sorted(@NotNull Iterable<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(373);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(374);
        }
        ArrayList<T> sorted = ContainerUtil.newArrayList(list);
        ContainerUtil.sort(sorted, comparator);
        ArrayList<T> arrayList = sorted;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(375);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T extends Comparable<? super T>> List<T> sorted(@NotNull Collection<T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(376);
        }
        List<T> list2 = ContainerUtil.sorted(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        });
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(377);
        }
        return list2;
    }

    public static <T> void sort(@NotNull T[] a, @NotNull Comparator<T> comparator) {
        int size;
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(378);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(379);
        }
        if ((size = a.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (comparator.compare(t0, t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a, comparator);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(380);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(381);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : iterable) {
            result2.add(mapping.fun(t));
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(382);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(383);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(384);
        }
        List<V> list = ContainerUtilRt.map2List(iterable, mapping);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(385);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, @NotNull Function<T, V> mapping) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(386);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(387);
        }
        List<V> list = ContainerUtil.mapNotNull(Arrays.asList(array), mapping);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(388);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] mapNotNull(@NotNull T[] array, @NotNull Function<T, V> mapping, @NotNull V[] emptyArray) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(389);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(390);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(391);
        }
        ArrayList<V> result2 = new ArrayList<V>(array.length);
        for (T t : array) {
            V v = mapping.fun(t);
            if (v == null) continue;
            result2.add(v);
        }
        if (result2.isEmpty()) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(392);
            }
            return emptyArray;
        }
        V[] VArray = result2.toArray(emptyArray);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(393);
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Iterable<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(394);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(395);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(396);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(397);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(398);
        }
        if (iterable.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(399);
            }
            return list;
        }
        ArrayList<T> result2 = new ArrayList<T>(iterable.size());
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(400);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> packNullables(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(401);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T element : elements) {
            ContainerUtil.addIfNotNull(list, element);
        }
        List<T> list2 = list.isEmpty() ? ContainerUtil.emptyList() : list;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(402);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull T[] array, @NotNull Function<T, V> mapping) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(403);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(404);
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            result2.add(mapping.fun(t));
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(405);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map(@NotNull T[] arr, @NotNull Function<T, V> mapping, @NotNull V[] emptyArray) {
        if (arr == null) {
            ContainerUtil.$$$reportNull$$$0(406);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(407);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(408);
        }
        if (arr.length == 0) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(409);
            }
            return emptyArray;
        }
        ArrayList<V> result2 = new ArrayList<V>(arr.length);
        for (T t : arr) {
            result2.add(mapping.fun(t));
        }
        V[] VArray = result2.toArray(emptyArray);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(410);
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> set(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(411);
        }
        HashSet<T> hashSet = ContainerUtil.newHashSet(items);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(412);
        }
        return hashSet;
    }

    public static <K, V> void putIfAbsent(K key, @Nullable V value, @NotNull Map<K, V> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(413);
        }
        if (!result2.containsKey(key)) {
            result2.put(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull Map<K, V> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(414);
        }
        if (value != null) {
            result2.put(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable Collection<? extends V> value, @NotNull MultiMap<K, V> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(415);
        }
        if (value != null) {
            result2.putValues(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull MultiMap<K, V> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(416);
        }
        if (value != null) {
            result2.putValue(key, value);
        }
    }

    public static <T> void add(final T element, final @NotNull Collection<T> result2, @NotNull Disposable parentDisposable) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(417);
        }
        if (parentDisposable == null) {
            ContainerUtil.$$$reportNull$$$0(418);
        }
        if (result2.add(element)) {
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    result2.remove(element);
                }
            });
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List<T> list = element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(419);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> createMaybeSingletonSet(@Nullable T element) {
        Set set = element == null ? Collections.emptySet() : Collections.singleton(element);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(420);
        }
        return set;
    }

    @NotNull
    public static <T, V> V getOrCreate(@NotNull Map<T, V> result2, T key, @NotNull V defaultValue) {
        V value;
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(421);
        }
        if (defaultValue == null) {
            ContainerUtil.$$$reportNull$$$0(422);
        }
        if ((value = result2.get(key)) == null) {
            value = defaultValue;
            result2.put(key, value);
        }
        V v = value;
        if (v == null) {
            ContainerUtil.$$$reportNull$$$0(423);
        }
        return v;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result2, T key, @NotNull Factory<V> factory) {
        V value;
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(424);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(425);
        }
        if ((value = result2.get(key)) == null) {
            value = factory.create();
            result2.put(key, value);
        }
        return value;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V getOrElse(@NotNull Map<T, V> result2, T key, @NotNull V defValue) {
        V value;
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(426);
        }
        if (defValue == null) {
            ContainerUtil.$$$reportNull$$$0(427);
        }
        V v = (value = result2.get(key)) == null ? defValue : value;
        if (v == null) {
            ContainerUtil.$$$reportNull$$$0(428);
        }
        return v;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(429);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(430);
        }
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(431);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(432);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(433);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(434);
        }
        return ContainerUtil.or(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(435);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(436);
        }
        return ContainerUtil.or(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(437);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(438);
        }
        return ContainerUtil.or(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(439);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(440);
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int count(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(441);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(442);
        }
        int count = 0;
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> unfold(@Nullable T t, @NotNull NullableFunction<T, T> next) {
        if (next == null) {
            ContainerUtil.$$$reportNull$$$0(443);
        }
        if (t == null) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(444);
            }
            return list;
        }
        ArrayList<T> list = new ArrayList<T>();
        while (t != null) {
            list.add(t);
            t = next.fun(t);
        }
        ArrayList<T> arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(445);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> dropTail(@NotNull List<T> items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(446);
        }
        List<T> list = items.subList(0, items.size() - 1);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(447);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> list(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(448);
        }
        List<T> list = Arrays.asList(items);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(449);
        }
        return list;
    }

    public static <T> void quickSort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(450);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(451);
        }
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(@NotNull List<T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(452);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(453);
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<T> x, Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(454);
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> singleton(T o, @NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(455);
        }
        Set<T> set = strategy == TObjectHashingStrategy.CANONICAL ? new SingletonSet<T>(o) : SingletonSet.withCustomStrategy(o, strategy);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(456);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Collection<E>[] collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(457);
        }
        List<E> list = ContainerUtil.flatten(Arrays.asList(collections));
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(458);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> removeDuplicatesFromSorted(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(459);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(460);
        }
        Object prev = null;
        ArrayList<T> result2 = null;
        for (int i = 0; i < list.size(); ++i) {
            int cmp;
            T t = list.get(i);
            if (t == null) {
                throw new IllegalArgumentException("get(" + i + ") = null");
            }
            int n = cmp = prev == null ? -1 : comparator.compare(prev, t);
            if (cmp < 0) {
                if (result2 != null) {
                    result2.add(t);
                }
            } else if (cmp == 0) {
                if (result2 == null) {
                    result2 = new ArrayList<T>(list.size());
                    result2.addAll(list.subList(0, i));
                }
            } else {
                throw new IllegalArgumentException("List must be sorted but get(" + (i - 1) + ")=" + list.get(i - 1) + " > get(" + i + ")=" + t);
            }
            prev = t;
        }
        List<T> list2 = result2 == null ? list : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(461);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(462);
        }
        ArrayList result2 = new ArrayList();
        for (Collection<E> list : collections) {
            result2.addAll(list);
        }
        List list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(463);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flattenIterables(@NotNull Iterable<? extends Iterable<E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(464);
        }
        ArrayList result2 = new ArrayList();
        for (Iterable<E> list : collections) {
            for (E e : list) {
                result2.add(e);
            }
        }
        List list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(465);
        }
        return list;
    }

    @NotNull
    public static <K, V> V[] convert(@NotNull K[] from, @NotNull V[] to, @NotNull Function<K, V> fun) {
        if (from == null) {
            ContainerUtil.$$$reportNull$$$0(466);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(467);
        }
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(468);
        }
        if (to.length < from.length) {
            Object[] array = (Object[])Array.newInstance(to.getClass().getComponentType(), from.length);
            to = array;
        }
        for (int i = 0; i < from.length; ++i) {
            to[i] = fun.fun(from[i]);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(469);
        }
        return to;
    }

    @Contract(pure=true)
    public static <T> boolean containsIdentity(@NotNull Iterable<T> list, T element) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(470);
        }
        for (T t : list) {
            if (t != element) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int indexOfIdentity(@NotNull List<T> list, T element) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(471);
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> boolean equalsIdentity(@NotNull List<T> list1, @NotNull List<T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(472);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(473);
        }
        int listSize = list1.size();
        if (list2.size() != listSize) {
            return false;
        }
        for (int i = 0; i < listSize; ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(474);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(475);
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(476);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(477);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, U extends T> U findLastInstance(@NotNull List<T> list, final @NotNull Class<U> clazz) {
        int i;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(478);
        }
        if (clazz == null) {
            ContainerUtil.$$$reportNull$$$0(479);
        }
        return (i = ContainerUtil.lastIndexOf(list, new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        })) < 0 ? null : (U)list.get(i);
    }

    @Contract(pure=true)
    public static <T, U extends T> int lastIndexOfInstance(@NotNull List<T> list, final @NotNull Class<U> clazz) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(480);
        }
        if (clazz == null) {
            ContainerUtil.$$$reportNull$$$0(481);
        }
        return ContainerUtil.lastIndexOf(list, new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        });
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<T> list, final @NotNull T object) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(482);
        }
        if (object == null) {
            ContainerUtil.$$$reportNull$$$0(483);
        }
        return ContainerUtil.indexOf(list, new Condition<T>(){

            @Override
            public boolean value(T t) {
                return t.equals(object);
            }
        });
    }

    @NotNull
    @Contract(pure=true)
    public static <A, B> Map<B, A> reverseMap(@NotNull Map<A, B> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(484);
        }
        HashMap<B, A> result2 = ContainerUtil.newHashMap();
        for (Map.Entry<A, B> entry : map.entrySet()) {
            result2.put(entry.getValue(), entry.getKey());
        }
        HashMap<B, A> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(485);
        }
        return hashMap;
    }

    @Contract(value="null -> null; !null -> !null")
    public static <T> List<T> trimToSize(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack() {
        Stack stack = ContainerUtilRt.newStack();
        if (stack == null) {
            ContainerUtil.$$$reportNull$$$0(486);
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack(@NotNull Collection<T> initial) {
        if (initial == null) {
            ContainerUtil.$$$reportNull$$$0(487);
        }
        Stack<T> stack = ContainerUtilRt.newStack(initial);
        if (stack == null) {
            ContainerUtil.$$$reportNull$$$0(488);
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack(T ... initial) {
        if (initial == null) {
            ContainerUtil.$$$reportNull$$$0(489);
        }
        Stack<T> stack = ContainerUtilRt.newStack(initial);
        if (stack == null) {
            ContainerUtil.$$$reportNull$$$0(490);
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        List list = ContainerUtilRt.emptyList();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(491);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        CopyOnWriteArrayList copyOnWriteArrayList = ContainerUtilRt.createEmptyCOWList();
        if (copyOnWriteArrayList == null) {
            ContainerUtil.$$$reportNull$$$0(492);
        }
        return copyOnWriteArrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        ConcurrentList<T> concurrentList = ContainerUtil.createConcurrentList();
        if (concurrentList == null) {
            ContainerUtil.$$$reportNull$$$0(493);
        }
        return concurrentList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList(@NotNull Collection<? extends T> c) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(494);
        }
        LockFreeCopyOnWriteArrayList<? extends T> lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList<T>(c);
        if (lockFreeCopyOnWriteArrayList == null) {
            ContainerUtil.$$$reportNull$$$0(495);
        }
        return lockFreeCopyOnWriteArrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        ConcurrentIntObjectHashMap concurrentIntObjectHashMap = new ConcurrentIntObjectHashMap();
        if (concurrentIntObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(496);
        }
        return concurrentIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        ConcurrentIntObjectHashMap concurrentIntObjectHashMap = new ConcurrentIntObjectHashMap(initialCapacity, loadFactor, concurrencyLevel);
        if (concurrentIntObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(497);
        }
        return concurrentIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectSoftValueMap() {
        ConcurrentIntKeySoftValueHashMap concurrentIntKeySoftValueHashMap = new ConcurrentIntKeySoftValueHashMap();
        if (concurrentIntKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(498);
        }
        return concurrentIntKeySoftValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        ConcurrentLongObjectHashMap concurrentLongObjectHashMap = new ConcurrentLongObjectHashMap();
        if (concurrentLongObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(499);
        }
        return concurrentLongObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap(int initialCapacity) {
        ConcurrentLongObjectHashMap concurrentLongObjectHashMap = new ConcurrentLongObjectHashMap(initialCapacity);
        if (concurrentLongObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(500);
        }
        return concurrentLongObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        ConcurrentWeakValueHashMap concurrentWeakValueHashMap = new ConcurrentWeakValueHashMap();
        if (concurrentWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(501);
        }
        return concurrentWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        ConcurrentIntKeyWeakValueHashMap concurrentIntKeyWeakValueHashMap = new ConcurrentIntKeyWeakValueHashMap();
        if (concurrentIntKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(502);
        }
        return concurrentIntKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(503);
        }
        ConcurrentWeakKeySoftValueHashMap concurrentWeakKeySoftValueHashMap = new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentWeakKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(504);
        }
        return concurrentWeakKeySoftValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(505);
        }
        ConcurrentSoftKeySoftValueHashMap concurrentSoftKeySoftValueHashMap = new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentSoftKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(506);
        }
        return concurrentSoftKeySoftValueHashMap;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(509);
        }
        ConcurrentWeakKeyWeakValueHashMap concurrentWeakKeyWeakValueHashMap = new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
        if (concurrentWeakKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(510);
        }
        return concurrentWeakKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        ConcurrentSoftValueHashMap concurrentSoftValueHashMap = new ConcurrentSoftValueHashMap();
        if (concurrentSoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(511);
        }
        return concurrentSoftValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        ConcurrentSoftHashMap concurrentSoftHashMap = new ConcurrentSoftHashMap();
        if (concurrentSoftHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(512);
        }
        return concurrentSoftHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap();
        if (concurrentWeakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(513);
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(514);
        }
        ConcurrentSoftHashMap concurrentSoftHashMap = new ConcurrentSoftHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentSoftHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(515);
        }
        return concurrentSoftHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(516);
        }
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentWeakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(517);
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(518);
        }
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap(hashingStrategy);
        if (concurrentWeakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(519);
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ConcurrentList<T> createConcurrentList() {
        LockFreeCopyOnWriteArrayList lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList();
        if (lockFreeCopyOnWriteArrayList == null) {
            ContainerUtil.$$$reportNull$$$0(520);
        }
        return lockFreeCopyOnWriteArrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ConcurrentList<T> createConcurrentList(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(521);
        }
        LockFreeCopyOnWriteArrayList<? extends T> lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList<T>(collection);
        if (lockFreeCopyOnWriteArrayList == null) {
            ContainerUtil.$$$reportNull$$$0(522);
        }
        return lockFreeCopyOnWriteArrayList;
    }

    @Deprecated
    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<T> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(523);
        }
        ContainerUtil.addIfNotNull(result2, element);
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result2, @Nullable T element) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(524);
        }
        ContainerUtilRt.addIfNotNull(result2, element);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull T[] array, @NotNull Function<T, V> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(525);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(526);
        }
        List<V> list = ContainerUtilRt.map2List(array, mapper);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(527);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(528);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(529);
        }
        List<V> list = ContainerUtilRt.map2List(collection, mapper);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(530);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> List<Pair<K, V>> map2List(@NotNull Map<K, V> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(531);
        }
        List<Pair<K, V>> list = ContainerUtilRt.map2List(map);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(532);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(533);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(534);
        }
        Set<V> set = ContainerUtilRt.map2Set(collection, mapper);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(535);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(536);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(537);
        }
        Set<V> set = ContainerUtilRt.map2Set(collection, mapper);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(538);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2LinkedSet(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(539);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(540);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(541);
            }
            return set;
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        LinkedHashSet<V> linkedHashSet = set;
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(542);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2SetNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(543);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(544);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(545);
            }
            return set;
        }
        HashSet set = new HashSet(collection.size());
        for (T t : collection) {
            V value = mapper.fun(t);
            if (value == null) continue;
            set.add(value);
        }
        Set set2 = set.isEmpty() ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(546);
        }
        return set2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(547);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(548);
        }
        T[] TArray = ContainerUtilRt.toArray(collection, array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(549);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(550);
        }
        if (sample == null) {
            ContainerUtil.$$$reportNull$$$0(551);
        }
        T[] TArray = ContainerUtilRt.toArray(c, sample);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(552);
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] copyAndClear(@NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory, boolean clear) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(553);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(554);
        }
        int size = collection.size();
        T[] a = factory.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(555);
        }
        return a;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> toCollection(@NotNull Iterable<T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(556);
        }
        ArrayList<T> arrayList = iterable instanceof Collection ? (ArrayList<T>)iterable : ContainerUtil.newArrayList(iterable);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(557);
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> toList(@NotNull Enumeration<T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(558);
        }
        if (!enumeration.hasMoreElements()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(559);
            }
            return list;
        }
        SmartList<T> result2 = new SmartList<T>();
        while (enumeration.hasMoreElements()) {
            result2.add(enumeration.nextElement());
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(560);
        }
        return smartList;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> notNullize(@Nullable List<T> list) {
        List list2 = list == null ? ContainerUtilRt.emptyList() : list;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(561);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(562);
        }
        return set2;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> notNullize(@Nullable Map<K, V> map) {
        Map map2 = map == null ? Collections.emptyMap() : map;
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(563);
        }
        return map2;
    }

    @Contract(pure=true)
    public static <T> boolean startsWith(@NotNull List<T> list, @NotNull List<T> prefix) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(564);
        }
        if (prefix == null) {
            ContainerUtil.$$$reportNull$$$0(565);
        }
        return list.size() >= prefix.size() && list.subList(0, prefix.size()).equals(prefix);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, C extends Collection<T>> C nullize(@Nullable C collection) {
        return ContainerUtil.isEmpty(collection) ? null : (C)collection;
    }

    @Contract(pure=true)
    public static <T extends Comparable<T>> int compareLexicographically(@NotNull List<T> o1, @NotNull List<T> o2) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(566);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(567);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result2 = Comparing.compare((Comparable)o1.get(i), (Comparable)o2.get(i));
            if (result2 == 0) continue;
            return result2;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    @Contract(pure=true)
    public static <T> int compareLexicographically(@NotNull List<T> o1, @NotNull List<T> o2, @NotNull Comparator<T> comparator) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(568);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(569);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(570);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result2 = comparator.compare(o1.get(i), o2.get(i));
            if (result2 == 0) continue;
            return result2;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String toString(@NotNull Map<?, ?> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(571);
        }
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        String string = sb.toString();
        if (string == null) {
            ContainerUtil.$$$reportNull$$$0(572);
        }
        return string;
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakKeySoftValueMap() {
        WeakKeySoftValueHashMap weakKeySoftValueHashMap = new WeakKeySoftValueHashMap();
        if (weakKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(573);
        }
        return weakKeySoftValueHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakKeyWeakValueMap() {
        WeakKeyWeakValueHashMap weakKeyWeakValueHashMap = new WeakKeyWeakValueHashMap();
        if (weakKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(574);
        }
        return weakKeyWeakValueHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createSoftKeySoftValueMap() {
        SoftKeySoftValueHashMap softKeySoftValueHashMap = new SoftKeySoftValueHashMap(true);
        if (softKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(575);
        }
        return softKeySoftValueHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createSoftValueMap() {
        SoftValueHashMap softValueHashMap = new SoftValueHashMap();
        if (softValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(576);
        }
        return softValueHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakValueMap() {
        WeakValueHashMap weakValueHashMap = new WeakValueHashMap();
        if (weakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(577);
        }
        return weakValueHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createSoftMap() {
        SoftHashMap softHashMap = new SoftHashMap();
        if (softHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(578);
        }
        return softHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createSoftMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(579);
        }
        SoftHashMap softHashMap = new SoftHashMap(strategy);
        if (softHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(580);
        }
        return softHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        WeakHashMap weakHashMap = new WeakHashMap();
        if (weakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(581);
        }
        return weakHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity) {
        WeakHashMap weakHashMap = new WeakHashMap(initialCapacity);
        if (weakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(582);
        }
        return weakHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(583);
        }
        WeakHashMap weakHashMap = new WeakHashMap(initialCapacity, loadFactor, strategy);
        if (weakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(584);
        }
        return weakHashMap;
    }

    @NotNull
    public static <T> Set<T> createWeakSet() {
        WeakHashSet weakHashSet = new WeakHashSet();
        if (weakHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(585);
        }
        return weakHashSet;
    }

    @NotNull
    public static <T> IntObjectMap<T> createIntKeyWeakValueMap() {
        IntKeyWeakValueHashMap intKeyWeakValueHashMap = new IntKeyWeakValueHashMap();
        if (intKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(586);
        }
        return intKeyWeakValueHashMap;
    }

    @NotNull
    public static <T> ObjectIntMap<T> createWeakKeyIntValueMap() {
        WeakKeyIntValueHashMap weakKeyIntValueHashMap = new WeakKeyIntValueHashMap();
        if (weakKeyIntValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(587);
        }
        return weakKeyIntValueHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 102: 
            case 105: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 121: 
            case 122: 
            case 126: 
            case 129: 
            case 137: 
            case 139: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 156: 
            case 159: 
            case 165: 
            case 166: 
            case 167: 
            case 190: 
            case 193: 
            case 196: 
            case 199: 
            case 201: 
            case 204: 
            case 207: 
            case 211: 
            case 215: 
            case 219: 
            case 222: 
            case 225: 
            case 228: 
            case 231: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 243: 
            case 246: 
            case 249: 
            case 252: 
            case 253: 
            case 256: 
            case 259: 
            case 261: 
            case 263: 
            case 266: 
            case 269: 
            case 270: 
            case 272: 
            case 275: 
            case 279: 
            case 284: 
            case 287: 
            case 300: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 325: 
            case 327: 
            case 329: 
            case 330: 
            case 332: 
            case 335: 
            case 340: 
            case 343: 
            case 345: 
            case 349: 
            case 352: 
            case 355: 
            case 357: 
            case 361: 
            case 365: 
            case 372: 
            case 375: 
            case 377: 
            case 382: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 396: 
            case 399: 
            case 400: 
            case 402: 
            case 405: 
            case 409: 
            case 410: 
            case 412: 
            case 419: 
            case 420: 
            case 423: 
            case 428: 
            case 444: 
            case 445: 
            case 447: 
            case 449: 
            case 456: 
            case 458: 
            case 461: 
            case 463: 
            case 465: 
            case 469: 
            case 485: 
            case 486: 
            case 488: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 495: 
            case 496: 
            case 497: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 513: 
            case 515: 
            case 517: 
            case 519: 
            case 520: 
            case 522: 
            case 527: 
            case 530: 
            case 532: 
            case 535: 
            case 538: 
            case 541: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 552: 
            case 555: 
            case 557: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 587: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 102: 
            case 105: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 121: 
            case 122: 
            case 126: 
            case 129: 
            case 137: 
            case 139: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 156: 
            case 159: 
            case 165: 
            case 166: 
            case 167: 
            case 190: 
            case 193: 
            case 196: 
            case 199: 
            case 201: 
            case 204: 
            case 207: 
            case 211: 
            case 215: 
            case 219: 
            case 222: 
            case 225: 
            case 228: 
            case 231: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 243: 
            case 246: 
            case 249: 
            case 252: 
            case 253: 
            case 256: 
            case 259: 
            case 261: 
            case 263: 
            case 266: 
            case 269: 
            case 270: 
            case 272: 
            case 275: 
            case 279: 
            case 284: 
            case 287: 
            case 300: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 325: 
            case 327: 
            case 329: 
            case 330: 
            case 332: 
            case 335: 
            case 340: 
            case 343: 
            case 345: 
            case 349: 
            case 352: 
            case 355: 
            case 357: 
            case 361: 
            case 365: 
            case 372: 
            case 375: 
            case 377: 
            case 382: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 396: 
            case 399: 
            case 400: 
            case 402: 
            case 405: 
            case 409: 
            case 410: 
            case 412: 
            case 419: 
            case 420: 
            case 423: 
            case 428: 
            case 444: 
            case 445: 
            case 447: 
            case 449: 
            case 456: 
            case 458: 
            case 461: 
            case 463: 
            case 465: 
            case 469: 
            case 485: 
            case 486: 
            case 488: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 495: 
            case 496: 
            case 497: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 513: 
            case 515: 
            case 517: 
            case 519: 
            case 520: 
            case 522: 
            case 527: 
            case 530: 
            case 532: 
            case 535: 
            case 538: 
            case 541: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 552: 
            case 555: 
            case 557: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 587: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 102: 
            case 105: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 121: 
            case 122: 
            case 126: 
            case 129: 
            case 137: 
            case 139: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 156: 
            case 159: 
            case 165: 
            case 166: 
            case 167: 
            case 190: 
            case 193: 
            case 196: 
            case 199: 
            case 201: 
            case 204: 
            case 207: 
            case 211: 
            case 215: 
            case 219: 
            case 222: 
            case 225: 
            case 228: 
            case 231: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 243: 
            case 246: 
            case 249: 
            case 252: 
            case 253: 
            case 256: 
            case 259: 
            case 261: 
            case 263: 
            case 266: 
            case 269: 
            case 270: 
            case 272: 
            case 275: 
            case 279: 
            case 284: 
            case 287: 
            case 300: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 325: 
            case 327: 
            case 329: 
            case 330: 
            case 332: 
            case 335: 
            case 340: 
            case 343: 
            case 345: 
            case 349: 
            case 352: 
            case 355: 
            case 357: 
            case 361: 
            case 365: 
            case 372: 
            case 375: 
            case 377: 
            case 382: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 396: 
            case 399: 
            case 400: 
            case 402: 
            case 405: 
            case 409: 
            case 410: 
            case 412: 
            case 419: 
            case 420: 
            case 423: 
            case 428: 
            case 444: 
            case 445: 
            case 447: 
            case 449: 
            case 456: 
            case 458: 
            case 461: 
            case 463: 
            case 465: 
            case 469: 
            case 485: 
            case 486: 
            case 488: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 495: 
            case 496: 
            case 497: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 513: 
            case 515: 
            case 517: 
            case 519: 
            case 520: 
            case 522: 
            case 527: 
            case 530: 
            case 532: 
            case 535: 
            case 538: 
            case 541: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 552: 
            case 555: 
            case 557: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 587: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 3: 
            case 12: 
            case 16: 
            case 100: 
            case 160: 
            case 232: 
            case 484: 
            case 531: 
            case 571: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 8: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 9: 
            case 157: 
            case 161: 
            case 304: 
            case 307: 
            case 310: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 22: 
            case 72: 
            case 76: 
            case 79: 
            case 455: 
            case 509: 
            case 579: 
            case 583: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 35: 
            case 113: 
            case 168: 
            case 202: 
            case 205: 
            case 208: 
            case 260: 
            case 296: 
            case 298: 
            case 386: 
            case 389: 
            case 403: 
            case 525: 
            case 548: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 37: 
            case 61: 
            case 170: 
            case 174: 
            case 178: 
            case 180: 
            case 292: 
            case 380: 
            case 383: 
            case 394: 
            case 397: 
            case 429: 
            case 431: 
            case 433: 
            case 435: 
            case 437: 
            case 439: 
            case 441: 
            case 556: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 63: 
            case 143: 
            case 148: 
            case 151: 
            case 163: 
            case 176: 
            case 182: 
            case 184: 
            case 277: 
            case 294: 
            case 347: 
            case 350: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 86: 
            case 119: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 188: 
            case 191: 
            case 194: 
            case 197: 
            case 200: 
            case 212: 
            case 216: 
            case 220: 
            case 223: 
            case 226: 
            case 229: 
            case 235: 
            case 239: 
            case 241: 
            case 244: 
            case 247: 
            case 250: 
            case 254: 
            case 257: 
            case 267: 
            case 280: 
            case 282: 
            case 285: 
            case 288: 
            case 290: 
            case 521: 
            case 528: 
            case 533: 
            case 536: 
            case 539: 
            case 543: 
            case 547: 
            case 553: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 101: 
            case 125: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 103: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 104: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 116: 
            case 138: 
            case 172: 
            case 186: 
            case 271: 
            case 276: 
            case 301: 
            case 303: 
            case 306: 
            case 309: 
            case 333: 
            case 366: 
            case 367: 
            case 370: 
            case 373: 
            case 376: 
            case 450: 
            case 459: 
            case 470: 
            case 471: 
            case 474: 
            case 476: 
            case 478: 
            case 480: 
            case 482: 
            case 564: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 124: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 130: 
            case 134: 
            case 312: 
            case 472: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 131: 
            case 135: 
            case 313: 
            case 473: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 132: 
            case 136: 
            case 368: 
            case 371: 
            case 374: 
            case 379: 
            case 451: 
            case 453: 
            case 460: 
            case 570: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 133: 
            case 171: 
            case 173: 
            case 175: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 158: 
            case 162: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 169: 
            case 179: 
            case 185: 
            case 187: 
            case 221: 
            case 224: 
            case 227: 
            case 230: 
            case 236: 
            case 265: 
            case 268: 
            case 291: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 438: 
            case 440: 
            case 442: 
            case 475: 
            case 477: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 181: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 189: 
            case 192: 
            case 195: 
            case 198: 
            case 203: 
            case 206: 
            case 210: 
            case 214: 
            case 218: 
            case 348: 
            case 526: 
            case 529: 
            case 534: 
            case 537: 
            case 540: 
            case 544: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 209: 
            case 213: 
            case 293: 
            case 295: 
            case 297: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 217: 
            case 467: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 242: 
            case 245: 
            case 248: 
            case 251: 
            case 255: 
            case 278: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 258: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValues";
                break;
            }
            case 262: 
            case 281: 
            case 558: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrays";
                break;
            }
            case 273: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 274: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 299: 
            case 468: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 318: 
            case 326: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 322: 
            case 324: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 328: 
            case 331: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 334: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 336: 
            case 338: 
            case 341: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 337: 
            case 339: 
            case 342: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 344: 
            case 346: 
            case 411: 
            case 446: 
            case 448: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 351: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 353: 
            case 466: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 354: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 356: 
            case 360: 
            case 364: 
            case 425: 
            case 554: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 358: 
            case 362: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 359: 
            case 363: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 369: 
            case 378: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 381: 
            case 384: 
            case 387: 
            case 390: 
            case 395: 
            case 398: 
            case 404: 
            case 407: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 391: 
            case 408: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 406: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 413: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 421: 
            case 424: 
            case 426: 
            case 523: 
            case 524: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 418: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 422: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 427: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 443: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 452: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 457: 
            case 462: 
            case 464: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 479: 
            case 481: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 483: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 487: 
            case 489: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 494: 
            case 550: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 503: 
            case 505: 
            case 514: 
            case 516: 
            case 518: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 551: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 565: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 566: 
            case 568: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 567: 
            case 569: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeMap";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newTroveMap";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "newEnumMap";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalStrategy";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "identityStrategy";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityHashMap";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayListWithCapacity";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyList";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptySet";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyMap";
                break;
            }
            case 53: 
            case 54: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "newSmartList";
                break;
            }
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 66: 
            case 68: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "newTroveSet";
                break;
            }
            case 84: 
            case 85: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityTroveSet";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityTroveMap";
                break;
            }
            case 89: 
            case 91: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeSet";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentMap";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "reverse";
                break;
            }
            case 102: 
            case 105: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 114: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableList";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSingletonList";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableMapBuilder";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 126: 
            case 340: 
            case 343: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 149: 
            case 150: 
            case 279: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSet";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromKeys";
                break;
            }
            case 159: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromValues";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterator";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterable";
                break;
            }
            case 190: 
            case 193: 
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Map";
                break;
            }
            case 196: 
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 204: 
            case 207: 
            case 211: 
            case 215: 
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 222: 
            case 225: 
            case 231: 
            case 234: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 228: 
            case 237: 
            case 238: 
            case 243: 
            case 256: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "skipNulls";
                break;
            }
            case 246: 
            case 249: 
            case 252: 
            case 253: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 259: {
                objectArray = objectArray2;
                objectArray2[1] = "stringMap";
                break;
            }
            case 261: 
            case 263: 
            case 266: 
            case 269: 
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 272: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 275: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 284: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 287: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 300: 
            case 302: 
            case 305: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 327: 
            case 329: 
            case 330: 
            case 332: 
            case 335: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 308: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 311: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 323: 
            case 325: {
                objectArray = objectArray2;
                objectArray2[1] = "concatIterators";
                break;
            }
            case 345: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 349: {
                objectArray = objectArray2;
                objectArray2[1] = "mapIterator";
                break;
            }
            case 352: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIterator";
                break;
            }
            case 355: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 357: 
            case 361: 
            case 549: 
            case 552: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 365: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollectionsToArray";
                break;
            }
            case 372: 
            case 375: 
            case 377: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 382: 
            case 385: 
            case 405: 
            case 409: 
            case 410: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 388: 
            case 392: 
            case 393: 
            case 396: 
            case 399: 
            case 400: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 402: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 412: {
                objectArray = objectArray2;
                objectArray2[1] = "set";
                break;
            }
            case 419: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 420: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 423: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 428: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrElse";
                break;
            }
            case 444: 
            case 445: {
                objectArray = objectArray2;
                objectArray2[1] = "unfold";
                break;
            }
            case 447: {
                objectArray = objectArray2;
                objectArray2[1] = "dropTail";
                break;
            }
            case 449: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 456: {
                objectArray = objectArray2;
                objectArray2[1] = "singleton";
                break;
            }
            case 458: 
            case 463: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 461: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 465: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenIterables";
                break;
            }
            case 469: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 485: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 486: 
            case 488: 
            case 490: {
                objectArray = objectArray2;
                objectArray2[1] = "newStack";
                break;
            }
            case 491: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 492: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyCOWList";
                break;
            }
            case 493: 
            case 495: {
                objectArray = objectArray2;
                objectArray2[1] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 496: 
            case 497: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectMap";
                break;
            }
            case 498: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectSoftValueMap";
                break;
            }
            case 499: 
            case 500: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentLongObjectMap";
                break;
            }
            case 501: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakValueMap";
                break;
            }
            case 502: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectWeakValueMap";
                break;
            }
            case 504: 
            case 507: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 506: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 508: 
            case 510: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 511: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftValueMap";
                break;
            }
            case 512: 
            case 515: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftMap";
                break;
            }
            case 513: 
            case 517: 
            case 519: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakMap";
                break;
            }
            case 520: 
            case 522: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentList";
                break;
            }
            case 527: 
            case 530: 
            case 532: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 535: 
            case 538: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 541: 
            case 542: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 545: 
            case 546: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 555: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 557: {
                objectArray = objectArray2;
                objectArray2[1] = "toCollection";
                break;
            }
            case 559: 
            case 560: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 561: 
            case 562: 
            case 563: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 572: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 573: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeySoftValueMap";
                break;
            }
            case 574: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyWeakValueMap";
                break;
            }
            case 575: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftKeySoftValueMap";
                break;
            }
            case 576: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftValueMap";
                break;
            }
            case 577: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakValueMap";
                break;
            }
            case 578: 
            case 580: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftMap";
                break;
            }
            case 581: 
            case 582: 
            case 584: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakMap";
                break;
            }
            case 585: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakSet";
                break;
            }
            case 586: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntKeyWeakValueMap";
                break;
            }
            case 587: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyIntValueMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 102: 
            case 105: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 121: 
            case 122: 
            case 126: 
            case 129: 
            case 137: 
            case 139: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 156: 
            case 159: 
            case 165: 
            case 166: 
            case 167: 
            case 190: 
            case 193: 
            case 196: 
            case 199: 
            case 201: 
            case 204: 
            case 207: 
            case 211: 
            case 215: 
            case 219: 
            case 222: 
            case 225: 
            case 228: 
            case 231: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 243: 
            case 246: 
            case 249: 
            case 252: 
            case 253: 
            case 256: 
            case 259: 
            case 261: 
            case 263: 
            case 266: 
            case 269: 
            case 270: 
            case 272: 
            case 275: 
            case 279: 
            case 284: 
            case 287: 
            case 300: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 325: 
            case 327: 
            case 329: 
            case 330: 
            case 332: 
            case 335: 
            case 340: 
            case 343: 
            case 345: 
            case 349: 
            case 352: 
            case 355: 
            case 357: 
            case 361: 
            case 365: 
            case 372: 
            case 375: 
            case 377: 
            case 382: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 396: 
            case 399: 
            case 400: 
            case 402: 
            case 405: 
            case 409: 
            case 410: 
            case 412: 
            case 419: 
            case 420: 
            case 423: 
            case 428: 
            case 444: 
            case 445: 
            case 447: 
            case 449: 
            case 456: 
            case 458: 
            case 461: 
            case 463: 
            case 465: 
            case 469: 
            case 485: 
            case 486: 
            case 488: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 495: 
            case 496: 
            case 497: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 513: 
            case 515: 
            case 517: 
            case 519: 
            case 520: 
            case 522: 
            case 527: 
            case 530: 
            case 532: 
            case 535: 
            case 538: 
            case 541: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 552: 
            case 555: 
            case 557: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 587: {
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newTreeMap";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "newTroveMap";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "newEnumMap";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 35: 
            case 37: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "newSmartList";
                break;
            }
            case 59: 
            case 61: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 67: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "newTroveSet";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "newIdentityTroveSet";
                break;
            }
            case 90: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "newTreeSet";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 113: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 123: 
            case 426: 
            case 427: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 124: 
            case 125: 
            case 338: 
            case 339: 
            case 341: 
            case 342: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 130: 
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 280: 
            case 281: 
            case 282: 
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 285: 
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 148: 
            case 277: 
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "collectSet";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 160: 
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 168: 
            case 169: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 188: 
            case 189: 
            case 191: 
            case 192: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 194: 
            case 195: 
            case 197: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 209: 
            case 210: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 220: 
            case 221: 
            case 223: 
            case 224: 
            case 229: 
            case 230: 
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 226: 
            case 227: 
            case 235: 
            case 236: 
            case 241: 
            case 242: 
            case 254: 
            case 255: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "stringMap";
                break;
            }
            case 260: 
            case 262: 
            case 264: 
            case 265: 
            case 267: 
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 271: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 273: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 288: 
            case 289: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 290: 
            case 291: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 298: 
            case 299: 
            case 301: 
            case 303: 
            case 304: 
            case 312: 
            case 313: 
            case 318: 
            case 326: 
            case 328: 
            case 331: 
            case 333: 
            case 334: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 306: 
            case 307: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 309: 
            case 310: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 322: 
            case 324: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 336: 
            case 337: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 344: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 346: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 347: 
            case 348: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 350: 
            case 351: {
                objectArray = objectArray;
                objectArray[2] = "filterIterator";
                break;
            }
            case 353: 
            case 354: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 356: 
            case 358: 
            case 359: 
            case 360: 
            case 547: 
            case 548: 
            case 550: 
            case 551: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 362: 
            case 363: 
            case 364: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollectionsToArray";
                break;
            }
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 378: 
            case 379: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 370: 
            case 371: 
            case 373: 
            case 374: 
            case 376: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 380: 
            case 381: 
            case 383: 
            case 384: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 386: 
            case 387: 
            case 389: 
            case 390: 
            case 391: 
            case 394: 
            case 395: 
            case 397: 
            case 398: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 401: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 411: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 413: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 414: 
            case 415: 
            case 416: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 417: 
            case 418: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 421: 
            case 422: 
            case 424: 
            case 425: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 429: 
            case 430: 
            case 431: 
            case 432: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 433: 
            case 434: 
            case 435: 
            case 436: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 437: 
            case 438: 
            case 439: 
            case 440: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 441: 
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 443: {
                objectArray = objectArray;
                objectArray[2] = "unfold";
                break;
            }
            case 446: {
                objectArray = objectArray;
                objectArray[2] = "dropTail";
                break;
            }
            case 448: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 450: 
            case 451: 
            case 452: 
            case 453: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 454: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 455: {
                objectArray = objectArray;
                objectArray[2] = "singleton";
                break;
            }
            case 457: 
            case 462: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 459: 
            case 460: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 464: {
                objectArray = objectArray;
                objectArray[2] = "flattenIterables";
                break;
            }
            case 466: 
            case 467: 
            case 468: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 470: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 471: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 472: 
            case 473: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 474: 
            case 475: 
            case 482: 
            case 483: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 476: 
            case 477: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 478: 
            case 479: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 480: 
            case 481: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfInstance";
                break;
            }
            case 484: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 487: 
            case 489: {
                objectArray = objectArray;
                objectArray[2] = "newStack";
                break;
            }
            case 494: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 503: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 505: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 509: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 514: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftMap";
                break;
            }
            case 516: 
            case 518: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakMap";
                break;
            }
            case 521: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 523: 
            case 524: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 525: 
            case 526: 
            case 528: 
            case 529: 
            case 531: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 533: 
            case 534: 
            case 536: 
            case 537: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 539: 
            case 540: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 543: 
            case 544: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 553: 
            case 554: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 556: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 558: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 564: 
            case 565: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 571: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 579: {
                objectArray = objectArray;
                objectArray[2] = "createSoftMap";
                break;
            }
            case 583: {
                objectArray = objectArray;
                objectArray[2] = "createWeakMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 102: 
            case 105: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 121: 
            case 122: 
            case 126: 
            case 129: 
            case 137: 
            case 139: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 156: 
            case 159: 
            case 165: 
            case 166: 
            case 167: 
            case 190: 
            case 193: 
            case 196: 
            case 199: 
            case 201: 
            case 204: 
            case 207: 
            case 211: 
            case 215: 
            case 219: 
            case 222: 
            case 225: 
            case 228: 
            case 231: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 243: 
            case 246: 
            case 249: 
            case 252: 
            case 253: 
            case 256: 
            case 259: 
            case 261: 
            case 263: 
            case 266: 
            case 269: 
            case 270: 
            case 272: 
            case 275: 
            case 279: 
            case 284: 
            case 287: 
            case 300: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 325: 
            case 327: 
            case 329: 
            case 330: 
            case 332: 
            case 335: 
            case 340: 
            case 343: 
            case 345: 
            case 349: 
            case 352: 
            case 355: 
            case 357: 
            case 361: 
            case 365: 
            case 372: 
            case 375: 
            case 377: 
            case 382: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 396: 
            case 399: 
            case 400: 
            case 402: 
            case 405: 
            case 409: 
            case 410: 
            case 412: 
            case 419: 
            case 420: 
            case 423: 
            case 428: 
            case 444: 
            case 445: 
            case 447: 
            case 449: 
            case 456: 
            case 458: 
            case 461: 
            case 463: 
            case 465: 
            case 469: 
            case 485: 
            case 486: 
            case 488: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 495: 
            case 496: 
            case 497: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 513: 
            case 515: 
            case 517: 
            case 519: 
            case 520: 
            case 522: 
            case 527: 
            case 530: 
            case 532: 
            case 535: 
            case 538: 
            case 541: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 552: 
            case 555: 
            case 557: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 587: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class KeyOrderedMultiMap<K, V>
    extends MultiMap<K, V> {
        public KeyOrderedMultiMap() {
        }

        public KeyOrderedMultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
            if (toCopy == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(0);
            }
            super(toCopy);
        }

        @Override
        @NotNull
        protected Map<K, Collection<V>> createMap() {
            TreeMap treeMap = new TreeMap();
            if (treeMap == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(1);
            }
            return treeMap;
        }

        @Override
        @NotNull
        protected Map<K, Collection<V>> createMap(int initialCapacity, float loadFactor) {
            TreeMap treeMap = new TreeMap();
            if (treeMap == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(2);
            }
            return treeMap;
        }

        @NotNull
        public NavigableSet<K> navigableKeySet() {
            NavigableSet navigableSet = ((TreeMap)this.myMap).navigableKeySet();
            if (navigableSet == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(3);
            }
            return navigableSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toCopy";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMap";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "navigableKeySet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(@NotNull E[] array) {
            if (array == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(0);
            }
            this.myStore = array;
        }

        @Override
        public E get(int index) {
            return this.myStore[index];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray", "<init>"));
        }
    }

    private static class ImmutableListBackedByList<E>
    extends ImmutableList<E> {
        private final List<E> myStore;

        private ImmutableListBackedByList(@NotNull List<E> list) {
            if (list == null) {
                ImmutableListBackedByList.$$$reportNull$$$0(0);
            }
            this.myStore = list;
        }

        @Override
        public E get(int index) {
            return this.myStore.get(index);
        }

        @Override
        public int size() {
            return this.myStore.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByList", "<init>"));
        }
    }

    public static class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new THashMap();

        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.myMap.put(key, value);
            return this;
        }

        @Contract(pure=true)
        public Map<K, V> build() {
            return Collections.unmodifiableMap(this.myMap);
        }
    }
}

