/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class SplitBySeparatorPolicy
extends FilePathSplittingPolicy {
    @Override
    public String getPresentableName(File file, int length) {
        String s;
        String absolutePath = file.getPath();
        if (absolutePath.length() <= length) {
            return absolutePath;
        }
        String name = file.getName();
        if (length < name.length()) {
            return "...";
        }
        if (length == name.length()) {
            return name;
        }
        ArrayList<String> components = this.getComponents(file);
        int currentLength = 0;
        ArrayList<String> end = new ArrayList<String>();
        ArrayList<String> begin = new ArrayList<String>();
        int size = components.size();
        int mult = 1;
        int currentIndex = 0;
        for (int i = size - 1; i >= 0 && (currentLength += (s = (String)components.get(currentIndex)).length()) <= length - 3; --i) {
            if (mult > 0) {
                end.add(s);
            } else {
                begin.add(s);
            }
            currentIndex += i * mult;
            mult *= -1;
        }
        if (end.isEmpty()) {
            return name;
        }
        StringBuffer result2 = new StringBuffer();
        Iterator iterator = begin.iterator();
        while (iterator.hasNext()) {
            result2.append((String)iterator.next());
        }
        result2.append("...");
        for (int i = end.size() - 1; i >= 0; --i) {
            result2.append((String)end.get(i));
        }
        return result2.toString();
    }

    private ArrayList<String> getComponents(File file) {
        ArrayList<String> result2 = new ArrayList<String>();
        File current = file;
        while (current != null) {
            result2.add(this.getFileName(current));
            if ((current = current.getParentFile()) == null) continue;
            result2.add(File.separator);
        }
        return result2;
    }

    private String getFileName(File current) {
        String result2 = current.getName();
        if (!result2.isEmpty()) {
            return result2;
        }
        String path = current.getPath();
        return path.substring(0, path.length() - 1);
    }
}

