/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class EmptyInitializerInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("EmptyClassInitializer" == null) {
            EmptyInitializerInspection.$$$reportNull$$$0(0);
        }
        return "EmptyClassInitializer";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.class.initializer.display.name", new Object[0]);
        if (string == null) {
            EmptyInitializerInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("empty.class.initializer.problem.descriptor", new Object[0]);
        if (string == null) {
            EmptyInitializerInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EmptyInitializerFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyInitializerVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/EmptyInitializerInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class EmptyInitializerVisitor
    extends BaseInspectionVisitor {
        private EmptyInitializerVisitor() {
        }

        @Override
        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                EmptyInitializerVisitor.$$$reportNull$$$0(0);
            }
            super.visitClassInitializer(initializer);
            PsiCodeBlock body = initializer.getBody();
            if (!ControlFlowUtils.isEmptyCodeBlock(body)) {
                return;
            }
            this.registerClassInitializerError(initializer, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/siyeh/ig/bugs/EmptyInitializerInspection$EmptyInitializerVisitor", "visitClassInitializer"));
        }
    }

    private static class EmptyInitializerFix
    extends InspectionGadgetsFix {
        private EmptyInitializerFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("empty.class.initializer.delete.quickfix", new Object[0]);
            if (string == null) {
                EmptyInitializerFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement codeBlock = element.getParent();
            assert (codeBlock != null);
            PsiElement classInitializer = codeBlock.getParent();
            assert (classInitializer != null);
            EmptyInitializerFix.deleteElement(classInitializer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyInitializerInspection$EmptyInitializerFix", "getFamilyName"));
        }
    }
}

