/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EqualsOnSuspiciousObjectInspection
extends BaseInspection {
    private List<String> myClasses = Arrays.asList("java.lang.StringBuilder", "java.lang.StringBuffer");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.called.on.suspicious.object.display.name", new Object[0]);
        if (string == null) {
            EqualsOnSuspiciousObjectInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String typeName = (String)infos[0];
        String string = InspectionGadgetsBundle.message("equals.called.on.suspicious.object.problem.descriptor", StringUtil.getShortName(typeName));
        if (string == null) {
            EqualsOnSuspiciousObjectInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseEqualsVisitor(){

            @Override
            void checkTypes(@NotNull PsiReferenceExpression expression, @NotNull PsiType type1, @NotNull PsiType type2) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!this.checkType(expression, type1)) {
                    this.checkType(expression, type2);
                }
            }

            private boolean checkType(PsiReferenceExpression expression, PsiType type) {
                PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type);
                if (psiClass != null) {
                    String qualifiedName = psiClass.getQualifiedName();
                    if (EqualsOnSuspiciousObjectInspection.this.myClasses.contains(qualifiedName)) {
                        PsiElement name = expression.getReferenceNameElement();
                        this.registerError(name == null ? expression : name, qualifiedName);
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type2";
                        break;
                    }
                }
                objectArray[1] = "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection$1";
                objectArray[2] = "checkTypes";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

