/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import org.jetbrains.annotations.NotNull;

public class UtilityClassWithPublicConstructorInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("utility.class.with.public.constructor.display.name", new Object[0]);
        if (string == null) {
            UtilityClassWithPublicConstructorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("utility.class.with.public.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            UtilityClassWithPublicConstructorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass psiClass = (PsiClass)infos[0];
        if (psiClass.getConstructors().length > 1) {
            return new UtilityClassWithPublicConstructorFix(true);
        }
        return new UtilityClassWithPublicConstructorFix(false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticClassWithPublicConstructorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/UtilityClassWithPublicConstructorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StaticClassWithPublicConstructorVisitor
    extends BaseInspectionVisitor {
        private StaticClassWithPublicConstructorVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                StaticClassWithPublicConstructorVisitor.$$$reportNull$$$0(0);
            }
            if (!UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            if (!StaticClassWithPublicConstructorVisitor.hasPublicConstructor(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private static boolean hasPublicConstructor(PsiClass aClass) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                if (!constructor.hasModifierProperty("public")) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/UtilityClassWithPublicConstructorInspection$StaticClassWithPublicConstructorVisitor", "visitClass"));
        }
    }

    private static class UtilityClassWithPublicConstructorFix
    extends InspectionGadgetsFix {
        private final boolean m_multipleConstructors;

        UtilityClassWithPublicConstructorFix(boolean multipleConstructors) {
            this.m_multipleConstructors = multipleConstructors;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("utility.class.with.public.constructor.make.quickfix", this.m_multipleConstructors ? 1 : 2);
            if (string == null) {
                UtilityClassWithPublicConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Make constructors private" == null) {
                UtilityClassWithPublicConstructorFix.$$$reportNull$$$0(1);
            }
            return "Make constructors private";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiMethod[] constructors;
            PsiElement classNameIdentifier = descriptor.getPsiElement();
            PsiClass psiClass = (PsiClass)classNameIdentifier.getParent();
            if (psiClass == null) {
                return;
            }
            for (PsiMethod constructor : constructors = psiClass.getConstructors()) {
                PsiModifierList modifierList = constructor.getModifierList();
                modifierList.setModifierProperty("private", true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/classlayout/UtilityClassWithPublicConstructorInspection$UtilityClassWithPublicConstructorFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

