/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FinalUtils;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TryFinallyCanBeTryWithResourcesInspection
extends BaseInspection {
    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.display.name", new Object[0]);
        if (string == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.problem.descriptor", new Object[0]);
        if (string == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new TryFinallyCanBeTryWithResourcesFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel7OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TryFinallyCanBeTryWithResourcesVisitor();
    }

    private static boolean resourceVariablesUsedInFinally(PsiStatement[] statements, BitSet closedVariableStatementIndices, Set<PsiVariable> resourceVariables) {
        for (int i = 0; i < statements.length; ++i) {
            if (closedVariableStatementIndices.get(i)) continue;
            Set<PsiVariable> usedVariables = VariableAccessUtils.collectUsedVariables(statements[i]);
            for (PsiVariable usedVariable : usedVariables) {
                if (!resourceVariables.contains(usedVariable)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isVariableUsedOutsideContext(PsiVariable variable, PsiElement context) {
        VariableUsedOutsideContextVisitor visitor = new VariableUsedOutsideContextVisitor(variable, context);
        PsiCodeBlock declarationScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        if (declarationScope == null) {
            return true;
        }
        declarationScope.accept(visitor);
        return visitor.variableIsUsed();
    }

    private static boolean findAutoClosableVariableWithoutTry(PsiStatement statement, Set<PsiVariable> variables) {
        if (statement instanceof PsiIfStatement) {
            PsiVariable resourceVariable;
            PsiLocalVariable variable;
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            if (ifStatement.getElseBranch() != null) {
                return false;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (!(condition instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.NE.equals(tokenType)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            if (PsiType.NULL.equals(rhs.getType())) {
                variable = ExpressionUtils.resolveLocalVariable(lhs);
            } else if (PsiType.NULL.equals(lhs.getType())) {
                variable = ExpressionUtils.resolveLocalVariable(rhs);
            } else {
                return false;
            }
            if (variable == null) {
                return false;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch instanceof PsiExpressionStatement) {
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(thenBranch);
            } else if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(ControlFlowUtils.getOnlyStatementInBlock(codeBlock));
            } else {
                return false;
            }
            if (variable.equals(resourceVariable)) {
                variables.add(resourceVariable);
                return true;
            }
        } else if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("close".equals(methodName)) {
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable) && !(target instanceof PsiParameter) || target instanceof PsiResourceVariable) {
                    return false;
                }
                PsiVariable variable = (PsiVariable)target;
                if (!TryFinallyCanBeTryWithResourcesInspection.isAutoCloseable(variable)) {
                    return false;
                }
                variables.add(variable);
                return true;
            }
            return false;
        }
        return false;
    }

    @Nullable
    private static PsiVariable findAutoCloseableVariable(PsiStatement statement) {
        HashSet<PsiVariable> variables = new HashSet<PsiVariable>(1);
        TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariables(statement, variables);
        if (variables.isEmpty()) {
            return null;
        }
        return ContainerUtil.getFirstItem(variables);
    }

    private static boolean findAutoCloseableVariables(PsiStatement statement, Set<PsiVariable> variables) {
        if (TryFinallyCanBeTryWithResourcesInspection.findAutoClosableVariableWithoutTry(statement, variables)) {
            return true;
        }
        if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            if (tryStatement.getResourceList() != null || tryStatement.getFinallyBlock() != null) {
                return true;
            }
            PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
            if (catchBlocks.length != 1) {
                return true;
            }
            PsiStatement[] catchStatements = catchBlocks[0].getStatements();
            if (catchStatements.length != 0) {
                return true;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return true;
            }
            PsiStatement[] tryStatements = tryBlock.getStatements();
            boolean containsClosedVariables = false;
            for (PsiStatement tryStmt : tryStatements) {
                if (!TryFinallyCanBeTryWithResourcesInspection.findAutoClosableVariableWithoutTry(tryStmt, variables)) continue;
                containsClosedVariables = true;
            }
            return containsClosedVariables;
        }
        return false;
    }

    private static boolean isAutoCloseable(PsiVariable variable) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(variable.getType());
        return InheritanceUtil.isInheritor(aClass, "java.lang.AutoCloseable");
    }

    private static int findInitialization(PsiElement[] elements, PsiVariable variable) {
        int result2 = -1;
        int statementsLength = elements.length;
        for (int i = 0; i < statementsLength; ++i) {
            PsiElement element = elements[i];
            if (TryFinallyCanBeTryWithResourcesInspection.isAssignmentToVariable(element, variable)) {
                if (result2 >= 0) {
                    return -1;
                }
                result2 = i;
                continue;
            }
            if (!VariableAccessUtils.variableIsAssigned(variable, element)) continue;
            return -1;
        }
        return result2;
    }

    private static boolean isAssignmentToVariable(PsiElement element, PsiVariable variable) {
        PsiExpressionStatement expressionStatement = ObjectUtils.tryCast(element, PsiExpressionStatement.class);
        if (expressionStatement == null) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = ObjectUtils.tryCast(expressionStatement.getExpression(), PsiAssignmentExpression.class);
        if (assignmentExpression == null) {
            return false;
        }
        if (assignmentExpression.getRExpression() == null) {
            return false;
        }
        return ExpressionUtils.isReferenceTo(assignmentExpression.getLExpression(), variable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class VariableUsedOutsideContextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean used;
        @NotNull
        private final PsiVariable variable;
        private final PsiElement skipContext;

        public VariableUsedOutsideContextVisitor(@NotNull PsiVariable variable, PsiElement skipContext) {
            if (variable == null) {
                VariableUsedOutsideContextVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
            this.skipContext = skipContext;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                VariableUsedOutsideContextVisitor.$$$reportNull$$$0(1);
            }
            if (element.equals(this.skipContext)) {
                return;
            }
            if (this.used) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                VariableUsedOutsideContextVisitor.$$$reportNull$$$0(2);
            }
            if (this.used) {
                return;
            }
            super.visitReferenceExpression(referenceExpression);
            PsiElement target = referenceExpression.resolve();
            if (target == null) {
                return;
            }
            if (target.equals(this.variable) && !VariableUsedOutsideContextVisitor.isCloseMethodCalled(referenceExpression)) {
                this.used = true;
            }
        }

        private static boolean isCloseMethodCalled(PsiReferenceExpression referenceExpression) {
            PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (!argumentList.isEmpty()) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            return "close".equals(name);
        }

        public boolean variableIsUsed() {
            return this.used;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$VariableUsedOutsideContextVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ResourceVariable {
        @Nullable(value="when in java 9")
        final PsiExpression myInitializer;
        final boolean myUsedOutsideTry;
        @NotNull
        final PsiVariable myVariable;

        ResourceVariable(@Nullable PsiExpression initializer, boolean usedOutsideTry, @NotNull PsiVariable variable) {
            if (variable == null) {
                ResourceVariable.$$$reportNull$$$0(0);
            }
            this.myInitializer = initializer;
            this.myUsedOutsideTry = usedOutsideTry;
            this.myVariable = variable;
        }

        String generateResourceDeclaration() {
            if (this.myUsedOutsideTry) {
                return this.myVariable.getName();
            }
            assert (this.myInitializer != null);
            return Objects.requireNonNull(this.myVariable.getTypeElement()).getText() + " " + this.myVariable.getName() + "=" + this.myInitializer.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$ResourceVariable", "<init>"));
        }
    }

    private static class Context {
        @NotNull
        final List<ResourceVariable> myResourceVariables;
        @NotNull
        final Set<PsiStatement> myStatementsToDelete;

        private Context(@NotNull List<ResourceVariable> resourceVariables, @NotNull Set<PsiStatement> statementsToDelete) {
            if (resourceVariables == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (statementsToDelete == null) {
                Context.$$$reportNull$$$0(1);
            }
            this.myResourceVariables = resourceVariables;
            this.myStatementsToDelete = statementsToDelete;
        }

        @Nullable
        static Context from(@NotNull PsiTryStatement tryStatement) {
            PsiCodeBlock finallyBlock;
            if (tryStatement == null) {
                Context.$$$reportNull$$$0(2);
            }
            if ((finallyBlock = tryStatement.getFinallyBlock()) == null) {
                return null;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return null;
            }
            PsiElement[] tryStatements = tryBlock.getStatements();
            PsiStatement[] finallyStatements = finallyBlock.getStatements();
            BitSet closedVariableStatementIndices = new BitSet(finallyStatements.length);
            HashSet collectedVariables = new HashSet();
            int length = finallyStatements.length;
            for (int i = 0; i < length; ++i) {
                PsiStatement statement = finallyStatements[i];
                closedVariableStatementIndices.set(i, TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariables(statement, collectedVariables));
            }
            if (collectedVariables.isEmpty()) {
                return null;
            }
            if (TryFinallyCanBeTryWithResourcesInspection.resourceVariablesUsedInFinally(finallyStatements, closedVariableStatementIndices, collectedVariables)) {
                return null;
            }
            ArrayList<ResourceVariable> resourceVariables = new ArrayList<ResourceVariable>();
            ArrayList<PsiElement> statementsToDelete = new ArrayList<PsiElement>();
            for (PsiVariable resourceVariable : collectedVariables) {
                boolean variableUsedOutsideTry = TryFinallyCanBeTryWithResourcesInspection.isVariableUsedOutsideContext(resourceVariable, tryStatement);
                if (!PsiUtil.isLanguageLevel9OrHigher(finallyBlock) && variableUsedOutsideTry) {
                    return null;
                }
                if (!variableUsedOutsideTry && resourceVariable instanceof PsiLocalVariable) {
                    boolean hasNonNullInitializer;
                    PsiExpression initializer = resourceVariable.getInitializer();
                    boolean bl = hasNonNullInitializer = initializer != null && !PsiType.NULL.equals(initializer.getType());
                    if (!hasNonNullInitializer) {
                        int assignmentStatementIndex = TryFinallyCanBeTryWithResourcesInspection.findInitialization(tryStatements, resourceVariable);
                        if (assignmentStatementIndex == -1) {
                            return null;
                        }
                        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)tryStatements[assignmentStatementIndex];
                        PsiExpression expression = assignmentStatement.getExpression();
                        PsiAssignmentExpression assignment = ObjectUtils.tryCast(expression, PsiAssignmentExpression.class);
                        if (assignment == null) {
                            return null;
                        }
                        initializer = assignment.getRExpression();
                        if (initializer == null) {
                            return null;
                        }
                        statementsToDelete.add(tryStatements[assignmentStatementIndex]);
                    } else if (VariableAccessUtils.variableIsAssigned(resourceVariable, tryBlock)) {
                        return null;
                    }
                    resourceVariables.add(new ResourceVariable(initializer, false, resourceVariable));
                    continue;
                }
                if ((resourceVariable instanceof PsiLocalVariable && resourceVariable.getInitializer() != null || resourceVariable instanceof PsiParameter) && FinalUtils.canBeFinal(resourceVariable)) {
                    resourceVariables.add(new ResourceVariable(null, true, resourceVariable));
                    continue;
                }
                return null;
            }
            for (int i = 0; i < finallyStatements.length; ++i) {
                if (!closedVariableStatementIndices.get(i)) continue;
                statementsToDelete.add(finallyStatements[i]);
            }
            Collections.sort(resourceVariables, Comparator.comparing(o -> o.myVariable, PsiElementOrderComparator.getInstance()));
            return new Context(resourceVariables, new HashSet<PsiStatement>(statementsToDelete));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceVariables";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statementsToDelete";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tryStatement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$Context";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TryFinallyCanBeTryWithResourcesVisitor
    extends BaseInspectionVisitor {
        private TryFinallyCanBeTryWithResourcesVisitor() {
        }

        @Override
        public void visitTryStatement(PsiTryStatement tryStatement) {
            super.visitTryStatement(tryStatement);
            if (Context.from(tryStatement) == null) {
                return;
            }
            this.registerStatementError(tryStatement, new Object[0]);
        }
    }

    private static class TryFinallyCanBeTryWithResourcesFix
    extends InspectionGadgetsFix {
        private TryFinallyCanBeTryWithResourcesFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.quickfix", new Object[0]);
            if (string == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiTryStatement)) {
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            Context context = Context.from(tryStatement);
            if (context == null) {
                return;
            }
            String resourceList = context.myResourceVariables.stream().map(ResourceVariable::generateResourceDeclaration).collect(Collectors.joining(";"));
            StringBuilder sb = new StringBuilder("try(");
            sb.append(resourceList).append(")");
            TryFinallyCanBeTryWithResourcesFix.restoreStatements(tryStatement, tryBlock, context);
            for (PsiStatement statement : context.myStatementsToDelete) {
                new CommentTracker().deleteAndRestoreComments(statement);
            }
            for (ResourceVariable variable : context.myResourceVariables) {
                if (variable.myUsedOutsideTry) continue;
                new CommentTracker().deleteAndRestoreComments(variable.myVariable);
            }
            sb.append(tryBlock.getText());
            for (Iterator<Object> iterator : tryStatement.getCatchSections()) {
                sb.append(iterator.getText());
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            if (!ControlFlowUtils.isEmptyCodeBlock(finallyBlock)) {
                sb.append("finally").append(finallyBlock.getText());
            } else {
                Object[] finallyBlockChildren = finallyBlock.getChildren();
                if (!((StreamEx)((StreamEx)StreamEx.of((Object[])finallyBlockChildren).skip(1L)).limit((long)(finallyBlockChildren.length - 2))).allMatch(el -> el instanceof PsiWhiteSpace)) {
                    PsiElement tryParent = tryStatement.getParent();
                    tryParent.addRangeAfter((PsiElement)finallyBlockChildren[1], (PsiElement)finallyBlockChildren[finallyBlockChildren.length - 2], tryStatement);
                }
            }
            tryStatement.replace(JavaPsiFacade.getElementFactory(project).createStatementFromText(sb.toString(), tryStatement));
        }

        private static void restoreStatements(PsiTryStatement tryStatement, PsiCodeBlock tryBlock, Context context) {
            Optional lastInTryVariable = ((StreamEx)StreamEx.of(context.myResourceVariables).map(v -> v.myInitializer).filter(e -> e != null && PsiTreeUtil.isAncestor(tryBlock, e, false))).max((Comparator)PsiElementOrderComparator.getInstance());
            ArrayList<PsiStatement> elementsToRestore = new ArrayList<PsiStatement>();
            if (lastInTryVariable.isPresent()) {
                PsiStatement last = PsiTreeUtil.getParentOfType((PsiElement)lastInTryVariable.get(), PsiStatement.class);
                PsiStatement[] statements = tryBlock.getStatements();
                for (int i = 0; i < statements.length && statements[i] != last; ++i) {
                    PsiStatement current = statements[i];
                    if (context.myStatementsToDelete.contains(current)) continue;
                    elementsToRestore.add(current);
                }
            }
            PsiElement tryStatementParent = tryStatement.getParent();
            for (int i = elementsToRestore.size() - 1; i >= 0; --i) {
                PsiStatement statement = (PsiStatement)elementsToRestore.get(i);
                tryStatementParent.addBefore(statement, tryStatement);
                statement.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$TryFinallyCanBeTryWithResourcesFix", "getFamilyName"));
        }
    }
}

