/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightJavaModule;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModulePresentationProvider
implements ItemPresentationProvider<PsiJavaModule> {
    private static final Pattern JAR_NAME = Pattern.compile(".+/([^/]+\\.jar)!/.*");

    @Override
    public ItemPresentation getPresentation(final @NotNull PsiJavaModule item) {
        if (item == null) {
            JavaModulePresentationProvider.$$$reportNull$$$0(0);
        }
        return new ItemPresentation(){

            @Override
            public String getPresentableText() {
                return item.getName();
            }

            @Override
            @Nullable
            public String getLocationString() {
                Module module;
                VirtualFile file = PsiImplUtil.getModuleVirtualFile(item);
                FileIndexFacade index = FileIndexFacade.getInstance(item.getProject());
                if (index.isInLibraryClasses(file)) {
                    Matcher matcher = JAR_NAME.matcher(file.getPath());
                    if (matcher.find()) {
                        return matcher.group(1);
                    }
                } else if (index.isInSource(file) && (module = index.getModuleForFile(file)) != null) {
                    return '[' + module.getName() + ']';
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean unused) {
                return item instanceof LightJavaModule ? AllIcons.FileTypes.Archive : AllIcons.Nodes.JavaModule;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/psi/presentation/java/JavaModulePresentationProvider", "getPresentation"));
    }
}

