/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PathMacrosImpl", storages={@Storage(value="path.macros.xml", roamingType=RoamingType.PER_OS)})
public class PathMacrosImpl
extends PathMacros
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(PathMacrosImpl.class);
    private final Map<String, String> myLegacyMacros = new THashMap();
    private final Map<String, String> myMacros = new LinkedHashMap<String, String>();
    private int myModificationStamp = 0;
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final List<String> myIgnoredMacros = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final String MACRO_ELEMENT = "macro";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    @NonNls
    public static final String IGNORED_MACRO_ELEMENT = "ignoredMacro";
    private static final Set<String> SYSTEM_MACROS = new THashSet();
    @NonNls
    public static final String EXT_FILE_NAME = "path.macros";

    public static PathMacrosImpl getInstanceEx() {
        return (PathMacrosImpl)PathMacrosImpl.getInstance();
    }

    @Override
    public Set<String> getUserMacroNames() {
        this.myLock.readLock().lock();
        try {
            THashSet tHashSet = new THashSet(this.myMacros.keySet());
            return tHashSet;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @NotNull
    public Set<String> getToolMacroNames() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            PathMacrosImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    public Set<String> getSystemMacroNames() {
        return SYSTEM_MACROS;
    }

    @Override
    public Collection<String> getIgnoredMacroNames() {
        return this.myIgnoredMacros;
    }

    @Override
    public void setIgnoredMacroNames(@NotNull Collection<String> names) {
        if (names == null) {
            PathMacrosImpl.$$$reportNull$$$0(1);
        }
        this.myIgnoredMacros.clear();
        this.myIgnoredMacros.addAll(names);
    }

    @Override
    public void addIgnoredMacro(@NotNull String name) {
        if (name == null) {
            PathMacrosImpl.$$$reportNull$$$0(2);
        }
        if (!this.myIgnoredMacros.contains(name)) {
            this.myIgnoredMacros.add(name);
        }
    }

    public int getModificationStamp() {
        this.myLock.readLock().lock();
        try {
            int n = this.myModificationStamp;
            return n;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @Override
    public boolean isIgnoredMacroName(@NotNull String macro) {
        if (macro == null) {
            PathMacrosImpl.$$$reportNull$$$0(3);
        }
        return this.myIgnoredMacros.contains(macro);
    }

    @Override
    public Set<String> getAllMacroNames() {
        return ContainerUtil.union(this.getUserMacroNames(), this.getSystemMacroNames());
    }

    @Override
    public String getValue(String name) {
        try {
            this.myLock.readLock().lock();
            String string = this.myMacros.get(name);
            return string;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @Override
    public void removeAllMacros() {
        try {
            this.myLock.writeLock().lock();
            this.myMacros.clear();
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    @Override
    public Collection<String> getLegacyMacroNames() {
        try {
            this.myLock.readLock().lock();
            THashSet tHashSet = new THashSet(this.myLegacyMacros.keySet());
            return tHashSet;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @Override
    public void setMacro(@NotNull String name, @NotNull String value) {
        if (name == null) {
            PathMacrosImpl.$$$reportNull$$$0(4);
        }
        if (value == null) {
            PathMacrosImpl.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces(value)) {
            return;
        }
        try {
            this.myLock.writeLock().lock();
            this.myMacros.put(name, value);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    @Override
    public void addLegacyMacro(@NotNull String name, @NotNull String value) {
        if (name == null) {
            PathMacrosImpl.$$$reportNull$$$0(6);
        }
        if (value == null) {
            PathMacrosImpl.$$$reportNull$$$0(7);
        }
        try {
            this.myLock.writeLock().lock();
            this.myLegacyMacros.put(name, value);
            this.myMacros.remove(name);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    @Override
    public void removeMacro(String name) {
        try {
            this.myLock.writeLock().lock();
            String value = this.myMacros.remove(name);
            LOG.assertTrue(value != null);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Element getState() {
        try {
            Element element = new Element("state");
            this.myLock.writeLock().lock();
            for (Map.Entry<String, String> entry : this.myMacros.entrySet()) {
                String value = entry.getValue();
                if (StringUtil.isEmptyOrSpaces(value)) continue;
                Element macro = new Element(MACRO_ELEMENT);
                macro.setAttribute(NAME_ATTR, entry.getKey());
                macro.setAttribute(VALUE_ATTR, value);
                element.addContent(macro);
            }
            for (String macro : this.myIgnoredMacros) {
                Element macroElement = new Element(IGNORED_MACRO_ELEMENT);
                macroElement.setAttribute(NAME_ATTR, macro);
                element.addContent(macroElement);
            }
            Iterator<Object> iterator = element;
            return iterator;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(@NotNull Element element) {
        if (element == null) {
            PathMacrosImpl.$$$reportNull$$$0(8);
        }
        try {
            this.myLock.writeLock().lock();
            for (Element macro : element.getChildren(MACRO_ELEMENT)) {
                String name = macro.getAttributeValue(NAME_ATTR);
                String value = macro.getAttributeValue(VALUE_ATTR);
                if (name == null || value == null || SYSTEM_MACROS.contains(name)) continue;
                if (value.length() > 1 && value.charAt(value.length() - 1) == '/') {
                    value = value.substring(0, value.length() - 1);
                }
                this.myMacros.put(name, value);
            }
            for (Element macroElement : element.getChildren(IGNORED_MACRO_ELEMENT)) {
                String ignoredName = macroElement.getAttributeValue(NAME_ATTR);
                if (StringUtil.isEmpty(ignoredName) || this.myIgnoredMacros.contains(ignoredName)) continue;
                this.myIgnoredMacros.add(ignoredName);
            }
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    public void addMacroReplacements(ReplacePathToMacroMap result2) {
        for (String name : this.getUserMacroNames()) {
            String value = this.getValue(name);
            if (StringUtil.isEmptyOrSpaces(value)) continue;
            result2.addMacroReplacement(value, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacroExpands(ExpandMacroToPathMap result2) {
        for (String string : this.getUserMacroNames()) {
            String value = this.getValue(string);
            if (StringUtil.isEmptyOrSpaces(value)) continue;
            result2.addMacroExpand(string, value);
        }
        this.myLock.readLock().lock();
        try {
            for (Map.Entry entry : this.myLegacyMacros.entrySet()) {
                result2.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    static {
        SYSTEM_MACROS.add("APPLICATION_HOME_DIR");
        SYSTEM_MACROS.add("APPLICATION_PLUGINS_DIR");
        SYSTEM_MACROS.add("PROJECT_DIR");
        SYSTEM_MACROS.add("MODULE_DIR");
        SYSTEM_MACROS.add("USER_HOME");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/PathMacrosImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_ATTR;
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = MACRO_ELEMENT;
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = VALUE_ATTR;
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolMacroNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/PathMacrosImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredMacroNames";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredMacro";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredMacroName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMacro";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLegacyMacro";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

