/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeArgumentsConditionalFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(AddTypeArgumentsConditionalFix.class);
    private final PsiSubstitutor mySubstitutor;
    private final PsiMethodCallExpression myExpression;
    private final PsiMethod myMethod;

    public AddTypeArgumentsConditionalFix(PsiSubstitutor substitutor, PsiMethodCallExpression expression, PsiMethod method) {
        this.mySubstitutor = substitutor;
        this.myExpression = expression;
        this.myMethod = method;
    }

    @Override
    @NotNull
    public String getText() {
        if ("Add explicit type arguments" == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(0);
        }
        return "Add explicit type arguments";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(2);
        }
        return this.mySubstitutor.isValid() && this.myExpression.isValid() && this.myMethod.isValid();
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        String withTypeArgsText;
        if (project == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(3);
        }
        PsiTypeParameter[] typeParameters = this.myMethod.getTypeParameters();
        String typeArguments = "<" + StringUtil.join(typeParameters, parameter -> {
            PsiType substituteTypeParam = this.mySubstitutor.substitute((PsiTypeParameter)parameter);
            LOG.assertTrue(substituteTypeParam != null);
            return GenericsUtil.eliminateWildcards(substituteTypeParam).getCanonicalText();
        }, ", ") + ">";
        PsiExpression expression = this.myExpression.getMethodExpression().getQualifierExpression();
        if (expression != null) {
            withTypeArgsText = expression.getText();
        } else if (AddTypeArgumentsConditionalFix.isInStaticContext(this.myExpression, null) || this.myMethod.hasModifierProperty("static")) {
            PsiClass aClass = this.myMethod.getContainingClass();
            LOG.assertTrue(aClass != null);
            withTypeArgsText = aClass.getQualifiedName();
        } else {
            withTypeArgsText = "this";
        }
        withTypeArgsText = withTypeArgsText + "." + typeArguments + this.myExpression.getMethodExpression().getReferenceName();
        PsiExpression withTypeArgs = JavaPsiFacade.getElementFactory(project).createExpressionFromText(withTypeArgsText + this.myExpression.getArgumentList().getText(), this.myExpression);
        this.myExpression.replace(withTypeArgs);
    }

    public static boolean isInStaticContext(PsiElement element, @Nullable PsiClass aClass) {
        return PsiUtil.getEnclosingStaticElement(element, aClass) != null;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public static void register(HighlightInfo highlightInfo, PsiExpression expression, @NotNull PsiType lType) {
        if (lType == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(4);
        }
        if (lType != PsiType.NULL && expression instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            if (thenExpression != null && elseExpression != null) {
                PsiType thenType = thenExpression.getType();
                PsiType elseType = elseExpression.getType();
                if (thenType != null && elseType != null) {
                    boolean thenAssignable = TypeConversionUtil.isAssignable(lType, thenType);
                    boolean elseAssignable = TypeConversionUtil.isAssignable(lType, elseType);
                    if (!thenAssignable && thenExpression instanceof PsiMethodCallExpression) {
                        AddTypeArgumentsConditionalFix.inferTypeArgs(highlightInfo, lType, thenExpression);
                    }
                    if (!elseAssignable && elseExpression instanceof PsiMethodCallExpression) {
                        AddTypeArgumentsConditionalFix.inferTypeArgs(highlightInfo, lType, elseExpression);
                    }
                }
            }
        }
    }

    private static void inferTypeArgs(HighlightInfo highlightInfo, PsiType lType, PsiExpression thenExpression) {
        JavaResolveResult result2 = ((PsiMethodCallExpression)thenExpression).resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result2.getElement();
        if (method != null) {
            PsiType returnType = method.getReturnType();
            PsiClass aClass = method.getContainingClass();
            if (returnType != null && aClass != null && aClass.getQualifiedName() != null) {
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(method.getProject());
                PsiDeclarationStatement variableDeclarationStatement = javaPsiFacade.getElementFactory().createVariableDeclarationStatement("xxx", lType, thenExpression);
                PsiExpression initializer = ((PsiLocalVariable)variableDeclarationStatement.getDeclaredElements()[0]).getInitializer();
                LOG.assertTrue(initializer != null);
                PsiSubstitutor substitutor = javaPsiFacade.getResolveHelper().inferTypeArguments(method.getTypeParameters(), method.getParameterList().getParameters(), ((PsiMethodCallExpression)thenExpression).getArgumentList().getExpressions(), PsiSubstitutor.EMPTY, initializer, DefaultParameterTypeInferencePolicy.INSTANCE);
                PsiType substitutedType = substitutor.substitute(returnType);
                if (substitutedType != null && TypeConversionUtil.isAssignable(lType, substitutedType)) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, thenExpression.getTextRange(), new AddTypeArgumentsConditionalFix(substitutor, (PsiMethodCallExpression)thenExpression, method));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsConditionalFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsConditionalFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

