/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RedundantLambdaCodeBlockInspection;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousCanBeLambdaInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(AnonymousCanBeLambdaInspection.class);
    public boolean reportNotAnnotatedInterfaces = true;

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Anonymous type can be replaced with lambda" == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(1);
        }
        return "Anonymous type can be replaced with lambda";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("Convert2Lambda" == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(2);
        }
        return "Convert2Lambda";
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report when interface is not annotated with @FunctionalInterface", this, "reportNotAnnotatedInterfaces");
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                super.visitAnonymousClass(aClass);
                PsiElement parent = aClass.getParent();
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, false, isOnTheFly || AnonymousCanBeLambdaInspection.this.reportNotAnnotatedInterfaces, Collections.emptySet())) {
                    PsiElement lBrace = aClass.getLBrace();
                    LOG.assertTrue(lBrace != null);
                    TextRange rangeInElement = new TextRange(0, aClass.getStartOffsetInParent() + lBrace.getStartOffsetInParent());
                    ProblemHighlightType type = ProblemHighlightType.LIKE_UNUSED_SYMBOL;
                    if (isOnTheFly && !AnonymousCanBeLambdaInspection.this.reportNotAnnotatedInterfaces) {
                        PsiClass baseClass = aClass.getBaseClassType().resolve();
                        LOG.assertTrue(baseClass != null);
                        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)baseClass, "java.lang.FunctionalInterface", 2)) {
                            type = ProblemHighlightType.INFORMATION;
                        }
                    }
                    holder.registerProblem(parent, "Anonymous #ref #loc can be replaced with lambda", type, rangeInElement, new ReplaceWithLambdaFix());
                }
            }
        };
        if (javaElementVisitor == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    static boolean hasRuntimeAnnotations(PsiMethod method, @NotNull Set<String> runtimeAnnotationsToIgnore) {
        PsiAnnotation[] annotations;
        if (runtimeAnnotationsToIgnore == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(5);
        }
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            PsiClass containingClass;
            PsiElement resolved;
            PsiAnnotationMemberValue value;
            PsiAnnotation retentionAnno;
            PsiElement target;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = target = ref != null ? ref.resolve() : null;
            if (!(target instanceof PsiClass) || runtimeAnnotationsToIgnore.contains(((PsiClass)target).getQualifiedName()) || (retentionAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiClass)target), Retention.class.getName())) == null || !((value = retentionAnno.findAttributeValue("value")) instanceof PsiReferenceExpression) || !((resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiField) || !RetentionPolicy.RUNTIME.name().equals(((PsiField)resolved).getName()) || (containingClass = ((PsiField)resolved).getContainingClass()) == null || !RetentionPolicy.class.getName().equals(containingClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasForbiddenRefsInsideBody(PsiMethod method, PsiAnonymousClass aClass) {
        ForbiddenRefsChecker checker = new ForbiddenRefsChecker(method, aClass);
        PsiCodeBlock body = method.getBody();
        LOG.assertTrue(body != null);
        body.accept(checker);
        return checker.hasForbiddenRefs();
    }

    private static PsiType getInferredType(PsiAnonymousClass aClass, PsiMethod method) {
        PsiExpression expression = (PsiExpression)aClass.getParent();
        PsiType psiType = PsiTypesUtil.getExpectedTypeByParent(expression);
        if (psiType != null) {
            return psiType;
        }
        PsiExpression topExpr = expression;
        while (topExpr.getParent() instanceof PsiParenthesizedExpression) {
            topExpr = (PsiExpression)topExpr.getParent();
        }
        PsiCall call = LambdaUtil.treeWalkUp(topExpr);
        if (call != null && call.resolveMethod() != null) {
            Object marker = new Object();
            PsiTreeUtil.mark(aClass, marker);
            PsiCall copyCall = LambdaUtil.copyTopLevelCall(call);
            if (copyCall == null) {
                return null;
            }
            PsiElement classArg = PsiTreeUtil.releaseMark(copyCall, marker);
            if (classArg instanceof PsiAnonymousClass) {
                PsiExpression lambda2 = JavaPsiFacade.getElementFactory(aClass.getProject()).createExpressionFromText(ReplaceWithLambdaFix.composeLambdaText(method), expression);
                lambda2 = (PsiExpression)classArg.getParent().replace(lambda2);
                ((PsiLambdaExpression)lambda2).getBody().replace(method.getBody());
                if (copyCall.resolveMethod() == null) {
                    return PsiType.NULL;
                }
                PsiType interfaceType = ((PsiLambdaExpression)lambda2).getFunctionalInterfaceType();
                return interfaceType;
            }
        }
        return PsiType.NULL;
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (ignoredRuntimeAnnotations == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(6);
        }
        return AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, acceptParameterizedFunctionTypes, true, ignoredRuntimeAnnotations);
    }

    public static boolean isLambdaForm(PsiAnonymousClass aClass, Set<String> ignoredRuntimeAnnotations) {
        PsiMethod[] methods = aClass.getMethods();
        if (methods.length != 1) {
            return false;
        }
        PsiMethod method = methods[0];
        return aClass.getFields().length == 0 && aClass.getInnerClasses().length == 0 && aClass.getInitializers().length == 0 && method.getBody() != null && method.getDocComment() == null && !AnonymousCanBeLambdaInspection.hasRuntimeAnnotations(method, ignoredRuntimeAnnotations) && !method.hasModifierProperty("synchronized") && !method.hasModifierProperty("strictfp") && !AnonymousCanBeLambdaInspection.hasForbiddenRefsInsideBody(method, aClass);
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, boolean reportNotAnnotatedInterfaces, @NotNull Set<String> ignoredRuntimeAnnotations) {
        PsiElement parent;
        PsiElement lambdaContext;
        if (ignoredRuntimeAnnotations == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(7);
        }
        PsiElement psiElement = lambdaContext = (parent = aClass.getParent()) != null ? parent.getParent() : null;
        if (lambdaContext == null || !LambdaUtil.isValidLambdaContext(lambdaContext) && !(lambdaContext instanceof PsiReferenceExpression)) {
            return false;
        }
        return AnonymousCanBeLambdaInspection.isLambdaForm(aClass, acceptParameterizedFunctionTypes, reportNotAnnotatedInterfaces, ignoredRuntimeAnnotations);
    }

    public static boolean isLambdaForm(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (ignoredRuntimeAnnotations == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(8);
        }
        return AnonymousCanBeLambdaInspection.isLambdaForm(aClass, acceptParameterizedFunctionTypes, true, ignoredRuntimeAnnotations);
    }

    public static boolean isLambdaForm(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, boolean reportNotAnnotatedInterfaces, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (ignoredRuntimeAnnotations == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(9);
        }
        if (PsiUtil.getLanguageLevel(aClass).isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiClassType baseClassType = aClass.getBaseClassType();
            PsiClassType.ClassResolveResult resolveResult = baseClassType.resolveGenerics();
            PsiClass baseClass = resolveResult.getElement();
            if (baseClass == null || !reportNotAnnotatedInterfaces && !AnnotationUtil.isAnnotated((PsiModifierListOwner)baseClass, "java.lang.FunctionalInterface", 2)) {
                return false;
            }
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod != null && (acceptParameterizedFunctionTypes || !interfaceMethod.hasTypeParameters()) && AnonymousCanBeLambdaInspection.isLambdaForm(aClass, ignoredRuntimeAnnotations)) {
                PsiMethod method = aClass.getMethods()[0];
                return AnonymousCanBeLambdaInspection.getInferredType(aClass, method) != null;
            }
        }
        return false;
    }

    public static PsiExpression replaceAnonymousWithLambda(@NotNull PsiElement anonymousClass, PsiType expectedType) {
        PsiNewExpression newArrayExpression;
        PsiArrayInitializerExpression initializer;
        if (anonymousClass == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(10);
        }
        LOG.assertTrue((initializer = (newArrayExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory(anonymousClass.getProject()).createExpressionFromText("new " + expectedType.getCanonicalText() + "[]{" + anonymousClass.getText() + "}", anonymousClass)).getArrayInitializer()) != null);
        return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda(initializer.getInitializers()[0], true, false);
    }

    public static PsiExpression replacePsiElementWithLambda(@NotNull PsiElement element, boolean ignoreEqualsMethod, boolean forceIgnoreTypeCast) {
        PsiMethod method;
        if (element == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(11);
        }
        if (!(element instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)element;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        if (anonymousClass == null) {
            return null;
        }
        if (ignoreEqualsMethod) {
            List<PsiMethod> methods = ContainerUtil.filter(anonymousClass.getMethods(), method1 -> !"equals".equals(method1.getName()));
            method = methods.get(0);
        } else {
            method = anonymousClass.getMethods()[0];
        }
        if (method == null || method.getBody() == null) {
            return null;
        }
        return AnonymousCanBeLambdaInspection.generateLambdaByMethod(anonymousClass, method, lambda2 -> (PsiLambdaExpression)newExpression.replace((PsiElement)lambda2), forceIgnoreTypeCast);
    }

    @NotNull
    static PsiExpression generateLambdaByMethod(PsiAnonymousClass anonymousClass, PsiMethod method, UnaryOperator<PsiLambdaExpression> replacer, boolean forceIgnoreTypeCast) {
        ChangeContextUtil.encodeContextInfo(anonymousClass, true);
        String canonicalText = anonymousClass.getBaseClassType().getCanonicalText();
        PsiCodeBlock body = method.getBody();
        LOG.assertTrue(body != null);
        Collection<PsiComment> comments = AnonymousCanBeLambdaInspection.collectCommentsOutsideMethodBody(anonymousClass.getParent(), body);
        Project project = anonymousClass.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
        String withoutTypesDeclared = ReplaceWithLambdaFix.composeLambdaText(method);
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)elementFactory.createExpressionFromText(withoutTypesDeclared, anonymousClass);
        PsiElement lambdaBody = lambdaExpression.getBody();
        LOG.assertTrue(lambdaBody != null);
        lambdaBody.replace(body);
        lambdaExpression = (PsiLambdaExpression)replacer.apply(lambdaExpression);
        HashSet<PsiVariable> variables = new HashSet<PsiVariable>();
        HashSet<String> usedLocalNames = new HashSet<String>();
        AnonymousCanBeLambdaInspection.collectLocalVariablesDefinedInsideLambda(lambdaExpression, variables, usedLocalNames);
        ReplaceWithLambdaFix.giveUniqueNames(project, elementFactory, lambdaExpression, usedLocalNames, variables.toArray(new PsiVariable[0]));
        PsiExpression singleExpr = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(lambdaExpression.getBody());
        if (singleExpr != null) {
            lambdaExpression.getBody().replace(singleExpr);
        }
        ChangeContextUtil.decodeContextInfo(lambdaExpression, null, null);
        AnonymousCanBeLambdaInspection.restoreComments(comments, lambdaExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(project);
        if (forceIgnoreTypeCast) {
            PsiExpression psiExpression = (PsiExpression)javaCodeStyleManager.shortenClassReferences(lambdaExpression);
            if (psiExpression == null) {
                AnonymousCanBeLambdaInspection.$$$reportNull$$$0(12);
            }
            return psiExpression;
        }
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + canonicalText + ")" + withoutTypesDeclared, lambdaExpression);
        PsiExpression typeCastOperand = typeCast.getOperand();
        LOG.assertTrue(typeCastOperand instanceof PsiLambdaExpression);
        PsiElement fromText = ((PsiLambdaExpression)typeCastOperand).getBody();
        LOG.assertTrue(fromText != null);
        lambdaBody = lambdaExpression.getBody();
        LOG.assertTrue(lambdaBody != null);
        fromText.replace(lambdaBody);
        ((PsiLambdaExpression)typeCastOperand).getParameterList().replace(lambdaExpression.getParameterList());
        typeCast = (PsiTypeCastExpression)lambdaExpression.replace(typeCast);
        if (RedundantCastUtil.isCastRedundant(typeCast)) {
            PsiExpression operand = typeCast.getOperand();
            LOG.assertTrue(operand != null);
            PsiExpression psiExpression = (PsiExpression)typeCast.replace(operand);
            if (psiExpression == null) {
                AnonymousCanBeLambdaInspection.$$$reportNull$$$0(13);
            }
            return psiExpression;
        }
        PsiExpression psiExpression = (PsiExpression)javaCodeStyleManager.shortenClassReferences(typeCast);
        if (psiExpression == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(14);
        }
        return psiExpression;
    }

    @NotNull
    static Collection<PsiComment> collectCommentsOutsideMethodBody(PsiElement anonymousClass, PsiCodeBlock body) {
        Collection<PsiComment> psiComments = PsiTreeUtil.findChildrenOfType(anonymousClass, PsiComment.class);
        psiComments.removeIf(comment -> PsiTreeUtil.isAncestor(body, comment, false));
        List<PsiComment> list = ContainerUtil.map(psiComments, comment -> (PsiComment)comment.copy());
        if (list == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static void collectLocalVariablesDefinedInsideLambda(PsiLambdaExpression lambdaExpression, final Set<PsiVariable> variables, Set<String> namesOfVariablesInTheBlock) {
        PsiElement block = PsiUtil.getTopLevelEnclosingCodeBlock(lambdaExpression, null);
        if (block == null) {
            block = lambdaExpression;
        }
        block.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitVariable(PsiVariable variable) {
                super.visitVariable(variable);
                if (!(variable instanceof PsiField)) {
                    variables.add(variable);
                }
            }
        });
        PsiResolveHelper helper = PsiResolveHelper.SERVICE.getInstance(lambdaExpression.getProject());
        Iterator<PsiVariable> iterator = variables.iterator();
        while (iterator.hasNext()) {
            PsiVariable local = iterator.next();
            String localName = local.getName();
            if (localName != null && !AnonymousCanBeLambdaInspection.shadowingResolve(localName, lambdaExpression, helper) && PsiTreeUtil.isAncestor(lambdaExpression, local, false)) continue;
            iterator.remove();
            namesOfVariablesInTheBlock.add(localName);
        }
    }

    private static boolean shadowingResolve(String localName, PsiLambdaExpression lambdaExpression, PsiResolveHelper helper) {
        PsiVariable variable = helper.resolveReferencedVariable(localName, lambdaExpression);
        return variable == null || variable instanceof PsiField;
    }

    public static boolean functionalInterfaceMethodReferenced(PsiMethod psiMethod, PsiAnonymousClass anonymClass, PsiCallExpression callExpression) {
        if (psiMethod != null && !psiMethod.hasModifierProperty("static")) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName())) {
                return false;
            }
            if (callExpression instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)callExpression).getMethodExpression().isQualified()) {
                return false;
            }
            if (InheritanceUtil.isInheritorOrSelf(anonymClass, containingClass, true) && !InheritanceUtil.hasEnclosingInstanceInScope(containingClass, anonymClass.getParent(), true, true)) {
                return true;
            }
        }
        return false;
    }

    public static void restoreComments(Collection<PsiComment> comments, PsiElement lambda2) {
        Object anchor = PsiTreeUtil.getParentOfType(lambda2, PsiStatement.class, PsiField.class);
        if (anchor == null) {
            anchor = lambda2;
        }
        for (PsiComment comment : comments) {
            anchor.getParent().addBefore(comment, (PsiElement)anchor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AnonymousCanBeLambdaInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeAnnotationsToIgnore";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRuntimeAnnotations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AnonymousCanBeLambdaInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLambdaByMethod";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommentsOutsideMethodBody";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasRuntimeAnnotations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeConvertedToLambda";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isLambdaForm";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceAnonymousWithLambda";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replacePsiElementWithLambda";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ForbiddenRefsChecker
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myBodyContainsForbiddenRefs;
        private final PsiMethod myMethod;
        private final PsiAnonymousClass myAnonymClass;

        public ForbiddenRefsChecker(PsiMethod method, PsiAnonymousClass aClass) {
            this.myMethod = method;
            this.myAnonymClass = aClass;
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitMethodCallExpression(methodCallExpression);
            PsiMethod psiMethod = methodCallExpression.resolveMethod();
            if (psiMethod == this.myMethod || AnonymousCanBeLambdaInspection.functionalInterfaceMethodReferenced(psiMethod, this.myAnonymClass, methodCallExpression) || psiMethod != null && !methodCallExpression.getMethodExpression().isQualified() && "getClass".equals(psiMethod.getName()) && psiMethod.getParameterList().isEmpty()) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        @Override
        public void visitThisExpression(PsiThisExpression expression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        @Override
        public void visitSuperExpression(PsiSuperExpression expression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitVariable(variable);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitReferenceExpression(expression);
            if (!(expression.getParent() instanceof PsiMethodCallExpression)) {
                PsiMember member = PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymClass, PsiMember.class);
                if (member instanceof PsiField || member instanceof PsiClassInitializer) {
                    PsiExpression initializer;
                    PsiElement resolved = expression.resolve();
                    PsiClass memberContainingClass = member.getContainingClass();
                    if (resolved instanceof PsiField && memberContainingClass != null && PsiTreeUtil.isAncestor(((PsiField)resolved).getContainingClass(), memberContainingClass, false) && expression.getQualifierExpression() == null && ((initializer = ((PsiField)resolved).getInitializer()) == null || resolved == member || initializer.getTextOffset() > this.myAnonymClass.getTextOffset() && ((PsiField)resolved).hasModifierProperty("static") == member.hasModifierProperty("static"))) {
                        this.myBodyContainsForbiddenRefs = true;
                    }
                } else {
                    PsiElement resolved;
                    PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymClass, PsiMethod.class);
                    if (method != null && method.isConstructor() && (resolved = expression.resolve()) instanceof PsiField && ((PsiField)resolved).hasModifierProperty("final") && ((PsiField)resolved).getInitializer() == null && ((PsiField)resolved).getContainingClass() == method.getContainingClass()) {
                        try {
                            int startOffset;
                            ControlFlow flow;
                            Collection<PsiVariable> writtenVariables;
                            PsiCodeBlock constructorBody = method.getBody();
                            if (constructorBody != null && !(writtenVariables = ControlFlowUtil.getWrittenVariables(flow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate(constructorBody), 0, startOffset = flow.getStartOffset(this.myAnonymClass), false)).contains(resolved)) {
                                this.myBodyContainsForbiddenRefs = true;
                            }
                        }
                        catch (AnalysisCanceledException e) {
                            this.myBodyContainsForbiddenRefs = true;
                        }
                    }
                }
            }
        }

        public boolean hasForbiddenRefs() {
            return this.myBodyContainsForbiddenRefs;
        }
    }

    private static class ReplaceWithLambdaFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithLambdaFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace with lambda" == null) {
                ReplaceWithLambdaFix.$$$reportNull$$$0(0);
            }
            return "Replace with lambda";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ReplaceWithLambdaFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithLambdaFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) != null) {
                AnonymousCanBeLambdaInspection.replacePsiElementWithLambda(element, false, false);
            }
        }

        private static void giveUniqueNames(Project project, final PsiElementFactory elementFactory, PsiElement body, Set<String> usedLocalNames, PsiVariable[] parameters) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
            final HashMap<PsiVariable, String> names = new HashMap<PsiVariable, String>();
            for (PsiVariable parameter : parameters) {
                String uniqueVariableName;
                String parameterName = parameter.getName();
                if (Comparing.equal(parameterName, uniqueVariableName = UniqueNameGenerator.generateUniqueName(codeStyleManager.suggestUniqueVariableName(parameterName, parameter.getParent(), false), usedLocalNames))) continue;
                names.put(parameter, uniqueVariableName);
            }
            if (names.isEmpty()) {
                return;
            }
            final LinkedHashMap replacements = new LinkedHashMap();
            body.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitVariable(PsiVariable variable) {
                    super.visitVariable(variable);
                    String newName = (String)names.get(variable);
                    if (newName != null) {
                        replacements.put(variable.getNameIdentifier(), elementFactory.createIdentifier(newName));
                    }
                }

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    String newName;
                    super.visitReferenceExpression(expression);
                    PsiElement resolve = expression.resolve();
                    if (resolve instanceof PsiVariable && (newName = (String)names.get(resolve)) != null) {
                        replacements.put(expression, elementFactory.createExpressionFromText(newName, expression));
                    }
                }
            });
            for (PsiElement psiElement : replacements.keySet()) {
                psiElement.replace((PsiElement)replacements.get(psiElement));
            }
        }

        private static String composeLambdaText(PsiMethod method) {
            StringBuilder buf = new StringBuilder();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1) {
                buf.append("(");
            }
            buf.append(StringUtil.join(parameters, ReplaceWithLambdaFix::composeParameter, ","));
            if (parameters.length != 1) {
                buf.append(")");
            }
            buf.append("-> {}");
            return buf.toString();
        }

        private static String composeParameter(PsiParameter parameter) {
            String parameterName = parameter.getName();
            if (parameterName == null) {
                parameterName = "";
            }
            return parameterName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

