/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.MethodDataExternalizer;
import com.intellij.codeInspection.dataFlow.NullityInference;
import com.intellij.codeInspection.dataFlow.NullityInferenceResult;
import com.intellij.codeInspection.dataFlow.ParameterNullityInferenceKt;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.codeInspection.dataFlow.PurityInference;
import com.intellij.codeInspection.dataFlow.PurityInferenceResult;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a<\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0017\u001a\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a,\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\n2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0\u001dH\u0002\"4\u0010\u0000\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004 \u0005*\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"gist", "Lcom/intellij/util/gist/PsiFileGist;", "", "", "Lcom/intellij/codeInspection/dataFlow/MethodData;", "kotlin.jvm.PlatformType", "calcData", "tree", "Lcom/intellij/lang/LighterAST;", "method", "Lcom/intellij/lang/LighterASTNode;", "createData", "body", "contracts", "", "Lcom/intellij/codeInspection/dataFlow/PreContract;", "nullity", "Lcom/intellij/codeInspection/dataFlow/NullityInferenceResult;", "purity", "Lcom/intellij/codeInspection/dataFlow/PurityInferenceResult;", "notNullParams", "Ljava/util/BitSet;", "getIndexedData", "Lcom/intellij/psi/impl/source/PsiMethodImpl;", "indexFile", "walkMethodBody", "", "root", "processor", "Lkotlin/Function1;", "intellij.java.analysis.impl"})
public final class ContractInferenceIndexKt {
    private static final PsiFileGist<Map<Integer, MethodData>> gist = GistManager.getInstance().newPsiFileGist("contractInference", 6, MethodDataExternalizer.INSTANCE, gist.1.INSTANCE);

    private static final Map<Integer, MethodData> indexFile(LighterAST tree) {
        HashMap result2 = new HashMap();
        RecursiveLighterASTNodeWalkingVisitor recursiveLighterASTNodeWalkingVisitor = new RecursiveLighterASTNodeWalkingVisitor(tree, result2, tree){
            private int methodIndex;
            final /* synthetic */ LighterAST $tree;
            final /* synthetic */ HashMap $result;

            public final int getMethodIndex() {
                return this.methodIndex;
            }

            public final void setMethodIndex(int n) {
                this.methodIndex = n;
            }

            public void visitNode(@NotNull LighterASTNode element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element.getTokenType() == JavaElementType.METHOD) {
                    MethodData methodData = ContractInferenceIndexKt.access$calcData(this.$tree, element);
                    if (methodData != null) {
                        MethodData methodData2;
                        MethodData data = methodData2 = methodData;
                        Map map = this.$result;
                        Integer n = this.methodIndex;
                        MethodData methodData3 = data;
                        map.put(n, methodData3);
                    }
                    int n = this.methodIndex;
                    this.methodIndex = n + 1;
                }
                if (JavaLightStubBuilder.isCodeBlockWithoutStubs(element)) {
                    return;
                }
                super.visitNode(element);
            }
            {
                this.$tree = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        LighterASTNode lighterASTNode = tree.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode, (String)"tree.root");
        recursiveLighterASTNodeWalkingVisitor.visitNode(lighterASTNode);
        return result2;
    }

    private static final MethodData calcData(LighterAST tree, LighterASTNode method) {
        LighterASTNode lighterASTNode = LightTreeUtil.firstChildOfType(tree, method, JavaElementType.CODE_BLOCK);
        if (lighterASTNode == null) {
            return null;
        }
        LighterASTNode body = lighterASTNode;
        List<LighterASTNode> statements = ContractInferenceInterpreter.getStatements(body, tree);
        List<PreContract> contracts2 = new ContractInferenceInterpreter(tree, method, body).inferContracts(statements);
        NullityInference.NullityInferenceVisitor nullityVisitor = new NullityInference.NullityInferenceVisitor(tree, body);
        PurityInference.PurityInferenceVisitor purityVisitor = new PurityInference.PurityInferenceVisitor(tree, body);
        Iterator<LighterASTNode> iterator = statements.iterator();
        while (iterator.hasNext()) {
            LighterASTNode statement;
            LighterASTNode lighterASTNode2 = statement = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode2, (String)"statement");
            ContractInferenceIndexKt.walkMethodBody(tree, lighterASTNode2, (Function1<? super LighterASTNode, Unit>)((Function1)new Function1<LighterASTNode, Unit>(nullityVisitor, purityVisitor){
                final /* synthetic */ NullityInference.NullityInferenceVisitor $nullityVisitor;
                final /* synthetic */ PurityInference.PurityInferenceVisitor $purityVisitor;

                public final void invoke(@NotNull LighterASTNode it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$nullityVisitor.visitNode(it);
                    this.$purityVisitor.visitNode(it);
                }
                {
                    this.$nullityVisitor = nullityInferenceVisitor;
                    this.$purityVisitor = purityInferenceVisitor;
                    super(1);
                }
            }));
        }
        List<LighterASTNode> list = statements;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"statements");
        BitSet notNullParams = ParameterNullityInferenceKt.inferNotNullParameters(tree, method, list);
        LighterASTNode lighterASTNode3 = body;
        Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode3, (String)"body");
        List<PreContract> list2 = contracts2;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"contracts");
        return ContractInferenceIndexKt.createData(lighterASTNode3, list2, nullityVisitor.getResult(), purityVisitor.getResult(), notNullParams);
    }

    private static final void walkMethodBody(LighterAST tree, LighterASTNode root, Function1<? super LighterASTNode, Unit> processor) {
        new RecursiveLighterASTNodeWalkingVisitor(processor, tree, tree){
            final /* synthetic */ Function1 $processor;
            final /* synthetic */ LighterAST $tree;

            public void visitNode(@NotNull LighterASTNode element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                IElementType type = element.getTokenType();
                if (type == JavaElementType.CLASS || type == JavaElementType.FIELD || type == JavaElementType.METHOD || type == JavaElementType.ANNOTATION_METHOD || type == JavaElementType.LAMBDA_EXPRESSION) {
                    return;
                }
                this.$processor.invoke((Object)element);
                super.visitNode(element);
            }
            {
                this.$processor = $captured_local_variable$0;
                this.$tree = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }.visitNode(root);
    }

    private static final MethodData createData(LighterASTNode body, List<? extends PreContract> contracts2, NullityInferenceResult nullity2, PurityInferenceResult purity2, BitSet notNullParams) {
        if (nullity2 == null && purity2 == null && contracts2.isEmpty() && notNullParams.isEmpty()) {
            return null;
        }
        return new MethodData(nullity2, purity2, contracts2, notNullParams, body.getStartOffset(), body.getEndOffset());
    }

    @Nullable
    public static final MethodData getIndexedData(@NotNull PsiMethodImpl method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Map<Integer, MethodData> map = gist.getFileData(method.getContainingFile());
        return map != null ? map.get(JavaStubImplUtil.getMethodStubIndex(method)) : null;
    }

    @Nullable
    public static final /* synthetic */ MethodData access$calcData(@NotNull LighterAST tree, @NotNull LighterASTNode method) {
        return ContractInferenceIndexKt.calcData(tree, method);
    }

    @NotNull
    public static final /* synthetic */ Map access$indexFile(@NotNull LighterAST tree) {
        return ContractInferenceIndexKt.indexFile(tree);
    }
}

