/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DataFlowInstructionVisitor
extends StandardInstructionVisitor {
    private static final Object ANY_VALUE = new Object();
    private final Map<NullabilityProblemKind.NullabilityProblem<?>, StateInfo> myStateInfos = new LinkedHashMap();
    private final Set<Instruction> myCCEInstructions = ContainerUtil.newHashSet();
    private final Map<MethodCallInstruction, Boolean> myFailingCalls = new HashMap<MethodCallInstruction, Boolean>();
    private final Map<PsiMethodCallExpression, ThreeState> myOptionalCalls = new HashMap<PsiMethodCallExpression, ThreeState>();
    private final Map<PsiMethodCallExpression, ThreeState> myBooleanCalls = new HashMap<PsiMethodCallExpression, ThreeState>();
    private final Map<MethodCallInstruction, ThreeState> myOfNullableCalls = new HashMap<MethodCallInstruction, ThreeState>();
    private final Map<PsiAssignmentExpression, Pair<PsiType, PsiType>> myArrayStoreProblems = new HashMap<PsiAssignmentExpression, Pair<PsiType, PsiType>>();
    private final Map<PsiMethodReferenceExpression, DfaValue> myMethodReferenceResults = new HashMap<PsiMethodReferenceExpression, DfaValue>();
    private final Map<PsiArrayAccessExpression, ThreeState> myOutOfBoundsArrayAccesses = new HashMap<PsiArrayAccessExpression, ThreeState>();
    private final List<PsiExpression> myOptionalQualifiers = new ArrayList<PsiExpression>();
    private final MultiMap<PushInstruction, Object> myPossibleVariableValues = MultiMap.createSet();
    private final Set<PsiElement> myReceiverMutabilityViolation = new HashSet<PsiElement>();
    private final Set<PsiElement> myArgumentMutabilityViolation = new HashSet<PsiElement>();
    private final Map<PsiExpression, Boolean> mySameValueAssigned = new HashMap<PsiExpression, Boolean>();
    private boolean myAlwaysReturnsNotNull = true;

    DataFlowInstructionVisitor() {
    }

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiExpression left = instruction.getLExpression();
        if (left != null && !Boolean.FALSE.equals(this.mySameValueAssigned.get(left))) {
            DfaValue dest = memState.peek();
            if (dest instanceof DfaVariableValue || dest instanceof DfaConstValue && !DataFlowInstructionVisitor.isFloatingZero(((DfaConstValue)dest).getValue())) {
                DfaMemoryState copy = memState.createCopy();
                copy.pop();
                DfaValue src = copy.peek();
                boolean sameValue = !copy.applyCondition(runner.getFactory().createCondition(dest, DfaRelationValue.RelationType.NE, src));
                this.mySameValueAssigned.merge(left, sameValue, Boolean::logicalAnd);
            } else {
                this.mySameValueAssigned.put(left, Boolean.FALSE);
            }
        }
        return super.visitAssign(instruction, runner, memState);
    }

    private static boolean isFloatingZero(Object value) {
        if (value instanceof Double) {
            return (Double)value == 0.0;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() == 0.0f;
        }
        return false;
    }

    StreamEx<PsiExpression> sameValueAssignments() {
        return StreamEx.ofKeys(this.mySameValueAssigned, Boolean::booleanValue);
    }

    @Override
    protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
        this.myCCEInstructions.add(instruction);
    }

    StreamEx<NullabilityProblemKind.NullabilityProblem<?>> problems() {
        return StreamEx.ofKeys(this.myStateInfos, info -> info.normalNpe || info.ephemeralNpe && !info.normalOk);
    }

    public Map<PsiAssignmentExpression, Pair<PsiType, PsiType>> getArrayStoreProblems() {
        return this.myArrayStoreProblems;
    }

    Map<PsiMethodCallExpression, ThreeState> getOptionalCalls() {
        return this.myOptionalCalls;
    }

    Map<MethodCallInstruction, ThreeState> getOfNullableCalls() {
        return this.myOfNullableCalls;
    }

    Map<PsiMethodCallExpression, ThreeState> getBooleanCalls() {
        return this.myBooleanCalls;
    }

    Map<PsiMethodReferenceExpression, DfaValue> getMethodReferenceResults() {
        return this.myMethodReferenceResults;
    }

    Set<Instruction> getClassCastExceptionInstructions() {
        return this.myCCEInstructions;
    }

    Set<PsiElement> getMutabilityViolations(boolean receiver) {
        return receiver ? this.myReceiverMutabilityViolation : this.myArgumentMutabilityViolation;
    }

    Stream<PsiArrayAccessExpression> outOfBoundsArrayAccesses() {
        return StreamEx.ofKeys(this.myOutOfBoundsArrayAccesses, ThreeState.YES::equals);
    }

    List<PsiExpression> getOptionalQualifiers() {
        return this.myOptionalQualifiers;
    }

    Map<PsiCall, List<MethodContract>> getAlwaysFailingCalls() {
        return StreamEx.ofKeys(this.myFailingCalls, v -> v).mapToEntry(MethodCallInstruction::getCallExpression, MethodCallInstruction::getContracts).toMap();
    }

    boolean isAlwaysReturnsNotNull(Instruction[] instructions) {
        return this.myAlwaysReturnsNotNull && ContainerUtil.exists(instructions, i -> i instanceof ReturnInstruction && ((ReturnInstruction)i).getAnchor() instanceof PsiReturnStatement);
    }

    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiMethodCallExpression call = ObjectUtils.tryCast(instruction.getCallExpression(), PsiMethodCallExpression.class);
        if (call != null) {
            String methodName = call.getMethodExpression().getReferenceName();
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown(call.getMethodExpression().getQualifierExpression());
            if (qualifier != null && TypeUtils.isOptional(qualifier.getType())) {
                if ("isPresent".equals(methodName) && qualifier instanceof PsiMethodCallExpression) {
                    this.myOptionalQualifiers.add(qualifier);
                } else if (DfaOptionalSupport.isOptionalGetMethodName(methodName)) {
                    Boolean fact = memState.getValueFact(memState.peek(), DfaFactType.OPTIONAL_PRESENCE);
                    ThreeState state = fact == null ? ThreeState.UNSURE : ThreeState.fromBoolean(fact);
                    this.myOptionalCalls.merge(call, state, ThreeState::merge);
                }
            }
        }
        if (instruction.matches(DfaOptionalSupport.OPTIONAL_OF_NULLABLE)) {
            DfaValue arg = memState.peek();
            ThreeState nullArg = memState.isNull(arg) ? ThreeState.YES : (memState.isNotNull(arg) ? ThreeState.NO : ThreeState.UNSURE);
            this.myOfNullableCalls.merge(instruction, nullArg, ThreeState::merge);
        }
        DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
        if (DataFlowInstructionVisitor.hasNonTrivialFailingContracts(instruction)) {
            DfaConstValue fail = runner.getFactory().getConstFactory().getContractFail();
            boolean allFail = Arrays.stream(states).allMatch(s -> s.getMemoryState().peek() == fail);
            this.myFailingCalls.merge(instruction, allFail, Boolean::logicalAnd);
        }
        this.handleBooleanCalls(instruction, states);
        return states;
    }

    void handleBooleanCalls(MethodCallInstruction instruction, DfaInstructionState[] states) {
        if (!DataFlowInstructionVisitor.hasNonTrivialBooleanContracts(instruction)) {
            return;
        }
        PsiMethod method = instruction.getTargetMethod();
        if (method == null || !ControlFlowAnalyzer.isPure(method)) {
            return;
        }
        PsiMethodCallExpression call = ObjectUtils.tryCast(instruction.getCallExpression(), PsiMethodCallExpression.class);
        if (call == null || this.myBooleanCalls.get(call) == ThreeState.UNSURE) {
            return;
        }
        PsiElement parent = call.getParent();
        if (parent instanceof PsiExpressionStatement) {
            return;
        }
        if (parent instanceof PsiLambdaExpression && PsiType.VOID.equals(LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)parent))) {
            return;
        }
        for (DfaInstructionState s : states) {
            Object value;
            DfaValue val = s.getMemoryState().peek();
            ThreeState state = ThreeState.UNSURE;
            if (val instanceof DfaConstValue && (value = ((DfaConstValue)val).getValue()) instanceof Boolean) {
                state = ThreeState.fromBoolean((Boolean)value);
            }
            this.myBooleanCalls.merge(call, state, ThreeState::merge);
        }
    }

    @Override
    protected void processArrayAccess(PsiArrayAccessExpression expression, boolean alwaysOutOfBounds) {
        this.myOutOfBoundsArrayAccesses.merge(expression, ThreeState.fromBoolean(alwaysOutOfBounds), ThreeState::merge);
    }

    @Override
    protected void processArrayStoreTypeMismatch(PsiAssignmentExpression assignmentExpression, PsiType fromType, PsiType toType) {
        if (assignmentExpression != null) {
            this.myArrayStoreProblems.put(assignmentExpression, Pair.create(fromType, toType));
        }
    }

    @Override
    protected void processMethodReferenceResult(PsiMethodReferenceExpression methodRef, List<? extends MethodContract> contracts2, DfaValue res) {
        if (contracts2.isEmpty() || !contracts2.get(0).isTrivial()) {
            this.myMethodReferenceResults.merge(methodRef, res, (a, b) -> a == b ? a : DfaUnknownValue.getInstance());
        }
    }

    @Override
    public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaValue;
        PsiExpression place = instruction.getPlace();
        if (!instruction.isReferenceWrite() && place instanceof PsiReferenceExpression && (dfaValue = instruction.getValue()) instanceof DfaVariableValue) {
            DfaConstValue constValue = memState.getConstantValue((DfaVariableValue)dfaValue);
            boolean report = constValue != null && DataFlowInstructionVisitor.shouldReportConstValue(constValue.getValue());
            this.myPossibleVariableValues.putValue(instruction, report ? constValue : ANY_VALUE);
        }
        return super.visitPush(instruction, runner, memState);
    }

    public List<Pair<PsiReferenceExpression, DfaConstValue>> getConstantReferenceValues() {
        ArrayList<Pair<PsiReferenceExpression, DfaConstValue>> result2 = ContainerUtil.newArrayList();
        for (PushInstruction instruction : this.myPossibleVariableValues.keySet()) {
            Object singleValue;
            Collection<Object> values = this.myPossibleVariableValues.get(instruction);
            if (values.size() != 1 || (singleValue = values.iterator().next()) == ANY_VALUE) continue;
            result2.add(Pair.create((PsiReferenceExpression)instruction.getPlace(), (DfaConstValue)singleValue));
        }
        return result2;
    }

    private static boolean hasNonTrivialFailingContracts(MethodCallInstruction instruction) {
        List<MethodContract> contracts2 = instruction.getContracts();
        return !contracts2.isEmpty() && contracts2.stream().anyMatch(contract -> contract.getReturnValue() == MethodContract.ValueConstraint.THROW_EXCEPTION && !contract.isTrivial());
    }

    private static boolean hasNonTrivialBooleanContracts(MethodCallInstruction instruction) {
        if (CustomMethodHandlers.find(instruction) != null) {
            return true;
        }
        List<MethodContract> contracts2 = instruction.getContracts();
        return !contracts2.isEmpty() && contracts2.stream().anyMatch(contract -> (contract.getReturnValue() == MethodContract.ValueConstraint.FALSE_VALUE || contract.getReturnValue() == MethodContract.ValueConstraint.TRUE_VALUE) && !contract.isTrivial());
    }

    @Override
    protected boolean checkNotNullable(DfaMemoryState state, DfaValue value, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        if (NullabilityProblemKind.nullableReturn.isMyProblem(problem) && !state.isNotNull(value)) {
            this.myAlwaysReturnsNotNull = false;
        }
        boolean ok = super.checkNotNullable(state, value, problem);
        if (problem == null) {
            return ok;
        }
        StateInfo info = this.myStateInfos.computeIfAbsent(problem, k -> new StateInfo());
        if (state.isEphemeral() && !ok) {
            info.ephemeralNpe = true;
        } else if (!state.isEphemeral()) {
            if (ok) {
                info.normalOk = true;
            } else {
                info.normalNpe = true;
            }
        }
        return ok;
    }

    @Override
    protected void reportMutabilityViolation(boolean receiver, @NotNull PsiElement anchor) {
        if (anchor == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(0);
        }
        if (receiver) {
            if (anchor instanceof PsiMethodReferenceExpression) {
                anchor = ((PsiMethodReferenceExpression)anchor).getReferenceNameElement();
            } else if (anchor instanceof PsiMethodCallExpression) {
                anchor = ((PsiMethodCallExpression)anchor).getMethodExpression().getReferenceNameElement();
            }
            if (anchor != null) {
                this.myReceiverMutabilityViolation.add(anchor);
            }
        } else {
            this.myArgumentMutabilityViolation.add(anchor);
        }
    }

    private static boolean shouldReportConstValue(Object value) {
        return value == null || value instanceof Boolean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/codeInspection/dataFlow/DataFlowInstructionVisitor", "reportMutabilityViolation"));
    }

    private static class StateInfo {
        boolean ephemeralNpe;
        boolean normalNpe;
        boolean normalOk;

        private StateInfo() {
        }
    }
}

