/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.TransferTarget;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaValueFactory {
    private final List<DfaValue> myValues = ContainerUtil.newArrayList();
    private final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myAssignableCache = ContainerUtil.newHashMap();
    private final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myConvertibleCache = ContainerUtil.newHashMap();
    private final Map<PsiType, DfaPsiType> myDfaTypes = ContainerUtil.newHashMap();
    private final boolean myUnknownMembersAreNullable;
    private final FieldChecker myFieldChecker;
    private static final ElementPattern<? extends PsiModifierListOwner> MEMBER_OR_METHOD_PARAMETER = StandardPatterns.or(new ElementPattern[]{PsiJavaPatterns.psiMember(), PsiJavaPatterns.psiParameter().withSuperParent(2, PsiJavaPatterns.psiMember())});
    private final Map<Pair<TransferTarget, FList<Trap>>, DfaControlTransferValue> myControlTransfers = FactoryMap.create(p -> new DfaControlTransferValue(this, (TransferTarget)p.first, (FList)p.second));
    private final DfaVariableValue.Factory myVarFactory;
    private final DfaConstValue.Factory myConstFactory;
    private final DfaBoxedValue.Factory myBoxedFactory;
    private final DfaRelationValue.Factory myRelationFactory;
    private final DfaExpressionFactory myExpressionFactory;
    private final DfaFactMapValue.Factory myFactFactory;

    public DfaValueFactory(@Nullable PsiElement context, boolean unknownMembersAreNullable) {
        this.myFieldChecker = new FieldChecker(context);
        this.myUnknownMembersAreNullable = unknownMembersAreNullable;
        this.myValues.add(null);
        this.myVarFactory = new DfaVariableValue.Factory(this);
        this.myConstFactory = new DfaConstValue.Factory(this);
        this.myBoxedFactory = new DfaBoxedValue.Factory(this);
        this.myRelationFactory = new DfaRelationValue.Factory(this);
        this.myExpressionFactory = new DfaExpressionFactory(this);
        this.myFactFactory = new DfaFactMapValue.Factory(this);
    }

    public boolean canTrustFieldInitializer(PsiField field) {
        return this.myFieldChecker.canTrustFieldInitializer(field);
    }

    @NotNull
    public Nullness suggestNullabilityForNonAnnotatedMember(@NotNull PsiModifierListOwner member) {
        if (member == null) {
            DfaValueFactory.$$$reportNull$$$0(0);
        }
        if (this.myUnknownMembersAreNullable && MEMBER_OR_METHOD_PARAMETER.accepts(member) && AnnotationUtil.getSuperAnnotationOwners(member).isEmpty()) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                DfaValueFactory.$$$reportNull$$$0(1);
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            DfaValueFactory.$$$reportNull$$$0(2);
        }
        return nullness;
    }

    @NotNull
    public DfaValue createTypeValue(@Nullable PsiType type, @NotNull Nullness nullability) {
        if (nullability == null) {
            DfaValueFactory.$$$reportNull$$$0(3);
        }
        if (type == null) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaValueFactory.$$$reportNull$$$0(4);
            }
            return dfaUnknownValue;
        }
        DfaFactMap facts = DfaFactMap.EMPTY.with(DfaFactType.TYPE_CONSTRAINT, TypeConstraint.EMPTY.withInstanceofValue(this.createDfaType(type))).with(DfaFactType.CAN_BE_NULL, NullnessUtil.toBoolean(nullability));
        DfaValue dfaValue = this.getFactFactory().createValue(facts);
        if (dfaValue == null) {
            DfaValueFactory.$$$reportNull$$$0(5);
        }
        return dfaValue;
    }

    @NotNull
    public <T> DfaValue withFact(@NotNull DfaValue value, @NotNull DfaFactType<T> factType, @Nullable T factValue) {
        if (value == null) {
            DfaValueFactory.$$$reportNull$$$0(6);
        }
        if (factType == null) {
            DfaValueFactory.$$$reportNull$$$0(7);
        }
        if (value instanceof DfaUnknownValue) {
            DfaValue dfaValue = this.getFactFactory().createValue(DfaFactMap.EMPTY.with(factType, factValue));
            if (dfaValue == null) {
                DfaValueFactory.$$$reportNull$$$0(8);
            }
            return dfaValue;
        }
        if (value instanceof DfaFactMapValue) {
            DfaValue dfaValue = ((DfaFactMapValue)value).withFact(factType, factValue);
            if (dfaValue == null) {
                DfaValueFactory.$$$reportNull$$$0(9);
            }
            return dfaValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            DfaValueFactory.$$$reportNull$$$0(10);
        }
        return dfaUnknownValue;
    }

    @NotNull
    public DfaPsiType createDfaType(@NotNull PsiType psiType) {
        if (psiType == null) {
            DfaValueFactory.$$$reportNull$$$0(11);
        }
        int dimensions = psiType.getArrayDimensions();
        if ((psiType = psiType.getDeepComponentType()) instanceof PsiClassType) {
            psiType = ((PsiClassType)psiType).rawType();
        }
        while (dimensions-- > 0) {
            psiType = psiType.createArrayType();
        }
        DfaPsiType dfaType = this.myDfaTypes.get(psiType);
        if (dfaType == null) {
            dfaType = new DfaPsiType(this.myDfaTypes.size() + 1, psiType, this.myAssignableCache, this.myConvertibleCache);
            this.myDfaTypes.put(psiType, dfaType);
        }
        DfaPsiType dfaPsiType = dfaType;
        if (dfaPsiType == null) {
            DfaValueFactory.$$$reportNull$$$0(12);
        }
        return dfaPsiType;
    }

    int registerValue(DfaValue value) {
        this.myValues.add(value);
        return this.myValues.size() - 1;
    }

    public DfaValue getValue(int id) {
        return this.myValues.get(id);
    }

    @NotNull
    public DfaPsiType getType(int id) {
        DfaPsiType dfaPsiType = (DfaPsiType)StreamEx.ofValues(this.myDfaTypes).findFirst(t -> t.getID() == id).orElseThrow(IllegalArgumentException::new);
        if (dfaPsiType == null) {
            DfaValueFactory.$$$reportNull$$$0(13);
        }
        return dfaPsiType;
    }

    @Nullable
    public DfaValue createValue(PsiExpression psiExpression) {
        return this.myExpressionFactory.getExpressionDfaValue(psiExpression);
    }

    @NotNull
    public DfaConstValue getInt(int value) {
        DfaConstValue dfaConstValue = this.getConstFactory().createFromValue(value, PsiType.INT, null);
        if (dfaConstValue == null) {
            DfaValueFactory.$$$reportNull$$$0(14);
        }
        return dfaConstValue;
    }

    @Nullable
    public DfaValue createLiteralValue(PsiLiteralExpression literal) {
        return this.getConstFactory().create(literal);
    }

    @NotNull
    public DfaValue createCondition(DfaValue dfaLeft, DfaRelationValue.RelationType relationType, DfaValue dfaRight) {
        DfaConstValue value = this.tryEvaluate(dfaLeft, relationType, dfaRight);
        if (value != null) {
            DfaConstValue dfaConstValue = value;
            if (dfaConstValue == null) {
                DfaValueFactory.$$$reportNull$$$0(15);
            }
            return dfaConstValue;
        }
        DfaRelationValue relation = this.getRelationFactory().createRelation(dfaLeft, relationType, dfaRight);
        if (relation != null) {
            DfaRelationValue dfaRelationValue = relation;
            if (dfaRelationValue == null) {
                DfaValueFactory.$$$reportNull$$$0(16);
            }
            return dfaRelationValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            DfaValueFactory.$$$reportNull$$$0(17);
        }
        return dfaUnknownValue;
    }

    @Nullable
    private DfaConstValue tryEvaluate(DfaValue dfaLeft, DfaRelationValue.RelationType relationType, DfaValue dfaRight) {
        if (dfaRight instanceof DfaFactMapValue && dfaLeft == this.getConstFactory().getNull()) {
            return this.tryEvaluate(dfaRight, relationType, dfaLeft);
        }
        if (dfaLeft instanceof DfaFactMapValue && dfaRight == this.getConstFactory().getNull() && Boolean.FALSE.equals(((DfaFactMapValue)dfaLeft).get(DfaFactType.CAN_BE_NULL))) {
            if (relationType == DfaRelationValue.RelationType.EQ) {
                return this.getConstFactory().getFalse();
            }
            if (relationType == DfaRelationValue.RelationType.NE) {
                return this.getConstFactory().getTrue();
            }
        }
        if (dfaLeft instanceof DfaFactMapValue && dfaRight instanceof DfaFactMapValue && (relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.IS_NOT)) {
            boolean isDistinct;
            DfaFactMap leftFacts = ((DfaFactMapValue)dfaLeft).getFacts();
            DfaFactMap rightFacts = ((DfaFactMapValue)dfaRight).getFacts();
            boolean isSuperState = rightFacts.isSuperStateOf(leftFacts);
            if (isSuperState) {
                return this.getBoolean(relationType == DfaRelationValue.RelationType.IS);
            }
            boolean bl = isDistinct = rightFacts.intersect(leftFacts) == null;
            if (isDistinct) {
                return this.getBoolean(relationType == DfaRelationValue.RelationType.IS_NOT);
            }
        }
        LongRangeSet leftRange = LongRangeSet.fromDfaValue(dfaLeft);
        LongRangeSet rightRange = LongRangeSet.fromDfaValue(dfaRight);
        if (leftRange != null && rightRange != null) {
            LongRangeSet constraint = rightRange.fromRelation(relationType);
            if (constraint != null && !constraint.intersects(leftRange)) {
                return this.getConstFactory().getFalse();
            }
            LongRangeSet revConstraint = rightRange.fromRelation(relationType.getNegated());
            if (revConstraint != null && !revConstraint.intersects(leftRange)) {
                return this.getConstFactory().getTrue();
            }
        }
        if (dfaLeft instanceof DfaConstValue && dfaRight instanceof DfaConstValue && (relationType == DfaRelationValue.RelationType.EQ || relationType == DfaRelationValue.RelationType.NE)) {
            return this.getBoolean(dfaLeft == dfaRight ^ !DfaUtil.isNaN(((DfaConstValue)dfaLeft).getValue()) ^ relationType == DfaRelationValue.RelationType.EQ);
        }
        return null;
    }

    public DfaConstValue getBoolean(boolean value) {
        return value ? this.getConstFactory().getTrue() : this.getConstFactory().getFalse();
    }

    public <T> DfaValue getFactValue(@NotNull DfaFactType<T> factType, @Nullable T value) {
        if (factType == null) {
            DfaValueFactory.$$$reportNull$$$0(18);
        }
        return this.getFactFactory().createValue(factType, value);
    }

    public Collection<DfaValue> getValues() {
        return Collections.unmodifiableCollection(this.myValues);
    }

    @NotNull
    public DfaControlTransferValue controlTransfer(TransferTarget kind, FList<Trap> traps) {
        DfaControlTransferValue dfaControlTransferValue = this.myControlTransfers.get(Pair.create(kind, traps));
        if (dfaControlTransferValue == null) {
            DfaValueFactory.$$$reportNull$$$0(19);
        }
        return dfaControlTransferValue;
    }

    @NotNull
    public DfaVariableValue.Factory getVarFactory() {
        DfaVariableValue.Factory factory = this.myVarFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(20);
        }
        return factory;
    }

    @NotNull
    public DfaConstValue.Factory getConstFactory() {
        DfaConstValue.Factory factory = this.myConstFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(21);
        }
        return factory;
    }

    @NotNull
    public DfaBoxedValue.Factory getBoxedFactory() {
        DfaBoxedValue.Factory factory = this.myBoxedFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(22);
        }
        return factory;
    }

    @NotNull
    public DfaRelationValue.Factory getRelationFactory() {
        DfaRelationValue.Factory factory = this.myRelationFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(23);
        }
        return factory;
    }

    @NotNull
    public DfaFactMapValue.Factory getFactFactory() {
        DfaFactMapValue.Factory factory = this.myFactFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(24);
        }
        return factory;
    }

    @NotNull
    public DfaExpressionFactory getExpressionFactory() {
        DfaExpressionFactory dfaExpressionFactory = this.myExpressionFactory;
        if (dfaExpressionFactory == null) {
            DfaValueFactory.$$$reportNull$$$0(25);
        }
        return dfaExpressionFactory;
    }

    private static boolean canCallMethodsInConstructors(PsiClass aClass, boolean virtual) {
        for (PsiMethod constructor : aClass.getConstructors()) {
            if (!constructor.getLanguage().isKindOf(JavaLanguage.INSTANCE)) {
                return true;
            }
            PsiCodeBlock body = constructor.getBody();
            if (body == null) continue;
            for (PsiMethodCallExpression call : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(body)).filter(PsiMethodCallExpression.class)) {
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                if (methodExpression.textMatches("this") || methodExpression.textMatches("super")) continue;
                if (!virtual) {
                    return true;
                }
                PsiMethod target = call.resolveMethod();
                if (target == null || !PsiUtil.canBeOverridden(target)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNullabilityForNonAnnotatedMember";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeValue";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withFact";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDfaType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInt";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createCondition";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "controlTransfer";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarFactory";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstFactory";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoxedFactory";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationFactory";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactFactory";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestNullabilityForNonAnnotatedMember";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTypeValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withFact";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDfaType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFactValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldChecker {
        private final boolean myTrustDirectFieldInitializers;
        private final boolean myTrustFieldInitializersInConstructors;
        private final boolean myCanInstantiateItself;
        private final PsiClass myClass;

        FieldChecker(PsiElement context) {
            PsiMethod method = context instanceof PsiClass ? null : PsiTreeUtil.getParentOfType(context, PsiMethod.class);
            PsiClass psiClass2 = this.myClass = method == null ? null : method.getContainingClass();
            if (this.myClass == null) {
                this.myCanInstantiateItself = false;
                this.myTrustFieldInitializersInConstructors = false;
                this.myTrustDirectFieldInitializers = false;
                return;
            }
            this.myCanInstantiateItself = ((StreamEx)StreamEx.of((Object[])this.myClass.getChildren()).select(PsiMember.class).filter(member -> member.hasModifierProperty("static"))).flatMap(member -> StreamEx.ofTree((Object)member, e -> StreamEx.of((Object[])e.getChildren()))).select(PsiNewExpression.class).map(newExpr -> newExpr.getClassReference()).nonNull().anyMatch(classRef -> classRef.isReferenceTo(this.myClass));
            if (method.hasModifierProperty("static") || method.isConstructor()) {
                this.myTrustDirectFieldInitializers = true;
                this.myTrustFieldInitializersInConstructors = false;
                return;
            }
            boolean superCtorsCallMethods = !InheritanceUtil.processSupers(this.myClass, false, psiClass -> !DfaValueFactory.canCallMethodsInConstructors(psiClass, true));
            boolean thisCtorsCallMethods = DfaValueFactory.canCallMethodsInConstructors(this.myClass, false);
            this.myTrustFieldInitializersInConstructors = !superCtorsCallMethods && !thisCtorsCallMethods;
            this.myTrustDirectFieldInitializers = !superCtorsCallMethods;
        }

        boolean canTrustFieldInitializer(PsiField field) {
            if (field.hasInitializer()) {
                boolean staticField = field.hasModifierProperty("static");
                if (staticField && this.myClass != null && field.getContainingClass() != this.myClass) {
                    return true;
                }
                return this.myTrustDirectFieldInitializers && (!this.myCanInstantiateItself || !staticField);
            }
            return this.myTrustFieldInitializersInConstructors;
        }
    }
}

