/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefJavaModuleImpl
extends RefElementImpl
implements RefJavaModule {
    private final RefModule myRefModule;
    private Map<String, List<String>> myExportedPackageNames;
    private Set<RefClass> myServiceInterfaces;
    private Set<RefClass> myServiceImplementations;
    private Set<RefClass> myUsedServices;
    private List<RefJavaModule.RequiredModule> myRequiredModules;

    RefJavaModuleImpl(@NotNull PsiJavaModule javaModule, @NotNull RefManagerImpl manager) {
        if (javaModule == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(1);
        }
        super(javaModule.getName(), javaModule, manager);
        this.myRefModule = manager.getRefModule(ModuleUtilCore.findModuleForPsiElement(javaModule));
        JAVA_MODULE.set(this.myRefModule, this);
    }

    @Override
    protected void initialize() {
        ((RefModuleImpl)this.myRefModule).add(this);
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor == null) {
                    RefJavaModuleImpl.$$$reportNull$$$0(13);
                }
                ((RefJavaVisitor)visitor).visitJavaModule(this);
            });
        } else {
            super.accept(visitor);
        }
    }

    @Override
    @Nullable
    public PsiJavaModule getElement() {
        return (PsiJavaModule)super.getElement();
    }

    @Override
    @Nullable
    public RefModule getModule() {
        return this.myRefModule;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getExportedPackageNames() {
        Map<String, List<String>> map = this.myExportedPackageNames != null ? this.myExportedPackageNames : Collections.emptyMap();
        if (map == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Override
    @NotNull
    public Set<RefClass> getServiceInterfaces() {
        Set<RefClass> set = this.myServiceInterfaces != null ? this.myServiceInterfaces : Collections.emptySet();
        if (set == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<RefClass> getServiceImplementations() {
        Set<RefClass> set = this.myServiceImplementations != null ? this.myServiceImplementations : Collections.emptySet();
        if (set == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<RefClass> getUsedServices() {
        Set<RefClass> set = this.myUsedServices != null ? this.myUsedServices : Collections.emptySet();
        if (set == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Override
    @NotNull
    public List<RefJavaModule.RequiredModule> getRequiredModules() {
        List<RefJavaModule.RequiredModule> list = this.myRequiredModules != null ? this.myRequiredModules : Collections.emptyList();
        if (list == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        return AllIcons.Nodes.JavaModule;
    }

    private void buildRequiresReferences(PsiJavaModule javaModule) {
        for (PsiRequiresStatement statement : javaModule.getRequires()) {
            PsiElement element;
            PsiJavaModuleReferenceElement referenceElement = statement.getReferenceElement();
            if (referenceElement == null || !((element = this.addReference(referenceElement.getReference())) instanceof PsiJavaModule)) continue;
            PsiJavaModule requiredModule = (PsiJavaModule)element;
            Map<String, List<String>> packagesExportedByModule = RefJavaModuleImpl.getPackagesExportedByModule(requiredModule);
            if (this.myRequiredModules == null) {
                this.myRequiredModules = new ArrayList<RefJavaModule.RequiredModule>(1);
            }
            this.myRequiredModules.add(new RefJavaModule.RequiredModule(requiredModule.getName(), packagesExportedByModule, statement.hasModifierProperty("transitive")));
        }
    }

    private void buildExportsReferences(PsiJavaModule javaModule) {
        List emptyList = Collections.emptyList();
        for (PsiPackageAccessibilityStatement statement : javaModule.getExports()) {
            PsiElement element = this.addReference(statement.getPackageReference());
            String packageName = null;
            if (element instanceof PsiPackage) {
                packageName = ((PsiPackage)element).getQualifiedName();
                if (this.myExportedPackageNames == null) {
                    this.myExportedPackageNames = new THashMap(1);
                }
                this.myExportedPackageNames.put(packageName, emptyList);
            }
            for (PsiJavaModuleReferenceElement referenceElement : statement.getModuleReferences()) {
                if (referenceElement == null) continue;
                PsiElement moduleElement = this.addReference(referenceElement.getReference());
                if (packageName == null || !(moduleElement instanceof PsiJavaModule)) continue;
                List<String> toModuleNames = this.myExportedPackageNames.get(packageName);
                if (toModuleNames == emptyList) {
                    toModuleNames = new ArrayList<String>(1);
                    this.myExportedPackageNames.put(packageName, toModuleNames);
                }
                toModuleNames.add(((PsiJavaModule)moduleElement).getName());
            }
        }
    }

    private void buildProvidesReferences(PsiJavaModule javaModule) {
        for (PsiProvidesStatement statement : javaModule.getProvides()) {
            RefElement refInterface;
            PsiElement providerInterface;
            PsiJavaCodeReferenceElement interfaceReference = statement.getInterfaceReference();
            PsiReferenceList implementationList = statement.getImplementationList();
            if (interfaceReference == null || implementationList == null || !((providerInterface = interfaceReference.resolve()) instanceof PsiClass) || !((refInterface = this.getRefManager().getReference(providerInterface)) instanceof RefClassImpl)) continue;
            if (this.myServiceInterfaces == null) {
                this.myServiceInterfaces = new THashSet();
            }
            this.myServiceInterfaces.add((RefClass)refInterface);
            for (PsiJavaCodeReferenceElement implementationReference : implementationList.getReferenceElements()) {
                RefElement refClass;
                PsiElement implementationClass = implementationReference.resolve();
                if (!(implementationClass instanceof PsiClass)) continue;
                RefElement refTargetElement = null;
                PsiElement targetElement = RefJavaModuleImpl.getProviderMethod((PsiClass)implementationClass);
                if (targetElement == null && (refClass = this.getRefManager().getReference(implementationClass)) instanceof RefClassImpl) {
                    PsiModifierListOwner constructorElement;
                    if (this.myServiceImplementations == null) {
                        this.myServiceImplementations = new THashSet();
                    }
                    this.myServiceImplementations.add((RefClass)refClass);
                    RefMethod refConstructor = ((RefClassImpl)refClass).getDefaultConstructor();
                    if (refConstructor != null && (constructorElement = refConstructor.getElement()) != null && constructorElement.hasModifierProperty("public")) {
                        refTargetElement = refConstructor;
                        targetElement = constructorElement;
                    }
                }
                if (targetElement == null) {
                    targetElement = implementationClass;
                }
                if (refTargetElement == null) {
                    refTargetElement = this.getRefManager().getReference(targetElement);
                }
                if (refTargetElement == null) continue;
                ((RefClassImpl)refInterface).addReference(refTargetElement, targetElement, providerInterface, false, true, null);
            }
        }
    }

    private void buildUsesReferences(PsiJavaModule javaModule) {
        for (PsiUsesStatement statement : javaModule.getUses()) {
            RefElement refClass;
            PsiElement usedInterface;
            PsiJavaCodeReferenceElement reference = statement.getClassReference();
            if (reference == null || !((usedInterface = reference.resolve()) instanceof PsiClass) || !((refClass = this.getRefManager().getReference(usedInterface)) instanceof RefClass)) continue;
            if (this.myUsedServices == null) {
                this.myUsedServices = new THashSet();
            }
            this.myUsedServices.add((RefClass)refClass);
        }
    }

    @Override
    public void buildReferences() {
        PsiJavaModule javaModule = this.getElement();
        if (javaModule != null) {
            this.buildRequiresReferences(javaModule);
            this.buildExportsReferences(javaModule);
            this.buildProvidesReferences(javaModule);
            this.buildUsesReferences(javaModule);
            this.getRefManager().fireBuildReferences(this);
        }
    }

    private PsiElement addReference(PsiPolyVariantReference reference) {
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        if (reference != null) {
            ResolveResult[] resolveResults;
            for (ResolveResult resolveResult : resolveResults = reference.multiResolve(false)) {
                PsiElement element = resolveResult.getElement();
                if (element == null) continue;
                resolvedElements.add(element);
                RefElement refElement = this.getRefManager().getReference(element);
                if (refElement == null) continue;
                this.addOutReference(refElement);
                ((RefElementImpl)refElement).addInReference(this);
            }
        }
        return resolvedElements.size() == 1 ? (PsiElement)resolvedElements.get(0) : null;
    }

    @Nullable
    public static RefJavaModule moduleFromExternalName(@NotNull RefManagerImpl manager, @NotNull String fqName) {
        PsiJavaModule javaModule;
        if (manager == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(8);
        }
        if (fqName == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(9);
        }
        return (javaModule = ContainerUtil.getFirstItem(JavaModuleNameIndex.getInstance().get(fqName, manager.getProject(), GlobalSearchScope.projectScope(manager.getProject())))) == null ? null : new RefJavaModuleImpl(javaModule, manager);
    }

    @NotNull
    private static Map<String, List<String>> getPackagesExportedByModule(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(10);
        }
        THashMap exportedPackages = new THashMap();
        for (PsiPackageAccessibilityStatement statement : javaModule.getExports()) {
            String packageName = statement.getPackageName();
            if (packageName == null) continue;
            exportedPackages.put(packageName, statement.getModuleNames());
        }
        Object object = !exportedPackages.isEmpty() ? exportedPackages : Collections.emptyMap();
        if (object == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(11);
        }
        return object;
    }

    @Nullable
    private static PsiMethod getProviderMethod(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(12);
        }
        PsiMethod[] methods = psiClass.findMethodsByName("provider", false);
        return ContainerUtil.find(methods, m -> m.hasModifierProperty("public") && m.hasModifierProperty("static") && m.getParameterList().isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefJavaModuleImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefJavaModuleImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedPackageNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceInterfaces";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceImplementations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedServices";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredModules";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesExportedByModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moduleFromExternalName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesExportedByModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProviderMethod";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$accept$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

