/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class UnixProcessManager {
    private static final Logger LOG = Logger.getInstance(UnixProcessManager.class);
    public static final int SIGINT = 2;
    public static final int SIGKILL = 9;
    public static final int SIGTERM = 15;
    private static final CLib C_LIB;

    private UnixProcessManager() {
    }

    public static int getProcessId(@NotNull Process process) {
        if (process == null) {
            UnixProcessManager.$$$reportNull$$$0(0);
        }
        try {
            if (SystemInfo.IS_AT_LEAST_JAVA9 && "java.lang.ProcessImpl".equals(process.getClass().getName())) {
                return ((Long)Process.class.getMethod("pid", new Class[0]).invoke((Object)process, new Object[0])).intValue();
            }
            return ObjectUtils.assertNotNull(ReflectionUtil.getField(process.getClass(), process, Integer.TYPE, "pid"));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to get PID from instance of " + process.getClass() + ", OS: " + SystemInfo.OS_NAME, t);
        }
    }

    public static int getCurrentProcessId() {
        return C_LIB != null ? C_LIB.getpid() : 0;
    }

    public static int sendSignal(int pid, int signal) {
        UnixProcessManager.checkCLib();
        return C_LIB.kill(pid, signal);
    }

    private static void checkCLib() {
        if (C_LIB == null) {
            throw new IllegalStateException("Couldn't load c library, OS: " + SystemInfo.OS_NAME + ", isUnix: " + SystemInfo.isUnix);
        }
    }

    public static boolean sendSigIntToProcessTree(@NotNull Process process) {
        if (process == null) {
            UnixProcessManager.$$$reportNull$$$0(1);
        }
        return UnixProcessManager.sendSignalToProcessTree(process, 2);
    }

    public static boolean sendSigKillToProcessTree(@NotNull Process process) {
        if (process == null) {
            UnixProcessManager.$$$reportNull$$$0(2);
        }
        return UnixProcessManager.sendSignalToProcessTree(process, 9);
    }

    public static boolean sendSignalToProcessTree(@NotNull Process process, int signal) {
        if (process == null) {
            UnixProcessManager.$$$reportNull$$$0(3);
        }
        try {
            return UnixProcessManager.sendSignalToProcessTree(UnixProcessManager.getProcessId(process), signal);
        }
        catch (Exception e) {
            LOG.warn("Error killing the process", e);
            return false;
        }
    }

    public static boolean sendSignalToProcessTree(int processId, int signal) {
        boolean result2;
        UnixProcessManager.checkCLib();
        int our_pid = C_LIB.getpid();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending signal " + signal + " to process tree with root PID " + processId);
        }
        Ref<Integer> foundPid = new Ref<Integer>();
        ProcessInfo processInfo = new ProcessInfo();
        ArrayList<Integer> childrenPids = new ArrayList<Integer>();
        UnixProcessManager.findChildProcesses(our_pid, processId, foundPid, processInfo, childrenPids);
        if (!foundPid.isNull()) {
            processInfo.killProcTree(foundPid.get(), signal);
            result2 = true;
        } else {
            for (Integer pid : childrenPids) {
                processInfo.killProcTree(pid, signal);
            }
            boolean bl = result2 = !childrenPids.isEmpty();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done sending signal " + signal + "; found: " + foundPid.get() + ", children: " + childrenPids + ", result: " + result2);
        }
        return result2;
    }

    private static void findChildProcesses(final int our_pid, final int process_pid, final Ref<Integer> foundPid, final ProcessInfo processInfo, final List<Integer> childrenPids) {
        final Ref<Boolean> ourPidFound = Ref.create(false);
        UnixProcessManager.processPSOutput(UnixProcessManager.getPSCmd(false), new Processor<String>(){

            @Override
            public boolean process(String s) {
                StringTokenizer st = new StringTokenizer(s, " ");
                int parent_pid = Integer.parseInt(st.nextToken());
                int pid = Integer.parseInt(st.nextToken());
                processInfo.register(pid, parent_pid);
                if (parent_pid == process_pid) {
                    childrenPids.add(pid);
                }
                if (pid == our_pid) {
                    ourPidFound.set(true);
                } else if (pid == process_pid) {
                    if (parent_pid == our_pid || our_pid == -1) {
                        foundPid.set(pid);
                    } else {
                        throw new IllegalStateException("Process (pid=" + process_pid + ") is not our child(our pid = " + our_pid + ")");
                    }
                }
                return false;
            }
        });
        if (our_pid != -1 && !ourPidFound.get().booleanValue()) {
            throw new IllegalStateException("IDE pid is not found in ps list(" + our_pid + ")");
        }
    }

    public static void processPSOutput(String[] cmd, Processor<String> processor) {
        UnixProcessManager.processCommandOutput(cmd, processor, true, true);
    }

    public static void processCommandOutput(String[] cmd, Processor<String> processor, boolean skipFirstLine, boolean throwOnError) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            UnixProcessManager.processCommandOutput(p, processor, skipFirstLine, throwOnError);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommandOutput(Process process, Processor<String> processor, boolean skipFirstLine, boolean throwOnError) throws IOException {
        BufferedReader stdOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            try {
                String s;
                if (skipFirstLine) {
                    stdOutput.readLine();
                }
                while ((s = stdOutput.readLine()) != null) {
                    processor.process(s);
                }
                StringBuilder errorStr = new StringBuilder();
                while ((s = stdError.readLine()) != null) {
                    if (s.contains("environment variables being ignored")) continue;
                    errorStr.append(s).append("\n");
                }
                if (throwOnError && errorStr.length() > 0) {
                    throw new IOException("Error reading ps output:" + errorStr.toString());
                }
            }
            finally {
                stdError.close();
            }
        }
        finally {
            stdOutput.close();
        }
    }

    public static String[] getPSCmd(boolean commandLineOnly) {
        return UnixProcessManager.getPSCmd(commandLineOnly, false);
    }

    public static String[] getPSCmd(boolean commandLineOnly, boolean isShortenCommand) {
        String psCommand = "/bin/ps";
        if (!new File(psCommand).isFile()) {
            psCommand = "ps";
        }
        if (SystemInfo.isLinux) {
            return new String[]{psCommand, "-e", "--format", commandLineOnly ? "%a" : "%P%p%a"};
        }
        if (SystemInfo.isMac || SystemInfo.isFreeBSD) {
            String command = isShortenCommand ? "comm" : "command";
            return new String[]{psCommand, "-ax", "-o", commandLineOnly ? command : "ppid,pid," + command};
        }
        throw new IllegalStateException(System.getProperty("os.name") + " is not supported.");
    }

    public static int getProcessPid(@NotNull Process process) {
        if (process == null) {
            UnixProcessManager.$$$reportNull$$$0(4);
        }
        return UnixProcessManager.getProcessId(process);
    }

    static {
        CLib lib = null;
        try {
            if (SystemInfo.isUnix && JnaLoader.isLoaded()) {
                lib = (CLib)Native.loadLibrary((String)"c", CLib.class);
            }
        }
        catch (Throwable t) {
            Logger.getInstance(UnixProcessManager.class).warn("Can't load standard library", t);
        }
        C_LIB = lib;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "process";
        objectArray2[1] = "com/intellij/execution/process/UnixProcessManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSigIntToProcessTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSigKillToProcessTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSignalToProcessTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessPid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProcessInfo {
        private final Map<Integer, List<Integer>> BY_PARENT = new TreeMap<Integer, List<Integer>>();

        private ProcessInfo() {
        }

        public void register(Integer pid, Integer parentPid) {
            List<Integer> children = this.BY_PARENT.get(parentPid);
            if (children == null) {
                children = new LinkedList<Integer>();
                this.BY_PARENT.put(parentPid, children);
            }
            children.add(pid);
        }

        public void killProcTree(int pid, int signal) {
            List<Integer> children = this.BY_PARENT.get(pid);
            if (children != null) {
                for (int child : children) {
                    this.killProcTree(child, signal);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending signal " + signal + " to PID " + pid);
            }
            UnixProcessManager.sendSignal(pid, signal);
        }
    }

    private static interface CLib
    extends Library {
        public int getpid();

        public int kill(int var1, int var2);
    }
}

