/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class SyntheticLibrary {
    @NotNull
    public abstract Collection<VirtualFile> getSourceRoots();

    @NotNull
    public Collection<VirtualFile> getBinaryRoots() {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            SyntheticLibrary.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            SyntheticLibrary.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    public Condition<VirtualFile> getExcludeFileCondition() {
        return null;
    }

    public boolean isShowInExternalLibrariesNode() {
        return this instanceof ItemPresentation;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(2);
        }
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptySet(), null);
        if (syntheticLibrary == null) {
            SyntheticLibrary.$$$reportNull$$$0(3);
        }
        return syntheticLibrary;
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots, @NotNull Set<VirtualFile> excludedRoots, @Nullable Condition<VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(4);
        }
        if (excludedRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(5);
        }
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(Collections.emptySet(), sourceRoots, excludedRoots, excludeCondition);
        if (syntheticLibrary == null) {
            SyntheticLibrary.$$$reportNull$$$0(6);
        }
        return syntheticLibrary;
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(final @NotNull Collection<VirtualFile> binaryRoots, final @NotNull Collection<VirtualFile> sourceRoots, final @NotNull Set<VirtualFile> excludedRoots, final @Nullable Condition<VirtualFile> excludeCondition) {
        if (binaryRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(7);
        }
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(8);
        }
        if (excludedRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(9);
        }
        SyntheticLibrary syntheticLibrary = new SyntheticLibrary(){

            @Override
            @NotNull
            public Collection<VirtualFile> getSourceRoots() {
                Collection collection = sourceRoots;
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<VirtualFile> getBinaryRoots() {
                Collection collection = binaryRoots;
                if (collection == null) {
                    1.$$$reportNull$$$0(1);
                }
                return collection;
            }

            @Override
            @NotNull
            public Set<VirtualFile> getExcludedRoots() {
                Set set = excludedRoots;
                if (set == null) {
                    1.$$$reportNull$$$0(2);
                }
                return set;
            }

            @Override
            @Nullable
            public Condition<VirtualFile> getExcludeFileCondition() {
                return excludeCondition;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SyntheticLibrary library = (SyntheticLibrary)o;
                if (!sourceRoots.equals(library.getSourceRoots())) {
                    return false;
                }
                if (!excludedRoots.equals(library.getExcludedRoots())) {
                    return false;
                }
                return !(excludeCondition != null ? !excludeCondition.equals(library.getExcludeFileCondition()) : library.getExcludeFileCondition() != null);
            }

            @Override
            public int hashCode() {
                int result2 = sourceRoots.hashCode();
                result2 = 31 * result2 + excludedRoots.hashCode();
                result2 = 31 * result2 + (excludeCondition != null ? excludeCondition.hashCode() : 0);
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/roots/SyntheticLibrary$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSourceRoots";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBinaryRoots";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExcludedRoots";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (syntheticLibrary == null) {
            SyntheticLibrary.$$$reportNull$$$0(10);
        }
        return syntheticLibrary;
    }

    @NotNull
    public final Set<VirtualFile> getAllRoots() {
        Set<VirtualFile> set = this.getRoots(true, true);
        if (set == null) {
            SyntheticLibrary.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    private Set<VirtualFile> getRoots(boolean includeSources, boolean includeBinaries) {
        THashSet roots = ContainerUtil.newTroveSet();
        if (includeSources) {
            roots.addAll(this.getSourceRoots());
        }
        if (includeBinaries) {
            roots.addAll(this.getBinaryRoots());
        }
        THashSet tHashSet = roots;
        if (tHashSet == null) {
            SyntheticLibrary.$$$reportNull$$$0(12);
        }
        return tHashSet;
    }

    public final boolean contains(@NotNull VirtualFile file, boolean includeSources, boolean includeBinaries) {
        if (file == null) {
            SyntheticLibrary.$$$reportNull$$$0(13);
        }
        return VfsUtilCore.isUnder(file, this.getRoots(includeSources, includeBinaries)) && !VfsUtilCore.isUnder(file, this.getExcludedRoots());
    }

    public final boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            SyntheticLibrary.$$$reportNull$$$0(14);
        }
        return this.contains(file, true, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/SyntheticLibrary";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryRoots";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/SyntheticLibrary";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newImmutableLibrary";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newImmutableLibrary";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

