/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.AstPath;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.reference.SoftReference;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.LazyParseableElement");
    private static final StaticGetter<CharSequence> NO_TEXT = new StaticGetter<Object>(null);
    private final ChameleonLock lock;
    @NotNull
    private Getter<CharSequence> myText;
    private volatile boolean myParsed;
    private static boolean ourParsingAllowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyParseableElement(@NotNull IElementType type, @Nullable CharSequence text2) {
        if (type == null) {
            LazyParseableElement.$$$reportNull$$$0(0);
        }
        super(type);
        ChameleonLock chameleonLock = this.lock = new ChameleonLock();
        synchronized (chameleonLock) {
            boolean bl = this.myParsed = text2 == null;
            if (text2 == null) {
                this.myText = NO_TEXT;
            } else {
                this.myText = new StaticGetter<CharSequence>(ImmutableCharSequence.asImmutable(text2));
                this.setCachedLength(text2.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myParsed) {
                this.myText = NO_TEXT;
            } else {
                this.setCachedLength(this.myText.get().length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getText() {
        CharSequence text2 = this.myText();
        if (text2 != null) {
            String string = text2.toString();
            if (string == null) {
                LazyParseableElement.$$$reportNull$$$0(1);
            }
            return string;
        }
        String s = super.getText();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            this.myText = new SoftReference<String>(s);
        }
        String string = s;
        if (string == null) {
            LazyParseableElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text2 = this.myText();
        CharSequence charSequence = text2 != null ? text2 : this.getText();
        if (charSequence == null) {
            LazyParseableElement.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @Override
    public int getTextLength() {
        CharSequence text2 = this.myText();
        if (text2 != null) {
            return text2.length();
        }
        return super.getTextLength();
    }

    @Override
    public int getNotCachedLength() {
        CharSequence text2 = this.myText();
        if (text2 != null) {
            return text2.length();
        }
        return super.getNotCachedLength();
    }

    @Override
    public int hc() {
        CharSequence text2 = this.myText();
        return text2 == null ? super.hc() : LeafElement.leafHC(text2);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        CharSequence text2;
        if (buffer == null) {
            LazyParseableElement.$$$reportNull$$$0(4);
        }
        if ((text2 = this.myText()) != null) {
            return LeafElement.leafTextMatches(text2, buffer, start);
        }
        return super.textMatches(buffer, start);
    }

    public boolean isParsed() {
        return this.myParsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence myText() {
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            return this.myText.get();
        }
    }

    @Override
    final void setFirstChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child);
    }

    @Override
    final void setLastChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParsed() {
        CharSequence text2;
        if (!ourParsingAllowed) {
            LOG.error("Parsing not allowed!!!");
        }
        if (this.myParsed) {
            return;
        }
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myParsed) {
                return;
            }
            text2 = this.myText.get();
            assert (text2 != null);
        }
        if (TreeUtil.getFileElement(this) == null) {
            LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DebugUtil.performPsiModification("lazy-parsing", () -> {
            TreeElement parsedNode = (TreeElement)((ILazyParseableElementTypeBase)((Object)this.getElementType())).parseContents(this);
            this.assertTextLengthIntact(text2, parsedNode);
            ChameleonLock chameleonLock = this.lock;
            synchronized (chameleonLock) {
                if (this.myParsed) {
                    return;
                }
                if (this.rawFirstChild() != null) {
                    LOG.error("Reentrant parsing?");
                }
                if (parsedNode != null) {
                    this.setChildren(parsedNode, AstPath.getNodePath(this));
                }
                this.myParsed = true;
                this.myText = new SoftReference<CharSequence>(text2);
            }
        });
    }

    private void assertTextLengthIntact(CharSequence text2, TreeElement child) {
        int length = 0;
        while (child != null) {
            length += child.getTextLength();
            child = child.getTreeNext();
        }
        if (length != text2.length()) {
            LOG.error("Text mismatch in " + LogUtil.objectAndClass(this.getElementType()), new Attachment("code.txt", text2.toString()));
        }
    }

    private void setChildren(@NotNull TreeElement parsedNode, @Nullable AstPath thisPath) {
        if (parsedNode == null) {
            LazyParseableElement.$$$reportNull$$$0(5);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            if (parsedNode == null) {
                LazyParseableElement.$$$reportNull$$$0(7);
            }
            try {
                AstPath.cacheNodePaths(this, parsedNode, thisPath);
                TreeElement last = LazyParseableElement.rawSetParents(parsedNode, this);
                super.setFirstChildNode(parsedNode);
                super.setLastChildNode(last);
            }
            catch (Throwable e) {
                LOG.error("Chameleon expansion may not be interrupted by exceptions", e);
            }
        });
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (first == null) {
            LazyParseableElement.$$$reportNull$$$0(6);
        }
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        CharSequence text2 = this.myText();
        if (text2 == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars(text2, buffer, start);
        }
        return start + text2.length();
    }

    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/LazyParseableElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/LazyParseableElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildrenWithoutNotifications";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setChildren$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChameleonLock {
        private ChameleonLock() {
        }

        @NonNls
        public String toString() {
            return "chameleon parsing lock";
        }
    }
}

