/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationWithSeparator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.injected.XmlAttributeLiteralEscaper;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeValueImpl
extends XmlElementImpl
implements XmlAttributeValue,
PsiLanguageInjectionHost,
RegExpLanguageHost,
PsiMetaOwner,
PsiMetaData {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.xml.XmlAttributeValueImpl");
    private volatile PsiReference[] myCachedReferences;
    private volatile long myModCount;

    public XmlAttributeValueImpl() {
        super(XmlElementType.XML_ATTRIBUTE_VALUE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttributeValue(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String getValue() {
        ASTNode endQuote;
        String text2 = this.getText();
        ASTNode startQuote = this.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER);
        if (startQuote != null) {
            text2 = StringUtil.trimStart(text2, startQuote.getText());
        }
        if ((endQuote = this.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER)) != null) {
            text2 = StringUtil.trimEnd(text2, endQuote.getText());
        }
        return text2;
    }

    @Override
    public TextRange getValueTextRange() {
        TextRange range = this.getTextRange();
        String value = this.getValue();
        if (value.isEmpty()) {
            return range;
        }
        int start = range.getStartOffset() + this.getText().indexOf(value);
        int end = start + value.length();
        return new TextRange(start, end);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedReferences = null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] cachedReferences = this.myCachedReferences;
        long curModCount = this.getManager().getModificationTracker().getModificationCount();
        if (cachedReferences != null && this.myModCount == curModCount) {
            if (cachedReferences == null) {
                XmlAttributeValueImpl.$$$reportNull$$$0(1);
            }
            return cachedReferences;
        }
        cachedReferences = ReferenceProvidersRegistry.getReferencesFromProviders(this);
        this.myCachedReferences = cachedReferences;
        this.myModCount = curModCount;
        if (cachedReferences == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(2);
        }
        return cachedReferences;
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences();
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    @Override
    public int getTextOffset() {
        return this.getTextRange().getStartOffset() + 1;
    }

    @Override
    public boolean isValidHost() {
        return this.getParent() instanceof XmlAttributeImpl;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(3);
        }
        try {
            String quoteChar = this.getTextLength() > 0 ? this.getText().substring(0, 1) : "";
            String contents = StringUtil.containsAnyChar(quoteChar, "'\"") ? StringUtil.trimEnd(StringUtil.trimStart(text2, quoteChar), quoteChar) : text2;
            XmlAttribute newAttribute = XmlElementFactory.getInstance(this.getProject()).createAttribute("q", contents, this);
            XmlAttributeValue newValue = newAttribute.getValueElement();
            CheckUtil.checkWritable(this);
            this.replaceAllChildrenToChildrenOf(newValue.getNode());
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        return this;
    }

    @NotNull
    public LiteralTextEscaper<XmlAttributeValueImpl> createLiteralTextEscaper() {
        XmlAttributeLiteralEscaper xmlAttributeLiteralEscaper = new XmlAttributeLiteralEscaper(this);
        if (xmlAttributeLiteralEscaper == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(4);
        }
        return xmlAttributeLiteralEscaper;
    }

    @Override
    public PsiMetaData getMetaData() {
        return this;
    }

    @Override
    public PsiElement getDeclaration() {
        return this;
    }

    @Override
    public String getName(PsiElement context) {
        return this.getValue();
    }

    @Override
    public String getName() {
        return this.getValue();
    }

    @Override
    public void init(PsiElement element) {
    }

    @Override
    @NotNull
    public Object[] getDependences() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(5);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentationWithSeparator(){

            @Override
            public String getPresentableText() {
                return XmlAttributeValueImpl.this.getText();
            }

            @Override
            public String getLocationString() {
                return SymbolPresentationUtil.getFilePathPresentation(XmlAttributeValueImpl.this.getContainingFile());
            }

            @Override
            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    public boolean characterNeedsEscaping(char c) {
        return c == ']' || c == '}';
    }

    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    public boolean supportsPossessiveQuantifiers() {
        return true;
    }

    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        return true;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return true;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return false;
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(6);
        }
        if (category.startsWith("Is")) {
            try {
                return Character.UnicodeBlock.forName(category.substring(2)) != null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (String[] name : DefaultRegExpPropertiesProvider.getInstance().getAllKnownProperties()) {
            if (!name[0].equals(category)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String[][] getAllKnownProperties() {
        String[][] stringArray = DefaultRegExpPropertiesProvider.getInstance().getAllKnownProperties();
        if (stringArray == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return DefaultRegExpPropertiesProvider.getInstance().getPropertyDescription(name);
    }

    @NotNull
    public String[][] getKnownCharacterClasses() {
        String[][] stringArray = DefaultRegExpPropertiesProvider.getInstance().getKnownCharacterClasses();
        if (stringArray == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKnownProperties";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownCharacterClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

